<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "address_change_log".
 *
 * @property int $id
 * @property int $order_id
 * @property string $old_address
 * @property string $new_address
 * @property int|null $change_status
 * @property string $created_at
 */
class AddressChangeLog extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'address_change_log';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['order_id', 'old_address', 'new_address', 'created_at'], 'required'],
            [['order_id', 'change_status'], 'integer'],
            [['old_address', 'new_address'], 'string'],
            [['created_at'], 'safe'], // Accepts DATETIME format
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'order_id' => 'Order ID',
            'old_address' => 'Old Address',
            'new_address' => 'New Address',
            'change_status' => 'Change Status',
            'created_at' => 'Created At',
        ];
    }

    /**
     * Optional: relation to Order model (if applicable)
     */
    // public function getOrder()
    // {
    //     return $this->hasOne(Order::class, ['id' => 'order_id']);
    // }
}
