<?php

namespace backend\models;

use Yii;
use yii\db\ActiveRecord;

/**
 * This is the model class for table "address_update_tokens".
 *
 * @property int $id
 * @property int $order_id
 * @property string $token
 * @property int $is_used
 * @property string|null $expires_at
 * @property string $created_at
 *
 * @property ItEasyOrder $order
 */
class AddressUpdateToken extends ActiveRecord
{
    public static function tableName()
    {
        return 'address_update_tokens';
    }

    public function rules()
    {
        return [
            [['order_id', 'token'], 'required'],
            [['order_id', 'is_used'], 'integer'],
            [['created_at', 'expires_at'], 'safe'],
            [['token'], 'string', 'max' => 64],
            [['token'], 'unique'],
            [['order_id'], 'exist', 'skipOnError' => true,
                'targetClass' => ItEasyOrder::class,
                'targetAttribute' => ['order_id' => 'it_easy_order_id']],
        ];
    }

    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'order_id' => 'Order ID',
            'token' => 'Token',
            'is_used' => 'Is Used',
            'expires_at' => 'Expires At',
            'created_at' => 'Created At',
        ];
    }

    // public function getOrder()
    // {
    //     return $this->hasOne(ItEasyOrder::class, ['it_easy_order_id' => 'order_id']);
    // }
}
