<?php

namespace backend\models;

use Yii;
use backend\models\ItEasyShippingApi;
use backend\models\ItEasyAwbResponce;
use backend\models\ItEasyOrderDispatch;
use backend\models\ItEasyOrder;
use backend\models\ItEasyOrderProduct;
use backend\models\ItEasyZonePincode;
use backend\models\ItEasyZippyPincodes;
use backend\models\ItEasyStore;
use backend\models\ItEasyClickpostCourier;
use backend\components\webhookSender;


class ApiCall extends \yii\db\ActiveRecord
{

     public function getDelhiVery($order_data,$shipid){
       
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where(['it_easy_ship_id'=>$shipid])->One();
        $client = $shiping_data['it_easy_userName'];
        $token = $shiping_data['it_easy_auth_key'];
        $urlawb='https://test.delhivery.com/waybill/api/fetch/json/?';      
        $urlawb='https://track.delhivery.com/waybill/api/fetch/json/?';           
        $getawbarray=array('token' =>$token, 'cl'=>$client);
        $urlawb.=http_build_query($getawbarray);
        $curlstr = curl_init();
        curl_setopt($curlstr, CURLOPT_URL, $urlawb);
        curl_setopt($curlstr, CURLOPT_RETURNTRANSFER, 1);
        $responce = curl_exec($curlstr);  
       	// print_r($responce);die;
        $returnarray = json_decode($responce, true);      
        curl_close($curlstr);
        // return $returnarray;
       	if(isset($returnarray) && !empty($returnarray)){
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,$returnarray,'delhivery awb number Success',$responce,$currentDateTime);
             ApiCall::sendWebhook($order_data['it_easy_order_id'],$shipid,$returnarray,$currentDateTime,'get_awb');
            $ApiCall = new ApiCall();
            $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data, $returnarray);
            ApiCall::findOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $returnarray ,'responce'=> 'success');
            
         }else{
              ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','delhivery awb number Failed',$responce,$currentDateTime);
              $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> 'not found');
         }
       	 return $all_value;        
    }
  
  
  	public function generateDelhiVery($order_data){
      	
      	$all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
      	date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
      	$order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
      	// echo "<pre>"; print_r($order); die;
      	foreach ($all_product as $key => $product) {
            if($key==0){$product_description = $product['it_easy_product_name'];} else {$product_description .= ','. $product['it_easy_product_name'];}		
        }
      	
      	$store_Data = ItEasyStore::find()->where(['it_easy_id' => $order['it_easy_store_id']])->asArray()->one();
        $client = $shiping_data['it_easy_userName'];
        $token = $shiping_data['it_easy_auth_key'];
      
        if($order_data['it_easy_order_type']=='COD'){	
            $payment_code='COD';
            $collective_value = round($order_data['it_easy_price']);
        } else {
            $payment_code='Pre-paid';					
            $collective_value = 0;
        }					
        $invoice_no = $order['it_easy_invoice_number'];

		$seller_address = $store_Data['it_easy_address_1'].' '.$store_Data['it_easy_address_2'];
		$client = $shiping_data['it_easy_userName'];
        $token = $shiping_data['it_easy_auth_key']; // replace this with your token key
        
        $url = "https://track.delhivery.com/cmu/push/json/?token=".$token;
        $params = array(); // this will contain request meta and the package feed
        $package_data = array(); // package data feed
        $shipments = array();
        $pickup_location = array();
        /////////////start: building the package feed/////////////////////
        $shipment = array();
        $shipment['waybill'] = $order_data['it_easy_awb_number']; // waybill number
        $shipment['name'] = $order['it_easy_shipping_firstname'].' '.$order['it_easy_shipping_lastname']; // consignee name
        $shipment['order'] = $order['it_easy_order_number']; // client order number
        $shipment['products_desc'] = $product_description;
        $shipment['order_date'] = $order['it_easy_converted_time']; // ISO Format
        $shipment['payment_mode'] = $payment_code;
        $shipment['total_amount'] = round($order['it_easy_total_price']); // in INR
        $shipment['cod_amount'] = $collective_value; // amount to be collected, required for COD
        $shipment['add'] = $order['it_easy_shipping_address_1'].' '.$order['it_easy_shipping_address_2']; // consignee address
        $shipment['city'] = $order['it_easy_shipping_city'];
        $shipment['state'] = $order['it_easy_shipping_state'];
        $shipment['country'] = 'India';
        $shipment['phone'] = substr($order['it_easy_mobile_number'], -10);
        $shipment['pin'] = $order['it_easy_shipping_pincode'];

        # optional if not set will use pickup_location s
        $shipment['return_add']= '';
        $shipment['return_city']= '';
        $shipment['return_country']= '';
        $shipment['return_name']= '';
        $shipment['return_phone']= '';
        $shipment['return_pin']= '';
        $shipment['return_state']= '';
        $shipment['supplier'] = $store_Data['it_easy_registered_name']; # optional
        # weights & dimensions
        $shipment['billable_weight']= 0.50; # optional willbe max of weight or	volumetric weight
        $shipment['dimensions']= '5.50CM x 5.50CM x 10CM'; # optional
        $shipment['volumetric']= 0.50; # optional volumetric weight
        $shipment['weight']= '500.0 gm'; # required},
        $shipment['product_quantity']= 1; # quantity of goods, positive integer
        $shipment['seller_inv']=  $invoice_no;
        $shipment['seller_inv_date']= $order['it_easy_converted_time']; # ISO format
        $shipment['seller_name']=  $store_Data['it_easy_registered_name']; # name of seller
        $shipment['seller_add']=  $seller_address; # seller address
        $shipment['seller_cst']= $store_Data['it_easy_gst_number']; # seller cst no
        $shipment['seller_tin']=  $store_Data['it_easy_gst_number']; # seller tin no

        // pickup location information //					
        $pickup_location['add'] = $seller_address;
        $pickup_location['city'] = $store_Data['it_easy_city'];
        $pickup_location['country'] ='India';
        $pickup_location['name'] = $client;  // Use client warehouse name
        $pickup_location['phone'] = $store_Data['it_easy_store_mobile'];
        $pickup_location['pin'] = $store_Data['it_easy_pincode'];
        $pickup_location['state'] = $store_Data['it_easy_state'];
        // pickup location return information //
        $pickup_return['return_add'] = $seller_address;
        $pickup_return['return_city'] = $store_Data['it_easy_city'];
        $pickup_return['return_country'] ='India';
        $pickup_return['return_phone'] = $store_Data['it_easy_store_mobile'];
        $pickup_return['return_pin'] = $store_Data['it_easy_pincode'];
        $pickup_return['return_state'] = $store_Data['it_easy_state'];

        $shipments = array($shipment);
        $package_data['shipments'] = $shipments;
        $package_data['pickup_location'] = $pickup_location;
        $package_data['pickup_return'] = $pickup_return;
        $params['format'] = 'json';					
        $params['data'] =json_encode($package_data);
        $string=http_build_query($params);
      
        $chdlv = curl_init();
        curl_setopt($chdlv, CURLOPT_URL, $url);
        curl_setopt($chdlv, CURLOPT_POST, true);
        curl_setopt($chdlv, CURLOPT_POSTFIELDS, http_build_query($params));
        curl_setopt($chdlv, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($chdlv, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));
        $result = curl_exec($chdlv);
        $returnarray = json_decode($result, true);	
        curl_close($chdlv);
        // echo "<pre>"; print_r($returnarray); die;
      	$awb_number = $order_data['it_easy_awb_number'];
      	if($returnarray['packages'][0]['status'] != 'Fail'){  
          
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order['it_easy_customer_id'] ,$order_data['it_easy_shipping_id'], $awb_number,'Delhivery Manifest Success',$result,$currentDateTime);
          
             ApiCall::sendWebhook($order_data['it_easy_order_id'],
             $order_data['it_easy_shipping_id'],$awb_number,$currentDateTime,'gen_awb');
             
          $ApiCall = new ApiCall();
          $ApiCall->updateOrderDispatch($order_data);
          ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order['it_easy_customer_id'] ,$order_data['it_easy_shipping_id'], $awb_number,'Delhivery Manifest Failed',$result,$currentDateTime);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> $result);
        }  
        return $all_value;
      
    }
    
    //added
    
    public function getDelhiVeryOne($order_data,$shipid){
       
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where(['it_easy_ship_id'=>$shipid])->One();
        $client = $shiping_data['it_easy_userName'];
        $token = $shiping_data['it_easy_auth_key'];
       // $urlawb='https://test.delhivery.com/waybill/api/fetch/json/?';      
       $urlawb='https://track.delhivery.com/waybill/api/fetch/json/?';      
       
        $getawbarray=array('token' =>$token, 'cl'=>$client);
        $urlawb.=http_build_query($getawbarray);
        $curlstr = curl_init();
        curl_setopt($curlstr, CURLOPT_URL, $urlawb);
        curl_setopt($curlstr, CURLOPT_RETURNTRANSFER, 1);
        $responce = curl_exec($curlstr);  
       	// print_r($responce);die;
        $returnarray = json_decode($responce, true);      
        curl_close($curlstr);
        // return $returnarray;
       	if(isset($returnarray) && !empty($returnarray)){
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,$returnarray,'delhivery awb number Success',$responce,$currentDateTime);
             ApiCall::sendWebhook($order_data['it_easy_order_id'],$shipid,$returnarray,$currentDateTime,'get_awb');
            $ApiCall = new ApiCall();
            $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data, $returnarray);
            ApiCall::findOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $returnarray ,'responce'=> 'success');
            
         }else{
              ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','delhivery awb number Failed',$responce,$currentDateTime);
              $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> 'not found');
         }
       	 return $all_value;        
    }
  
  
  	public function generateDelhiVeryOne($order_data){
  	   // print_r($order_data);die;
      	
      	$all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
      	date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
      	$order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
      	// echo "<pre>"; print_r($order); die;
      	foreach ($all_product as $key => $product) {
            if($key==0){$product_description = $product['it_easy_product_name'];} else {$product_description .= ','. $product['it_easy_product_name'];}		
        }
      	
      	$store_Data = ItEasyStore::find()->where(['it_easy_id' => $order['it_easy_store_id']])->asArray()->one();
        $client = $shiping_data['it_easy_userName'];
        $token = $shiping_data['it_easy_auth_key'];
      
        if($order_data['it_easy_order_type']=='COD'){	
            $payment_code='COD';
            $collective_value = round($order_data['it_easy_price']);
        } else {
            $payment_code='Pre-paid';					
            $collective_value = 0;
        }					
        $invoice_no = $order['it_easy_invoice_number'];

		$seller_address = $store_Data['it_easy_address_1'].' '.$store_Data['it_easy_address_2'];
		$client = $shiping_data['it_easy_userName'];
        $token = $shiping_data['it_easy_auth_key']; // replace this with your token key
        
        $url = "https://track.delhivery.com/cmu/push/json/?token=".$token;
       //$url = "https://track.delhivery.com/cmu/create.json/?token=".$token;
        $params = array(); // this will contain request meta and the package feed
        $package_data = array(); // package data feed
        $shipments = array();
        $pickup_location = array();
        /////////////start: building the package feed/////////////////////
        $shipment = array();
        $shipment['waybill'] = $order_data['it_easy_awb_number']; // waybill number
        $shipment['name'] = $order['it_easy_shipping_firstname'].' '.$order['it_easy_shipping_lastname']; // consignee name
        $shipment['order'] = $order['it_easy_order_number']; // client order number
        $shipment['products_desc'] = $product_description;
        $shipment['order_date'] = $order['it_easy_converted_time']; // ISO Format
        $shipment['payment_mode'] = $payment_code;
        $shipment['total_amount'] = round($order['it_easy_total_price']); // in INR
        $shipment['cod_amount'] = $collective_value; // amount to be collected, required for COD
        $shipment['add'] = $order['it_easy_shipping_address_1'].' '.$order['it_easy_shipping_address_2']; // consignee address
        $shipment['city'] = $order['it_easy_shipping_city'];
        $shipment['state'] = $order['it_easy_shipping_state'];
        $shipment['country'] = 'India';
        $shipment['phone'] = substr($order['it_easy_mobile_number'], -10);
        $shipment['pin'] = $order['it_easy_shipping_pincode'];

        # optional if not set will use pickup_location
        $shipment['return_add']= '';
        $shipment['return_city']= '';
        $shipment['return_country']= '';
        $shipment['return_name']= '';
        $shipment['return_phone']= '';
        $shipment['return_pin']= '';
        $shipment['return_state']= '';
        $shipment['supplier'] = $store_Data['it_easy_registered_name']; # optional
        # weights & dimensions
        $shipment['billable_weight']= 0.50; # optional willbe max of weight or	volumetric weight
        $shipment['dimensions']= '5.50CM x 5.50CM x 10CM'; # optional
        $shipment['volumetric']= 0.50; # optional volumetric weight
        $shipment['weight']= '500.0 gm'; # required},
        $shipment['product_quantity']= 1; # quantity of goods, positive integer
        $shipment['seller_inv']=  $invoice_no;
        $shipment['seller_inv_date']= $order['it_easy_converted_time']; # ISO format
        $shipment['seller_name']=  $store_Data['it_easy_registered_name']; # name of seller
        $shipment['seller_add']=  $seller_address; # seller address
        $shipment['seller_cst']= $store_Data['it_easy_gst_number']; # seller cst no
        $shipment['seller_tin']=  $store_Data['it_easy_gst_number']; # seller tin no

        // pickup location information //					
        $pickup_location['add'] = $seller_address;
        $pickup_location['city'] = $store_Data['it_easy_city'];
        $pickup_location['country'] ='India';
        $pickup_location['name'] =   "NUTRIHERBS W"; // $client;  Use client warehouse name
        $pickup_location['phone'] = $store_Data['it_easy_store_mobile'];
        $pickup_location['pin'] = $store_Data['it_easy_pincode'];
        $pickup_location['state'] = $store_Data['it_easy_state'];
        // pickup location return information //
        $pickup_return['return_add'] = $seller_address;
        $pickup_return['return_city'] = $store_Data['it_easy_city'];
        $pickup_return['return_country'] ='India';
        $pickup_return['return_phone'] = $store_Data['it_easy_store_mobile'];
        $pickup_return['return_pin'] = $store_Data['it_easy_pincode'];
        $pickup_return['return_state'] = $store_Data['it_easy_state'];

        $shipments = array($shipment);
        $package_data['shipments'] = $shipments;
        $package_data['pickup_location'] = $pickup_location;
        $package_data['pickup_return'] = $pickup_return;
        $params['format'] = 'json';					
        $params['data'] =json_encode($package_data);
        $string=http_build_query($params);
      
        $chdlv = curl_init();
        curl_setopt($chdlv, CURLOPT_URL, $url);
        curl_setopt($chdlv, CURLOPT_POST, true);
        curl_setopt($chdlv, CURLOPT_POSTFIELDS, http_build_query($params));
        curl_setopt($chdlv, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($chdlv, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));
        $result = curl_exec($chdlv);
        $returnarray = json_decode($result, true);	
        curl_close($chdlv);
         // echo "<pre>"; print_r($returnarray); die;
      	$awb_number = $order_data['it_easy_awb_number'];
      	if($returnarray['packages'][0]['status'] != 'Fail'){  
          
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order['it_easy_customer_id'] ,$order_data['it_easy_shipping_id'], $awb_number,'Delhivery Manifest Success',$result,$currentDateTime);
          
             ApiCall::sendWebhook($order_data['it_easy_order_id'],
             $order_data['it_easy_shipping_id'],$awb_number,$currentDateTime,'gen_awb');
             
          $ApiCall = new ApiCall();
          $ApiCall->updateOrderDispatch($order_data);
          ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order['it_easy_customer_id'] ,$order_data['it_easy_shipping_id'], $awb_number,'Delhivery Manifest Failed',$result,$currentDateTime);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> $result);
        }  
        return $all_value;
      
    }
  
    
    
    //end
  
  
     public function getEcomExpress($order_data,$shipid){
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where(['it_easy_ship_id'=>$shipid])->One();
        if($order_data['it_easy_payment_code']=='cod' || $order_data['it_easy_payment_code']=='lead'){
            $type='COD';          
        } else {
            $type='PPD';              
        }
        $getawbstring = array('username' =>$shiping_data['it_easy_userName'], 'password' =>$shiping_data['it_easy_passWord'], 'count'=>'1', 'type'=>$type);
        $courier_link = 'https://api.ecomexpress.in/apiv2/fetch_awb/';
        $awb = curl_init();
        curl_setopt($awb, CURLOPT_URL, $courier_link);
        curl_setopt($awb, CURLOPT_POST, true);
        curl_setopt($awb, CURLOPT_POSTFIELDS, $getawbstring);
        curl_setopt($awb, CURLOPT_RETURNTRANSFER, 1);
        $awbresponce = curl_exec($awb);  
        // echo $awbresponce; 
        $getawbarray = json_decode($awbresponce, true);                 
        curl_close($awb);
        // return $getawbarray;
           if(isset($getawbarray['awb'][0]) && !empty($getawbarray['awb'][0])){
             $awb_number = $getawbarray['awb'][0];
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,$awb_number,'Ecom Express awb number Success',$awbresponce,$currentDateTime);
             ApiCall::sendWebhook($order_data['it_easy_order_id'],$shipid,$awb_number,$currentDateTime,'get_awb');
            $ApiCall = new ApiCall();
            $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data,$awb_number);
            ApiCall::findOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
           }else{
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','Ecom Express awb number Failed',$awbresponce,$currentDateTime);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> $awbresponce);
           }  
           return $all_value;
    }
    
    
    public function getEcomExpressair($order_data,$shipid){
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where(['it_easy_ship_id'=>$shipid])->One();
        if($order_data['it_easy_payment_code']=='cod' || $order_data['it_easy_payment_code']=='lead'){
            $type='COD';          
        } else {
            $type='PPD';              
        }
        $getawbstring = array('username' =>$shiping_data['it_easy_userName'], 'password' =>$shiping_data['it_easy_passWord'], 'count'=>'1', 'type'=>'EXPP');
        
        // echo "<pre>"; print_r($getawbstring); die;
        $courier_link = 'https://shipment.ecomexpress.in/services/shipment/products/v2/fetch_awb/';
        $awb = curl_init();
        curl_setopt($awb, CURLOPT_URL, $courier_link);
        curl_setopt($awb, CURLOPT_POST, true);
        curl_setopt($awb, CURLOPT_POSTFIELDS, $getawbstring);
        curl_setopt($awb, CURLOPT_RETURNTRANSFER, 1);
        $awbresponce = curl_exec($awb);  
        // echo $awbresponce; 
        $getawbarray = json_decode($awbresponce, true);                 
        curl_close($awb);
        // return $getawbarray;
           if(isset($getawbarray['awb'][0]) && !empty($getawbarray['awb'][0])){
             $awb_number = $getawbarray['awb'][0];
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,$awb_number,'Ecom Express awb number Success',$awbresponce,$currentDateTime);
            ApiCall::sendWebhook($order_data['it_easy_order_id'],$shipid,$currentDateTime,'get_awb') ;
            $ApiCall = new ApiCall();
            $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data,$awb_number);
            ApiCall::findOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
           }else{
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','Ecom Express awb number Failed',$awbresponce,$currentDateTime);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> $awbresponce);
           }  
           return $all_value;
    }
  
  
  	public function generateEcomExpress($order_data){
      	$all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
      	date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
      	$order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
      	
      	foreach ($all_product as $key => $product) {
            if($key==0){$product_description = $product['it_easy_product_name'];} else {$product_description .= ','. $product['it_easy_product_name'];}		
        }
      	
      	$store_Data = ItEasyStore::find()->where(['it_easy_id' => $order['it_easy_store_id']])->asArray()->one();
        $client = $shiping_data['it_easy_userName'];
        $token = $shiping_data['it_easy_auth_key'];
      
      	
        if($order_data['it_easy_order_type'] =='COD'){				            		
            $payment_code= 'COD';
            $collective_value = round($order_data['it_easy_collective_price']);
        } else {
            $payment_code='PPD';					
            $collective_value = 0;

        }


        $dataorders = array('AWB_NUMBER' 			   => $order_data['it_easy_awb_number'],
                            'ORDER_NUMBER'			   => $order_data['it_easy_order_number'],
                            'PRODUCT'	               => strtoupper($payment_code),
                            'PIECES'	               => 1,
                            'CONSIGNEE'	       		   => strtoupper($order['it_easy_shipping_firstname'].' '.$order['it_easy_shipping_lastname']),
                            'CONSIGNEE_ADDRESS1'	   => strtoupper($order['it_easy_shipping_address_1']),
                            'CONSIGNEE_ADDRESS2'	   => strtoupper($order['it_easy_shipping_address_2']),
                            'CONSIGNEE_ADDRESS3'	   => strtoupper($order['it_easy_shipping_address_1']),
                            'DESTINATION_CITY'	       => strtoupper($order['it_easy_shipping_city']),
                            'PINCODE'	               => strtoupper($order['it_easy_shipping_pincode']),
                            'STATE'	                   => strtoupper($order['it_easy_shipping_state']),
                            'MOBILE'	               => substr($order['it_easy_mobile_number'], -10),
                            'TELEPHONE'	               => $order['it_easy_alternate_number'],
                            'ITEM_DESCRIPTION'	       => $product_description,
                            "PIECES" => 1,
                            'COLLECTABLE_VALUE'	       => $collective_value,
                            'DECLARED_VALUE'	       => $order['it_easy_total_price'],
                            'ACTUAL_WEIGHT'	           => '0.50', 
                            'VOLUMETRIC_WEIGHT'	       => '0.50',
                            'LENGTH'	               => '0',
                            'BREADTH'	       		   => '5.5',
                            'HEIGHT'				   => '5.5',
                            'PICKUP_NAME'	      	   => $store_Data['it_easy_store_name'],
                            'PICKUP_ADDRESS_LINE1'	   => $store_Data['it_easy_address_1'],
                            'PICKUP_ADDRESS_LINE2'	   => $store_Data['it_easy_address_2'].' '.$store_Data['it_easy_city'],
                            'PICKUP_PINCODE'	       => $store_Data['it_easy_pincode'],
                            //'PICKUP_PHONE'	           => 'strtoupper($store_telephone)',
                            'PICKUP_PHONE'	           => $store_Data['it_easy_store_mobile'],
                            'PICKUP_MOBILE'	           => $store_Data['it_easy_store_mobile'],
                            'RETURN_NAME'	           => $store_Data['it_easy_store_name'],
                            'RETURN_ADDRESS_LINE1'	   => $store_Data['it_easy_address_1'],
                            'RETURN_ADDRESS_LINE2'	   => $store_Data['it_easy_address_2'].' '.$store_Data['it_easy_city'].' '.$store_Data['it_easy_state'],
                            'RETURN_PINCODE'	       => $store_Data['it_easy_pincode'],
                            'RETURN_PHONE'	           => $store_Data['it_easy_store_mobile'],
                            'RETURN_MOBILE'	           => $store_Data['it_easy_store_mobile']					
                        );
     
        $datas['username']=$shiping_data['it_easy_userName'];
        $datas['password']=$shiping_data['it_easy_passWord'];
      
        $json_details =json_encode($dataorders);
        $datas['json_input']='['.$json_details.']';
        
        $curlmawb = curl_init();                    // initiate curl
        $url= 'https://api.ecomexpress.in/apiv2/manifest_awb/';
        curl_setopt($curlmawb, CURLOPT_URL,$url);
        curl_setopt($curlmawb, CURLOPT_POST, true);  // tell curl you want to post something
        curl_setopt($curlmawb, CURLOPT_POSTFIELDS, $datas); // define what you want to post
        curl_setopt($curlmawb, CURLOPT_RETURNTRANSFER, true); // return the output in string format
        $ManifestAwbresponce = curl_exec($curlmawb); // execute 
        
        $getManifestAwb = json_decode($ManifestAwbresponce, true);
        curl_close($curlmawb);
      	$awb_number = $order_data['it_easy_awb_number'];
      	if((!empty($getManifestAwb['shipments'][0]['success']) && $getManifestAwb['shipments'][0]['success']==1)){ 
            
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order['it_easy_customer_id'] ,$order_data['it_easy_shipping_id'], $awb_number,'Ecom Express Manifest Success',$ManifestAwbresponce,$currentDateTime);
            
              ApiCall::sendWebhook($order_data['it_easy_order_id'],
             $order_data['it_easy_shipping_id'],$awb_number,$currentDateTime,'gen_awb');
             
            $ApiCall = new ApiCall();
            $ApiCall->updateOrderDispatch($order_data);
            ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order['it_easy_customer_id'] ,$order_data['it_easy_shipping_id'], $awb_number,'Ecom Express Manifest Failed',$ManifestAwbresponce,$currentDateTime);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number  ,'responce'=> $ManifestAwbresponce);
        }  
        return $all_value;
    }
    
    
    public function generateEcomExpressair($order_data){
      	$all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
      	date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
      	$order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
      	
      	foreach ($all_product as $key => $product) {
            if($key==0){$product_description = $product['it_easy_product_name'];} else {$product_description .= ','. $product['it_easy_product_name'];}		
        }
      	
      	$store_Data = ItEasyStore::find()->where(['it_easy_id' => $order['it_easy_store_id']])->asArray()->one();
        $client = $shiping_data['it_easy_userName'];
        $token = $shiping_data['it_easy_auth_key'];
      
      	
        if($order_data['it_easy_order_type'] =='COD'){				            		
            $payment_code= 'COD';
            $collective_value = round($order_data['it_easy_collective_price']);
        } else {
            $payment_code='PPD';					
            $collective_value = 0;

        }


        $dataorders = array('AWB_NUMBER' 			   => $order_data['it_easy_awb_number'],
                            'ORDER_NUMBER'			   => $order_data['it_easy_order_number'],
                            'PRODUCT'	               => strtoupper($payment_code),
                            'PIECES'	               => 1,
                            'CONSIGNEE'	       		   => strtoupper($order['it_easy_shipping_firstname'].' '.$order['it_easy_shipping_lastname']),
                            'CONSIGNEE_ADDRESS1'	   => strtoupper($order['it_easy_shipping_address_1']),
                            'CONSIGNEE_ADDRESS2'	   => strtoupper($order['it_easy_shipping_address_2']),
                            'CONSIGNEE_ADDRESS3'	   => strtoupper($order['it_easy_shipping_address_1']),
                            'DESTINATION_CITY'	       => strtoupper($order['it_easy_shipping_city']),
                            'PINCODE'	               => strtoupper($order['it_easy_shipping_pincode']),
                            'STATE'	                   => strtoupper($order['it_easy_shipping_state']),
                            'MOBILE'	               => substr($order['it_easy_mobile_number'], -10),
                            'TELEPHONE'	               => $order['it_easy_alternate_number'],
                            'ITEM_DESCRIPTION'	       => $product_description,
                            "PIECES" => 1,
                            'COLLECTABLE_VALUE'	       => $collective_value,
                            'DECLARED_VALUE'	       => $order['it_easy_total_price'],
                            'ACTUAL_WEIGHT'	           => '0.50', 
                            'VOLUMETRIC_WEIGHT'	       => '0.50',
                            'LENGTH'	               => '0',
                            'BREADTH'	       		   => '5.5',
                            'HEIGHT'				   => '5.5',
                            'PICKUP_NAME'	      	   => $store_Data['it_easy_store_name'],
                            'PICKUP_ADDRESS_LINE1'	   => $store_Data['it_easy_address_1'],
                            'PICKUP_ADDRESS_LINE2'	   => $store_Data['it_easy_address_2'].' '.$store_Data['it_easy_city'],
                            'PICKUP_PINCODE'	       => $store_Data['it_easy_pincode'],
                            //'PICKUP_PHONE'	           => 'strtoupper($store_telephone)',
                            'PICKUP_PHONE'	           => $store_Data['it_easy_store_mobile'],
                            'PICKUP_MOBILE'	           => $store_Data['it_easy_store_mobile'],
                            'RETURN_NAME'	           => $store_Data['it_easy_store_name'],
                            'RETURN_ADDRESS_LINE1'	   => $store_Data['it_easy_address_1'],
                            'RETURN_ADDRESS_LINE2'	   => $store_Data['it_easy_address_2'].' '.$store_Data['it_easy_city'].' '.$store_Data['it_easy_state'],
                            'RETURN_PINCODE'	       => $store_Data['it_easy_pincode'],
                            'RETURN_PHONE'	           => $store_Data['it_easy_store_mobile'],
                            'RETURN_MOBILE'	           => $store_Data['it_easy_store_mobile']					
                        );
     
        $datas['username']=$shiping_data['it_easy_userName'];
        $datas['password']=$shiping_data['it_easy_passWord'];
      
        $json_details =json_encode($dataorders);
        $datas['json_input']='['.$json_details.']';
        // echo json_encode($datas); die;
        $curlmawb = curl_init();                    // initiate curl
        $url= 'https://shipment.ecomexpress.in/services/expp/manifest/v2/expplus/';
        // echo $url; echo "<br>"; 
        
        // echo json_encode($datas); 
        
        curl_setopt($curlmawb, CURLOPT_URL,$url);
        curl_setopt($curlmawb, CURLOPT_POST, true);  // tell curl you want to post something
        curl_setopt($curlmawb, CURLOPT_POSTFIELDS, $datas); // define what you want to post
        curl_setopt($curlmawb, CURLOPT_RETURNTRANSFER, true); // return the output in string format
        $ManifestAwbresponce = curl_exec($curlmawb); // execute 
        
        $getManifestAwb = json_decode($ManifestAwbresponce, true);
        // echo $ManifestAwbresponce; die;
        curl_close($curlmawb);
      	$awb_number = $order_data['it_easy_awb_number'];
      	if((!empty($getManifestAwb['shipments'][0]['success']) && $getManifestAwb['shipments'][0]['success']==1)){ 
            
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order['it_easy_customer_id'] ,$order_data['it_easy_shipping_id'], $awb_number,'Ecom Express Manifest Success',$ManifestAwbresponce,$currentDateTime);
            
             ApiCall::sendWebhook($order_data['it_easy_order_id'],
             $order_data['it_easy_shipping_id'],$awb_number,$currentDateTime,'gen_awb');
             
            $ApiCall = new ApiCall();
            $ApiCall->updateOrderDispatch($order_data);
            ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order['it_easy_customer_id'] ,$order_data['it_easy_shipping_id'], $awb_number,'Ecom Express Manifest Failed',$ManifestAwbresponce,$currentDateTime);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number  ,'responce'=> $ManifestAwbresponce);
        }  
        return $all_value;
    }
  
     public function getXpressbees($order_data,$shipid){
        // echo "<pre>";print_r($order_data);die;
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
         $shiping_data =  ItEasyShippingApi::find()->asArray()->where(['it_easy_ship_id'=>$shipid])->One();
        $connection = \Yii::$app->db;
        if($order_data['it_easy_payment_code'] == 'COD'){
         
        $sql="SELECT * FROM  `it_easy_xpressbees_awb_number` WHERE cod = '1' AND `status`!= '1' AND `IsUse`!= '1' ORDER BY `awb` ASC LIMIT 0,1";
        }else{

        $sql="SELECT * FROM `it_easy_xpressbees_awb_number` WHERE prepaid = '1' AND `status`!= '1' AND `IsUse`!= '1' ORDER BY `awb` ASC LIMIT 0,1";
        }
        $command = $connection->createCommand($sql);
        $data = $command->queryAll();
        // echo"<pre>";print_r($data);die;
        if(isset($data) && !empty($data)){
        ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,$data[0]['awb'],'Xpressbees awb number Success','success',$currentDateTime);
        ApiCall::sendWebhook($order_data['it_easy_order_id'],$shipid,$data[0]['awb'],$currentDateTime,'get_awb');
        $ApiCall = new ApiCall();
        $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data, $data[0]['awb']);
        \Yii::$app->db->createCommand("UPDATE it_easy_xpressbees_awb_number SET status=:status, IsUse=:IsUse WHERE awb=:awb")->bindValue(':awb', $data[0]['awb'])->bindValue(':status', '1')->bindValue(':IsUse', '1')->execute();

        ApiCall::findOrderModel($order_data['it_easy_order_id']);
      
        $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $data[0]['awb'] ,'responce'=> 'success');
        
       }else{
        ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','Xpressbees awb number Failed','not found',$currentDateTime);
        $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> 'not found');
       }
       return $all_value;
    }
  
  
     public function getIndiaPost($order_data,$shipid,$india_post_courier_awb){
        // echo "<pre>";print_r($order_data);die;
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
         $shiping_data =  ItEasyShippingApi::find()->asArray()->where(['it_easy_ship_id'=>$shipid])->One();
        if(isset($india_post_courier_awb) && !empty($india_post_courier_awb)){
        ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,$india_post_courier_awb,'India Post awb number Success','success',$currentDateTime);
        $ApiCall = new ApiCall();
        $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data, $india_post_courier_awb);
        ApiCall::findOrderModel($order_data['it_easy_order_id']);
      
        $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $india_post_courier_awb ,'responce'=> 'success');
        
       }else{
        ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','India Post awb number Failed','not found',$currentDateTime);
        $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> 'not found');
       }
       return $all_value;
    }
  
  
  	public function generateXpressbees($order_data){
      		
      	  $all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
          date_default_timezone_set('Asia/kolkata');
          $currentDateTime = date('Y-m-d H:i:s');
          $awb_responce = new ItEasyAwbResponce();
          $order_dispatch = new ItEasyOrderDispatch();
          $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
          $order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
          // echo "<pre>"; print_r($order); die;
          

          $store_Data = ItEasyStore::find()->where(['it_easy_id' => $order['it_easy_store_id']])->asArray()->one();
          $client = $shiping_data['it_easy_userName'];
          $token = $shiping_data['it_easy_auth_key'];
      	
          $search = [];
          $search['username'] = $shiping_data['it_easy_userName'];
          $search['password'] = $shiping_data['it_easy_passWord'];
          $search['secretkey'] = $shiping_data['it_easy_auth_key'];

          date_default_timezone_set("Asia/Kolkata");
          $create_date=date("Y-m-d H:i:s");
          $chdlv = curl_init();
          curl_setopt($chdlv, CURLOPT_URL, "https://userauthapis.xbees.in/api/auth/generateToken");
          curl_setopt($chdlv, CURLOPT_POST, true);
          curl_setopt($chdlv, CURLOPT_POSTFIELDS, json_encode($search));
          curl_setopt($chdlv, CURLOPT_RETURNTRANSFER, 1);
          curl_setopt($chdlv, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "Authorization: Bearer xyz",
          ));
          $result = curl_exec($chdlv);
         // echo $result; 
          $returnarray = json_decode($result, true);
         // echo "<pre>"; print_r($returnarray);
          $token = $returnarray['token'];
         // echo $token; die;
      		
      	  if($order_data['it_easy_order_type']=='COD'){
            $payment_code= 'COD';
            $collective_value = round($order_data['it_easy_collective_price']);
          } else {
            $payment_code='PrePaid';					
            $collective_value = 0;
          }
          if(empty($order['it_easy_converted_time'])){
              $order['it_easy_converted_time'] = date('Y-m-d H:i:s');
          }
      
      	  $post_data = [];
                
          $post_data['AirWayBillNO'] = $order_data['it_easy_awb_number'];
        //   $post_data['BusinessAccountName'] = "SKYGAIN WEB";
          $post_data['BusinessAccountName'] = "NUTRIHERBS";
          $post_data['OrderNo'] = $order_data['it_easy_order_number'];
          $post_data['OrderType'] = $payment_code;
          $post_data['SubOrderNo'] = $order_data['it_easy_order_number'];
          $post_data['CollectibleAmount'] = $collective_value;
          $post_data['DeclaredValue'] = $collective_value;
          $post_data['PickupType'] = "Vendor";
          $post_data['Quantity'] = "1";
          $post_data['ServiceType'] = "SD";
          $post_data['DropDetails']['Addresses'][0]['Address'] = $order['it_easy_shipping_address_1'].' '.$order['it_easy_shipping_address_2'];
          $post_data['DropDetails']['Addresses'][0]['City'] = $order['it_easy_shipping_city'];
          $post_data['DropDetails']['Addresses'][0]['EmailID'] = "";
          $post_data['DropDetails']['Addresses'][0]['Name'] = $order['it_easy_shipping_firstname'].' '.$order['it_easy_shipping_lastname'];
          $post_data['DropDetails']['Addresses'][0]['PinCode'] = $order['it_easy_shipping_pincode'];
          $post_data['DropDetails']['Addresses'][0]['State'] = $order['it_easy_shipping_state'];
          $post_data['DropDetails']['Addresses'][0]['Type'] = "Primary";
          $post_data['DropDetails']['ContactDetails'][0]['PhoneNo'] = substr($order['it_easy_mobile_number'], -10);
          $post_data['DropDetails']['ContactDetails'][0]['VirtualNumber'] = null;
          $post_data['DropDetails']['ContactDetails'][0]['Type'] = "Primary";
          $post_data['DropDetails']['IsGenSecurityCode'] = null;
          $post_data['DropDetails']['SecurityCode'] = null;
          $post_data['DropDetails']['IsGeoFencingEnabled'] = null;
          $post_data['DropDetails']['Latitude'] = null;
          $post_data['DropDetails']['Longitude'] = null;
          $post_data['DropDetails']['MaxThresholdRadius'] = null;
          $post_data['DropDetails']['MidPoint'] = null;
          $post_data['DropDetails']['MinThresholdRadius'] = null;
          $post_data['DropDetails']['RediusLocation'] = null;
          $post_data['PickupDetails']['Addresses'][0]['Address'] = $store_Data['it_easy_address_1'].' '.$store_Data['it_easy_address_2'];
          $post_data['PickupDetails']['Addresses'][0]['City'] = $store_Data['it_easy_city'];
          $post_data['PickupDetails']['Addresses'][0]['EmailID'] = $store_Data['it_easy_store_email'];
          $post_data['PickupDetails']['Addresses'][0]['Name'] = $store_Data['it_easy_store_name'];
          $post_data['PickupDetails']['Addresses'][0]['PinCode'] = $store_Data['it_easy_pincode'];
          $post_data['PickupDetails']['Addresses'][0]['State'] = $store_Data['it_easy_state'];
          $post_data['PickupDetails']['Addresses'][0]['Type'] = "Primary";
          $post_data['PickupDetails']['ContactDetails'][0]['PhoneNo'] = $store_Data['it_easy_store_mobile'];
          $post_data['PickupDetails']['ContactDetails'][0]['Type'] = "Primary";
        //   $post_data['PickupDetails']['PickupVendorCode'] = 'SKYGAIN WEB';
          $post_data['PickupDetails']['PickupVendorCode'] = 'NUTRIHERBS';
          $post_data['PickupDetails']['IsGenSecurityCode'] = null;
          $post_data['PickupDetails']['SecurityCode'] = null;
          $post_data['PickupDetails']['IsGeoFencingEnabled'] = null;
          $post_data['PickupDetails']['Latitude'] = null;
          $post_data['PickupDetails']['Longitude'] = null;
          $post_data['PickupDetails']['MaxThresholdRadius'] = null;
          $post_data['PickupDetails']['MidPoint'] = null;
          $post_data['PickupDetails']['MinThresholdRadius'] = null;
          $post_data['PickupDetails']['RediusLocation'] = null;
          $post_data['RTODetails']['Addresses'][0]['Address'] = $store_Data['it_easy_address_1'].' '.$store_Data['it_easy_address_2'];
          $post_data['RTODetails']['Addresses'][0]['City'] = $store_Data['it_easy_city'];
          $post_data['RTODetails']['Addresses'][0]['EmailID'] = $store_Data['it_easy_store_email'];
          $post_data['RTODetails']['Addresses'][0]['Name'] = $store_Data['it_easy_store_name'];
          $post_data['RTODetails']['Addresses'][0]['PinCode'] = $store_Data['it_easy_pincode'];
          $post_data['RTODetails']['Addresses'][0]['State'] = $store_Data['it_easy_state'];
          $post_data['RTODetails']['Addresses'][0]['Type'] = "Primary";
          $post_data['RTODetails']['ContactDetails'][0]['PhoneNo'] = $store_Data['it_easy_store_mobile'];
          $post_data['RTODetails']['ContactDetails'][0]['Type'] = "Primary";
          $post_data['Instruction'] = "";
          $post_data['CustomerPromiseDate'] = null;
          $post_data['IsCommercialProperty'] = null;
          $post_data['IsDGShipmentType'] = null;
          $post_data['IsOpenDelivery'] = null;
          $post_data['IsSameDayDelivery'] = null;
          $post_data['ManifestID'] = $order['it_easy_order_id'];
          $post_data['SenderName'] = null;
          $post_data['PackageDetails']['Dimensions']['Height'] = '5';
          $post_data['PackageDetails']['Dimensions']['Length'] = '5';
          $post_data['PackageDetails']['Dimensions']['Width'] = '5';
          $post_data['PackageDetails']['Weight']['BillableWeight'] = '0.5';
          $post_data['PackageDetails']['Weight']['PhyWeight'] = '0.5';
          $post_data['PackageDetails']['Weight']['VolWeight'] = '0.5';
          $post_data['GSTMultiSellerInfo'][0]['BuyerGSTRegNumber'] = '';
          $post_data['GSTMultiSellerInfo'][0]['EBNExpiryDate'] = null;
          $post_data['GSTMultiSellerInfo'][0]['EWayBillSrNumber'] =  $order_data['it_easy_awb_number'];
          $post_data['GSTMultiSellerInfo'][0]['InvoiceDate'] = date('d-m-Y', strtotime($order['it_easy_converted_time']));
          $post_data['GSTMultiSellerInfo'][0]['InvoiceNumber'] = $order['it_easy_invoice_number'];
          $post_data['GSTMultiSellerInfo'][0]['InvoiceValue'] = null;
          $post_data['GSTMultiSellerInfo'][0]['IsSellerRegUnderGST'] = 'Yes';
          $post_data['GSTMultiSellerInfo'][0]['SellerAddress'] = $store_Data['it_easy_address_1'].' '.$store_Data['it_easy_address_2'];
          $post_data['GSTMultiSellerInfo'][0]['SellerGSTRegNumber'] = $store_Data['it_easy_gst_number'];
          $post_data['GSTMultiSellerInfo'][0]['SellerName'] = $store_Data['it_easy_store_name'];
          $post_data['GSTMultiSellerInfo'][0]['SellerPincode'] = $store_Data['it_easy_pincode'];
          $post_data['GSTMultiSellerInfo'][0]['SupplySellerStatePlace'] = $store_Data['it_easy_state'];
      
      	  $all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
      	  foreach($all_product as $key => $product){	
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['ProductCategory'] = $product['it_easy_product_name'];
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['ProductDesc'] = $product['it_easy_variation_name'];
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['CGSTAmount'] = $product['it_easy_product_tax'];
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['Discount'] = null;
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['GSTTAXRateIGSTN'] = null;
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['GSTTaxRateCGSTN'] = null;
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['GSTTaxRateSGSTN'] = null;
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['GSTTaxTotal'] = $product['it_easy_product_tax'];
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['HSNCode'] = '23321';
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['IGSTAmount'] = null;
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['SGSTAmount'] = null;
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['TaxableValue'] = $product['it_easy_product_total'];
          }
            // echo "<pre>"; print_r($post_data); die;
          $ch = curl_init();
          curl_setopt($ch, CURLOPT_URL, "https://apishipmentmanifestation.xbees.in/shipmentmanifestation/forward");
          curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
          curl_setopt($ch, CURLOPT_HEADER, FALSE);

          curl_setopt($ch, CURLOPT_POST, TRUE);

          curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_data));

          curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "token: ".$token,
            "versionnumber: v1",
          ));

          $response = curl_exec($ch);
        //   echo $response; die;
          $returnarray = json_decode($response, true);
          curl_close($ch);
      	 //  echo "<pre>"; print_r($returnarray); die;	
      	 $awb_number = $order_data['it_easy_awb_number'];
      	 if($returnarray['ReturnCode'] == '100'){ 
            
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order['it_easy_customer_id'] ,$order_data['it_easy_shipping_id'], $awb_number,'Xpressbees Manifest Success',$response,$currentDateTime);
            ApiCall::sendWebhook($order_data['it_easy_order_id'],
             $order_data['it_easy_shipping_id'],$awb_number,$currentDateTime,'gen_awb');
            $ApiCall = new ApiCall();
            $ApiCall->updateOrderDispatch($order_data);
            ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order['it_easy_customer_id'] ,$order_data['it_easy_shipping_id'], $awb_number,'Xpressbees Manifest Failed',$response,$currentDateTime);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number  ,'responce'=> $response);
        }  
        return $all_value;
      
    }
  
  	public function getShipdelight($order_data,$shipid){
      
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $shiping_data =  ItEasyShippingApi::find()->where(['it_easy_ship_id'=>$shipid])->One();
  		$invoice_no = $order_data['it_easy_invoice_number'];
			
		if(!empty($order_data['it_easy_alternate_number'])){
			$telephone2=substr($order_data['it_easy_alternate_number'], -10);
		} else {
			$telephone2=substr($order_data['it_easy_mobile_number'], -10);
		}
		if($order_data['it_easy_payment_code']=='COD'){
		  	$mode='COD';
		  	$collectable_value=round($order_data['it_easy_total_price']);
		} else {
		  	$mode='PPD';
		  	$collectable_value='0';
		}		

        $url = "https://api.instashipin.com/api/v1/tenancy/authToken";


        $data_order["api_key"] = $shiping_data->it_easy_userName;
        
        
        $ch = curl_init();
        
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        
        curl_setopt($ch, CURLOPT_POST, TRUE);
        
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data_order));
        
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "Authorization: Bearer ".$shiping_data->it_easy_passWord
        ));
        
        $response = curl_exec($ch);
        $returnarray = json_decode($response, true);
        curl_close($ch);
        // echo "<pre>"; print_r($returnarray); die;
        $post_Data['token_id'] = $returnarray['data']['response']['token_id'];
        $post_Data['auto_approve'] =  true;
        $post_Data['order_number'] =  $order_data['it_easy_order_number'];
        $post_Data['transaction_ref_no'] =  $invoice_no;
        $post_Data['payment_method'] =  $mode;
        $post_Data['discount_total'] =  '0.00';
        $post_Data['invoice_total'] =  round($order_data['it_easy_total_price']);
        $post_Data['cod_total'] =  $collectable_value;
        $post_Data['length'] =  5;
        $post_Data['breadth'] =  5;
        $post_Data['height'] =  5;
        $post_Data['actual_weight'] =  0.5;
        $post_Data['volumetric_weight'] =  0.5;
        $post_Data['shipping']['first_name'] =  $order_data['it_easy_shipping_firstname'];
        $post_Data['shipping']['last_name'] =  $order_data['it_easy_shipping_lastname'];
        $post_Data['shipping']['address_1'] =  $order_data['it_easy_shipping_address_1'];
        $post_Data['shipping']['address_2'] =  $order_data['it_easy_shipping_address_2'];
        $post_Data['shipping']['city'] =  $order_data['it_easy_shipping_city'];
        $post_Data['shipping']['state'] =  $order_data['it_easy_shipping_state'];
        $post_Data['shipping']['postcode'] =  $order_data['it_easy_shipping_pincode'];
        $post_Data['shipping']['country'] =  'India';
        $post_Data['shipping']['phone'] =  substr($order_data['it_easy_shipping_mobile_number'],-10);
      	
      	$all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
        $count_product = count($all_product); 
        $check_value = $count_product - 1;
        $product_total = 0;
        foreach($all_product as $key => $produc){
            
            if($key == $check_value){
                $get_rest_amount = round($order_data['it_easy_total_price']) - round($produc->it_easy_product_total);
                $post_Data['line_items'][$key]['name'] =  $produc->it_easy_product_name.' '.$produc->it_easy_variation_name;
                $post_Data['line_items'][$key]['quantity'] =  $produc->it_easy_product_quantity;
                $post_Data['line_items'][$key]['sku'] =  '';
                $post_Data['line_items'][$key]['unit_price'] =  round($produc->it_easy_product_total) + $get_rest_amount;
                $post_Data['line_items'][$key]['actual_weight'] =  0.5;
            }else{
                $product_total += round($produc->it_easy_product_total);
                $post_Data['line_items'][$key]['name'] =  $produc->it_easy_product_name.' '.$produc->it_easy_variation_name;
                $post_Data['line_items'][$key]['quantity'] =  $produc->it_easy_product_quantity;
                $post_Data['line_items'][$key]['sku'] =  '';
                $post_Data['line_items'][$key]['unit_price'] =  round($produc->it_easy_product_total);
                $post_Data['line_items'][$key]['actual_weight'] =  0.5;
            }
        }  
      	$store_Data = ItEasyStore::find()->where(['it_easy_id' => $order_data['it_easy_store_id']])->one();
      
        $post_Data['pickup']['vendor_name'] =  $store_Data['it_easy_store_name'];
        $post_Data['pickup']['address_1'] =  $store_Data['it_easy_address_1'];
        $post_Data['pickup']['address_2'] =  $store_Data['it_easy_address_2'];
        $post_Data['pickup']['city'] =  $store_Data['it_easy_city'];
        $post_Data['pickup']['state'] =   $store_Data['it_easy_state'];
        $post_Data['pickup']['postcode'] =  $store_Data['it_easy_pincode'];
        $post_Data['pickup']['country'] =  'India';
        $post_Data['pickup']['phone'] =  $store_Data['it_easy_store_mobile'];
        // echo "<pre>"; print_r($post_Data);die;
        
        $url2 = 'https://api.instashipin.com/api/v2/courier-vendor/book';
        
        $ch2 = curl_init();
        
        curl_setopt($ch2, CURLOPT_URL, $url2);
        curl_setopt($ch2, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch2, CURLOPT_HEADER, FALSE);
        
        curl_setopt($ch2, CURLOPT_POST, TRUE);
        
        curl_setopt($ch2, CURLOPT_POSTFIELDS, json_encode($post_Data));
        
        curl_setopt($ch2, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "Authorization: Bearer ".$shiping_data->it_easy_passWord
        ));
        
        $response2 = curl_exec($ch2);
        $returnarray2 = json_decode($response2, true);
        // echo "<pre>"; print_r($returnarray2); die;
        if(!empty($returnarray2['data']['success']) && $returnarray2['data']['success'] == '1'){  
          $awb_number = $returnarray2['data']['response']['airwaybilno'];
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order_data['it_easy_customer_id'] ,$shipid, $awb_number,'Shipdelightnumber Success',$response2,$currentDateTime);
          ApiCall::sendWebhook($order_data['it_easy_order_id'],$shipid,$awb_number,$currentDateTime,'get_awb');
          $ApiCall = new ApiCall();
          ApiCall::findOrderModel($order_data['it_easy_order_id']);
          $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data,$awb_number);
          
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','Shipdelightnumber failed',$response2,$currentDateTime);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> $response2);
        }  
        return $all_value;
      
    }
  
  	public function generateShipdelight($order_data){
      	date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
        $order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
        $store_Data = ItEasyStore::find()->where(['it_easy_id' => $order['it_easy_store_id']])->asArray()->one();
        $ApiCall = new ApiCall();
        $ApiCall->updateOrderDispatch($order_data);
        ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
        $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number = $order_data['it_easy_awb_number'] ,'responce'=> 'success');
        ApiCall::sendWebhook($order_data['it_easy_order_id'], $order_data['it_easy_shipping_id'],$awb_number,$currentDateTime,'gen_awb');
      	return $all_value;
    }

    
    
    public function getSmartr($order_data,$shipid,$access_token){
        //
        // echo $access_token; die;
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $shiping_data =  ItEasyShippingApi::find()->where(['it_easy_ship_id'=>$shipid])->One();
        $invoice_no = $order_data['it_easy_invoice_number'];
            
        if(!empty($order_data['it_easy_alternate_number'])){
            $telephone2=substr($order_data['it_easy_alternate_number'], -10);
        } else {
            $telephone2=substr($order_data['it_easy_mobile_number'], -10);
        }
        if($order_data['it_easy_payment_code']=='COD'){
            $mode='ACC';
            $collectable_value=round($order_data['it_easy_total_price']);
        } else {
            $mode='ACP';
            $collectable_value='0';
        }  
        if(!empty($order_data['it_easy_converted_time'] && isset($order_data['it_easy_converted_time']))){
            $invoice_date = date('d-m-Y', strtotime($order_data['it_easy_converted_time']));
        }else{
            $invoice_date = date('d-m-Y');
        }
         
        $url2 = "https://api.smartr.in/api/v1/add-order/";
        
        $store_Data = ItEasyStore::find()->where(['it_easy_id' => $order_data['it_easy_store_id']])->one();
      
        
        $all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
                $product_name = '';
                $quantity = 0;
        foreach($all_product as $key => $product){
            $product_name .= " ".$product['it_easy_product_name'].' '.$product['it_easy_variation_name'];
            $quantity += $product['it_easy_product_quantity'];
        }
        
        
        $post_data[0]['packageDetails']['awbNumber'] = "";
        $post_data[0]['packageDetails']['orderNumber'] = 'NH'.$order_data['it_easy_order_id'];
        $post_data[0]['packageDetails']['productType'] = $mode;
        $post_data[0]['packageDetails']['collectableValue'] = $collectable_value;
        $post_data[0]['packageDetails']['declaredValue'] = $order_data['it_easy_total_price'];
        $post_data[0]['packageDetails']['itemDesc'] = $product_name;
        $post_data[0]['packageDetails']['dimensions'] = "5~5~5~1~0.5~0/";
        $post_data[0]['packageDetails']['pieces'] = 1;
        $post_data[0]['packageDetails']['weight'] = "0.5";
        $post_data[0]['packageDetails']['invoiceNumber'] = $invoice_no;
        $post_data[0]['deliveryDetails']['toName'] = $order_data['it_easy_shipping_firstname'].' '.$order_data['it_easy_shipping_lastname'];
        $post_data[0]['deliveryDetails']['toAdd'] = $order_data['it_easy_shipping_address_1'].' '.$order_data['it_easy_shipping_address_2'];
        $post_data[0]['deliveryDetails']['toCity'] = $order_data['it_easy_shipping_city'];
        $post_data[0]['deliveryDetails']['toState'] = $order_data['it_easy_shipping_state'];
        $post_data[0]['deliveryDetails']['toPin'] = $order_data['it_easy_shipping_pincode'];
        $post_data[0]['deliveryDetails']['toMobile'] = substr($order_data['it_easy_mobile_number'], -10);
        $post_data[0]['deliveryDetails']['toAddType'] = "Home";
        $post_data[0]['deliveryDetails']['toLat'] = "0.0";
        $post_data[0]['deliveryDetails']['toLng'] = "0.0";
        $post_data[0]['deliveryDetails']['toEmail'] = $order_data['it_easy_email'];
        $post_data[0]['pickupDetails']['fromName'] =  $store_Data['it_easy_store_name'];
        $post_data[0]['pickupDetails']['fromAdd'] = $store_Data['it_easy_address_1']." ".$store_Data['it_easy_address_2'];
        $post_data[0]['pickupDetails']['fromCity'] = $store_Data['it_easy_city'];
        $post_data[0]['pickupDetails']['fromState'] = $store_Data['it_easy_state'];
        $post_data[0]['pickupDetails']['fromPin'] = $store_Data['it_easy_pincode'];
        $post_data[0]['pickupDetails']['fromMobile'] = $store_Data['it_easy_store_mobile'];
        $post_data[0]['pickupDetails']['fromAddType'] = "Seller";
        $post_data[0]['pickupDetails']['fromLat'] = "0.0";
        $post_data[0]['pickupDetails']['fromLng'] = "0.0";
        $post_data[0]['pickupDetails']['fromEmail'] = $store_Data['it_easy_store_email'];
        $post_data[0]['returnDetails']['rtoName'] = $store_Data['it_easy_store_name'];
        $post_data[0]['returnDetails']['rtoAdd'] = $store_Data['it_easy_address_1']." ".$store_Data['it_easy_address_2'];
        $post_data[0]['returnDetails']['rtoCity'] = $store_Data['it_easy_city'];
        $post_data[0]['returnDetails']['rtoState'] = $store_Data['it_easy_state'];
        $post_data[0]['returnDetails']['rtoPin'] = $store_Data['it_easy_pincode'];
        $post_data[0]['returnDetails']['rtoMobile'] = $store_Data['it_easy_store_mobile'];
        $post_data[0]['returnDetails']['rtoAddType'] = "Seller";
        $post_data[0]['returnDetails']['rtoLat'] = "0.0";
        $post_data[0]['returnDetails']['rtoLng'] = "0.0";
        $post_data[0]['returnDetails']['rtoEmail'] = $store_Data['it_easy_store_email'];
        $post_data[0]['additionalInformation']['customerCode'] = "DELNUTRI001";
        $post_data[0]['additionalInformation']['essentialFlag'] = "";
        $post_data[0]['additionalInformation']['otpFlag'] = "";
        $post_data[0]['additionalInformation']['dgFlag'] = "";
        $post_data[0]['additionalInformation']['isSurface'] = "false";
        $post_data[0]['additionalInformation']['isReverse'] = "false";
        $post_data[0]['additionalInformation']['sellerGSTIN'] = $store_Data['it_easy_gst_number'];
        $post_data[0]['additionalInformation']['sellerERN'] = "";
        
        // echo "<pre>"; print_r($post_data);
        
        $curl2 = curl_init($url2);
        curl_setopt($curl2, CURLOPT_URL, $url2);
        curl_setopt($curl2, CURLOPT_POST, true);
        curl_setopt($curl2, CURLOPT_RETURNTRANSFER, true);
        
        $headers2 = array(
           "Authorization: Bearer ".$access_token,
           "Content-Type: application/json",
        );
        curl_setopt($curl2, CURLOPT_HTTPHEADER, $headers2);
        curl_setopt($curl2, CURLOPT_POSTFIELDS, json_encode($post_data));
        $resp2 = curl_exec($curl2);
        $result2 = json_decode($resp2);
        // echo "<pre>"; print_r($result2); die;
        curl_close($curl2);
                
        
        if(isset($result2->total_success[0]->awbNumber) && !empty($result2->total_success[0]->awbNumber)){  
          $awb_number = $result2->total_success[0]->awbNumber;
          $smart_sub_courier_name = 'Smartr';
          if(!empty($result2->total_success[0]->qrCodeData) && isset($result2->total_success[0]->qrCodeData)){
                $smart_route_code = $result2->total_success[0]->qrCodeData;
          }else{
                $smart_route_code = '';
          }
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order_data['it_easy_customer_id'] ,$shipid, $awb_number,'Smartr Success',$resp2,$currentDateTime);
          ApiCall::sendWebhook($order_data['it_easy_order_id'],$shipid,$awb_number,$currentDateTime,'get_awb');
          $ApiCall = new ApiCall();
          ApiCall::findOrderModel($order_data['it_easy_order_id']);
          $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data,$awb_number,$smart_sub_courier_name,$smart_route_code);
          
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','Smartr failed',$resp2,$currentDateTime);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> $resp2);
        }  
        return $all_value;
      
    }
    
    
    public function generateSmartr($order_data){
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
        
        $order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
               
        $awb_number = $order_data['it_easy_awb_number'];
        
        $ApiCall = new ApiCall();
        $ApiCall->updateOrderDispatch($order_data);
        ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
        $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        ApiCall::sendWebhook($order_data['it_easy_order_id'], $order_data['it_easy_shipping_id'],$awb_number,$currentDateTime,'gen_awb');
       
        return $all_value;
    }
    
    
    
    public function getIthink($order_data,$shipid){
        
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $shiping_data =  ItEasyShippingApi::find()->where(['it_easy_ship_id'=>$shipid])->One();
        $invoice_no = $order_data['it_easy_invoice_number'];
            
        if(!empty($order_data['it_easy_alternate_number'])){
            $telephone2=substr($order_data['it_easy_alternate_number'], -10);
        } else {
            $telephone2=substr($order_data['it_easy_mobile_number'], -10);
        }
        if($order_data['it_easy_payment_code']=='COD'){
            $mode='cod';
            $collectable_value=round($order_data['it_easy_total_price']);
        } else {
            $mode='Prepaid';
            $collectable_value='0';
        }  
        if(!empty($order_data['it_easy_converted_time'] && isset($order_data['it_easy_converted_time']))){
            $invoice_date = date('d-m-Y', strtotime($order_data['it_easy_converted_time']));
        }else{
            $invoice_date = date('d-m-Y');
        }
         
        $url2 = "https://api.smartr.in/api/v1/add-order/";
        
        $store_Data = ItEasyStore::find()->where(['it_easy_id' => $order_data['it_easy_store_id']])->one();
      
        
        $all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
                
        
        $product_count = count($all_product); 
        
        
        $post_data['data']['shipments'][0]['waybill'] = "";
        $post_data['data']['shipments'][0]['order'] = 'NH'.$order_data['it_easy_order_id'];
        $post_data['data']['shipments'][0]['sub_order'] = "C";
        $post_data['data']['shipments'][0]['order_date'] = date('d-m-Y', strtotime($invoice_date));
        $post_data['data']['shipments'][0]['total_amount'] = $order_data['it_easy_total_price'];
        $post_data['data']['shipments'][0]['name'] = $order_data['it_easy_shipping_firstname'].' '.$order_data['it_easy_shipping_lastname'];
        $post_data['data']['shipments'][0]['company_name'] = "";
        $post_data['data']['shipments'][0]['add'] = $order_data['it_easy_shipping_address_1'];
        $post_data['data']['shipments'][0]['add2'] = $order_data['it_easy_shipping_address_2'];
        $post_data['data']['shipments'][0]['add3'] = "";
        $post_data['data']['shipments'][0]['pin'] = $order_data['it_easy_shipping_pincode'];
        $post_data['data']['shipments'][0]['city'] = $order_data['it_easy_shipping_city'];
        $post_data['data']['shipments'][0]['state'] = $order_data['it_easy_shipping_state'];
        $post_data['data']['shipments'][0]['country'] = "India";
        $post_data['data']['shipments'][0]['phone'] = substr($order_data['it_easy_mobile_number'], -10);
        $post_data['data']['shipments'][0]['alt_phone'] = $telephone2;
        $post_data['data']['shipments'][0]['email'] = $order_data['it_easy_email'];
        $post_data['data']['shipments'][0]['is_billing_same_as_shipping'] = "yes";
        $post_data['data']['shipments'][0]['billing_name'] = $order_data['it_easy_shipping_firstname'].' '.$order_data['it_easy_shipping_lastname'];
        $post_data['data']['shipments'][0]['billing_company_name'] = "";
        $post_data['data']['shipments'][0]['billing_add'] = $order_data['it_easy_shipping_address_1'];
        $post_data['data']['shipments'][0]['billing_add2'] = $order_data['it_easy_shipping_address_2'];
        $post_data['data']['shipments'][0]['billing_add3'] = "";
        $post_data['data']['shipments'][0]['billing_pin'] = $order_data['it_easy_shipping_pincode'];
        $post_data['data']['shipments'][0]['billing_city'] = $order_data['it_easy_shipping_city'];
        $post_data['data']['shipments'][0]['billing_state'] = $order_data['it_easy_shipping_state'];
        $post_data['data']['shipments'][0]['billing_country'] = "India";
        $post_data['data']['shipments'][0]['billing_phone'] = substr($order_data['it_easy_mobile_number'], -10);
        $post_data['data']['shipments'][0]['billing_alt_phone'] = $telephone2;
        $post_data['data']['shipments'][0]['billing_email'] = $order_data['it_easy_email'];
        $r = 0;
        $all_pro_price = 0;
        $discount = 0;
        foreach($all_product as $key => $product1){
             $all_pro_price += $product1['it_easy_product_total'];
        }
        foreach($all_product as $key => $product){
            if($key == 0){
                $discount = $all_pro_price - $order_data['it_easy_total_price'];
            }else{
                $discount = 0;
            }
            $post_data['data']['shipments'][0]['products'][$r]['product_name'] = $product['it_easy_product_name'].' '.$product['it_easy_variation_name'];
            $post_data['data']['shipments'][0]['products'][$r]['product_sku'] = $product['it_easy_variation_name'];
            $post_data['data']['shipments'][0]['products'][$r]['product_quantity'] = $product['it_easy_product_quantity'];
            $post_data['data']['shipments'][0]['products'][$r]['product_price'] = $product['it_easy_product_total'];
            $post_data['data']['shipments'][0]['products'][$r]['product_tax_rate'] = "5";
            $post_data['data']['shipments'][0]['products'][$r]['product_hsn_code'] = "13021919";
            $post_data['data']['shipments'][0]['products'][$r]['product_discount'] = $discount;
            $r++;
        }
        $post_data['data']['shipments'][0]['shipment_length'] = "5";
        $post_data['data']['shipments'][0]['shipment_width'] = "5";
        $post_data['data']['shipments'][0]['shipment_height'] = "5";
        $post_data['data']['shipments'][0]['weight'] = "0.300";
        $post_data['data']['shipments'][0]['shipping_charges'] = "0";
        $post_data['data']['shipments'][0]['giftwrap_charges'] = "0";
        $post_data['data']['shipments'][0]['transaction_charges'] = "0";
        $post_data['data']['shipments'][0]['total_discount'] = "0";
        $post_data['data']['shipments'][0]['first_attemp_discount'] = "0";
        $post_data['data']['shipments'][0]['cod_charges'] = "0";
        $post_data['data']['shipments'][0]['advance_amount'] = "0";
        $post_data['data']['shipments'][0]['cod_amount'] = $collectable_value;
        $post_data['data']['shipments'][0]['payment_mode'] = $mode;
        $post_data['data']['shipments'][0]['reseller_name'] = "";
        $post_data['data']['shipments'][0]['eway_bill_number'] = "";
        $post_data['data']['shipments'][0]['gst_number'] = "";
        $post_data['data']['shipments'][0]['what3words'] = "0";
        $post_data['data']['shipments'][0]['return_address_id'] = $shiping_data->it_easy_auth_key;
        $post_data['data']['shipments'][0]['api_source'] = "0";
        $post_data['data']['shipments'][0]['store_id'] = "1";
        $post_data['data']['pickup_address_id'] = $shiping_data->it_easy_auth_key;
        $post_data['data']['access_token'] = $shiping_data->it_easy_userName;
        $post_data['data']['secret_key'] = $shiping_data->it_easy_passWord;
        $post_data['data']['logistics'] = "";
        $post_data['data']['s_type'] = "";
        $post_data['data']['order_type'] = "";
        
        // echo "<pre>"; print_r($post_data); die;
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL             => "https://my.ithinklogistics.com/api_v3/order/add.json",
          CURLOPT_RETURNTRANSFER  => true,
          CURLOPT_ENCODING        => "",
          CURLOPT_MAXREDIRS       => 10,
          CURLOPT_TIMEOUT         => 30,
          CURLOPT_HTTP_VERSION    => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST   => "POST",
          CURLOPT_POSTFIELDS      => json_encode($post_data),
          CURLOPT_HTTPHEADER      => array(
              "cache-control: no-cache",
              "content-type: application/json"
          )
        ));
    
        $resp2 = curl_exec($curl);
        $result2 = json_decode($resp2, true);
        $result2 = (array)$result2;
        $err      = curl_error($curl);
        curl_close($curl);
        
       
    //   echo $result2['data'][1]['logistic_name'];   
    //     echo "<pre>"; print_r($result2); die;
        if(isset($result2['data'][1]['waybill']) && !empty($result2['data'][1]['waybill'])){  
          $awb_number = $result2['data'][1]['waybill'];
          $smart_sub_courier_name = $result2['data'][1]['logistic_name'];
        //   echo $smart_sub_courier_name;
        //   echo "<pre>"; print_r($result2); die;
          $smart_route_code = '';
          
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order_data['it_easy_customer_id'] ,$shipid, $awb_number,'Ithink Success',$resp2,$currentDateTime);
          ApiCall::sendWebhook($order_data['it_easy_order_id'],$shipid,$awb_number,$currentDateTime,'get_awb');
          
          $ApiCall = new ApiCall();
          ApiCall::findOrderModel($order_data['it_easy_order_id']);
          $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data,$awb_number,$smart_sub_courier_name,$smart_route_code);
          
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','Ithink failed',$resp2,$currentDateTime);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> $resp2);
        }  
        return $all_value;
      
    }
    

    public function getClickpost($order_data,$shipid,$account_name){
        //
        // echo $access_token; die;
        $shiping_data = ItEasyClickpostCourier::find()->where(['cp_id' => $shipid])->asArray()->one();
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $invoice_no = $order_data['it_easy_invoice_number'];
            
        if(!empty($order_data['it_easy_alternate_number'])){
            $telephone2=substr($order_data['it_easy_alternate_number'], -10);
        } else {
            $telephone2=substr($order_data['it_easy_mobile_number'], -10);
        }
        if($order_data['it_easy_payment_code']=='COD'){
            $mode='COD';
            $collectable_value=round($order_data['it_easy_total_price']) - round($order_data['it_easy_partially_paid']);
        } else {
            $mode='PREPAID';
            $collectable_value='0';
        }  
        if(!empty($order_data['it_easy_converted_time'] && isset($order_data['it_easy_converted_time']))){
            $invoice_date = date('Y-m-d', strtotime($order_data['it_easy_converted_time']));
        }else{
            $invoice_date = date('Y-m-d');
        }
         
        $url = "https://www.clickpost.in/api/v3/create-order/?key=28ab0068-a66d-4ecf-8b20-ad8b28f1f83f";

        
        $post_Data['request_info'] = array('client_id' =>'WIU7XKIS4H7W7322KBLGS','run_type'=>'create');
        $store_Data = ItEasyStore::find()->where(['it_easy_id' => $order_data['it_easy_store_id']])->asArray()->one();
        
        $order_new_array = [];
        $order_new_array['drop_info']['drop_lat'] = 0;
        $order_new_array['drop_info']['drop_city'] = $order_data['it_easy_shipping_city'];
        $order_new_array['drop_info']['drop_long'] = 0;
        $order_new_array['drop_info']['drop_name'] = $order_data['it_easy_shipping_firstname'].' '.$order_data['it_easy_shipping_lastname'];
        $order_new_array['drop_info']['drop_email'] = str_replace(" ","",trim($order_data['it_easy_email']));
        $order_new_array['drop_info']['drop_phone'] = substr($order_data['it_easy_mobile_number'], -10);
        $order_new_array['drop_info']['drop_state'] = $order_data['it_easy_shipping_state'];
        $order_new_array['drop_info']['drop_address'] = $order_data['it_easy_shipping_address_1'].' '.$order_data['it_easy_shipping_address_2'];
        $order_new_array['drop_info']['drop_district'] = $order_data['it_easy_shipping_city'];
        $order_new_array['drop_info']['drop_landmark'] = null;
        $order_new_array['drop_info']['drop_pincode'] = $order_data['it_easy_shipping_pincode'];
        $order_new_array['drop_info']['drop_country'] = "IN";
        // $order_new_array['drop_info']['drop_address_type'] = "RESIDENTIAL";
        // $order_new_array['drop_info']['drop_vendor_code'] = "test_drop";
        
        $order_new_array['pickup_info']['pickup_lat'] = 0;
        $order_new_array['pickup_info']['pickup_city'] = $store_Data['it_easy_city'];
        $order_new_array['pickup_info']['pickup_long'] = 0;
        $order_new_array['pickup_info']['pickup_name'] = $store_Data['it_easy_registered_name'];
        $order_new_array['pickup_info']['pickup_email'] = trim($store_Data['it_easy_store_email']);
        $order_new_array['pickup_info']['pickup_time'] = date('Y-m-d').'T19:00:00';
        $order_new_array['pickup_info']['pickup_phone'] = $store_Data['it_easy_store_mobile'];
        $order_new_array['pickup_info']['pickup_state'] = $store_Data['it_easy_state'];
        $order_new_array['pickup_info']['pickup_address'] = $store_Data['it_easy_address_1'].' '.$store_Data['it_easy_address_2'];
        $order_new_array['pickup_info']['pickup_district'] = $store_Data['it_easy_city'];
        $order_new_array['pickup_info']['pickup_landmark'] = null;
        $order_new_array['pickup_info']['pickup_pincode'] = $store_Data['it_easy_pincode'];
        $order_new_array['pickup_info']['pickup_country'] = "IN";
        // $order_new_array['pickup_info']['pickup_address_type'] = "OFFICE";
        $all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
                $productarray = [];
                $weight_t = 0;
foreach($all_product as $key => $product){
    
    $variation_details = ItEasyProductVariation::find()->where(['it_easy_product_id' => $product['it_easy_product_id'] ])->andWhere(['it_easy_variation_id' => $product['it_easy_variation_id'] ])->asArray()->one();
    if(!empty($variation_details['it_easy_product_weight'])){
        $weight_t += $variation_details['it_easy_product_weight'] * $product['it_easy_product_quantity'];
    }else{
        $variation_details['it_easy_product_weight'] = '100';
    }
    $order_new_array['shipment_details']['items'][$key]['sku'] = substr($product['it_easy_product_name'], 0, 20);
    $order_new_array['shipment_details']['items'][$key]['price'] = $product['it_easy_product_total'];
    $order_new_array['shipment_details']['items'][$key]['weight'] = $variation_details['it_easy_product_weight'];
    $order_new_array['shipment_details']['items'][$key]['hs_code'] = '13021919';
    $order_new_array['shipment_details']['items'][$key]['quantity'] = $product['it_easy_product_quantity'];
    $order_new_array['shipment_details']['items'][$key]['description'] = $product['it_easy_product_name'].' '.$product['it_easy_variation_name'];
    $order_new_array['shipment_details']['items'][$key]['additional']['manufacture_country'] = 'INDIA';
    $order_new_array['shipment_details']['items'][$key]['additional']['manufacture_country_code'] = 'IN';
    $order_new_array['shipment_details']['items'][$key]['additional']['cat'] = 'Nutra';
    $order_new_array['shipment_details']['items'][$key]['additional']['images'] = '';
    $order_new_array['shipment_details']['items'][$key]['additional']['product_url'] = '';
    $order_new_array['shipment_details']['items'][$key]['additional']['return_days'] = '1';
    $order_new_array['shipment_details']['items'][$key]['additional']['length'] = '5';
    $order_new_array['shipment_details']['items'][$key]['additional']['breadth'] = '5';
    $order_new_array['shipment_details']['items'][$key]['additional']['height'] = '5';
    $order_new_array['shipment_details']['items'][$key]['additional']['brand'] = 'Nutriherbs';
    $order_new_array['shipment_details']['items'][$key]['additional']['color'] = 'Black';
    $order_new_array['shipment_details']['items'][$key]['additional']['size'] = '10';
    $order_new_array['shipment_details']['items'][$key]['additional']['serial_no'] = $product['it_easy_id'];
    $order_new_array['shipment_details']['items'][$key]['additional']['imei'] = '';
    $order_new_array['shipment_details']['items'][$key]['additional']['ean'] = '';
    $order_new_array['shipment_details']['items'][$key]['additional']['sub_category'] = '';
    $order_new_array['shipment_details']['items'][$key]['additional']['return_reason'] = '';
    $order_new_array['shipment_details']['items'][$key]['gst_info']['hsn_code'] = '13021919';
    $order_new_array['shipment_details']['items'][$key]['gst_info']['cgst_amount'] = '0';
    $order_new_array['shipment_details']['items'][$key]['gst_info']['igst_amount'] = '0';
    $order_new_array['shipment_details']['items'][$key]['gst_info']['sgst_amount'] = '0';
    $order_new_array['shipment_details']['items'][$key]['gst_info']['gst_discount'] = '0';
    $order_new_array['shipment_details']['items'][$key]['gst_info']['seller_gstin'] = $store_Data['it_easy_gst_number'];
    $order_new_array['shipment_details']['items'][$key]['gst_info']['cgst_tax_rate'] = '0';
    $order_new_array['shipment_details']['items'][$key]['gst_info']['gst_total_tax'] = $product['it_easy_product_tax'];
    $order_new_array['shipment_details']['items'][$key]['gst_info']['igst_tax_rate'] = '0';
    $order_new_array['shipment_details']['items'][$key]['gst_info']['sgst_tax_rate'] = '0';
    $order_new_array['shipment_details']['items'][$key]['gst_info']['taxable_value'] = $product['it_easy_product_total'];
    $order_new_array['shipment_details']['items'][$key]['gst_info']['consignee_gstin'] = '';
    $order_new_array['shipment_details']['items'][$key]['gst_info']['place_of_supply'] = '09';
    $order_new_array['shipment_details']['items'][$key]['gst_info']['enterprise_gstin'] = $store_Data['it_easy_gst_number'];
    $order_new_array['shipment_details']['items'][$key]['gst_info']['ewaybill_serial_number'] = "NA";
    $order_new_array['shipment_details']['items'][$key]['gst_info']['is_seller_registered_under_gst'] = true;
    $order_new_array['shipment_details']['items'][$key]['gst_info']['invoice_reference'] = $invoice_no;
}
    $order_new_array['shipment_details']['height'] = '5';
    $order_new_array['shipment_details']['length'] = '5'; 
    $order_new_array['shipment_details']['weight'] = $weight_t; 
    $order_new_array['shipment_details']['breadth'] = '5'; 
    $order_new_array['shipment_details']['order_id'] = "".$order_data['it_easy_order_id'].""; 
    $order_new_array['shipment_details']['cod_value'] = $collectable_value;
    $order_new_array['shipment_details']['cod_currency_code'] = 'INR';
    $order_new_array['shipment_details']['order_type'] = $mode;
    $order_new_array['shipment_details']['invoice_date'] = $invoice_date;
    $order_new_array['shipment_details']['delivery_type'] = 'FORWARD';
    $order_new_array['shipment_details']['invoice_value'] = $order_data['it_easy_total_price'];
    $order_new_array['shipment_details']['invoice_number'] = $invoice_no;
    $order_new_array['shipment_details']['courier_partner'] = (int)$shipid;
    $order_new_array['shipment_details']['reference_number'] = substr($account_name,0,4).''.$order_data['it_easy_order_id'].'S'.rand(100,999);
    $order_new_array['shipment_details']['account_code'] = $account_name;
    $order_new_array['shipment_details']['booking_id'] = "";
    $order_new_array['additional']['return_info']['lat'] = '0';
    $order_new_array['additional']['return_info']['city'] = $store_Data['it_easy_city'];
    $order_new_array['additional']['return_info']['long'] = '0';
    $order_new_array['additional']['return_info']['name'] = $store_Data['it_easy_registered_name'];
    $order_new_array['additional']['return_info']['email'] = trim($store_Data['it_easy_store_email']);
    $order_new_array['additional']['return_info']['phone'] = $store_Data['it_easy_store_mobile'];
    $order_new_array['additional']['return_info']['state'] = $store_Data['it_easy_state'];
    $order_new_array['additional']['return_info']['address'] = $store_Data['it_easy_address_1'].' '.$store_Data['it_easy_address_2'];
    $order_new_array['additional']['return_info']['district'] = $store_Data['it_easy_city'];
    $order_new_array['additional']['return_info']['landmark'] = '';
    $order_new_array['additional']['return_info']['pincode'] = $store_Data['it_easy_pincode'];
    $order_new_array['additional']['return_info']['country'] = 'IN';
    $Date = date('Y-m-d');
    $order_new_array['additional']['estimated_delivery_date'] = date('Y-m-d', strtotime($Date. ' + 2 days'));
    $order_new_array['additional']['async'] = false;
    $order_new_array['additional']['label'] = true;
    // $order_new_array['additional']['vendor_code'] = 'nutriherbs';
    $order_new_array['additional']['zone'] = 'Delhi';
    // $order_new_array['additional']['min_edd'] = '1';
    // $order_new_array['additional']['max_edd'] = '7';
    // $order_new_array['additional']['qc_type'] = 'doorstep';
    // $order_new_array['additional']['invoice_base_64'] = base64_encode($invoice_no);
    // $order_new_array['additional']['is_multi_seller'] = false;
    $order_new_array['additional']['channel_name'] = 'Clickpost';
    // $order_new_array['additional']['otp_based_delivery'] = false;
    // $order_new_array['additional']['inv_url'] = '';
    $order_new_array['additional']['pickup_type'] = 'WH';
    $order_new_array['additional']['is_fragile'] = true;
    $order_new_array['additional']['is_dangerous'] = false;
    $order_new_array['additional']['from_wh'] = "SOURCE WAREHOUSE";
    $order_new_array['additional']['to_wh'] = "DESTINATION WAREHOUSE";
    // $order_new_array['additional']['invoice_reference'] = substr($account_name,0,5).''.$order_data['it_easy_order_number'].'#'.rand(100,999);
    $order_new_array['additional']['order_date'] = $invoice_date;
    $order_new_array['gst_info']['seller_gstin'] = $store_Data['it_easy_gst_number'];
    $order_new_array['gst_info']['seller_name'] = $store_Data['it_easy_registered_name'];
    $order_new_array['gst_info']['taxable_value'] = $order_data['it_easy_total_price'];
    $order_new_array['gst_info']['ewaybill_serial_number'] = 'NA';
    $order_new_array['gst_info']['is_seller_registered_under_gst'] = true;
    $order_new_array['gst_info']['sgst_tax_rate'] = '0';
    $order_new_array['gst_info']['place_of_supply'] = 'Delhi';
    $order_new_array['gst_info']['gst_discount'] = '0';
    $order_new_array['gst_info']['hsn_code'] = '13021919';
    $order_new_array['gst_info']['sgst_amount'] = '0';
    $order_new_array['gst_info']['enterprise_gstin'] = $store_Data['it_easy_gst_number'];
    $order_new_array['gst_info']['gst_total_tax'] = $order_data['it_easy_gst_price'];
    $order_new_array['gst_info']['igst_amount'] = '0';
    $order_new_array['gst_info']['cgst_amount'] = '0';
    $order_new_array['gst_info']['gst_tax_base'] = '0';
    $order_new_array['gst_info']['consignee_gstin'] = '';
    $order_new_array['gst_info']['igst_tax_rate'] = '0';
    $order_new_array['gst_info']['cgst_tax_rate'] = '0';
    // echo json_encode($order_new_array);
    // echo "<pre>"; print_r($order_new_array); die;
    
    $ch2 = curl_init();
    curl_setopt($ch2, CURLOPT_URL, $url);
    curl_setopt($ch2, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch2, CURLOPT_HEADER, FALSE);
    curl_setopt($ch2, CURLOPT_POST, TRUE);
    curl_setopt($ch2, CURLOPT_POSTFIELDS, json_encode($order_new_array));
    curl_setopt($ch2, CURLOPT_HTTPHEADER, array(
        "Content-Type: application/json",
        "accept: application/json"
    ));
    $response2 = curl_exec($ch2);
    // echo $response2; die;
    $returnarray2 = json_decode($response2, true);
    // echo "<pre>"; print_r($returnarray2); die;
                curl_close($ch2);
    if((isset($returnarray2['meta']['status']) || $returnarray2['meta']['status'] == '200') && !empty($returnarray2['result']['waybill'])){  
      $awb_number = $returnarray2['result']['waybill'];
      $smart_sub_courier_name = $returnarray2['result']['courier_name'];
      if(!empty($returnarray2['result']['sort_code']) && isset($returnarray2['result']['sort_code'])){
        $smart_route_code = $returnarray2['result']['sort_code'];
      }else{
          $smart_route_code = '';
      }
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order_data['it_easy_customer_id'] ,$shipid, $awb_number,'Clickpost Success',$response2,$currentDateTime);
          $ApiCall = new ApiCall();
          ApiCall::findOrderModel($order_data['it_easy_order_id']);
          $ApiCall->addOrderDispatchclickpost($order_data,$shipid,$shiping_data,$awb_number,$smart_sub_courier_name,$smart_route_code);
          
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> $returnarray2['meta']['message']);
        }else{
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','Clickpost failed',$response2,$currentDateTime);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'AWB Failed' ,'responce'=> $response2);
        }  
        return $all_value;
      
    }
    
    
    
    public function getShiprocket($order_data,$shipid,$access_token){
        //
        // echo $access_token; die;
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        
        // 🔒 STOP SHIPROCKET RE-CREATION IF ALREADY FAILED
$lastAwb = ItEasyAwbResponce::find()
    ->where([
        'it_easy_order_id'    => $order_data['it_easy_order_id'],
        'it_easy_shipping_id' => $shipid   // Shiprocket = 12
    ])
    ->orderBy(['it_easy_created_time' => SORT_DESC])
    ->one();

if ($lastAwb) {

    $response = json_decode($lastAwb->it_easy_api_responce, true);

    if (
        $lastAwb->it_easy_api_type === 'shiprocket failed'
        && isset($response['status_code'])
        && (int)$response['status_code'] === 400
    ) {
        return [
            'order_id'   => $order_data['it_easy_order_id'],
            'awb_number' => '',
            'responce'   => 'Shiprocket blocked: No courier service available.'
        ];
    }
}


        $awb_responce = new ItEasyAwbResponce();
        $shiping_data =  ItEasyShippingApi::find()->where(['it_easy_ship_id'=>$shipid])->One();
        $invoice_no = $order_data['it_easy_invoice_number'];
            
        if(!empty($order_data['it_easy_alternate_number'])){
            $telephone2=substr($order_data['it_easy_alternate_number'], -10);
        } else {
            $telephone2=substr($order_data['it_easy_mobile_number'], -10);
        }
        if($order_data['it_easy_payment_code']=='COD'){
            $mode='COD';
            $collectable_value=round($order_data['it_easy_total_price']);
        } else {
            $mode='Prepaid';
            $collectable_value='0';
        }  
        if(!empty($order_data['it_easy_converted_time'] && isset($order_data['it_easy_converted_time']))){
            $invoice_date = date('d-m-Y', strtotime($order_data['it_easy_converted_time']));
        }else{
            $invoice_date = date('d-m-Y');
        }
        
        
        
        $url = "https://apiv2.shiprocket.in/v1/external/orders/create/adhoc";

        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        
        $headers = array(
           "Content-Type: application/json",
           "Authorization: Bearer ".$access_token,
        );
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        $order_Data = [];
        $order_Data['order_id'] = 'NH'.$order_data['it_easy_order_id'].'ss'.rand(0,1000);
        $order_Data['order_date'] = $invoice_date;
        $order_Data['pickup_location'] = 'warehouse';
        $order_Data['channel_id'] = '6865780';
        $order_Data['comment'] = "Reseller: ".$order_data['it_easy_shipping_firstname'];
        $order_Data['billing_customer_name'] = $order_data['it_easy_shipping_firstname'];
        $order_Data['billing_last_name'] = $order_data['it_easy_shipping_lastname'];
        $order_Data['billing_address'] = $order_data['it_easy_shipping_address_1'];
        $order_Data['billing_address_2'] = $order_data['it_easy_shipping_address_2'];
        $order_Data['billing_city'] = $order_data['it_easy_shipping_city'];
        $order_Data['billing_pincode'] = trim($order_data['it_easy_shipping_pincode']);
        $order_Data['billing_state'] = $order_data['it_easy_shipping_state'];
        $order_Data['billing_country'] = 'India';
        $order_Data['billing_email'] = trim($order_data['it_easy_email']); 
        $order_Data['billing_phone'] = substr($order_data['it_easy_mobile_number'], -10);
        $order_Data['shipping_is_billing'] = true;
        $order_Data['shipping_customer_name'] = "";
        $order_Data['shipping_last_name'] = "";
        $order_Data['shipping_address'] = "";
        $order_Data['shipping_address_2'] = "";
        $order_Data['shipping_city'] = "";
        $order_Data['shipping_pincode'] = "";
        $order_Data['shipping_country'] = "";
        $order_Data['shipping_state'] = "";
        $order_Data['shipping_email'] = "";
        $order_Data['shipping_phone'] = "";
        
        
        $all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
                $productarray = [];
        foreach($all_product as $key => $product){     
            $order_Data['order_items'][$key]['name'] = $product['it_easy_product_name'].' '.$product['it_easy_variation_name'];
            $order_Data['order_items'][$key]['sku'] = substr($product['it_easy_product_name'].' '.$product['it_easy_variation_name'], 0, 45);
            $order_Data['order_items'][$key]['units'] = $product['it_easy_product_quantity'];
            $order_Data['order_items'][$key]['selling_price'] = $product['it_easy_product_total'];
            $order_Data['order_items'][$key]['discount'] = "";
            $order_Data['order_items'][$key]['tax'] = "";
            $order_Data['order_items'][$key]['hsn'] = 30049011;   
        } 
        
        
        
        
        $order_Data['payment_method'] = $mode;
        $order_Data['shipping_charges'] = 0;
        $order_Data['giftwrap_charges'] = 0;
        $order_Data['transaction_charges'] = 0;
        $order_Data['total_discount'] = 0;
        $order_Data['sub_total'] = round($order_data['it_easy_total_price']);
        $order_Data['length'] = 5;
        $order_Data['breadth'] = 5;
        $order_Data['height'] = 5;
        $order_Data['weight'] = 0.5;
        
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($order_Data));
        
        //for debug only!
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        
        $results = curl_exec($curl);
        
    	if(curl_error($curl)) {
    		$results.=curl_error($curl);
    		}
    	curl_close($curl);
    	$objArray = json_decode($results, true);
     	//echo "<pre>"; print_r($objArray);
    	if(isset($objArray['shipment_id']) && !empty($objArray['shipment_id'])){
    	    
    	    $shipment_id = $objArray['shipment_id'];
    	    $url = "https://apiv2.shiprocket.in/v1/external/courier/assign/awb";

            $curl = curl_init($url);
            curl_setopt($curl, CURLOPT_URL, $url);
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            
            $headers = array(
               "Content-Type: application/json",
               "Authorization: Bearer ".$access_token,
            );
            curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
            
            $data['shipment_id'] = $shipment_id;
            curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
            
            //for debug only!
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
            
            $resp = curl_exec($curl);
            curl_close($curl);
            $returnarray2 = json_decode($resp, true);
            //echo "<pre>"; print_r($objArray2); die;
            
            if(isset($returnarray2['response']['data']['awb_code']) && !empty($returnarray2['response']['data']['awb_code'])){  
              $awb_number = $returnarray2['response']['data']['awb_code'];
              $smart_sub_courier_name = $returnarray2['response']['data']['courier_name'];
              if(!empty($returnarray2['response']['data']['routing_code']) && isset($returnarray2['response']['data']['routing_code'])){
              $smart_route_code = $returnarray2['response']['data']['routing_code'];
              }else{
                  $smart_route_code = '';
              }
              ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order_data['it_easy_customer_id'] ,$shipid, $awb_number,'shiprocket Success',$resp,$currentDateTime);
              ApiCall::sendWebhook($order_data['it_easy_order_id'],$shipid,$awb_number,$currentDateTime,'get_awb');
              $ApiCall = new ApiCall();
              ApiCall::findOrderModel($order_data['it_easy_order_id']);
              $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data,$awb_number,$smart_sub_courier_name,$smart_route_code);
              $dispatch_Model = ItEasyOrderDispatch::findOne(['it_easy_awb_number' => $awb_number]);
              $dispatch_Model->shipment_id = $shipment_id;
              $dispatch_Model->save(false);
              
              $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
            }else{
              ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','shiprocket failed',$resp,$currentDateTime);
              $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> $resp);
            } 
    	    
    	}else{
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','shiprocket failed',$results,$currentDateTime);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> $results);
        }
        
         
        return $all_value;
      
    }
    
    
    
    
    public function getSmartship($order_data,$shipid,$access_token){
        //
        // echo $access_token; die;
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $shiping_data =  ItEasyShippingApi::find()->where(['it_easy_ship_id'=>$shipid])->One();
        $invoice_no = $order_data['it_easy_invoice_number'];
            
        if(!empty($order_data['it_easy_alternate_number'])){
            $telephone2=substr($order_data['it_easy_alternate_number'], -10);
        } else {
            $telephone2=substr($order_data['it_easy_mobile_number'], -10);
        }
        if($order_data['it_easy_payment_code']=='COD'){
            $mode='COD';
            $collectable_value=round($order_data['it_easy_total_price']);
        } else {
            $mode='Prepaid';
            $collectable_value='0';
        }  
        if(!empty($order_data['it_easy_converted_time'] && isset($order_data['it_easy_converted_time']))){
            $invoice_date = date('d-m-Y', strtotime($order_data['it_easy_converted_time']));
        }else{
            $invoice_date = date('d-m-Y');
        }
         
        $url = "http://api.smartship.in/v2/app/Fulfillmentservice/orderRegistrationOneStep";

        
        $post_Data['request_info'] = array('client_id' =>'WIU7XKIS4H7W7322KBLGS','run_type'=>'create');
      
        $order_new_array = [];
        $order_new_array['client_order_reference_id'] = 'NH'.$order_data['it_easy_order_id'];
        $order_new_array['shipment_type'] = '1';
        $order_new_array['order_collectable_amount'] = $collectable_value;
        $order_new_array['total_order_value'] = $collectable_value;
        $order_new_array['payment_type'] = $mode;
        $order_new_array['package_order_weight'] = '400';
        $order_new_array['package_order_length'] = '5';
        $order_new_array['package_order_height'] = '5';
        $order_new_array['package_order_width'] = '5';
        $order_new_array['shipper_hub_id'] = '80718';
        $order_new_array['shipper_gst_no'] = '07AAVCS9330D1Z0';
        $order_new_array['order_invoice_date'] = $invoice_date;
    $order_new_array['order_invoice_number'] = $order_data['it_easy_invoice_number'];
        $order_new_array['is_return_qc'] = '0';
        $order_new_array['return_reason_id'] = '0';
        
        $all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
                $productarray = [];
        foreach($all_product as $key => $product){
             
                $order_new_array['product_details'][$key]['client_product_reference_id'] =  $product['it_easy_product_id'];
                $order_new_array['product_details'][$key]['product_name'] =  $product['it_easy_product_name'].' '.$product['it_easy_variation_name'];
                $order_new_array['product_details'][$key]['product_hsn_code'] = "30039011";
                $order_new_array['product_details'][$key]['product_category'] =  'Nutra';
                $order_new_array['product_details'][$key]['product_quantity'] =  $product['it_easy_product_quantity'];
                $order_new_array['product_details'][$key]['product_invoice_value'] =  $product['it_easy_product_total'];
                $order_new_array['product_details'][$key]['product_gst_tax_rate'] =  $product['it_easy_product_tax'];
                $order_new_array['product_details'][$key]['product_taxable_value'] =  $product['it_easy_product_price'];
                $order_new_array['product_details'][$key]['product_sgst_amount'] =  '0';
                $order_new_array['product_details'][$key]['product_sgst_tax_rate'] =  '0';
                $order_new_array['product_details'][$key]['product_cgst_amount'] =  '0';
                $order_new_array['product_details'][$key]['product_cgst_tax_rate'] =  '0';
               
        }       
        
                $order_new_array['consignee_details']['consignee_name'] = $order_data['it_easy_shipping_firstname'].' '.$order_data['it_easy_shipping_lastname'];
                
                $order_new_array['consignee_details']['consignee_phone'] = substr($order_data['it_easy_mobile_number'], -10);
                $order_new_array['consignee_details']['consignee_email'] = str_replace(" ","",trim($order_data['it_easy_email']));
                $order_new_array['consignee_details']['consignee_complete_address'] = $order_data['it_easy_shipping_address_1'].' '.$order_data['it_easy_shipping_address_2']." ".$order_data['it_easy_shipping_city'].' '.$order_data['it_easy_shipping_state'];
                $order_new_array['consignee_details']['consignee_pincode'] = $order_data['it_easy_shipping_pincode'];
                $post_Data['orders'][] =   $order_new_array;
                
        //   echo "<pre>"; print_r($post_Data); die;
                $ch2 = curl_init();
                curl_setopt($ch2, CURLOPT_URL, $url);
                curl_setopt($ch2, CURLOPT_RETURNTRANSFER, TRUE);
                curl_setopt($ch2, CURLOPT_HEADER, FALSE);
                curl_setopt($ch2, CURLOPT_POST, TRUE);
                curl_setopt($ch2, CURLOPT_POSTFIELDS, json_encode($post_Data));
                curl_setopt($ch2, CURLOPT_HTTPHEADER, array(
                    "Content-Type: application/json",
                    "Authorization: Bearer ".$access_token
                ));
                $response2 = curl_exec($ch2);
                // echo $response2; die;
                $returnarray2 = json_decode($response2, true);
                // echo "<pre>"; print_r($returnarray2); die;
                curl_close($ch2);
        if(isset($returnarray2['data']['success_order_details']['orders'][0]['awb_number']) && !empty($returnarray2['data']['success_order_details']['orders'][0]['awb_number'])){  
          $awb_number = $returnarray2['data']['success_order_details']['orders'][0]['awb_number'];
          $smart_sub_courier_name = $returnarray2['data']['success_order_details']['orders'][0]['carrier_name'];
          if(!empty($returnarray2['data']['success_order_details']['orders'][0]['route_code']) && isset($returnarray2['data']['success_order_details']['orders'][0]['route_code'])){
          $smart_route_code = $returnarray2['data']['success_order_details']['orders'][0]['route_code'];
          }else{
              $smart_route_code = '';
          }
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order_data['it_easy_customer_id'] ,$shipid, $awb_number,'Smartship Success',$response2,$currentDateTime);
          ApiCall::sendWebhook($order_data['it_easy_order_id'],$shipid,$awb_number,$currentDateTime,'get_awb');
          $ApiCall = new ApiCall();
          ApiCall::findOrderModel($order_data['it_easy_order_id']);
          $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data,$awb_number,$smart_sub_courier_name,$smart_route_code);
          
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','Smartship failed',$response2,$currentDateTime);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> $response2);
        }  
        return $all_value;
      
    }
    
    
    public function getEkart($order_data,$shipid,$access_token){
        //
        // echo $access_token; die;
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $shiping_data =  ItEasyShippingApi::find()->where(['it_easy_ship_id'=>$shipid])->One();
        $invoice_no = $order_data['it_easy_invoice_number'];
            
        if(!empty($order_data['it_easy_alternate_number'])){
            $telephone2=substr($order_data['it_easy_alternate_number'], -10);
        } else {
            $telephone2=substr($order_data['it_easy_mobile_number'], -10);
        }
        
        $count_id = strlen($order_data['it_easy_order_id']);
            
        if($count_id == '5'){
            $ship_code = '00000'.$order_data['it_easy_order_id'];
        }else if($count_id == '4'){
            $ship_code = '000000'.$order_data['it_easy_order_id'];
        }else if($count_id == '3'){
            $ship_code = '0000000'.$order_data['it_easy_order_id'];
        }else if($count_id == '6'){
            $ship_code = '0000'.$order_data['it_easy_order_id'];
        }else if($count_id == '7'){
            $ship_code = '000'.$order_data['it_easy_order_id'];
        }else if($count_id == '8'){
            $ship_code = '00'.$order_data['it_easy_order_id'];
        }else if($count_id == '9'){
            $ship_code = '0'.$order_data['it_easy_order_id'];
        }
        if($order_data['it_easy_payment_code']=='COD'){
            $mode='COD';
            $collectable_value=round($order_data['it_easy_total_price']);
            $tracking_id = "SKGC".$ship_code;
        } else {
            $mode='Prepaid';
            
            
            $tracking_id = "SKGP".$ship_code;
            $collectable_value='0';
        }  
        if(!empty($order_data['it_easy_converted_time'] && isset($order_data['it_easy_converted_time']))){
            $invoice_date = date('Y-m-d H:i:s', strtotime($order_data['it_easy_converted_time']));
        }else{
            $invoice_date = date('Y-m-d H:i:s');
        }
         
        $url = "https://api.ekartlogistics.com/v2/shipments/create";
        $all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
                $productarray = [];
        
        
        foreach($all_product as $key => $product){
             
                $productarray[$key]['product_id'] =  $product['it_easy_product_id'];
                $productarray[$key]['category'] =  "Health & Wellness";
                $productarray[$key]['product_title'] =  $product['it_easy_product_name'].' '.$product['it_easy_variation_name'];
                $productarray[$key]['quantity'] = $product['it_easy_product_quantity'];
                $productarray[$key]['cost']['totalSaleValue'] =  $product['it_easy_product_total'];
                $productarray[$key]['cost']['totalTaxValue'] =  $product['it_easy_product_tax'];
                $productarray[$key]['cost']['tax_breakup']['cgst'] = 0;
                $productarray[$key]['cost']['tax_breakup']['sgst'] = 0;
                $productarray[$key]['cost']['tax_breakup']['igst'] = 0;
                $productarray[$key]['seller_details']['seller_reg_name'] = "Skygain Nutricare Private Limited";
                $productarray[$key]['seller_details']['vat_id'] = "";
                $productarray[$key]['seller_details']['cst_id'] = "";
                $productarray[$key]['seller_details']['gstin_id'] = "07AAVCS9330D1Z0";
                $productarray[$key]['hsn'] = "";
                $productarray[$key]['item_attributes'][0]['name'] = "order_id";
                $productarray[$key]['item_attributes'][0]['value'] = "NH".$order_data['it_easy_order_id'];
                $productarray[$key]['item_attributes'][1]['name'] = "invoice_id";
                $productarray[$key]['item_attributes'][1]['value'] = "NH".$order_data['it_easy_order_id'];
                $productarray[$key]['handling_attributes'] = [];
               
        }
        
        
        
        $data_post['request_Id'] = rand(0,100)."NH".$order_data['it_easy_order_id'];
        $data_post['client_name'] = "SKG";
        $data_post['services'][0]['service_code'] = "ECONOMY";
        $data_post['services'][0]['service_details'][0]['service_leg'] = "FORWARD";
        $data_post['services'][0]['service_details'][0]['service_data']['vendor_name'] = "Skygain Nutricare Private Limited";
        $data_post['services'][0]['service_details'][0]['service_data']['vendor_name'] = $collectable_value;
        $data_post['services'][0]['service_details'][0]['service_data']['dispatch_date'] = $invoice_date;
        $data_post['services'][0]['service_details'][0]['service_data']['source']['address']['first_name'] = "Skygain Nutricare Private Limited";
        $data_post['services'][0]['service_details'][0]['service_data']['source']['address']['address_line1'] = "A-52 Second Floor Okhla Phase 1 Near Crown Plaza";
        $data_post['services'][0]['service_details'][0]['service_data']['source']['address']['pincode'] = "110020";
        $data_post['services'][0]['service_details'][0]['service_data']['source']['address']['city'] = "New Delhi";
        $data_post['services'][0]['service_details'][0]['service_data']['source']['address']['state'] = "Delhi";
        $data_post['services'][0]['service_details'][0]['service_data']['source']['address']['primary_contact_number'] = "7827466736";
        $data_post['services'][0]['service_details'][0]['service_data']['destination']['address']['first_name'] = $order_data['it_easy_shipping_firstname'].' '.$order_data['it_easy_shipping_lastname'];
        $data_post['services'][0]['service_details'][0]['service_data']['destination']['address']['address_line1'] = $order_data['it_easy_shipping_address_1'].' '.$order_data['it_easy_shipping_address_2'];
        $data_post['services'][0]['service_details'][0]['service_data']['destination']['address']['pincode'] = $order_data['it_easy_shipping_pincode'];
        $data_post['services'][0]['service_details'][0]['service_data']['destination']['address']['city'] = $order_data['it_easy_shipping_city'];
        $data_post['services'][0]['service_details'][0]['service_data']['destination']['address']['state'] = $order_data['it_easy_shipping_state'];
        $data_post['services'][0]['service_details'][0]['service_data']['destination']['address']['primary_contact_number'] = substr($order_data['it_easy_mobile_number'], -10);
        
        $data_post['services'][0]['service_details'][0]['service_data']['return_location']['address']['first_name'] = "Skygain Nutricare Private Limited";
        $data_post['services'][0]['service_details'][0]['service_data']['return_location']['address']['address_line1'] = "A-52 Second Floor Okhla Phase 1 Near Crown Plaza";
        $data_post['services'][0]['service_details'][0]['service_data']['return_location']['address']['pincode'] = "110020";
        $data_post['services'][0]['service_details'][0]['service_data']['return_location']['address']['city'] = "New Delhi";
        $data_post['services'][0]['service_details'][0]['service_data']['return_location']['address']['state'] = "Delhi";
        $data_post['services'][0]['service_details'][0]['service_data']['return_location']['address']['primary_contact_number'] = "7827466736";
        $data_post['services'][0]['service_details'][0]['shipment']['tracking_id'] = $tracking_id;
        $data_post['services'][0]['service_details'][0]['shipment']['shipment_value'] = round($order_data['it_easy_total_price']);
        $data_post['services'][0]['service_details'][0]['shipment']['shipment_dimensions']['length']['value'] = 5;
        $data_post['services'][0]['service_details'][0]['shipment']['shipment_dimensions']['breadth']['value'] = 5;
        $data_post['services'][0]['service_details'][0]['shipment']['shipment_dimensions']['height']['value'] = 5;
        $data_post['services'][0]['service_details'][0]['shipment']['shipment_dimensions']['weight']['value'] = "0.20";
        $data_post['services'][0]['service_details'][0]['shipment']['shipment_items'] = $productarray;
        // echo $access_token; echo "<br>";
        // echo json_encode($data_post); die;
                $ch2 = curl_init();
                curl_setopt($ch2, CURLOPT_URL, $url);
                curl_setopt($ch2, CURLOPT_RETURNTRANSFER, TRUE);
                curl_setopt($ch2, CURLOPT_HEADER, FALSE);
                curl_setopt($ch2, CURLOPT_POST, TRUE);
                curl_setopt($ch2, CURLOPT_POSTFIELDS, json_encode($data_post));
                curl_setopt($ch2, CURLOPT_HTTPHEADER, array(
                    "Content-Type: application/json",
                    "HTTP_X_MERCHANT_CODE: SKG",
                    "Authorization: ".$access_token
                ));
                $response2 = curl_exec($ch2);
                // echo $response2; die;
                $returnarray2 = json_decode($response2, true);
                //echo "<pre>"; print_r($returnarray2); die;
                curl_close($ch2);
        if(isset($returnarray2['response'][0]['tracking_id']) && !empty($returnarray2['response'][0]['tracking_id'])  &&  ($returnarray2['response'][0]['status']== 'REQUEST_RECEIVED') ){  
          $awb_number = $returnarray2['response'][0]['tracking_id'];
          $smart_sub_courier_name = 'Ekart';
          
              $smart_route_code = '';
          
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order_data['it_easy_customer_id'] ,$shipid, $awb_number,'Smartship Success',$response2,$currentDateTime);
          ApiCall::sendWebhook($order_data['it_easy_order_id'],$shipid,$awb_number,$currentDateTime,'get_awb');
          $ApiCall = new ApiCall();
          ApiCall::findOrderModel($order_data['it_easy_order_id']);
          $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data,$awb_number,$smart_sub_courier_name,$smart_route_code);
          
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','Smartship failed',$response2,$currentDateTime);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> $response2);
        }  
        return $all_value;
      
    }
    
    
    public function getUrbanbolt($order_data,$shipid,$access_token){
        //
        // echo $access_token; die;
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $shiping_data =  ItEasyShippingApi::find()->where(['it_easy_ship_id'=>$shipid])->One();
        $invoice_no = $order_data['it_easy_invoice_number'];
            
        if(!empty($order_data['it_easy_alternate_number'])){
            $telephone2=substr($order_data['it_easy_alternate_number'], -10);
        } else {
            $telephone2=substr($order_data['it_easy_mobile_number'], -10);
        }
        
        
        if($order_data['it_easy_payment_code']=='COD'){
            $mode='COD';
            $collectable_value=round($order_data['it_easy_total_price']);
        } else {
            $mode='PPD';
            $collectable_value=0;
        }  
        if(!empty($order_data['it_easy_converted_time'] && isset($order_data['it_easy_converted_time']))){
            $invoice_date = date('Y-m-d H:i:s', strtotime($order_data['it_easy_converted_time']));
        }else{
            $invoice_date = date('Y-m-d H:i:s');
        }
         
        $url = "https://api.urbanebolt.in/api/v1/services/manifest/";
        $all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
                $productarray = [];
        
        $prod_qut = 0;
        foreach($all_product as $key => $product){
                $prod_qut += $product['it_easy_product_quantity'];
        }
        
        
        
        
        
        $data_post[0]['customerCode'] = "UBC0119";
        $data_post[0]["orderNumber"] = rand(0,100)."NH".$order_data['it_easy_order_id'];
        $data_post[0]["declaredValue"] = round($order_data['it_easy_total_price']);
        $data_post[0]["itemDescription"] = "HEALTH & WELLNESS";
        $data_post[0]["collectableValue"] = $collectable_value;
        $data_post[0]["height"] = 5;
        $data_post[0]["length"] = 5;
        $data_post[0]["pieces"] = 1;
        $data_post[0]["weight"] = 0.2;
        $data_post[0]["breadth"] = 5;
        $data_post[0]["payMode"] = $mode;
        $data_post[0]["serviceType"] = "NDD";
        $data_post[0]["rtnCity"] = "Okhla";
        $data_post[0]["rtnName"] = "Skygain Nutricare Private Limited";
        $data_post[0]["consCity"] = $order_data['it_easy_shipping_city'];
        $data_post[0]["consName"] = $order_data['it_easy_shipping_firstname'].' '.$order_data['it_easy_shipping_lastname'];
        $data_post[0]["rtnEmail"] = "support@nutriherbs.in";
        $data_post[0]["rtnState"] = "New Delhi";
        $data_post[0]["shprCity"] = "Okhla";
        $data_post[0]["shprName"] = "Shadab";
        $data_post[0]["consEmail"] = "";
        $data_post[0]["consState"] = $order_data['it_easy_shipping_state'];
        $data_post[0]["rtnMobile"] = "7827466736";
        $data_post[0]["shprEmail"] = "support@nutriherbs.in";
        $data_post[0]["shprState"] = "New Delhi";
        $data_post[0]["consMobile"] = substr($order_data['it_easy_mobile_number'], -10);
        $data_post[0]["rtnAddress"] = "A-52 Second Floor Okhla Phase 1 Near Crown Plaza";
        $data_post[0]["rtnAddressType"] = "Seller";
        $data_post[0]["rtnCountry"] = "INDIA";
        $data_post[0]["rtnPincode"] = "110020";
        $data_post[0]["shprMobile"] = "7827466736";
        $data_post[0]["consAddress"] = $order_data['it_easy_shipping_address_1'].' '.$order_data['it_easy_shipping_address_2'];
        $data_post[0]["consAddressType"] = "Home";
        $data_post[0]["consCountry"] = "INDIA";
        $data_post[0]["consPincode"] = $order_data['it_easy_shipping_pincode'];
        $data_post[0]["invoiceNumber"] = "NH".$order_data['it_easy_order_id'];
        $data_post[0]["invoiceDate"] = date("Y-m-d");
        $data_post[0]["shprAddress"] = "A-52 Second Floor Okhla Phase 1 Near Crown Plaza";
        $data_post[0]["shprAddressType"] = "Seller";
        $data_post[0]["shprCountry"] = "INDIA";
        $data_post[0]["shprPincode"] = "110020";
        $data_post[0]["invoiceValue"] = round($order_data['it_easy_total_price']);
        $data_post[0]["itemQuantity"] = $prod_qut;
        
        
        
        // echo $access_token; echo "<br>";
        // echo json_encode($data_post); die;
                $ch2 = curl_init();
                curl_setopt($ch2, CURLOPT_URL, $url);
                curl_setopt($ch2, CURLOPT_RETURNTRANSFER, TRUE);
                curl_setopt($ch2, CURLOPT_HEADER, FALSE);
                curl_setopt($ch2, CURLOPT_POST, TRUE);
                curl_setopt($ch2, CURLOPT_POSTFIELDS, json_encode($data_post));
                curl_setopt($ch2, CURLOPT_HTTPHEADER, array(
                    "Content-Type: application/json",
                    "Cookie: csrftoken=tK8oyHpfF2FcI2lS0F2pqVNmHx9YV0j8; sessionid=21bjwngg0x9s90ujff1cq4dpls3ufc2t",
                    "Authorization: Bearer ".$access_token
                ));
                $response2 = curl_exec($ch2);
                // echo $response2; die;
                $returnarray2 = json_decode($response2, true);
               // echo "<pre>"; print_r($returnarray2); die;
                curl_close($ch2);
        if(isset($returnarray2['successResponse'][0]['awbNumber']) && !empty($returnarray2['successResponse'][0]['awbNumber'])){  
          $awb_number = $returnarray2['successResponse'][0]['awbNumber'];
          $smart_sub_courier_name = 'Urbanbolt';
          
              $smart_route_code = $returnarray2['successResponse'][0]['routeCode'];
          
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order_data['it_easy_customer_id'] ,$shipid, $awb_number,'Smartship Success',$response2,$currentDateTime);
          ApiCall::sendWebhook($order_data['it_easy_order_id'],$shipid,$awb_number,$currentDateTime,'get_awb');
          $ApiCall = new ApiCall();
          ApiCall::findOrderModel($order_data['it_easy_order_id']);
          $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data,$awb_number,$smart_sub_courier_name,$smart_route_code);
          
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','Smartship failed',$response2,$currentDateTime);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> $response2);
        }  
        return $all_value;
      
    }
    
    
    public function getProzo($order_data,$shipid,$access_token){
        //
        // echo $access_token; die;
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $shiping_data =  ItEasyShippingApi::find()->where(['it_easy_ship_id'=>$shipid])->One();
        $invoice_no = $order_data['it_easy_invoice_number'];
            
        if(!empty($order_data['it_easy_alternate_number'])){
            $telephone2=substr($order_data['it_easy_alternate_number'], -10);
        } else {
            $telephone2=substr($order_data['it_easy_mobile_number'], -10);
        }
        
        $count_id = strlen($order_data['it_easy_order_id']);
            
        
        if($order_data['it_easy_payment_code']=='COD'){
            $mode='COD';
            $collectable_value=round($order_data['it_easy_total_price']);
        } else {
            $mode='PREPAID';
            $collectable_value='0';
        }  
        if(!empty($order_data['it_easy_converted_time'] && isset($order_data['it_easy_converted_time']))){
            $invoice_date = date('Y-m-d H:i:s', strtotime($order_data['it_easy_converted_time']));
        }else{
            $invoice_date = date('Y-m-d H:i:s');
        }
         
        $url = "https://proship.prozo.com/api/order/create";
        $all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
                $productarray = [];
        
        
        foreach($all_product as $key => $product){
                $productarray[$key]['units'] = $product['it_easy_product_quantity'];
                $productarray[$key]['tax'] = 5;
                $productarray[$key]['hsn'] = "30049011";
                $productarray[$key]['item_name'] =  $product['it_easy_product_name'].' '.$product['it_easy_variation_name'];
                $productarray[$key]['sku_id'] =  $product['it_easy_product_name'].' '.$product['it_easy_variation_name'];
                $productarray[$key]['item_url'] = "NA";
                $productarray[$key]['selling_price'] =  $product['it_easy_product_total'];
        }
        
        $data_post['reverse'] = "";
        $data_post['order_type'] = "Forward Shipment";
        $data_post['item_list'] = $productarray;
        $data_post['pickup_details']['from_name'] = "Skygain Nutricare Private Limited";
        $data_post['pickup_details']['from_phone_number'] = "7827466736";
        $data_post['pickup_details']['from_address'] = "A-52 Second Floor Okhla Phase 1 Near Crown Plaza";
        $data_post['pickup_details']['from_addressline'] = "A-52 Second Floor Okhla Phase 1 Near Crown Plaza";
        $data_post['pickup_details']['from_pincode'] = "110020";
        $data_post['pickup_details']['from_city'] = "New Delhi";
        $data_post['pickup_details']['from_state'] = "Delhi";
        $data_post['pickup_details']['from_country'] = "IN";
        $data_post['pickup_details']['gstin'] = "07AAECH9422L1ZA";
        $data_post['pickup_details']['from_email'] = "support@nutriherbs.in";
        
        $data_post['delivery_details']['to_name'] = $order_data['it_easy_shipping_firstname'].' '.$order_data['it_easy_shipping_lastname'];
        $data_post['delivery_details']['to_phone_number'] = substr($order_data['it_easy_mobile_number'], -10);
        $data_post['delivery_details']['to_address'] = $order_data['it_easy_shipping_address_1'].' '.$order_data['it_easy_shipping_address_2'];
        $data_post['delivery_details']['to_country'] = "IN";
        $data_post['delivery_details']['to_email'] = "";
        $data_post['delivery_details']['to_pincode'] = $order_data['it_easy_shipping_pincode'];
        $data_post['delivery_details']['to_city'] = $order_data['it_easy_shipping_city'];
        $data_post['delivery_details']['to_addressline'] = $order_data['it_easy_shipping_address_1'].' '.$order_data['it_easy_shipping_address_2'];
        $data_post['delivery_details']['to_state'] = $order_data['it_easy_shipping_state'];
        
        $data_post['customer_detail']['to_email'] = "";
        $data_post['customer_detail']['to_address'] = $order_data['it_easy_shipping_address_1'].' '.$order_data['it_easy_shipping_address_2'];
        $data_post['customer_detail']['to_city'] = $order_data['it_easy_shipping_city'];
        $data_post['customer_detail']['to_city'] = "IN";
        $data_post['customer_detail']['to_state'] = $order_data['it_easy_shipping_state'];
        $data_post['shipment_detail'][0]['item_breadth'] = 1;
        $data_post['shipment_detail'][0]['item_length'] = 1;
        $data_post['shipment_detail'][0]['item_height'] = 1;
        $data_post['shipment_detail'][0]['item_weight'] = 200;
        $data_post['invoice_value'] = round($order_data['it_easy_total_price']);
        $data_post['cod_amount'] = $collectable_value;
        $data_post['client_order_id'] = "NH".$order_data['it_easy_order_id'];
        $data_post['is_reverse'] = "";
        $data_post['invoice_number'] = $order_data['it_easy_invoice_number'];
        $data_post['transaction_charge'] = 0;
        $data_post['giftwrap_charge'] = 0;
        $data_post['payment_mode'] = $mode;
        $data_post['reference'] = rand(0,100)."NH".$order_data['it_easy_order_id'];
        $data_post['channel_name'] = "WMS";
        
    
        // echo $access_token; echo "<br>";
        // echo json_encode($data_post); die;
                $ch2 = curl_init();
                curl_setopt($ch2, CURLOPT_URL, $url);
                curl_setopt($ch2, CURLOPT_RETURNTRANSFER, TRUE);
                curl_setopt($ch2, CURLOPT_HEADER, FALSE);
                curl_setopt($ch2, CURLOPT_POST, TRUE);
                curl_setopt($ch2, CURLOPT_POSTFIELDS, json_encode($data_post));
                curl_setopt($ch2, CURLOPT_HTTPHEADER, array(
                    "Content-Type: application/json",
                    "Authorization: Bearer ".$access_token
                ));
                $response2 = curl_exec($ch2);
                // echo $response2; die;
                $returnarray2 = json_decode($response2, true);
                // echo "<pre>"; print_r($returnarray2); die;
                curl_close($ch2);
        if(isset($returnarray2['result']['awb_number']) && !empty($returnarray2['result']['awb_number'])){  
          $awb_number = $returnarray2['result']['awb_number'];
          $smart_sub_courier_name = $returnarray2['result']['courier_id']['parent'];
            if(!empty($returnarray2['result']['sort_code']) && isset($returnarray2['result']['sort_code'])){
                $smart_route_code = $returnarray2['result']['sort_code'];
            }else{
              $smart_route_code = '';
            }
              
          
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order_data['it_easy_customer_id'] ,$shipid, $awb_number,'Prozo Success',$response2,$currentDateTime);
          ApiCall::sendWebhook($order_data['it_easy_order_id'],$shipid,$awb_number,$currentDateTime,'get_awb');
          $ApiCall = new ApiCall();
          ApiCall::findOrderModel($order_data['it_easy_order_id']);
          $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data,$awb_number,$smart_sub_courier_name,$smart_route_code);
          
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','Prozo failed',$response2,$currentDateTime);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> $response2);
        }  
        return $all_value;
      
    }
    
public function getZippy($order_data, $shipid, $access_token)
{
    
    //  echo "<pre>";

    // echo "===== ORDER DATA =====\n";
    // print_r($order_data);

    // echo "\n===== SHIP ID =====\n";
    // print_r($shipid);

    // echo "\n===== ACCESS TOKEN =====\n";
    // print_r(substr($access_token, 0, 20) . '********');

    // echo "</pre>";
    // die;
    date_default_timezone_set('Asia/kolkata');
    $currentDateTime = date('Y-m-d H:i:s');

    $shiping_data = ItEasyShippingApi::find()->where(['it_easy_ship_id' => $shipid])->one();


	$carrier_name=$shiping_data->it_easy_carrier;
	$service_name=$shiping_data->it_easy_service_name;
// 	echo $carrier_name;
// 	echo $service_name;die;
	


    // PAYMENT MODE
    if ($order_data['it_easy_payment_code'] == 'COD') {
        $mode = 'COD';
        $collectable_value = round($order_data['it_easy_total_price']);
    } else {
        $mode = 'PREPAID';
        $collectable_value = 0;
    }

    // CUSTOMER PHONE
    if (!empty($order_data['it_easy_alternate_number'])) {
        $phone = substr($order_data['it_easy_alternate_number'], -10);
    } else {
        $phone = substr($order_data['it_easy_mobile_number'], -10);
    }

    // PRODUCT LIST
    $all_product = ItEasyOrderProduct::find()
        ->where(['it_easy_order_id' => $order_data['it_easy_order_id']])
        ->all();

    $product_array = [];
    foreach ($all_product as $key => $product) {
        $product_array[$key] = [
            "productName"  => $product['it_easy_product_name'],
            "price"        => $product['it_easy_product_total'],
            "quantity"     => $product['it_easy_product_quantity'],
            "category"     => null,
            "currencyCode" => "INR",
            "sku"          => $product['it_easy_product_sku'],
            "taxRate"      => "5",
            "discount"     => "0",
            "description"  => null,
            "hs_code"      => "30049011"
        ];
    }

    // ZIPPYY API URL
    $url = "https://sellingpartnerapi-in.zippyy.ai/v1/external/shipments/forward-shipment";

    // PREPARE PAYLOAD
    $payload = [
        "orderNumber"     => "NH" . $order_data['it_easy_order_id'],
        "orderCreatedAt"  => (string) (time() * 1000),
        "channelId"       => "External",

        "sender" => [
            "firstName"   => "Skygain",
            "lastName"    => "Nutricare",
            "email"       => "support@nutriherbs.in",
            "phoneNumber" => "7827466736",
            "companyName" => "Skygain Nutricare"
        ],

        "origin" => [
            "addressLine1" => "A-52 Second Floor Okhla Phase 1",
            "addressLine2" => "Near Crown Plaza",
            "city"         => "New Delhi",
            "state"        => "Delhi",
            "country"      => "India",
            "countryCode"  => "IN",
            "pinCode"      => "110020",
            "type"         => "Work"
        ],

        "receiver" => [
            "firstName"   => $order_data['it_easy_shipping_firstname'],
            "lastName"    => $order_data['it_easy_shipping_lastname'],
            "email"       => $order_data['it_easy_email'],
            "phoneNumber" => $phone,
            "companyName" => ""
        ],

        "destination" => [
            "addressLine1" => $order_data['it_easy_shipping_address_1'],
            "addressLine2" => $order_data['it_easy_shipping_address_2'],
            "city"         => $order_data['it_easy_shipping_city'],
            "state"        => $order_data['it_easy_shipping_state'],
            "country"      => "India",
            "countryCode"  => "IN",
            "pinCode"      => $order_data['it_easy_shipping_pincode'],
            "type"         => "Residential"
        ],

        "returnAddress" => [
            "addressLine1" => "A-52 Second Floor Okhla Phase 1",
            "addressLine2" => "Near Crown Plaza",
            "city"         => "New Delhi",
            "state"        => "Delhi",
            "country"      => "India",
            "countryCode"  => "IN",
            "pinCode"      => "110020",
            "type"         => "Work"
        ],

        "type"               => "External",
        "sellerNote"         => "Order shipment",
        "parcelAttributes"   => [
            "dimension" => [
                "length" => 12,
                "width"  => 12,
                "height" => 12,
                "unit"   => "cm"
            ],
            "weight" => [
                "weight" => 1,
                "unit"   => "kg"
            ]
        ],
        "tags"                => "order",
        "productRequestsList" => $product_array,

        "shippingProperties" => [
            "orderType"       => $mode,
            "subTotal"        => round($order_data['it_easy_total_price']),
            "shippingCharges" => 0.0,
            "otherCharges"    => 0.0,
            "discount"        => 0.0
        ],

        "carrier" => $carrier_name,
        "service" => $service_name
    ];

    // CURL CALL
    $curl = curl_init();
    
//     echo "<pre>";
// echo "===== ZIPPYY REQUEST PAYLOAD =====\n";
// print_r($payload);
// echo "\n\n===== JSON ENCODED PAYLOAD =====\n";
// echo json_encode($payload, JSON_PRETTY_PRINT);
// echo "</pre>";
// die;
    curl_setopt_array($curl, [
        CURLOPT_URL            => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_POSTFIELDS     => json_encode($payload),
        CURLOPT_HTTPHEADER     => [
            "Authorization: Bearer " . $access_token,
            "Content-Type: application/json"
        ],
    ]);

    $response = curl_exec($curl);
    curl_close($curl);

    $api_result = json_decode($response, true);

    $all_value = [];

// ==========================
// SUCCESS (AWB RECEIVED)
// ==========================
if (isset($api_result['awb']) && !empty($api_result['awb'])) {

    $awb_number = $api_result['awb'];

    ApiCall::updateAwbResponce(
        $order_data['it_easy_order_id'],
        $order_data['it_easy_customer_id'],
        $shipid,
        $awb_number,
        'Zippy Success',
        $response,
        $currentDateTime
    );

    ApiCall::sendWebhook(
        $order_data['it_easy_order_id'],
        $shipid,
        $awb_number,
        $currentDateTime,
        'get_awb'
    );

    $ApiCall = new ApiCall();
    ApiCall::findOrderModel($order_data['it_easy_order_id']);
    $ApiCall->addOrderDispatch(
        $order_data,
        $shipid,
        $shiping_data,
        $awb_number,
        'Zippyy',
        ''
    );

    $all_value = array(
        'order_id'   => $order_data['it_easy_order_id'],
        'awb_number' => $awb_number,
        'responce'   => 'success'
    );

} else {

    // ==========================
    // FAIL (NO AWB)
    // ==========================
    ApiCall::updateAwbResponce(
        $order_data['it_easy_order_id'],
        $order_data['it_easy_customer_id'],
        $shipid,
        'awb number not found',
        'Zippy Failed',
        $response,
        $currentDateTime
    );

    $all_value = array(
        'order_id'   => $order_data['it_easy_order_id'],
        'awb_number' => 'awb number not find',
        'responce'   => $response
    );
}

return $all_value;

}


//nim test








// public function getNimbus($order_data, $shipid, $access_token)
// {
//     date_default_timezone_set('Asia/kolkata');
//     $currentDateTime = date('Y-m-d H:i:s');

//     $shiping_data = ItEasyShippingApi::find()
//         ->where(['it_easy_ship_id' => $shipid])
//         ->one();

//     // ---------------- PAYMENT MODE (Nimbus) ----------------
//     if ($order_data['it_easy_payment_code'] == 'COD') {
//         $payment_type = 'cod';
//     } else {
//         $payment_type = 'prepaid';
//     }

//     // ---------------- NIMBUS URL ----------------
//     $url = "https://api.nimbuspost.com/v1/shipments";

//     // ---------------- BUILD PAYLOAD ----------------
//     $post_data = [];

//     $post_data['order_number'] = substr('NH' . $order_data['it_easy_order_id'], 0, 20);
//     $post_data['payment_type'] = $payment_type;
//     $post_data['order_amount'] = round($order_data['it_easy_total_price']);

//     // ---------------- PACKAGE DETAILS ----------------
//     $post_data['package_weight']  = 400;
//     $post_data['package_length']  = 12;
//     $post_data['package_breadth'] = 12;
//     $post_data['package_height']  = 12;

//     // ---------------- CONSIGNEE DETAILS ----------------
//     $post_data['consignee']['name'] =
//         $order_data['it_easy_shipping_firstname'] . ' ' .
//         $order_data['it_easy_shipping_lastname'];

//     $post_data['consignee']['address']   = $order_data['it_easy_shipping_address_1'];
//     $post_data['consignee']['address_2'] = $order_data['it_easy_shipping_address_2'];
//     $post_data['consignee']['city']      = $order_data['it_easy_shipping_city'];
//     $post_data['consignee']['state']     = $order_data['it_easy_shipping_state'];
//     $post_data['consignee']['pincode']   = $order_data['it_easy_shipping_pincode'];
//     $post_data['consignee']['phone']     = substr($order_data['it_easy_alternate_number'], -10);

//     // ---------------- PICKUP DETAILS (Nimbus) ----------------
//     $post_data['pickup']['warehouse_name'] = 'Skygain Nutricare Private Limited';
//     $post_data['pickup']['name']           = 'Skygain Nutricare Private Limited';
//     $post_data['pickup']['address']        = 'A-52 Second Floor Okhla Phase 1 Near Crown Plaza';
//     $post_data['pickup']['address_2']      = 'A-52 Second Floor Okhla Phase 1 Near Crown Plaza';
//     $post_data['pickup']['city']           = 'New Delhi';
//     $post_data['pickup']['state']          = 'Delhi';
//     $post_data['pickup']['pincode']        = '110020';
//     $post_data['pickup']['phone']          = '7827466736';
//     $post_data['pickup']['gst_number']     = '07AAECH9422L1ZA';

//     // ---------------- ORDER ITEMS (REQUIRED BY NIMBUS) ----------------
//     $all_product = ItEasyOrderProduct::find()
//         ->where(['it_easy_order_id' => $order_data['it_easy_order_id']])
//         ->all();

//     $post_data['order_items'] = [];

//     foreach ($all_product as $key => $product) {

//         $post_data['order_items'][$key]['name'] =
//             $product['it_easy_product_name'] . ' ' .
//             $product['it_easy_variation_name'];

//         $post_data['order_items'][$key]['qty'] =
//             (string) $product['it_easy_product_quantity'];

//         $post_data['order_items'][$key]['price'] =
//             (string) round($product['it_easy_product_price']);

//         $post_data['order_items'][$key]['sku'] =
//             $product['it_easy_product_sku'] ?? '';
//     }

//     // ---------------- CURL REQUEST ----------------
//     $ch2 = curl_init();
//     curl_setopt($ch2, CURLOPT_URL, $url);
//     curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
//     curl_setopt($ch2, CURLOPT_HEADER, false);
//     curl_setopt($ch2, CURLOPT_POST, true);
//     curl_setopt($ch2, CURLOPT_POSTFIELDS, json_encode($post_data));
//     curl_setopt($ch2, CURLOPT_HTTPHEADER, [
//         "Content-Type: application/json",
//         "Authorization: Bearer " . $access_token
//     ]);

//     $response2 = curl_exec($ch2);
//     curl_close($ch2);

//     $returnarray2 = json_decode($response2, true);

//     // ---------------- SUCCESS HANDLING ----------------
//     if (
//         isset($returnarray2['status']) &&
//         $returnarray2['status'] === true &&
//         isset($returnarray2['data']['awb_number']) &&
//         !empty($returnarray2['data']['awb_number'])
//     ) {

//         $awb_number = $returnarray2['data']['awb_number'];
//         $smart_sub_courier_name = "Nimbus";
//         $smart_route_code = '';

//         ApiCall::updateAwbResponce(
//             $order_data['it_easy_order_id'],
//             $order_data['it_easy_customer_id'],
//             $shipid,
//             $awb_number,
//             'Nimbus Awb Success',
//             $response2,
//             $currentDateTime
//         );

//         ApiCall::sendWebhook(
//             $order_data['it_easy_order_id'],
//             $shipid,
//             $awb_number,
//             $currentDateTime,
//             'get_awb'
//         );

//         ApiCall::findOrderModel($order_data['it_easy_order_id']);

//         $ApiCall = new ApiCall();
//         $ApiCall->addOrderDispatch(
//             $order_data,
//             $shipid,
//             $shiping_data,
//             $awb_number,
//             $smart_sub_courier_name,
//             $smart_route_code
//         );

//          $all_value =  array(
//             'order_id'   => $order_data['it_easy_order_id'],
//             'awb_number' => $awb_number,
//             'responce'   => 'success'
//         );

//     } else {

//         ApiCall::updateAwbResponce(
//             $order_data['it_easy_order_id'],
//             $order_data['it_easy_customer_id'],
//             $shipid,
//             'awb number not found',
//             'Nimbus failed',
//             $response2,
//             $currentDateTime
//         );

//         $all_value =  array(
//             'order_id'   => $order_data['it_easy_order_id'],
//             'awb_number' => 'awb number not found',
//             'responce'   => $response2
//         );
//     }
//     return $all_value;
// }



//end


    
    
    public function getBlitz($order_data,$shipid,$access_token){
        //
        // echo $access_token;
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $shiping_data =  ItEasyShippingApi::find()->where(['it_easy_ship_id'=>$shipid])->One();
        $invoice_no = $order_data['it_easy_invoice_number'];
            
        if(!empty($order_data['it_easy_alternate_number'])){
            $telephone2=substr($order_data['it_easy_alternate_number'], -10);
        } else {
            $telephone2=substr($order_data['it_easy_mobile_number'], -10);
        }
        if($order_data['it_easy_payment_code']=='COD'){
            $mode='COD';
            $collectable_value=round($order_data['it_easy_total_price']);
        } else {
            $mode='PREPAID';
            $collectable_value='0';
        }  
        if(!empty($order_data['it_easy_converted_time'] && isset($order_data['it_easy_converted_time']))){
            $invoice_date = date('d-m-Y', strtotime($order_data['it_easy_converted_time']));
        }else{
            $invoice_date = date('d-m-Y');
        }
         
        $url = "https://xv24xrhpxa.execute-api.ap-south-1.amazonaws.com/v1/waybill/";
        
        
        $post_data['channelId'] = 'Nutriherbs'; 
        $post_data['returnShipmentFlag'] = false; 
        $post_data['Shipment']['code'] = 'NH'.$order_data['it_easy_order_id'].'ss'.rand(0,100); 
        $post_data['Shipment']['orderCode'] = 'NH'.$order_data['it_easy_order_id']; 
        $post_data['Shipment']['weight'] = '50';
        $post_data['Shipment']['length'] = '50';
        $post_data['Shipment']['height'] = '50';
        $post_data['Shipment']['breadth'] = '50';
        
        $all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
                $productarray = [];
        foreach($all_product as $key => $product){
             
                $post_data['Shipment']['items'][$key]['name'] =  $product['it_easy_product_name'].' '.$product['it_easy_variation_name'];
                $post_data['Shipment']['items'][$key]['description'] =  $product['it_easy_product_name'].' '.$product['it_easy_variation_name'];
                $post_data['Shipment']['items'][$key]['quantity'] =  (string)$product['it_easy_product_quantity'];
                $post_data['Shipment']['items'][$key]['item_value'] =  $product['it_easy_product_total'];
                $post_data['Shipment']['items'][$key]['skuCode'] =  "";
               
        } 
                $post_data['deliveryAddressDetails']['name'] = $order_data['it_easy_shipping_firstname'].' '.$order_data['it_easy_shipping_lastname'];
                $post_data['deliveryAddressDetails']['phone'] = substr($order_data['it_easy_mobile_number'], -10);
                $post_data['deliveryAddressDetails']['address1'] = $order_data['it_easy_shipping_address_1'];
                $post_data['deliveryAddressDetails']['address2'] = $order_data['it_easy_shipping_address_2'];
                $post_data['deliveryAddressDetails']['pincode'] = $order_data['it_easy_shipping_pincode'];
                $post_data['deliveryAddressDetails']['city'] = $order_data['it_easy_shipping_city'];
                $post_data['deliveryAddressDetails']['state'] = $order_data['it_easy_shipping_state'];
                $post_data['deliveryAddressDetails']['country'] = 'INDIA';
                
                $post_data['pickupAddressDetails']['name'] = "Shadab";
                $post_data['pickupAddressDetails']['phone'] = "7827466736";
                $post_data['pickupAddressDetails']['address1'] = "Skygain Nutricare PVT LTD A-52 Second Floor";
                $post_data['pickupAddressDetails']['address2'] = "Okhla Phase 1 Near Crown Plaza";
                $post_data['pickupAddressDetails']['pincode'] = "110020";
                $post_data['pickupAddressDetails']['city'] = "New Delhi";
                $post_data['pickupAddressDetails']['state'] = "Delhi";
                $post_data['pickupAddressDetails']['country'] = 'INDIA';
                
                $post_data['paymentMode'] = $mode;
                $post_data['totalAmount'] = (string)round($order_data['it_easy_total_price']);
                $post_data['collectableAmount'] = $collectable_value;
               
        
    
        
        // echo $access_token; echo "<br>";
    
                
        //   echo "<pre>"; print_r($post_data);
          
        //   echo json_encode($post_data);
                $ch2 = curl_init();
                curl_setopt($ch2, CURLOPT_URL, $url);
                curl_setopt($ch2, CURLOPT_RETURNTRANSFER, TRUE);
                curl_setopt($ch2, CURLOPT_HEADER, FALSE);
                curl_setopt($ch2, CURLOPT_POST, TRUE);
                curl_setopt($ch2, CURLOPT_POSTFIELDS, json_encode($post_data));
                curl_setopt($ch2, CURLOPT_HTTPHEADER, array(
                    "Content-Type: application/json",
                    "Authorization: ".$access_token
                ));
                $response2 = curl_exec($ch2);
                // echo $response2; die;
                $returnarray2 = json_decode($response2, true);
                // echo "<pre>"; print_r($returnarray2); die;
                curl_close($ch2);
        if(isset($returnarray2['waybill']) && !empty($returnarray2['waybill'])){  
          $awb_number = $returnarray2['waybill'];
          $smart_sub_courier_name = "Blitz";
          
            $smart_route_code = '';
          
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order_data['it_easy_customer_id'] ,$shipid, $awb_number,'Blitz Success',$response2,$currentDateTime);
          ApiCall::sendWebhook($order_data['it_easy_order_id'],$shipid,$awb_number,$currentDateTime,'get_awb');
          $ApiCall = new ApiCall();
          ApiCall::findOrderModel($order_data['it_easy_order_id']);
          $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data,$awb_number,$smart_sub_courier_name,$smart_route_code);
          
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','Blitz failed',$response2,$currentDateTime);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> $response2);
        }  
        return $all_value;
      
    }
    
    
    public function getProfessional($order_data,$shipid){
        //
        // echo $access_token; die;
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $shiping_data =  ItEasyShippingApi::find()->where(['it_easy_ship_id'=>$shipid])->One();
        $invoice_no = $order_data['it_easy_invoice_number'];
            
        if(!empty($order_data['it_easy_alternate_number'])){
            $telephone2=substr($order_data['it_easy_alternate_number'], -10);
        } else {
            $telephone2=substr($order_data['it_easy_mobile_number'], -10);
        }
        if($order_data['it_easy_payment_code']=='COD'){
            $mode='CASH';
            $collectable_value=round($order_data['it_easy_total_price']);
        } else {
            $mode='PREPAID';
            $collectable_value='0';
        }  
        if(!empty($order_data['it_easy_converted_time'] && isset($order_data['it_easy_converted_time']))){
            $invoice_date = date('d-m-Y', strtotime($order_data['it_easy_converted_time']));
        }else{
            $invoice_date = date('d-m-Y');
        }
        
        
        $parameters = array(
                	'REF_NO' => $order_data['it_easy_order_id'].''.rand(0,100),
                	'BDATE' => date('Y-m-d'),
                	'SENDER' => 'Skygain Nutracare PVT LTD',
                	'SENDER_CODE' => '112200',
                	'SENDER_ADDRESS' => 'A-52 Second Floor Okhla Phase 1 Near Crown Plaza',
                	'SENDER_CITY' => 'New Delhi',
                	'SENDER_PINCODE' => '110020',
                	'SENDER_MOB' => '7827466736',
                	'SENDER_EMAIL' => 'support@nutriherbs.com',
                	'GSTIN' => '07AAECH9422L1ZA',
                	'RECIPIENT' => $order_data['it_easy_shipping_firstname'].' '.$order_data['it_easy_shipping_lastname'],
                	'RECIPIENT_ADDRESS' => $order_data['it_easy_shipping_address_1'].' '.$order_data['it_easy_shipping_address_2'],
                	'RECIPIENT_CITY' => $order_data['it_easy_shipping_city'].' '.$order_data['it_easy_shipping_state'],
                	'RECIPIENT_PINCODE' => $order_data['it_easy_shipping_pincode'],
                	'RECIPIENT_MOB' => substr($order_data['it_easy_mobile_number'], -10),
                	'RECIPIENT_EMAIL' => $order_data['it_easy_email'],
                	'WEIGHT' => '0.4',
                	'PIECES' =>  '1',
                	'FLYER_NO' => "s123456", 
                	'CUST_INVOICE' => $order_data['it_easy_invoice_number'],
                	'CUST_INVOICEAMT' => round($order_data['it_easy_total_price']),
                	'VOL_LENGTH' => "5",
                	'VOL_WIDTH' => "10",
                	'VOL_HEIGHT' => "10",
                	'DESCRIPTION' => "Order",
                	'REMARKS' => "Order",
                	'COD_AMOUNT' => $collectable_value,
                	'PAYMENT_MODE' => $mode,
                	'TYPE' => "",
                	'ORDER_STATUS' => "HOLD"
                	);
                // echo "<pre>"; print_r($parameters);
            //   echo json_encode($parameters);  die; 
        $url="https://tpcglobe.com/TPCWebService/PickupRequest.ashx?client=GGNGGN0307&tpcpwd=GGN321";
        
    
                
        //   echo "<pre>"; print_r($parameters);
                $ch_xsprs = curl_init();
                $headers= array('Accept: application/json','Content-Type: application/json');
                curl_setopt($ch_xsprs, CURLOPT_URL, $url);
                curl_setopt($ch_xsprs, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch_xsprs, CURLOPT_POST, 1);
                curl_setopt($ch_xsprs, CURLOPT_POSTFIELDS, json_encode($parameters));
                curl_setopt($ch_xsprs, CURLOPT_RETURNTRANSFER, true);
                $response2  = curl_exec($ch_xsprs);
                // echo $response2; die;
                $returnarray2 = json_decode($response2, true);
                // echo "<pre>"; print_r($returnarray2); die;
                curl_close($ch_xsprs);
        if(isset($returnarray2['status']) && $returnarray2['status'] == 'success'){  
          $awb_number = $returnarray2['POD_NO'];
          $smart_sub_courier_name = "Professional";
          if(!empty($returnarray2['REF_NO']) && isset($returnarray2['REF_NO'])){
          $smart_route_code = $returnarray2['REF_NO'];
          }else{
              $smart_route_code = '';
          }
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order_data['it_easy_customer_id'] ,$shipid, $awb_number,'Professional Success',$response2,$currentDateTime);
          ApiCall::sendWebhook($order_data['it_easy_order_id'],$shipid,$awb_number,$currentDateTime,'get_awb');
          $ApiCall = new ApiCall();
          ApiCall::findOrderModel($order_data['it_easy_order_id']);
          $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data,$awb_number,$smart_sub_courier_name,$smart_route_code);
          
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','Professional failed',$response2,$currentDateTime);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> $response2);
        }  
        return $all_value;
      
    }
    
    
    
    
    public function getPickndel($order_data,$shipid,$access_token){
        //
        // echo $access_token; die;
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $shiping_data =  ItEasyShippingApi::find()->where(['it_easy_ship_id'=>$shipid])->One();
        $invoice_no = $order_data['it_easy_invoice_number'];
            
        if(!empty($order_data['it_easy_alternate_number'])){
            $telephone2=substr($order_data['it_easy_alternate_number'], -10);
        } else {
            $telephone2=substr($order_data['it_easy_mobile_number'], -10);
        }
        if($order_data['it_easy_payment_code']=='COD'){
            $mode='COD';
            $collectable_value=round($order_data['it_easy_total_price']);
        } else {
            $mode='Prepaid';
            $collectable_value='0';
        }  
        if(!empty($order_data['it_easy_converted_time'] && isset($order_data['it_easy_converted_time']))){
            $invoice_date = date('d-m-Y', strtotime($order_data['it_easy_converted_time']));
        }else{
            $invoice_date = date('d-m-Y');
        }
       
         $all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
                $productarray = [];
        foreach($all_product as $key => $product){
             
                $productarray[$key]['Qty'] =  $product['it_easy_product_quantity'];
                $productarray[$key]['Type'] = "Goods";
                $productarray[$key]['IsFragile'] = "0";
                $productarray[$key]['IsLiquid'] = "0";
                $productarray[$key]['Name'] = $product['it_easy_product_name'].' '.$product['it_easy_variation_name'];
                $productarray[$key]['Cost'] = $product['it_easy_product_total'];
                $productarray[$key]['Length'] = "10";
                $productarray[$key]['Width'] = "10";
                $productarray[$key]['Height'] = "10";
                $productarray[$key]['ActualWeight'] = "0.20";
                $productarray[$key]['EWayBillNo'] = "";
        }


        $arrayData = [
                "Control" => [
                    "RequestId" => 'NH'.$order_data['it_easy_order_id'].'-'.Yii::$app->security->generateRandomString(4),
                    "Source" => "3",
                    "RequestTime" => time(),
                    "Version" => "3.2"
                ],
                "Data" => [
                    "UserId" => "7103",
                    "OrderDetails" => [
                        [
                            "PreAWBNo" => "",
                            "ClientUniqueNo" => 'NH'.$order_data['it_easy_order_id'].'-'.Yii::$app->security->generateRandomString(4),
                            "VehicleType" => "Dietry Product",
                            "BrandName" => "Nutriherbs",
                            "OrderType" => "B2C",
                            "InvoiceNo" => $invoice_no,
                            "InvoiceUrl" => "",
                            "InvoiceValue" => round($order_data['it_easy_total_price']),
                            "EWAYBillNo" => 'NH'.$order_data['it_easy_order_id'].'/'.Yii::$app->security->generateRandomString(4),
                            "TotalActualWeight" => "0.200",
                            "Info" => [
                                [
                                    "Pickup" => [
                                        "UniqueNo" => "7827466736",
                                        "PersonName" => "Shadab",
                                        "Mobile" => "7827466736",
                                        "AddressType" => "Office",
                                        "HouseNo" => "",
                                        "Landmark" => "",
                                        "Address" => "A-52,Second Floor , Okhla Phase -1 , Near Crown Plaza Delhi",
                                        "Lat" => "",
                                        "Lng" => "",
                                        "Pincode" => "110020",
                                        "CashPaid" => "0",
                                        "CashCollection" => "0",
                                        "Comment" => "",
                                        "PickupDate" => "",
                                        "PickupSlot" => "",
                                        "RTOAddr" => ""
                                    ],
                                    "Item" => $productarray,
                                    "Delivery" => [
                                        "UniqueNo" => substr($order_data['it_easy_mobile_number'], -10),
                                        "PersonName" => $order_data['it_easy_shipping_firstname'].' '.$order_data['it_easy_shipping_lastname'],
                                        "Mobile" => substr($order_data['it_easy_mobile_number'], -10),
                                        "AddressType" => "home",
                                        "HouseNo" => "",
                                        "Landmark" => "",
                                        "Address" => $order_data['it_easy_shipping_address_1'].' '.$order_data['it_easy_shipping_address_2']." ".$order_data['it_easy_shipping_city'].' '.$order_data['it_easy_shipping_state'],
                                        "Lat" => "",
                                        "Lng" => "",
                                        "Pincode" => $order_data['it_easy_shipping_pincode'],
                                        "CashCollection" => $collectable_value,
                                        "Comment" => ""
                                    ]
                                ]
                            ]
                        ]
                    ]
                ]
            ]; 
         
         
         
         
         
        $url = "https://api.pikndel.com/backoffice/api/pikndel/place_order";

                
        //   echo "<pre>"; print_r($post_Data); die;
                $ch2 = curl_init();
                curl_setopt($ch2, CURLOPT_URL, $url);
                curl_setopt($ch2, CURLOPT_RETURNTRANSFER, TRUE);
                curl_setopt($ch2, CURLOPT_HEADER, FALSE);
                curl_setopt($ch2, CURLOPT_POST, TRUE);
                curl_setopt($ch2, CURLOPT_POSTFIELDS, json_encode($arrayData));
                curl_setopt($ch2, CURLOPT_HTTPHEADER, array(
                    "Content-Type: application/json",
                    "Authorization: Bearer ".$access_token
                ));
                $response2 = curl_exec($ch2);
                // echo $response2; die;
                $returnarray2 = json_decode($response2, true);
                // echo "<pre>"; print_r($returnarray2); die;
                curl_close($ch2);
        if(isset($returnarray2['Data'][0]['Details'][0]['AWBNo']) && !empty($returnarray2['Data'][0]['Details'][0]['AWBNo'])){  
          $awb_number = $returnarray2['Data'][0]['Details'][0]['AWBNo'];
          $smart_sub_courier_name = "PICKNDEL";
          if(!empty($returnarray2['Data'][0]['Details'][0]['DeliveryHUBCentre']) && isset($returnarray2['Data'][0]['Details'][0]['DeliveryHUBCentre'])){
          $smart_route_code = $returnarray2['Data'][0]['Details'][0]['DeliveryHUBCentre'];
          }else{
              $smart_route_code = '';
          }
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order_data['it_easy_customer_id'] ,$shipid, $awb_number,'Pickndel Success',$response2,$currentDateTime);
          ApiCall::sendWebhook($order_data['it_easy_order_id'],$shipid,$awb_number,$currentDateTime,'get_awb');
          $ApiCall = new ApiCall();
          ApiCall::findOrderModel($order_data['it_easy_order_id']);
          $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data,$awb_number,$smart_sub_courier_name,$smart_route_code);
          
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','Pickndel failed',$response2,$currentDateTime);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> $response2);
        }  
        return $all_value;
      
    }
    
    
    
    public function getRapidsyp($order_data,$shipid){
        //
        // echo $access_token; die;
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $shiping_data =  ItEasyShippingApi::find()->where(['it_easy_ship_id'=>$shipid])->One();
        
        $shipping_value =  ItEasyShippingPaymentMethod::find()->andWhere(['it_easy_method_code'=>$order_data['it_easy_shipping_code']])->One();
        if(!empty($order_data['it_easy_coupon_id'])){
            $coupon_value =  ItEasyCoupon::find()->where(['it_easy_id'=>$order_data['it_easy_coupon_id']])->One();
            $coupon_discount = $coupon_value->it_easy_discount;
        }else{
            $coupon_discount = 0;
        }
        
        
        $invoice_no = $order_data['it_easy_invoice_number'];
            
        if(!empty($order_data['it_easy_alternate_number'])){
            $telephone2=substr($order_data['it_easy_alternate_number'], -10);
        } else {
            $telephone2=substr($order_data['it_easy_mobile_number'], -10);
        }
        if($order_data['it_easy_payment_code']=='COD'){
            $mode='COD';
            $collectable_value=round($order_data['it_easy_total_price']);
        } else {
            $mode='PREPAID';
            $collectable_value='0';
        }  
        if(!empty($order_data['it_easy_converted_time'] && isset($order_data['it_easy_converted_time']))){
            $invoice_date = date('Y-m-d', strtotime($order_data['it_easy_converted_time']));
        }else{
            $invoice_date = date('Y-m-d');
        }
        
        
        
        $url = "https://api.rapidshyp.com/rapidshyp/apis/v1/wrapper";
       
       	$apiKey = $shiping_data->it_easy_auth_key; // Replace with your actual API key
       	
       	$order_data['it_easy_mobile_number'] = preg_replace('/\D/', '', $order_data['it_easy_mobile_number']);
       	$order_data['it_easy_mobile_number'] = substr($order_data['it_easy_mobile_number'], -10);
       
       $product_array = [];
       
        $all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
        // echo "<pre>"; print_r($all_product); die;
                $productarray = [];
        foreach($all_product as $key => $product){
             
         	$product_array[$key]['itemName'] = $product['it_easy_product_name'].' '.$product['it_easy_variation_name'];
         	$product_array[$key]['sku'] = "";
         	$product_array[$key]['description'] = $product['it_easy_product_name'].' '.$product['it_easy_variation_name'];
         	$product_array[$key]['units'] = (int)$product['it_easy_product_quantity'];
         	$product_array[$key]['unitPrice'] = (int)$product['it_easy_product_total']/ (int)$product['it_easy_product_quantity'];
         	$product_array[$key]['tax'] = 0.0;
         	$product_array[$key]['hsn'] = '30049011';
         	$product_array[$key]['productLength'] = 5.0;
         	$product_array[$key]['productBreadth'] = 5.0;
         	$product_array[$key]['productHeight'] = 5.0;
         	$product_array[$key]['productWeight'] = 0.5;
         	$product_array[$key]['brand'] = 'Nutriherbs';
         	$product_array[$key]['imageURL'] = 'http://example.com/product1.jpg';
         	$product_array[$key]['isFragile'] = false;
         	$product_array[$key]['isPersonalisable'] = false;   
        }   
       
           $data = [
              "orderId" => 'N-'.$order_data['it_easy_order_id'].'SS'.rand(1, 100),
              "orderDate" => $invoice_date,
              "pickupAddressName" => "Nutriherbs Warehouse",
              "pickupLocation" => [
                  "contactName" => "Shadab",
                  "pickupName" => 'Nutriherbs Warehouse',
                  "pickupEmail" => 'logistics@nutriherbs.in',
                  "pickupPhone" => '7827466736',
                  "pickupAddress1" => 'A-52,Second Floor , Okhla Phase -1 , Near Crown Plaza',
                  "pickupAddress2" => '',
                  "pinCode" => '110020'
              ],
              "storeName" => "DEFAULT",
              "billingIsShipping" => true,
              "shippingAddress" => [
                  "firstName" => $order_data['it_easy_shipping_firstname'],
                  "lastName" => $order_data['it_easy_shipping_lastname'],
                  "addressLine1" => $order_data['it_easy_shipping_address_1'].' '.$order_data['it_easy_shipping_address_2'],
                  "addressLine2" => $order_data['it_easy_shipping_city'].' '.$order_data['it_easy_shipping_state'],
                  "pinCode" => $order_data['it_easy_shipping_pincode'],
                  "email" => $order_data['it_easy_email'],
                  "phone" => substr($order_data['it_easy_mobile_number'], -10)
              ],
              "billingAddress" => [
                  "firstName" => $order_data['it_easy_shipping_firstname'],
                  "lastName" => $order_data['it_easy_shipping_lastname'],
                  "addressLine1" => $order_data['it_easy_shipping_address_1'].' '.$order_data['it_easy_shipping_address_2'],
                  "addressLine2" => $order_data['it_easy_shipping_city'].' '.$order_data['it_easy_shipping_state'],
                  "pinCode" => $order_data['it_easy_shipping_pincode'],
                  "email" => $order_data['it_easy_email'],
                  "phone" => substr($order_data['it_easy_mobile_number'], -10)
              ],
              "orderItems" => $product_array,
              "paymentMethod" => $mode,
              "shippingCharges" => (int)$shipping_value->it_easy_method_value,
              "giftWrapCharges" => 0.0,
              "transactionCharges" => 0.0,
              "totalDiscount" => (int)$coupon_discount,
            //   "totalOrderValue" => round($order_data['it_easy_total_price']),
              "codCharges" => 0.0,
              "prepaidAmount" => 0.0,
              "packageDetails" => [
                  "packageLength" => 5.0,
                  "packageBreadth" => 5.0,
                  "packageHeight" => 5.0,
                  "packageWeight" => 5.0
              ]
          ];
           	
           	// 	echo "<pre>"; print_r($data); die;	
           		$ch = curl_init($url);
    
                // Set cURL options
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    'Content-Type: application/json',
                    'rapidshyp-token: ' . $apiKey
                ]);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    
                // Execute cURL request
                $response2 = curl_exec($ch);
           		$returnarray2 = json_decode($response2, true);
           	// 	echo "<pre>"; print_r($returnarray); die;
                //return $returnarray2;
                curl_close($ch);
    
        if(isset($returnarray2['shipment'][0]['awb']) && !empty($returnarray2['shipment'][0]['awb'])){  
          $awb_number = $returnarray2['shipment'][0]['awb'];
          $smart_sub_courier_name = $returnarray2['shipment'][0]['parentCourierName'];
          if(!empty($returnarray2['shipment'][0]['routingCode']) && isset($returnarray2['shipment'][0]['routingCode'])){
          $smart_route_code = $returnarray2['shipment'][0]['routingCode'];
          }else{
              $smart_route_code = '';
          }
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order_data['it_easy_customer_id'] ,$shipid, $awb_number,'Rapidsyp Success',$response2,$currentDateTime);
         ApiCall::sendWebhook($order_data['it_easy_order_id'],$shipid,$awb_number,$currentDateTime,'get_awb');
          $ApiCall = new ApiCall();
          ApiCall::findOrderModel($order_data['it_easy_order_id']);
          $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data,$awb_number,$smart_sub_courier_name,$smart_route_code);
          
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','Rapidsyp failed',$response2,$currentDateTime);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> $response2);
        }  
        return $all_value;
      
    }
    
    
    public function getDtdc($order_data,$shipid){
        //
        // echo $access_token; die;
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $shiping_data =  ItEasyShippingApi::find()->where(['it_easy_ship_id'=>$shipid])->One();
        
        $shipping_value =  ItEasyShippingPaymentMethod::find()->andWhere(['it_easy_method_code'=>$order_data['it_easy_shipping_code']])->One();
        if(!empty($order_data['it_easy_coupon_id'])){
            $coupon_value =  ItEasyCoupon::find()->where(['it_easy_id'=>$order_data['it_easy_coupon_id']])->One();
            $coupon_discount = $coupon_value->it_easy_discount;
        }else{
            $coupon_discount = 0;
        }
        
        
        $invoice_no = $order_data['it_easy_invoice_number'];
            
        if(!empty($order_data['it_easy_alternate_number'])){
            $telephone2=substr($order_data['it_easy_alternate_number'], -10);
        } else {
            $telephone2=substr($order_data['it_easy_mobile_number'], -10);
        }
        if($order_data['it_easy_payment_code']=='COD'){
            $mode='cash';
            $collectable_value=round($order_data['it_easy_total_price']);
        } else {
            $mode='';
            $collectable_value='0';
        }  
        if(!empty($order_data['it_easy_converted_time'] && isset($order_data['it_easy_converted_time']))){
            $invoice_date = date('Y-m-d', strtotime($order_data['it_easy_converted_time']));
        }else{
            $invoice_date = date('Y-m-d');
        }
        
        
        
        $url = "https://pxapi.dtdc.in/api/customer/integration/consignment/softdata";
       
       	$apiKey = $shiping_data->it_easy_auth_key; // Replace with your actual API key
       	
       	$order_data['it_easy_mobile_number'] = preg_replace('/\D/', '', $order_data['it_easy_mobile_number']);
       	$order_data['it_easy_mobile_number'] = substr($order_data['it_easy_mobile_number'], -10);
       
       $product_array = [];
       
        $all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
        // echo "<pre>"; print_r($all_product); die;
        $count_price = count($all_product);
                $productarray = [];
        foreach($all_product as $key => $product){
             
         	$product_array[$key]['description'] = $product['it_easy_product_name'].' '.$product['it_easy_variation_name'];
         	
         	$product_array[$key]['declared_value'] = (int)$product['it_easy_product_total'];
         	$product_array[$key]['height'] = 5;
         	$product_array[$key]['length'] = 5;
         	$product_array[$key]['width'] = 5;
         	$product_array[$key]['weight'] = 0.5; 
        }
        
        $data_post['consignments'][0]['customer_code'] = 'GL10246';
        $data_post['consignments'][0]['service_type_id'] = 'B2C SMART EXPRESS';
        $data_post['consignments'][0]['load_type'] = 'NON-DOCUMENT';
        $data_post['consignments'][0]['description'] = 'Nutra Product';
        $data_post['consignments'][0]['dimension_unit'] = 'cm';
        $data_post['consignments'][0]['length'] = '10';
        $data_post['consignments'][0]['width'] = '10';
        $data_post['consignments'][0]['height'] = '10';
        $data_post['consignments'][0]['weight_unit'] = 'kg';
        $data_post['consignments'][0]['weight'] = '0.240';
        $data_post['consignments'][0]['declared_value'] = round($order_data['it_easy_total_price']);
        $data_post['consignments'][0]['num_pieces'] = $count_price;
        $data_post['consignments'][0]['origin_details']['name'] = 'Skygain Nutricare PVT LTD';
        $data_post['consignments'][0]['origin_details']['phone'] = '7827466736';
        $data_post['consignments'][0]['origin_details']['alternate_phone'] = '7827466736';
        $data_post['consignments'][0]['origin_details']['address_line_1'] = 'A-52,Second Floor , Okhla Phase -1';
        $data_post['consignments'][0]['origin_details']['address_line_2'] = 'Near Crown Plaza';
        $data_post['consignments'][0]['origin_details']['pincode'] = '110020';
        $data_post['consignments'][0]['origin_details']['city'] = 'Delhi';
        $data_post['consignments'][0]['origin_details']['state'] = 'Delhi';
        $data_post['consignments'][0]['destination_details']['name'] = $order_data['it_easy_shipping_firstname'].' '.$order_data['it_easy_shipping_lastname'];
        $data_post['consignments'][0]['destination_details']['phone'] = substr($order_data['it_easy_mobile_number'], -10);
        $data_post['consignments'][0]['destination_details']['alternate_phone'] = substr($order_data['it_easy_mobile_number'], -10);
        $data_post['consignments'][0]['destination_details']['address_line_1'] = $order_data['it_easy_shipping_address_1'];
        $data_post['consignments'][0]['destination_details']['address_line_2'] = $order_data['it_easy_shipping_address_2'];
        $data_post['consignments'][0]['destination_details']['pincode'] = $order_data['it_easy_shipping_pincode'];
        $data_post['consignments'][0]['destination_details']['city'] = $order_data['it_easy_shipping_city'];
        $data_post['consignments'][0]['destination_details']['state'] = $order_data['it_easy_shipping_state'];
        $data_post['consignments'][0]['customer_reference_number'] = 'N-'.$order_data['it_easy_order_id'].'SS'.rand(1, 100);
        $data_post['consignments'][0]['cod_collection_mode'] = $mode;
        $data_post['consignments'][0]['cod_amount'] = $collectable_value;
        $data_post['consignments'][0]['commodity_id'] = '7';
        $data_post['consignments'][0]['pieces_detail'] = $product_array;
                // echo "<pre>"; print_r($data_post); 
                
                // echo json_encode($data_post);
           		$ch = curl_init($url);
    
                // Set cURL options
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    'Content-Type: application/json',
                    'api-key: 9b36e284715f58b22ab8295c13a844'
                ]);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data_post));
    
                // Execute cURL request
                $response2 = curl_exec($ch);
                // echo $response2;
           		$returnarray2 = json_decode($response2, true);
           	// 	echo "<pre>"; print_r($returnarray2); die;
                //return $returnarray2;
                curl_close($ch);
    
        if(isset($returnarray2['data'][0]['reference_number']) && !empty($returnarray2['data'][0]['reference_number'])){  
          $awb_number = $returnarray2['data'][0]['reference_number'];
          $smart_sub_courier_name = 'DTDC';
          
              $smart_route_code = '';
          
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order_data['it_easy_customer_id'] ,$shipid, $awb_number,'DTDC Success',$response2,$currentDateTime);
          ApiCall::sendWebhook($order_data['it_easy_order_id'],$shipid,$awb_number,$currentDateTime,'get_awb');
          
          $ApiCall = new ApiCall();
          ApiCall::findOrderModel($order_data['it_easy_order_id']);
          $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data,$awb_number,$smart_sub_courier_name,$smart_route_code);
          
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','DTDC failed',$response2,$currentDateTime);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> $response2);
        }  
        return $all_value;
      
    }
    
    
    
    public function getQuickshift($order_data,$shipid){
        //
        // echo $access_token; die;
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $shiping_data =  ItEasyShippingApi::find()->where(['it_easy_ship_id'=>$shipid])->One();
        
        $shipping_value =  ItEasyShippingPaymentMethod::find()->andWhere(['it_easy_method_code'=>$order_data['it_easy_shipping_code']])->One();
        if(!empty($order_data['it_easy_coupon_id'])){
            $coupon_value =  ItEasyCoupon::find()->where(['it_easy_id'=>$order_data['it_easy_coupon_id']])->One();
            $coupon_discount = $coupon_value->it_easy_discount;
        }else{
            $coupon_discount = 0;
        }
        
        
        $invoice_no = $order_data['it_easy_invoice_number'];
            
        if(!empty($order_data['it_easy_alternate_number'])){
            $telephone2=substr($order_data['it_easy_alternate_number'], -10);
        } else {
            $telephone2=substr($order_data['it_easy_mobile_number'], -10);
        }
        if($order_data['it_easy_payment_code']=='COD'){
            $mode='COD';
            $collectable_value=round($order_data['it_easy_total_price']);
        } else {
            $mode='PREPAID';
            $collectable_value='0';
        }  
        if(!empty($order_data['it_easy_converted_time'] && isset($order_data['it_easy_converted_time']))){
            $invoice_date = date('Y-m-d', strtotime($order_data['it_easy_converted_time']));
        }else{
            $invoice_date = date('Y-m-d');
        }
        
        
        
        $url = "https://api.quickshift.in/qs_ecom/externalAPI/public/createShipment";
       
       	$apiKey = $shiping_data->it_easy_auth_key; // Replace with your actual API key
       	
       	$order_data['it_easy_mobile_number'] = preg_replace('/\D/', '', $order_data['it_easy_mobile_number']);
       	$order_data['it_easy_mobile_number'] = substr($order_data['it_easy_mobile_number'], -10);
       
       $product_array = [];
       
        $all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
        // echo "<pre>"; print_r($all_product); die;
        
        $count_price = count($all_product);
                $productarray = [];
        foreach($all_product as $key => $product){
            $product_array[$key]['suborder_quantity'] = (int)$product['it_easy_product_quantity']; 
            $product_array[$key]['item_quantity'] = (int)$product['it_easy_product_quantity']; 
            $product_array[$key]['returned_quantity'] = 0; 
            $product_array[$key]['cancelled_quantity'] = 0;
            $product_array[$key]['shipped_quantity'] = (int)$product['it_easy_product_quantity'];
            $product_array[$key]['tax_type'] = 'GST';
            $product_array[$key]['company_product_id'] = $product['it_easy_product_id'];
            $product_array[$key]['sku'] = $product['it_easy_variation_name'];
            $product_array[$key]['sku'] = 'Normal';
            $product_array[$key]['sub_product_count'] = (int)$product['it_easy_product_quantity']; 
            $product_array[$key]['productName'] = $product['it_easy_product_name'].' '.$product['it_easy_variation_name'];
         	$product_array[$key]['description'] = $product['it_easy_product_name'].' '.$product['it_easy_variation_name'];
         	$product_array[$key]['category'] = 'dietary heral tablet';
         	$product_array[$key]['brand'] = 'Nutriherbs';
         	$product_array[$key]['model_no'] = 'Nutriherbs';
         	$product_array[$key]['product_tax_code'] = '5206';
            $product_array[$key]['ean'] = '9977665555';
            $product_array[$key]['size'] = '64';
            $product_array[$key]['cost'] = (int)$product['it_easy_product_total'];
            $product_array[$key]['mrp'] = (int)$product['it_easy_product_total'];
            $product_array[$key]['weight'] = 200;
            $product_array[$key]['length'] = 10;
            $product_array[$key]['width'] = 10;
            $product_array[$key]['height'] = 10;
            $product_array[$key]['scheme_applied'] = 0;
            $product_array[$key]['custom_fields'] = [];
            $product_array[$key]['tax_rate'] = 12;
            $product_array[$key]['selling_price'] = (int)$product['it_easy_product_total'];
            $product_array[$key]['item_status'] = 'Confirmed';
            $product_array[$key]['breakup_types']['Item Amount Excluding Tax'] = (int)$product['it_easy_product_price'];
            $product_array[$key]['breakup_types']['Item Amount IGST'] = (int)$product['it_easy_product_tax'];
        }
        $data_post['order_data']['reference_code'] = 'NH'.$order_data['it_easy_order_id'].'SS'.rand(1, 100);
        $data_post['order_data']['company_name'] = 'Skygain Nutricare PVT LTD';
        $data_post['order_data']['seller_gst'] = '07AAVCS9330D1Z0';
        $data_post['order_data']['pickup_address'] = 'A-52, 3rd Floor , Okhla Phase -1 New Delhi';
        $data_post['order_data']['pickup_name'] = 'Regular';
        $data_post['order_data']['pickup_city'] = 'New Delhi';
        $data_post['order_data']['pickup_state'] = 'Delhi';
        $data_post['order_data']['pickup_pin_code'] = '110020';
        $data_post['order_data']['pickup_country'] = 'India';
        $data_post['order_data']['pickup_phone'] = '7827466736';
        $data_post['order_data']['order_type'] = 'B2C';
        $data_post['order_data']['marketplace'] = 'Offline';
        $data_post['order_data']['order_date'] = date('Y-m-d H:i:s');
        $data_post['order_data']['invoice_date'] = date('Y-m-d H:i:s');
        $data_post['order_data']['invoice_number'] = $order_data['it_easy_invoice_number'];
        $data_post['order_data']['Package Weight'] = 200;
        $data_post['order_data']['Package Height'] = 10;
        $data_post['order_data']['Package Length'] = 10;
        $data_post['order_data']['Package Width'] = 5;
        $data_post['order_data']['order_status'] = 'Open';
        $data_post['order_data']['payment_mode'] = $mode;
         $data_post['order_data']['customer_name'] = $order_data['it_easy_shipping_firstname'].' '.$order_data['it_easy_shipping_lastname'];
        $data_post['order_data']['contact_num'] = substr($order_data['it_easy_mobile_number'], -10);
        $data_post['order_data']['address_line_1'] = $order_data['it_easy_shipping_address_1'];
        $data_post['order_data']['address_line_2'] = $order_data['it_easy_shipping_address_2'];
        $data_post['order_data']['pin_code'] = $order_data['it_easy_shipping_pincode'];
        $data_post['order_data']['city'] = $order_data['it_easy_shipping_city'];
        $data_post['order_data']['state'] = $order_data['it_easy_shipping_state'];
        $data_post['order_data']['country'] = 'India';
        $data_post['order_data']['billing_name'] = $order_data['it_easy_shipping_firstname'].' '.$order_data['it_easy_shipping_lastname'];
        $data_post['order_data']['billing_mobile'] = substr($order_data['it_easy_mobile_number'], -10);
        $data_post['order_data']['billing_address_1'] = $order_data['it_easy_shipping_address_1'];
        $data_post['order_data']['billing_address_2'] = $order_data['it_easy_shipping_address_2'];
        $data_post['order_data']['billing_pin_code'] = $order_data['it_easy_shipping_pincode'];
        $data_post['order_data']['billing_city'] = $order_data['it_easy_shipping_city'];
        $data_post['order_data']['billing_state'] = $order_data['it_easy_shipping_state'];
        $data_post['order_data']['billing_country'] = 'India';
        $data_post['order_data']['order_quantity'] = 1;
        $data_post['order_data']['collectable_amount'] = (int)$collectable_value;
        $data_post['order_data']['total_amount'] = (int)$order_data['it_easy_total_price'];
        $data_post['order_data']['total_tax'] = (int)$order_data['it_easy_gst_price'];
        $data_post['order_data']['breakup_types']['Item Amount Excluding Tax'] = (int)$order_data['it_easy_total_price'] - (int)$order_data['it_easy_gst_price'];
        $data_post['order_data']['breakup_types']['Item Amount IGST'] = (int)$order_data['it_easy_gst_price'];
        $data_post['order_data']['tcs_rate'] = 0;
        $data_post['order_data']['tcs_amount'] = 0;
        $data_post['order_data']['order_items'] = $product_array;
        $data_post['credentials']['username'] = 'sushil@nutriherbs.in';
        $data_post['credentials']['request_type'] = 'QS-LEAP';
        $data_post['credentials']['request_action'] = 'PICKUP';
        $data_post['credentials']['pickup_address_id'] = 'P20250721111458900';
        $data_post['credentials']['eeApiToken'] = '409d1f1b91cb9f7b350dc1f7ba8fa83d';
        $data_post['credentials']['business_type'] = 'Easyops';
        
                // echo "<pre>"; print_r($data_post); 
                
                //echo json_encode($data_post);
           		$ch = curl_init($url);
    
                // Set cURL options
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    'Content-Type: application/json',
                ]);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data_post));
    
                // Execute cURL request
                $response2 = curl_exec($ch);
                // echo $response2;
           		$returnarray2 = json_decode($response2, true);
           		//echo "<pre>"; print_r($returnarray2); die;
                //return $returnarray2;
                curl_close($ch);
    
        if(isset($returnarray2['tracking_number']) && !empty($returnarray2['tracking_number'])){  
          $awb_number = $returnarray2['tracking_number'];
          $smart_sub_courier_name = $returnarray2['courier_name'];
          
              $smart_route_code = '';
          
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order_data['it_easy_customer_id'] ,$shipid, $awb_number,'Quickshift Success',$response2,$currentDateTime);
          ApiCall::sendWebhook($order_data['it_easy_order_id'],$shipid,$awb_number,$currentDateTime,'get_awb');
          
          $ApiCall = new ApiCall();
          ApiCall::findOrderModel($order_data['it_easy_order_id']);
          $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data,$awb_number,$smart_sub_courier_name,$smart_route_code);
          
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','Quickshift failed',$response2,$currentDateTime);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> $response2);
        }  
        return $all_value;
      
    }
    
    
    
    
    
    public function generateIthink($order_data){
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
        
        $order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
               
            $awb_number = $order_data['it_easy_awb_number'];
            
            $ApiCall = new ApiCall();
            $ApiCall->updateOrderDispatch($order_data);
            ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
            ApiCall::sendWebhook($order_data['it_easy_order_id'], $order_data['it_easy_shipping_id'],$awb_number,$currentDateTime,'gen_awb');
       
        return $all_value;
    }
    
    public function generateEkart($order_data){
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
        
        $order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
               
            $awb_number = $order_data['it_easy_awb_number'];
            
            $ApiCall = new ApiCall();
            $ApiCall->updateOrderDispatch($order_data);
            ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
            ApiCall::sendWebhook($order_data['it_easy_order_id'], $order_data['it_easy_shipping_id'],$awb_number,$currentDateTime,'gen_awb');
       
        return $all_value;
    }
    
    public function generateUrbanbolt($order_data){
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
        
        $order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
               
            $awb_number = $order_data['it_easy_awb_number'];
            
            $ApiCall = new ApiCall();
            $ApiCall->updateOrderDispatch($order_data);
            ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
            ApiCall::sendWebhook($order_data['it_easy_order_id'], $order_data['it_easy_shipping_id'],$awb_number,$currentDateTime,'gen_awb');
       
        return $all_value;
    }
    
    public function generateProzo($order_data){
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
        
        $order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
               
            $awb_number = $order_data['it_easy_awb_number'];
            
            $ApiCall = new ApiCall();
            $ApiCall->updateOrderDispatch($order_data);
            ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
            ApiCall::sendWebhook($order_data['it_easy_order_id'], $order_data['it_easy_shipping_id'],$awb_number,$currentDateTime,'gen_awb');
       
        return $all_value;
    }
    
    
    public function generateZippy($order_data)
{
    date_default_timezone_set('Asia/kolkata');
    $currentDateTime = date('Y-m-d H:i:s');

    $awb_responce = new ItEasyAwbResponce();
    $order_dispatch = new ItEasyOrderDispatch();

    // Shipping API data
    $shiping_data = ItEasyShippingApi::find()
        ->asArray()
        ->where(['it_easy_ship_id' => $order_data['it_easy_shipping_id']])
        ->one();

    // Order data
    $order = ItEasyOrder::find()
        ->where(['it_easy_order_id' => $order_data['it_easy_order_id']])
        ->asArray()
        ->one();
        
          $awb_number = $order_data['it_easy_awb_number'];

    // ----------------- CALL ZIPPYY AWB FUNCTION -----------------
    $ApiCall = new ApiCall();
            $ApiCall->updateOrderDispatch($order_data);
            ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
            ApiCall::sendWebhook($order_data['it_easy_order_id'], $order_data['it_easy_shipping_id'],$awb_number,$currentDateTime,'gen_awb');
       
        return $all_value;
}


// public function generateNimbus($order_data)
// {
//     date_default_timezone_set('Asia/kolkata');
//     $currentDateTime = date('Y-m-d H:i:s');

//     $awb_responce   = new ItEasyAwbResponce();
//     $order_dispatch = new ItEasyOrderDispatch();

//     $shiping_data = ItEasyShippingApi::find()
//         ->asArray()
//         ->where(['it_easy_ship_id' => $order_data['it_easy_shipping_id']])
//         ->one();

//     $order = ItEasyOrder::find()
//         ->where(['it_easy_order_id' => $order_data['it_easy_order_id']])
//         ->asArray()
//         ->one();

//     // ---------------- NIMBUS AWB ----------------
//     $awb_number = $order_data['it_easy_awb_number'];

//     // ---------------- UPDATE DISPATCH ----------------
//     $ApiCall = new ApiCall();
//     $ApiCall->updateOrderDispatch($order_data);

//     ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);

//     // ---------------- WEBHOOK ----------------
//     ApiCall::sendWebhook(
//         $order_data['it_easy_order_id'],
//         $order_data['it_easy_shipping_id'],
//         $awb_number,
//         $currentDateTime,
//         'gen_awb'
//     );

//     // ---------------- FINAL RESPONSE ----------------
//     $all_value = array(
//         'order_id'   => $order_data['it_easy_order_id'],
//         'awb_number' => $awb_number,
//         'responce'   => 'success'
//     );

//     return $all_value;
// }



    
    public function generateShiprocket($order_data,$shiping_id, $access_token){
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
        $order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
        
        $shipment_id = $order_data['shipment_id'];
        $url = "https://apiv2.shiprocket.in/v1/external/courier/generate/pickup";

        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        
        $headers = array(
           "Content-Type: application/json",
           "Authorization: Bearer ".$access_token,
        );
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        
        $data['shipment_id'] = [$shipment_id];
        
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
        
        //for debug only!
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        
        $resp = curl_exec($curl);
        $getManifestAwb = json_decode($resp);
        // echo "<pre>"; print_r($getManifestAwb); die;
        if((isset($getManifestAwb->pickup_status) && $getManifestAwb->pickup_status == 'pickup_status' ) || (isset($getManifestAwb->status_code) && $getManifestAwb->status_code == '400')  ){
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order['it_easy_customer_id'] ,$order_data['it_easy_shipping_id'], $order_data['it_easy_awb_number'],'Shiprocket Manifest Success',$resp,$currentDateTime);
            ApiCall::sendWebhook($order_data['it_easy_order_id'], $order_data['it_easy_shipping_id'],$order_data['it_easy_awb_number'],$currentDateTime,'gen_awb');
            $ApiCall = new ApiCall();
            $ApiCall->updateOrderDispatch($order_data);
            ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $order_data['it_easy_awb_number'] ,'responce'=> 'success');
        }else{
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order['it_easy_customer_id'] ,$order_data['it_easy_shipping_id'], $order_data['it_easy_awb_number'],'Smartship Manifest Failed',$resp,$currentDateTime);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $order_data['it_easy_awb_number']  ,'responce'=> $resp);
        }  
        return $all_value;
    }
    


    // public function generateSmartship($order_data,$access_token){
    //     date_default_timezone_set('Asia/kolkata');
    //     $currentDateTime = date('Y-m-d H:i:s');
    //     $awb_responce = new ItEasyAwbResponce();
    //     $order_dispatch = new ItEasyOrderDispatch();
    //     $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
    //     $order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
    //              $post_Data['client_order_reference_ids'][] = $order_data['it_easy_order_id'];
    //              $post_Data['preferred_pickup_date'] = date('d-m-Y');
    //              $post_Data['creation_mode'] = '1';
    //             $url = 'http://api.smartship.in/v2/app/Fulfillmentservice/createManifest';
    //             $ch2 = curl_init();
    //             curl_setopt($ch2, CURLOPT_URL, $url);
    //             curl_setopt($ch2, CURLOPT_RETURNTRANSFER, TRUE);
    //             curl_setopt($ch2, CURLOPT_HEADER, FALSE);
    //             curl_setopt($ch2, CURLOPT_POST, TRUE);
    //             curl_setopt($ch2, CURLOPT_POSTFIELDS, json_encode($post_Data));
    //             curl_setopt($ch2, CURLOPT_HTTPHEADER, array(
    //                 "Content-Type: application/json",
    //                 "Authorization: Bearer ".$access_token
    //             ));
    //             $ManifestAwbresponce = curl_exec($ch2);
    //             $getManifestAwb = json_decode($ManifestAwbresponce, true);
    //             curl_close($ch2);
    //         $awb_number = $order_data['it_easy_awb_number'];
    //         // if((!empty($getManifestAwb['message']) && $getManifestAwb['message']=='success')){ 
    //         if(!isset($getManifestAwb['data']['errors'])){
    //         ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order['it_easy_customer_id'] ,$order_data['it_easy_shipping_id'], $awb_number,'Smartship Manifest Success',$ManifestAwbresponce,$currentDateTime);
    //         $ApiCall = new ApiCall();
    //         $ApiCall->updateOrderDispatch($order_data);
    //         ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
    //         $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
    //     }else{
    //         ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order['it_easy_customer_id'] ,$order_data['it_easy_shipping_id'], $awb_number,'Smartship Manifest Failed',$ManifestAwbresponce,$currentDateTime);
    //         $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number  ,'responce'=> $ManifestAwbresponce);
    //     }  
    //     return $all_value;
    // }
    
    
    public function generateSmartship($order_data){
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
        
        $order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
               
            $awb_number = $order_data['it_easy_awb_number'];
            
            $ApiCall = new ApiCall();
            $ApiCall->updateOrderDispatch($order_data);
            ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
            ApiCall::sendWebhook($order_data['it_easy_order_id'], $order_data['it_easy_shipping_id'],$awb_number,$currentDateTime,'gen_awb');
       
        return $all_value;
    }
    
    public function generatePickndel($order_data){
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
        
        $order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
               
            $awb_number = $order_data['it_easy_awb_number'];
            
            $ApiCall = new ApiCall();
            $ApiCall->updateOrderDispatch($order_data);
            ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
            ApiCall::sendWebhook($order_data['it_easy_order_id'], $order_data['it_easy_shipping_id'],$awb_number,$currentDateTime,'gen_awb');
       
        return $all_value;
    }
    
    public function generateRapidsyp($order_data){
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
        
        $order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
               
            $awb_number = $order_data['it_easy_awb_number'];
            
            $ApiCall = new ApiCall();
            $ApiCall->updateOrderDispatch($order_data);
            ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
            ApiCall::sendWebhook($order_data['it_easy_order_id'], $order_data['it_easy_shipping_id'],$awb_number,$currentDateTime,'gen_awb');
       
        return $all_value;
    }
    
    public function generateDtdc($order_data){
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
        
        $order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
               
            $awb_number = $order_data['it_easy_awb_number'];
            
            $ApiCall = new ApiCall();
            $ApiCall->updateOrderDispatch($order_data);
            ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
       
        return $all_value;
    }
    
    public function generateQuickshift($order_data){
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
        
        $order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
               
            $awb_number = $order_data['it_easy_awb_number'];
            
            $ApiCall = new ApiCall();
            $ApiCall->updateOrderDispatch($order_data);
            ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
       
        return $all_value;
    }
    
    
    public function generateClickpost($order_data){
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
        
        $order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
           
        $awb_number = $order_data['it_easy_awb_number'];
        
        $ApiCall = new ApiCall();
        $ApiCall->updateOrderDispatch($order_data);
        ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
        $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
       
        return $all_value;
    }

	
  
  	public function updateOrderDispatch($order_data){
  	    date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
      	$dispatch_model = ItEasyOrderDispatch::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->one();
      	$dispatch_model->it_easy_order_status          = 'Order Manifested';
      	$dispatch_model->it_easy_placed_time = date('Y-m-d H:i:s');
      	$dispatch_model->it_easy_status_updated_at  = date('Y-m-d H:i:s');
      	$dispatch_model->save(false);
    }

    public function addOrderDispatch($order_data,$shipid,$shiping_data,$returnarray='',$smart_sub_courier_name='',$smart_route_code=''){
    	
      	$zone_name = ItEasyZonePincode::find()->where(['it_easy_pincode' => $order_data['it_easy_shipping_pincode'] ])->one();

      	if($order_data['it_easy_payment_code'] == 'COD'){
          	$ordet_type = 'COD';
          	$collective_price = $order_data['it_easy_total_price'];
        }else{
          	$ordet_type = 'Prepaid';
          	$collective_price = '0.00';
        }

        if(!empty($smart_sub_courier_name) && isset($smart_sub_courier_name)){
            $sub_courier_name = $smart_sub_courier_name;
        }else{
            $sub_courier_name = $shiping_data['it_easy_name'];
        }

        $order_dispatch = ItEasyOrderDispatch::findOne(['it_easy_order_id' => $order_data['it_easy_order_id']]);
        if(empty($order_dispatch)){
                $order_dispatch = new ItEasyOrderDispatch();
        }
        $order_dispatch->it_easy_order_id              = $order_data['it_easy_order_id'];
        $order_dispatch->it_easy_order_number          = $order_data['it_easy_order_number'];
        $order_dispatch->it_easy_shipping_id           = $shipid;
        $order_dispatch->it_easy_user_id               = $order_data['it_easy_customer_id'];
        $order_dispatch->it_easy_department_id         = $order_data['it_easy_department_id'];
        $order_dispatch->it_easy_awb_number            = $returnarray;
        $order_dispatch->it_easy_order_type            = $ordet_type;
        $order_dispatch->it_easy_firstname             = $order_data['it_easy_shipping_firstname'];
        $order_dispatch->it_easy_lastname              = $order_data['it_easy_shipping_lastname'];
        $order_dispatch->it_easy_address_1             = $order_data['it_easy_shipping_address_1'];
        $order_dispatch->it_easy_address_2             = $order_data['it_easy_shipping_address_2'];
        $order_dispatch->it_easy_city                  = $order_data['it_easy_shipping_city'];
        $order_dispatch->it_easy_state                 = $order_data['it_easy_shipping_state'];
        $order_dispatch->it_easy_state_id              = $order_data['it_easy_shipping_state_id'];
        $order_dispatch->it_easy_pincode               = $order_data['it_easy_shipping_pincode'];
        $order_dispatch->it_easy_mobile                = $order_data['it_easy_shipping_mobile_number'];
        $order_dispatch->it_easy_email                 = $order_data['it_easy_shipping_email'];
        $order_dispatch->it_easy_alternate_mobile      = $order_data['it_easy_shipping_alternate_number'];
        $order_dispatch->it_easy_price                 = $order_data['it_easy_total_price'];
        $order_dispatch->it_easy_collective_price      = $collective_price;
        $order_dispatch->it_easy_order_date            = '';
        $order_dispatch->it_easy_dispatch_time         = '';
        $order_dispatch->it_easy_awb_time           =  date('Y-m-d H:i:s');
        $order_dispatch->it_easy_return_awb            = '';
        $order_dispatch->it_easy_pickup_time           = '';
        if(!empty($zone_name)){
            $order_dispatch->it_easy_zone_name             = $zone_name->it_easy_zone_name;
        }else{
            $order_dispatch->it_easy_zone_name             = 'Zone A';
        }
        $order_dispatch->it_easy_courier_name          = $shiping_data['it_easy_name'];
        $order_dispatch->it_easy_subcourier_name       = $sub_courier_name;
        $order_dispatch->it_easy_order_status          = 'AWB Assigned';
        $order_dispatch->it_easy_courier_comment       = '';
        $order_dispatch->it_easy_status_updated_at     = $order_data['it_easy_updated_time'];
        $order_dispatch->it_easy_first_scan_date       = '';
        $order_dispatch->it_easy_last_scan_date        = '';
        $order_dispatch->it_easy_first_attempted_date  = '';
        $order_dispatch->it_easy_last_attempted_date   = '';
        $order_dispatch->it_easy_delivery_date         = $order_data['it_easy_delivered_time'];
        $order_dispatch->it_easy_route_code            = $smart_route_code;
        $order_dispatch->it_easy_picked                = $order_data['it_easy_order_id'];
        $order_dispatch->it_easy_auto_rto_date         = '';
        $order_dispatch->it_easy_rto_date              = '';
        $order_dispatch->it_easy_attempt_count         = '';
        $order_dispatch->it_easy_courier_price         = '';
        $order_dispatch->it_easy_rto_updated_by        = '';
        $order_dispatch->it_easy_label_generated       = '0';
        $order_dispatch->save(false);
        

    }
    
    
    public function addOrderDispatchclickpost($order_data,$shipid,$shiping_data,$returnarray='',$smart_sub_courier_name='',$smart_route_code=''){
    	
      	$zone_name = ItEasyZonePincode::find()->where(['it_easy_pincode' => $order_data['it_easy_shipping_pincode'] ])->one();

      	if($order_data['it_easy_payment_code'] == 'COD'){
          	$ordet_type = 'COD';
          	$collective_price = $order_data['it_easy_total_price'];
        }else{
          	$ordet_type = 'Prepaid';
          	$collective_price = '0.00';
        }

        if(!empty($smart_sub_courier_name) && isset($smart_sub_courier_name)){
            $sub_courier_name = $smart_sub_courier_name;
        }else{
            $sub_courier_name = $shiping_data['courier_name'];
        }

        $order_dispatch = ItEasyOrderDispatch::findOne(['it_easy_order_id' => $order_data['it_easy_order_id']]);
        if(empty($order_dispatch)){
                $order_dispatch = new ItEasyOrderDispatch();
        }
        $order_dispatch->it_easy_order_id              = $order_data['it_easy_order_id'];
        $order_dispatch->it_easy_order_number          = $order_data['it_easy_order_number'];
        $order_dispatch->it_easy_shipping_id           = $shipid;
        $order_dispatch->it_easy_user_id               = $order_data['it_easy_customer_id'];
        $order_dispatch->it_easy_department_id         = $order_data['it_easy_department_id'];
        $order_dispatch->it_easy_awb_number            = $returnarray;
        $order_dispatch->it_easy_order_type            = $ordet_type;
        $order_dispatch->it_easy_firstname             = $order_data['it_easy_shipping_firstname'];
        $order_dispatch->it_easy_lastname              = $order_data['it_easy_shipping_lastname'];
        $order_dispatch->it_easy_address_1             = $order_data['it_easy_shipping_address_1'];
        $order_dispatch->it_easy_address_2             = $order_data['it_easy_shipping_address_2'];
        $order_dispatch->it_easy_city                  = $order_data['it_easy_shipping_city'];
        $order_dispatch->it_easy_state                 = $order_data['it_easy_shipping_state'];
        $order_dispatch->it_easy_state_id              = $order_data['it_easy_shipping_state_id'];
        $order_dispatch->it_easy_pincode               = $order_data['it_easy_shipping_pincode'];
        $order_dispatch->it_easy_mobile                = $order_data['it_easy_shipping_mobile_number'];
        $order_dispatch->it_easy_email                 = $order_data['it_easy_shipping_email'];
        $order_dispatch->it_easy_alternate_mobile      = $order_data['it_easy_shipping_alternate_number'];
        $order_dispatch->it_easy_price                 = $order_data['it_easy_total_price'];
        $order_dispatch->it_easy_collective_price      = $collective_price;
        $order_dispatch->it_easy_order_date            = '';
        $order_dispatch->it_easy_dispatch_time         = '';
        $order_dispatch->it_easy_awb_time           =  date('Y-m-d H:i:s');
        $order_dispatch->it_easy_return_awb            = '';
        $order_dispatch->it_easy_pickup_time           = '';
        if(!empty($zone_name)){
            $order_dispatch->it_easy_zone_name             = $zone_name->it_easy_zone_name;
        }else{
            $order_dispatch->it_easy_zone_name             = 'Zone A';
        }
        $order_dispatch->it_easy_courier_name          = $shiping_data['courier_name'];
        $order_dispatch->it_easy_subcourier_name       = $sub_courier_name;
        $order_dispatch->it_easy_order_status          = 'AWB Assigned';
        $order_dispatch->it_easy_courier_comment       = '';
        $order_dispatch->it_easy_status_updated_at     = $order_data['it_easy_updated_time'];
        $order_dispatch->it_easy_first_scan_date       = '';
        $order_dispatch->it_easy_last_scan_date        = '';
        $order_dispatch->it_easy_first_attempted_date  = '';
        $order_dispatch->it_easy_last_attempted_date   = '';
        $order_dispatch->it_easy_delivery_date         = $order_data['it_easy_delivered_time'];
        $order_dispatch->it_easy_route_code            = $smart_route_code;
        $order_dispatch->it_easy_picked                = $order_data['it_easy_order_id'];
        $order_dispatch->it_easy_auto_rto_date         = '';
        $order_dispatch->it_easy_rto_date              = '';
        $order_dispatch->it_easy_attempt_count         = '';
        $order_dispatch->it_easy_courier_price         = '';
        $order_dispatch->it_easy_rto_updated_by        = '';
        $order_dispatch->it_easy_label_generated       = '0';
        $order_dispatch->save(false);
        

    }
    
    
    public function addOrderDispatchclickpostcustom($order_data,$shipid,$shiping_data,$returnarray='',$smart_sub_courier_name='',$smart_route_code='',$order_status=''){
    	
      	$zone_name = ItEasyZonePincode::find()->where(['it_easy_pincode' => $order_data['it_easy_shipping_pincode'] ])->one();

      	if($order_data['it_easy_payment_code'] == 'COD'){
          	$ordet_type = 'COD';
          	$collective_price = $order_data['it_easy_total_price'];
        }else{
          	$ordet_type = 'Prepaid';
          	$collective_price = '0.00';
        }

        if(!empty($smart_sub_courier_name) && isset($smart_sub_courier_name)){
            $sub_courier_name = $smart_sub_courier_name;
        }else{
            $sub_courier_name = $shiping_data['courier_name'];
        }
        
        $order_dispatch = ItEasyOrderDispatch::findOne(['it_easy_order_id' => $order_data['it_easy_order_id']]);
        if(empty($order_dispatch)){
            // echo "<pre>"; print_r($order_data); die;
                $order_dispatch = new ItEasyOrderDispatch();
        }
        $order_dispatch->it_easy_order_id              = $order_data['it_easy_order_id'];
        $order_dispatch->it_easy_order_number          = $order_data['it_easy_order_number'];
        $order_dispatch->it_easy_shipping_id           = $shipid;
        $order_dispatch->it_easy_user_id               = $order_data['it_easy_customer_id'];
        $order_dispatch->it_easy_department_id         = $order_data['it_easy_department_id'];
        $order_dispatch->it_easy_awb_number            = $returnarray;
        $order_dispatch->it_easy_order_type            = $ordet_type;
        $order_dispatch->it_easy_firstname             = $order_data['it_easy_shipping_firstname'];
        $order_dispatch->it_easy_lastname              = $order_data['it_easy_shipping_lastname'];
        $order_dispatch->it_easy_address_1             = $order_data['it_easy_shipping_address_1'];
        $order_dispatch->it_easy_address_2             = $order_data['it_easy_shipping_address_2'];
        $order_dispatch->it_easy_city                  = $order_data['it_easy_shipping_city'];
        $order_dispatch->it_easy_state                 = $order_data['it_easy_shipping_state'];
        $order_dispatch->it_easy_state_id              = $order_data['it_easy_shipping_state_id'];
        $order_dispatch->it_easy_pincode               = $order_data['it_easy_shipping_pincode'];
        $order_dispatch->it_easy_mobile                = $order_data['it_easy_shipping_mobile_number'];
        $order_dispatch->it_easy_email                 = $order_data['it_easy_shipping_email'];
        $order_dispatch->it_easy_alternate_mobile      = $order_data['it_easy_shipping_alternate_number'];
        $order_dispatch->it_easy_price                 = $order_data['it_easy_total_price'];
        $order_dispatch->it_easy_collective_price      = $collective_price;
        $order_dispatch->it_easy_order_date            = $order_data['it_easy_converted_time'];
        $order_dispatch->it_easy_dispatch_time         = $order_data['it_easy_placed_time'];
        $order_dispatch->it_easy_awb_time           =  $order_data['it_easy_assign_time'];
        $order_dispatch->it_easy_return_awb            = '';
        $order_dispatch->it_easy_pickup_time           = $order_data['it_easy_placed_time'];
        if(!empty($zone_name)){
            $order_dispatch->it_easy_zone_name             = $zone_name->it_easy_zone_name;
        }else{
            $order_dispatch->it_easy_zone_name             = 'Zone A';
        }
        $order_dispatch->it_easy_courier_name          = $shiping_data['courier_name'];
        $order_dispatch->it_easy_subcourier_name       = $sub_courier_name;
        $order_dispatch->it_easy_order_status          = $order_status;
        $order_dispatch->it_easy_courier_comment       = '';
        $order_dispatch->it_easy_status_updated_at     = $order_data['it_easy_updated_time'];
        $order_dispatch->it_easy_first_scan_date       = '';
        $order_dispatch->it_easy_last_scan_date        = '';
        $order_dispatch->it_easy_first_attempted_date  = '';
        $order_dispatch->it_easy_last_attempted_date   = '';
        $order_dispatch->it_easy_delivery_date         = $order_data['it_easy_delivered_time'];
        $order_dispatch->it_easy_route_code            = $smart_route_code;
        $order_dispatch->it_easy_picked                = $order_data['it_easy_order_id'];
        $order_dispatch->it_easy_auto_rto_date         = '';
        $order_dispatch->it_easy_rto_date              = '';
        $order_dispatch->it_easy_attempt_count         = '';
        $order_dispatch->it_easy_courier_price         = '';
        $order_dispatch->it_easy_rto_updated_by        = '';
        $order_dispatch->it_easy_label_generated       = '1';
        $order_dispatch->save(false);
        

    }


    protected static function findOrderModel($it_easy_order_id)
    {
        if (($model = ItEasyOrder::findOne(['it_easy_order_id' => $it_easy_order_id])) !== null) {
            $model->it_easy_order_status_id = '2';
          	$model->it_easy_assign_time = date('Y-m-d H:i:s');
          	$model->it_easy_updated_time = date('Y-m-d H:i:s');
            $model->save(false);
          
          	$add_order_status = ItEasyOrder::addOrderStatusHistory($it_easy_order_id, '2', 'AWB Assign');
        }
        
    }
  
  	protected static function findupdateOrderModel($it_easy_order_id)
    {
        if (($model = ItEasyOrder::findOne(['it_easy_order_id' => $it_easy_order_id])) !== null) {
            $model->it_easy_order_status_id = '4';
          	$model->it_easy_updated_time = date('Y-m-d H:i:s');
            $model->save(false);
          
          	$add_order_status = ItEasyOrder::addOrderStatusHistory($it_easy_order_id, '4', 'Order Manifest');
        }
        
    }
 
   
    public function updateAwbResponce($it_easy_order_id="",$user_id="",$shipid="",$awb_number="",$api_type="",$responce="",$currentDateTime=""){
        // echo $shipid; echo "<br>"; echo  $awb_number; die;
        $awb_responce = new ItEasyAwbResponce();
        $awb_responce->it_easy_order_id = $it_easy_order_id;
        $awb_responce->it_easy_user_id = $user_id;
        $awb_responce->it_easy_shipping_id = $shipid;
        $awb_responce->it_easy_awb_number  = $awb_number;
        $awb_responce->it_easy_api_type = $api_type;
        $awb_responce->it_easy_api_responce = $responce;
        $awb_responce->it_easy_created_time = $currentDateTime;
        $awb_responce->save(false);
        
      
    }//function end
    
    
    public static function sendWebhook($it_easy_order_id="",$shipid="",$awb_number="",$currentDateTime="",$type=""){
       
       
          //start
   // âœ… Send webhook only if AWB number is valid
    if (
        $type === 'get_awb' &&
        !empty($awb_number) &&
        strtolower(trim($awb_number)) !== 'awb number not found'
    ) {
       
         ApiCall::commonCallDeliver($it_easy_order_id,$shipid,$awb_number,$currentDateTime,$type);
      
    }//if first
    // for delivery out staus code webhook function
     if (
        $type === 'gen_awb' &&
        !empty($awb_number)){
          
            ApiCall::commonCallDeliver($it_easy_order_id,$shipid,$awb_number,$currentDateTime,$type);
        
        }//if second
        //change end sunil
    }
    
    public static function commonCallDeliver($it_easy_order_id="",$shipid="",$awb_number="",$currentDateTime="",$type=""){
        
     $order = ItEasyOrder::findOne($it_easy_order_id);
        if ($order) {
            $customer_name = $order->it_easy_shipping_firstname . ' ' . $order->it_easy_lastname;
            $customer_phone = $order->it_easy_mobile_number;
            $total_amount = $order->it_easy_total_price;
            $order_awb_number=$awb_number;
         

            // Build order summary
            $order_products = \backend\models\ItEasyOrderProduct::find()
                ->where(['it_easy_order_id' => $it_easy_order_id])
                ->all();
                
                $shipper = ItEasyShippingApi::find()
                           ->where(['it_easy_ship_id' => $shipid])
                          ->one();

if ($shipper) {
    $shipper_name = $shipper->it_easy_name;  // or whatever the actual 
    // add to object
}


            $order_summary = [];
            foreach ($order_products as $product) {
                $order_summary[] = $product->it_easy_product_name 
        . ' (' . $product->it_easy_variation_name . ')' // added variation
        . ' (Qty: ' . $product->it_easy_product_quantity . ')';
            }

            $order_summary = implode(', ', $order_summary);
          
            if($type=="get_awb"){
             
               $stage="awb_assigned";
            }
            if($type=="gen_awb"){
               
               $stage="out_delivery";
            }
           

            // ðŸ”” Trigger WhatsApp webhook
            webhookSender::sendAwbStageWebhook(
                $stage,
                $customer_name,
                $it_easy_order_id,
                $order_summary,
                $total_amount,
                $customer_phone,
                $order,
                $order_awb_number,
                $shipper_name
                
            );
        }
    }//end function
    
    
    public function test($it_easy_order_id,$stage){
        
        ApiCall::sendWebhook(
    $it_easy_order_id, // order ID
    5,                         // shipping ID
    '123456',                    // âœ… AWB number (or error string)
    '',                // timestamp
    $stage                       // webhook event type
);

die;
        
          $order = ItEasyOrder::findOne($it_easy_order_id);
        if ($order) {
            $awb_number="2838739";
            $customer_name = $order->it_easy_shipping_firstname . ' ' . $order->it_easy_lastname;
            $customer_phone = $order->it_easy_mobile_number;
            $total_amount = $order->it_easy_total_price;
            $order_awb_number=$awb_number;
            $shipid=5;
         

            // Build order summary
            $order_products = \backend\models\ItEasyOrderProduct::find()
                ->where(['it_easy_order_id' => $it_easy_order_id])
                ->all();
                
                $shipper = ItEasyShippingApi::find()
                           ->where(['it_easy_ship_id' => $shipid])
                          ->one();

if ($shipper) {
    $shipper_name = $shipper->it_easy_name;  // or whatever the actual 
    // add to object
}

            $order_summary = [];
            foreach ($order_products as $product) {
                $order_summary[] = $product->it_easy_product_name . ' (Qty: ' . $product->it_easy_product_quantity . ')';
            }

            $order_summary = implode(', ', $order_summary);

            // ðŸ”” Trigger WhatsApp webhook
            webhookSender::sendAwbStageWebhook(
                'out_delivery',
                $customer_name,
                $it_easy_order_id,
                $order_summary,
                $total_amount,
                $customer_phone,
                $order,
                $order_awb_number,
                $shipper_name
                
            );
        }
        
    }



 


}
