<?php

namespace backend\models;

use Yii;
use backend\models\ItEasyShippingApi;
use backend\models\ItEasyAwbResponce;
use backend\models\ItEasyOrderDispatch;
use backend\models\ItEasyOrder;
use backend\models\ItEasyOrderProduct;
use backend\models\ItEasyZonePincode;
use backend\models\ItEasyStore;


class ApiCall extends \yii\db\ActiveRecord
{
    
     public function getDelhiVery($order_data,$shipid){
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where(['it_easy_ship_id'=>$shipid])->One();
        $client = $shiping_data['it_easy_userName'];
        $token = $shiping_data['it_easy_auth_key'];
        $urlawb='https://test.delhivery.com/waybill/api/fetch/json/?';      
        $urlawb='https://track.delhivery.com/waybill/api/fetch/json/?';           
        $getawbarray=array('token' =>$token, 'cl'=>$client);
        $urlawb.=http_build_query($getawbarray);
        $curlstr = curl_init();
        curl_setopt($curlstr, CURLOPT_URL, $urlawb);
        curl_setopt($curlstr, CURLOPT_RETURNTRANSFER, 1);
        $responce = curl_exec($curlstr);  
       	// print_r($responce);die;
        $returnarray = json_decode($responce, true);      
        curl_close($curlstr);
        // return $returnarray;
       	if(isset($returnarray) && !empty($returnarray)){
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,$returnarray,'delhivery awb number Success',$responce,$currentDateTime);
            $ApiCall = new ApiCall();
            $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data, $returnarray);
            ApiCall::findOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $returnarray ,'responce'=> 'success');
            
         }else{
              ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','delhivery awb number Failed',$responce,$currentDateTime);
              $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> 'not found');
         }
       	 return $all_value;        
    }
  
  
  	public function generateDelhiVery($order_data){
      	set_time_limit(0);
  	    ini_set('max_execution_time', 0);
  	    ini_set("memory_limit", "-1");
      	$all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
      	date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
      	$order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
      	// echo "<pre>"; print_r($order); die;
      	foreach ($all_product as $key => $product) {
            if($key==0){$product_description = $product['it_easy_product_name'];} else {$product_description .= ','. $product['it_easy_product_name'];}		
        }
      	
      	$store_Data = ItEasyStore::find()->where(['it_easy_id' => $order['it_easy_store_id']])->asArray()->one();
        $client = $shiping_data['it_easy_userName'];
        $token = $shiping_data['it_easy_auth_key'];
      
        if($order_data['it_easy_order_type']=='COD'){	
            $payment_code='COD';
            $collective_value = round($order_data['it_easy_price']);
        } else {
            $payment_code='Pre-paid';					
            $collective_value = 0;
        }					
        $invoice_no = $order['it_easy_invoice_number'];

		$seller_address = $store_Data['it_easy_address_1'].' '.$store_Data['it_easy_address_2'];
		$client = $shiping_data['it_easy_userName'];
        $token = $shiping_data['it_easy_auth_key']; // replace this with your token key
        
        $url = "https://track.delhivery.com/cmu/push/json/?token=".$token;
        $params = array(); // this will contain request meta and the package feed
        $package_data = array(); // package data feed
        $shipments = array();
        $pickup_location = array();
        /////////////start: building the package feed/////////////////////
        $shipment = array();
        $shipment['waybill'] = $order_data['it_easy_awb_number']; // waybill number
        $shipment['name'] = $order['it_easy_shipping_firstname'].' '.$order['it_easy_shipping_lastname']; // consignee name
        $shipment['order'] = $order['it_easy_order_number']; // client order number
        $shipment['products_desc'] = $product_description;
        $shipment['order_date'] = $order['it_easy_converted_time']; // ISO Format
        $shipment['payment_mode'] = $payment_code;
        $shipment['total_amount'] = round($order['it_easy_total_price']); // in INR
        $shipment['cod_amount'] = $collective_value; // amount to be collected, required for COD
        $shipment['add'] = $order['it_easy_shipping_address_1'].' '.$order['it_easy_shipping_address_2']; // consignee address
        $shipment['city'] = $order['it_easy_shipping_city'];
        $shipment['state'] = $order['it_easy_shipping_state'];
        $shipment['country'] = 'India';
        $shipment['phone'] = $order['it_easy_mobile_number'];
        $shipment['pin'] = $order['it_easy_shipping_pincode'];

        # optional if not set will use pickup_location
        $shipment['return_add']= '';
        $shipment['return_city']= '';
        $shipment['return_country']= '';
        $shipment['return_name']= '';
        $shipment['return_phone']= '';
        $shipment['return_pin']= '';
        $shipment['return_state']= '';
        $shipment['supplier'] = $store_Data['it_easy_registered_name']; # optional
        # weights & dimensions
        $shipment['billable_weight']= 0.50; # optional willbe max of weight or	volumetric weight
        $shipment['dimensions']= '5.50CM x 5.50CM x 10CM'; # optional
        $shipment['volumetric']= 0.50; # optional volumetric weight
        $shipment['weight']= '500.0 gm'; # required},
        $shipment['product_quantity']= 1; # quantity of goods, positive integer
        $shipment['seller_inv']=  $invoice_no;
        $shipment['seller_inv_date']= $order['it_easy_converted_time']; # ISO format
        $shipment['seller_name']=  $store_Data['it_easy_registered_name']; # name of seller
        $shipment['seller_add']=  $seller_address; # seller address
        $shipment['seller_cst']= $store_Data['it_easy_gst_number']; # seller cst no
        $shipment['seller_tin']=  $store_Data['it_easy_gst_number']; # seller tin no

        // pickup location information //					
        $pickup_location['add'] = $seller_address;
        $pickup_location['city'] = $store_Data['it_easy_city'];
        $pickup_location['country'] ='India';
        $pickup_location['name'] = $client;  // Use client warehouse name
        $pickup_location['phone'] = $store_Data['it_easy_store_mobile'];
        $pickup_location['pin'] = $store_Data['it_easy_pincode'];
        $pickup_location['state'] = $store_Data['it_easy_state'];
        // pickup location return information //
        $pickup_return['return_add'] = $seller_address;
        $pickup_return['return_city'] = $store_Data['it_easy_city'];
        $pickup_return['return_country'] ='India';
        $pickup_return['return_phone'] = $store_Data['it_easy_store_mobile'];
        $pickup_return['return_pin'] = $store_Data['it_easy_pincode'];
        $pickup_return['return_state'] = $store_Data['it_easy_state'];

        $shipments = array($shipment);
        $package_data['shipments'] = $shipments;
        $package_data['pickup_location'] = $pickup_location;
        $package_data['pickup_return'] = $pickup_return;
        $params['format'] = 'json';					
        $params['data'] =json_encode($package_data);
        $string=http_build_query($params);
      
        $chdlv = curl_init();
        curl_setopt($chdlv, CURLOPT_URL, $url);
        curl_setopt($chdlv, CURLOPT_POST, true);
        curl_setopt($chdlv, CURLOPT_POSTFIELDS, http_build_query($params));
        curl_setopt($chdlv, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($chdlv, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));
        $result = curl_exec($chdlv);
        $returnarray = json_decode($result, true);	
        curl_close($chdlv);
        // echo "<pre>"; print_r($returnarray); die;
      	$awb_number = $order_data['it_easy_awb_number'];
      	if($returnarray['packages'][0]['status'] != 'Fail'){  
          
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order['it_easy_customer_id'] ,$order_data['it_easy_shipping_id'], $awb_number,'Delhivery Manifest Success',$result,$currentDateTime);
          $ApiCall = new ApiCall();
          $ApiCall->updateOrderDispatch($order_data);
          ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order['it_easy_customer_id'] ,$order_data['it_easy_shipping_id'], $awb_number,'Delhivery Manifest Failed',$result,$currentDateTime);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> json_encode($returnarray['packages'][0]['remarks']));
        }  
        return $all_value;
        die;
    }
  
  
     public function getEcomExpress($order_data,$shipid){
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where(['it_easy_ship_id'=>$shipid])->One();
        if($order_data['it_easy_payment_code']=='cod' || $order_data['it_easy_payment_code']=='lead'){
            $type='COD';          
        } else {
            $type='PPD';              
        }
        $getawbstring = array('username' =>$shiping_data['it_easy_userName'], 'password' =>$shiping_data['it_easy_passWord'], 'count'=>'1', 'type'=>$type);
        $courier_link = 'https://api.ecomexpress.in/apiv2/fetch_awb/';
        $awb = curl_init();
        curl_setopt($awb, CURLOPT_URL, $courier_link);
        curl_setopt($awb, CURLOPT_POST, true);
        curl_setopt($awb, CURLOPT_POSTFIELDS, $getawbstring);
        curl_setopt($awb, CURLOPT_RETURNTRANSFER, 1);
        $awbresponce = curl_exec($awb);  
        // echo $awbresponce; 
        $getawbarray = json_decode($awbresponce, true);                 
        curl_close($awb);
        // return $getawbarray;
           if(isset($getawbarray['awb'][0]) && !empty($getawbarray['awb'][0])){
             $awb_number = $getawbarray['awb'][0];
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,$awb_number,'Ecom Express awb number Success',$awbresponce,$currentDateTime);
            $ApiCall = new ApiCall();
            $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data,$awb_number);
            ApiCall::findOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
           }else{
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','Ecom Express awb number Failed',$awbresponce,$currentDateTime);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> $awbresponce);
           }  
           return $all_value;
    }
  
  
  	public function generateEcomExpress($order_data){
      	$all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
      	date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
      	$order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
      	
      	foreach ($all_product as $key => $product) {
            if($key==0){$product_description = $product['it_easy_product_name'];} else {$product_description .= ','. $product['it_easy_product_name'];}		
        }
      	
      	$store_Data = ItEasyStore::find()->where(['it_easy_id' => $order['it_easy_store_id']])->asArray()->one();
        $client = $shiping_data['it_easy_userName'];
        $token = $shiping_data['it_easy_auth_key'];
      
      	
        if($order_data['it_easy_order_type'] =='COD'){				            		
            $payment_code= 'COD';
            $collective_value = round($order_data['it_easy_collective_price']);
        } else {
            $payment_code='PPD';					
            $collective_value = 0;

        }


        $dataorders = array('AWB_NUMBER' 			   => $order_data['it_easy_awb_number'],
                            'ORDER_NUMBER'			   => $order_data['it_easy_order_number'],
                            'PRODUCT'	               => strtoupper($payment_code),
                            'PIECES'	               => 1,
                            'CONSIGNEE'	       		   => strtoupper($order['it_easy_shipping_firstname'].' '.$order['it_easy_shipping_lastname']),
                            'CONSIGNEE_ADDRESS1'	   => strtoupper($order['it_easy_shipping_address_1']),
                            'CONSIGNEE_ADDRESS2'	   => strtoupper($order['it_easy_shipping_address_2']),
                            'CONSIGNEE_ADDRESS3'	   => strtoupper($order['it_easy_shipping_address_1']),
                            'DESTINATION_CITY'	       => strtoupper($order['it_easy_shipping_city']),
                            'PINCODE'	               => strtoupper($order['it_easy_shipping_pincode']),
                            'STATE'	                   => strtoupper($order['it_easy_shipping_state']),
                            'MOBILE'	               => $order['it_easy_mobile_number'],
                            'TELEPHONE'	               => $order['it_easy_alternate_number'],
                            'ITEM_DESCRIPTION'	       => $product_description,
                            "PIECES" => 1,
                            'COLLECTABLE_VALUE'	       => $collective_value,
                            'DECLARED_VALUE'	       => $order['it_easy_total_price'],
                            'ACTUAL_WEIGHT'	           => '0.50', 
                            'VOLUMETRIC_WEIGHT'	       => '0.50',
                            'LENGTH'	               => '0',
                            'BREADTH'	       		   => '5.5',
                            'HEIGHT'				   => '5.5',
                            'PICKUP_NAME'	      	   => $store_Data['it_easy_store_name'],
                            'PICKUP_ADDRESS_LINE1'	   => $store_Data['it_easy_address_1'],
                            'PICKUP_ADDRESS_LINE2'	   => $store_Data['it_easy_address_2'].' '.$store_Data['it_easy_city'],
                            'PICKUP_PINCODE'	       => $store_Data['it_easy_pincode'],
                            //'PICKUP_PHONE'	           => 'strtoupper($store_telephone)',
                            'PICKUP_PHONE'	           => $store_Data['it_easy_store_mobile'],
                            'PICKUP_MOBILE'	           => $store_Data['it_easy_store_mobile'],
                            'RETURN_NAME'	           => $store_Data['it_easy_store_name'],
                            'RETURN_ADDRESS_LINE1'	   => $store_Data['it_easy_address_1'],
                            'RETURN_ADDRESS_LINE2'	   => $store_Data['it_easy_address_2'].' '.$store_Data['it_easy_city'].' '.$store_Data['it_easy_state'],
                            'RETURN_PINCODE'	       => $store_Data['it_easy_pincode'],
                            'RETURN_PHONE'	           => $store_Data['it_easy_store_mobile'],
                            'RETURN_MOBILE'	           => $store_Data['it_easy_store_mobile']					
                        );
     
        $datas['username']=$shiping_data['it_easy_userName'];
        $datas['password']=$shiping_data['it_easy_passWord'];
      
        $json_details =json_encode($dataorders);
        $datas['json_input']='['.$json_details.']';
        
        $curlmawb = curl_init();                    // initiate curl
        $url= 'https://api.ecomexpress.in/apiv2/manifest_awb/';
        curl_setopt($curlmawb, CURLOPT_URL,$url);
        curl_setopt($curlmawb, CURLOPT_POST, true);  // tell curl you want to post something
        curl_setopt($curlmawb, CURLOPT_POSTFIELDS, $datas); // define what you want to post
        curl_setopt($curlmawb, CURLOPT_RETURNTRANSFER, true); // return the output in string format
        $ManifestAwbresponce = curl_exec($curlmawb); // execute 
        
        $getManifestAwb = json_decode($ManifestAwbresponce, true);
        curl_close($curlmawb);
      	$awb_number = $order_data['it_easy_awb_number'];
      	if((!empty($getManifestAwb['shipments'][0]['success']) && $getManifestAwb['shipments'][0]['success']==1)){ 
            
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order['it_easy_customer_id'] ,$order_data['it_easy_shipping_id'], $awb_number,'Ecom Express Manifest Success',$ManifestAwbresponce,$currentDateTime);
            $ApiCall = new ApiCall();
            $ApiCall->updateOrderDispatch($order_data);
            ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order['it_easy_customer_id'] ,$order_data['it_easy_shipping_id'], $awb_number,'Ecom Express Manifest Failed',$ManifestAwbresponce,$currentDateTime);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number  ,'responce'=> $ManifestAwbresponce);
        }  
        return $all_value;
    }
  
     public function getXpressbees($order_data,$shipid){
        // echo "<pre>";print_r($order_data);die;
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
         $shiping_data =  ItEasyShippingApi::find()->asArray()->where(['it_easy_ship_id'=>$shipid])->One();
        $connection = \Yii::$app->db;
        if($order_data['it_easy_payment_code'] == 'COD'){
         
        $sql="SELECT * FROM  `it_easy_xpressbees_awb_number` WHERE cod = '1' AND `status`!= '1' AND `IsUse`!= '1' ORDER BY `awb` ASC LIMIT 0,1";
        }else{

        $sql="SELECT * FROM `it_easy_xpressbees_awb_number` WHERE prepaid = '1' AND `status`!= '1' AND `IsUse`!= '1' ORDER BY `awb` ASC LIMIT 0,1";
        }
        $command = $connection->createCommand($sql);
        $data = $command->queryAll();
        // echo"<pre>";print_r($data);die;
        if(isset($data) && !empty($data)){
        ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,$data[0]['awb'],'Xpressbees awb number Success','success',$currentDateTime);
        $ApiCall = new ApiCall();
        $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data, $data[0]['awb']);
        \Yii::$app->db->createCommand("UPDATE it_easy_xpressbees_awb_number SET status=:status, IsUse=:IsUse WHERE awb=:awb")->bindValue(':awb', $data[0]['awb'])->bindValue(':status', '1')->bindValue(':IsUse', '1')->execute();

        ApiCall::findOrderModel($order_data['it_easy_order_id']);
      
        $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $data[0]['awb'] ,'responce'=> 'success');
        
       }else{
        ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','Xpressbees awb number Failed','not found',$currentDateTime);
        $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> 'not found');
       }
       return $all_value;
    }
  
  
     public function getIndiaPost($order_data,$shipid,$india_post_courier_awb){
        // echo "<pre>";print_r($order_data);die;
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
         $shiping_data =  ItEasyShippingApi::find()->asArray()->where(['it_easy_ship_id'=>$shipid])->One();
        if(isset($india_post_courier_awb) && !empty($india_post_courier_awb)){
        ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,$india_post_courier_awb,'India Post awb number Success','success',$currentDateTime);
        $ApiCall = new ApiCall();
        $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data, $india_post_courier_awb);
        ApiCall::findOrderModel($order_data['it_easy_order_id']);
      
        $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $india_post_courier_awb ,'responce'=> 'success');
        
       }else{
        ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','India Post awb number Failed','not found',$currentDateTime);
        $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> 'not found');
       }
       return $all_value;
    }
  
  
  	public function generateXpressbees($order_data){
      		
      	  $all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
          date_default_timezone_set('Asia/kolkata');
          $currentDateTime = date('Y-m-d H:i:s');
          $awb_responce = new ItEasyAwbResponce();
          $order_dispatch = new ItEasyOrderDispatch();
          $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
          $order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
          // echo "<pre>"; print_r($order); die;
          

          $store_Data = ItEasyStore::find()->where(['it_easy_id' => $order['it_easy_store_id']])->asArray()->one();
          $client = $shiping_data['it_easy_userName'];
          $token = $shiping_data['it_easy_auth_key'];
      	
          $search = [];
          $search['username'] = $shiping_data['it_easy_userName'];
          $search['password'] = $shiping_data['it_easy_passWord'];
          $search['secretkey'] = $shiping_data['it_easy_auth_key'];

          date_default_timezone_set("Asia/Kolkata");
          $create_date=date("Y-m-d H:i:s");
          $chdlv = curl_init();
          curl_setopt($chdlv, CURLOPT_URL, "https://userauthapis.xbees.in/api/auth/generateToken");
          curl_setopt($chdlv, CURLOPT_POST, true);
          curl_setopt($chdlv, CURLOPT_POSTFIELDS, json_encode($search));
          curl_setopt($chdlv, CURLOPT_RETURNTRANSFER, 1);
          curl_setopt($chdlv, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "Authorization: Bearer xyz",
          ));
          $result = curl_exec($chdlv);
          $returnarray = json_decode($result, true);
          if(isset($returnarray['token'])){
        //   echo "<pre>"; print_r($returnarray); die;
          $token = $returnarray['token'];
      		
      	  if($order_data['it_easy_order_type']=='COD'){
            $payment_code= 'COD';
            $collective_value = round($order_data['it_easy_collective_price']);
          } else {
            $payment_code='PrePaid';					
            $collective_value = 0;
          }
      
      	  $post_data = [];
                
          $post_data['AirWayBillNO'] = $order_data['it_easy_awb_number'];
          $post_data['BusinessAccountName'] = "SKYGAIN WEB";
          $post_data['OrderNo'] = $order_data['it_easy_order_number'];
          $post_data['OrderType'] = $payment_code;
          $post_data['SubOrderNo'] = $order_data['it_easy_order_number'];
          $post_data['CollectibleAmount'] = $collective_value;
          $post_data['DeclaredValue'] = $collective_value;
          $post_data['PickupType'] = "Vendor";
          $post_data['Quantity'] = "1";
          $post_data['ServiceType'] = "SD";
          $post_data['DropDetails']['Addresses'][0]['Address'] = $order['it_easy_shipping_address_1'].' '.$order['it_easy_shipping_address_2'];
          $post_data['DropDetails']['Addresses'][0]['City'] = $order['it_easy_shipping_city'];
          $post_data['DropDetails']['Addresses'][0]['EmailID'] = "";
          $post_data['DropDetails']['Addresses'][0]['Name'] = $order['it_easy_shipping_firstname'].' '.$order['it_easy_shipping_lastname'];
          $post_data['DropDetails']['Addresses'][0]['PinCode'] = $order['it_easy_shipping_pincode'];
          $post_data['DropDetails']['Addresses'][0]['State'] = $order['it_easy_shipping_state'];
          $post_data['DropDetails']['Addresses'][0]['Type'] = "Primary";
          $post_data['DropDetails']['ContactDetails'][0]['PhoneNo'] = $order['it_easy_mobile_number'];
          $post_data['DropDetails']['ContactDetails'][0]['VirtualNumber'] = null;
          $post_data['DropDetails']['ContactDetails'][0]['Type'] = "Primary";
          $post_data['DropDetails']['IsGenSecurityCode'] = null;
          $post_data['DropDetails']['SecurityCode'] = null;
          $post_data['DropDetails']['IsGeoFencingEnabled'] = null;
          $post_data['DropDetails']['Latitude'] = null;
          $post_data['DropDetails']['Longitude'] = null;
          $post_data['DropDetails']['MaxThresholdRadius'] = null;
          $post_data['DropDetails']['MidPoint'] = null;
          $post_data['DropDetails']['MinThresholdRadius'] = null;
          $post_data['DropDetails']['RediusLocation'] = null;
          $post_data['PickupDetails']['Addresses'][0]['Address'] = $store_Data['it_easy_address_1'].' '.$store_Data['it_easy_address_2'];
          $post_data['PickupDetails']['Addresses'][0]['City'] = $store_Data['it_easy_city'];
          $post_data['PickupDetails']['Addresses'][0]['EmailID'] = $store_Data['it_easy_store_email'];
          $post_data['PickupDetails']['Addresses'][0]['Name'] = $store_Data['it_easy_store_name'];
          $post_data['PickupDetails']['Addresses'][0]['PinCode'] = $store_Data['it_easy_pincode'];
          $post_data['PickupDetails']['Addresses'][0]['State'] = $store_Data['it_easy_state'];
          $post_data['PickupDetails']['Addresses'][0]['Type'] = "Primary";
          $post_data['PickupDetails']['ContactDetails'][0]['PhoneNo'] = $store_Data['it_easy_store_mobile'];
          $post_data['PickupDetails']['ContactDetails'][0]['Type'] = "Primary";
          $post_data['PickupDetails']['PickupVendorCode'] = 'SKYGAIN WEB';
          $post_data['PickupDetails']['IsGenSecurityCode'] = null;
          $post_data['PickupDetails']['SecurityCode'] = null;
          $post_data['PickupDetails']['IsGeoFencingEnabled'] = null;
          $post_data['PickupDetails']['Latitude'] = null;
          $post_data['PickupDetails']['Longitude'] = null;
          $post_data['PickupDetails']['MaxThresholdRadius'] = null;
          $post_data['PickupDetails']['MidPoint'] = null;
          $post_data['PickupDetails']['MinThresholdRadius'] = null;
          $post_data['PickupDetails']['RediusLocation'] = null;
          $post_data['RTODetails']['Addresses'][0]['Address'] = $store_Data['it_easy_address_1'].' '.$store_Data['it_easy_address_2'];
          $post_data['RTODetails']['Addresses'][0]['City'] = $store_Data['it_easy_city'];
          $post_data['RTODetails']['Addresses'][0]['EmailID'] = $store_Data['it_easy_store_email'];
          $post_data['RTODetails']['Addresses'][0]['Name'] = $store_Data['it_easy_store_name'];
          $post_data['RTODetails']['Addresses'][0]['PinCode'] = $store_Data['it_easy_pincode'];
          $post_data['RTODetails']['Addresses'][0]['State'] = $store_Data['it_easy_state'];
          $post_data['RTODetails']['Addresses'][0]['Type'] = "Primary";
          $post_data['RTODetails']['ContactDetails'][0]['PhoneNo'] = $store_Data['it_easy_store_mobile'];
          $post_data['RTODetails']['ContactDetails'][0]['Type'] = "Primary";
          $post_data['Instruction'] = "";
          $post_data['CustomerPromiseDate'] = null;
          $post_data['IsCommercialProperty'] = null;
          $post_data['IsDGShipmentType'] = null;
          $post_data['IsOpenDelivery'] = null;
          $post_data['IsSameDayDelivery'] = null;
          $post_data['ManifestID'] = $order['it_easy_order_id'];
          $post_data['SenderName'] = null;
          $post_data['PackageDetails']['Dimensions']['Height'] = '5';
          $post_data['PackageDetails']['Dimensions']['Length'] = '5';
          $post_data['PackageDetails']['Dimensions']['Width'] = '5';
          $post_data['PackageDetails']['Weight']['BillableWeight'] = '0.5';
          $post_data['PackageDetails']['Weight']['PhyWeight'] = '0.5';
          $post_data['PackageDetails']['Weight']['VolWeight'] = '0.5';
          $post_data['GSTMultiSellerInfo'][0]['BuyerGSTRegNumber'] = '';
          $post_data['GSTMultiSellerInfo'][0]['EBNExpiryDate'] = null;
          $post_data['GSTMultiSellerInfo'][0]['EWayBillSrNumber'] =  $order_data['it_easy_awb_number'];
          $post_data['GSTMultiSellerInfo'][0]['InvoiceDate'] = date('d-m-Y', strtotime($order['it_easy_converted_time']));
          $post_data['GSTMultiSellerInfo'][0]['InvoiceNumber'] = $order['it_easy_invoice_number'];
          $post_data['GSTMultiSellerInfo'][0]['InvoiceValue'] = null;
          $post_data['GSTMultiSellerInfo'][0]['IsSellerRegUnderGST'] = 'Yes';
          $post_data['GSTMultiSellerInfo'][0]['SellerAddress'] = $store_Data['it_easy_address_1'].' '.$store_Data['it_easy_address_2'];
          $post_data['GSTMultiSellerInfo'][0]['SellerGSTRegNumber'] = $store_Data['it_easy_gst_number'];
          $post_data['GSTMultiSellerInfo'][0]['SellerName'] = $store_Data['it_easy_store_name'];
          $post_data['GSTMultiSellerInfo'][0]['SellerPincode'] = $store_Data['it_easy_pincode'];
          $post_data['GSTMultiSellerInfo'][0]['SupplySellerStatePlace'] = $store_Data['it_easy_state'];
      
      	  $all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
      	  foreach($all_product as $key => $product){	
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['ProductCategory'] = $product['it_easy_product_name'];
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['ProductDesc'] = $product['it_easy_variation_name'];
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['CGSTAmount'] = $product['it_easy_product_tax'];
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['Discount'] = null;
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['GSTTAXRateIGSTN'] = null;
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['GSTTaxRateCGSTN'] = null;
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['GSTTaxRateSGSTN'] = null;
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['GSTTaxTotal'] = $product['it_easy_product_tax'];
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['HSNCode'] = '23321';
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['IGSTAmount'] = null;
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['SGSTAmount'] = null;
              $post_data['GSTMultiSellerInfo'][0]['HSNDetails'][$key]['TaxableValue'] = $product['it_easy_product_total'];
          }

      
          $ch = curl_init();
          curl_setopt($ch, CURLOPT_URL, "https://apishipmentmanifestation.xbees.in/shipmentmanifestation/forward");
          curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
          curl_setopt($ch, CURLOPT_HEADER, FALSE);

          curl_setopt($ch, CURLOPT_POST, TRUE);

          curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_data));

          curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "token: ".$token,
            "versionnumber: v1",
          ));

          $response = curl_exec($ch);
          $returnarray = json_decode($response, true);
          curl_close($ch);
      	 //  echo "<pre>"; print_r($returnarray); die;	
      	 $awb_number = $order_data['it_easy_awb_number'];
      	 if(!empty($returnarray['AWBNo'])){ 
            
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order['it_easy_customer_id'] ,$order_data['it_easy_shipping_id'], $awb_number,'Xpressbees Manifest Success',$response,$currentDateTime);
            $ApiCall = new ApiCall();
            $ApiCall->updateOrderDispatch($order_data);
            ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order['it_easy_customer_id'] ,$order_data['it_easy_shipping_id'], $awb_number,'Xpressbees Manifest Failed',$response,$currentDateTime);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number  ,'responce'=> $response);
        }
        }else{
            ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order['it_easy_customer_id'] ,$order_data['it_easy_shipping_id'], $awb_number,'Xpressbees Manifest Failed',$result,$currentDateTime);
            $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number  ,'responce'=> $result);
        }
        return $all_value;
      
    }
  
  	public function getShipdelight($order_data,$shipid){
        set_time_limit(0);
  	    ini_set('max_execution_time', 0);
  	    ini_set("memory_limit", "-1");
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $shiping_data =  ItEasyShippingApi::find()->where(['it_easy_ship_id'=>$shipid])->One();
  		$invoice_no = $order_data['it_easy_invoice_number'];
			
		if(!empty($order_data['it_easy_alternate_number'])){
			$telephone2=$order_data['it_easy_alternate_number'];
		} else {
			$telephone2=$order_data['it_easy_mobile_number'];
		}
		if($order_data['it_easy_payment_code']=='COD'){
		  	$mode='COD';
		  	$collectable_value=round($order_data['it_easy_total_price']);
		} else {
		  	$mode='PPD';
		  	$collectable_value='0';
		}		

        $url = "https://api.instashipin.com/api/v1/tenancy/authToken";


        $data_order["api_key"] = $shiping_data->it_easy_userName;
        
        
        $ch = curl_init();
        
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        
        curl_setopt($ch, CURLOPT_POST, TRUE);
        
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data_order));
        
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "Authorization: Bearer ".$shiping_data->it_easy_passWord
        ));
        
        $response = curl_exec($ch);
        $returnarray = json_decode($response, true);
        curl_close($ch);
        // echo "<pre>"; print_r($returnarray); die;
        $post_Data['token_id'] = $returnarray['data']['response']['token_id'];
        $post_Data['auto_approve'] =  true;
        $post_Data['order_number'] =  $order_data['it_easy_order_number'];
        $post_Data['transaction_ref_no'] =  $invoice_no;
        $post_Data['payment_method'] =  $mode;
        $post_Data['discount_total'] =  '0.00';
        $post_Data['invoice_total'] =  round($order_data['it_easy_total_price']);
        $post_Data['cod_total'] =  $collectable_value;
        $post_Data['length'] =  5;
        $post_Data['breadth'] =  5;
        $post_Data['height'] =  5;
        $post_Data['actual_weight'] =  0.5;
        $post_Data['volumetric_weight'] =  0.5;
        $post_Data['shipping']['first_name'] =  $order_data['it_easy_shipping_firstname'];
        $post_Data['shipping']['last_name'] =  $order_data['it_easy_shipping_lastname'];
        $post_Data['shipping']['address_1'] =  $order_data['it_easy_shipping_address_1'];
        $post_Data['shipping']['address_2'] =  $order_data['it_easy_shipping_address_2'];
        $post_Data['shipping']['city'] =  $order_data['it_easy_shipping_city'];
        $post_Data['shipping']['state'] =  $order_data['it_easy_shipping_state'];
        $post_Data['shipping']['postcode'] =  $order_data['it_easy_shipping_pincode'];
        $post_Data['shipping']['country'] =  'India';
        $post_Data['shipping']['phone'] =  substr($order_data['it_easy_shipping_mobile_number'],-10);
      	
      	$all_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->all();
        $count_product = count($all_product); 
        $check_value = $count_product - 1;
        $product_total = 0;
        foreach($all_product as $key => $produc){
            
            if($key == $check_value){
                $value = array_sum(array_column($all_product,'it_easy_product_total'));
                    
                $get_rest_amount = round($order_data['it_easy_total_price']) - $value;
                
                $post_Data['line_items'][$key]['name'] =  $produc->it_easy_product_name.' '.$produc->it_easy_variation_name;
                $post_Data['line_items'][$key]['quantity'] =  $produc->it_easy_product_quantity;
                $post_Data['line_items'][$key]['sku'] =  '';
                $post_Data['line_items'][$key]['unit_price'] =  (round($produc->it_easy_product_total) + $get_rest_amount ) / $produc->it_easy_product_quantity;
                $post_Data['line_items'][$key]['actual_weight'] =  0.5;
            }else{
                $product_total += round($produc->it_easy_product_total);
                $post_Data['line_items'][$key]['name'] =  $produc->it_easy_product_name.' '.$produc->it_easy_variation_name;
                $post_Data['line_items'][$key]['quantity'] =  $produc->it_easy_product_quantity;
                $post_Data['line_items'][$key]['sku'] =  '';
                $post_Data['line_items'][$key]['unit_price'] =  (round($produc->it_easy_product_total) ) / $produc->it_easy_product_quantity;
                $post_Data['line_items'][$key]['actual_weight'] =  0.5;
            }
        }  
      	$store_Data = ItEasyStore::find()->where(['it_easy_id' => $order_data['it_easy_store_id']])->one();
      
        $post_Data['pickup']['vendor_name'] =  $store_Data['it_easy_store_name'];
        $post_Data['pickup']['address_1'] =  $store_Data['it_easy_address_1'];
        $post_Data['pickup']['address_2'] =  $store_Data['it_easy_address_2'];
        $post_Data['pickup']['city'] =  $store_Data['it_easy_city'];
        $post_Data['pickup']['state'] =   $store_Data['it_easy_state'];
        $post_Data['pickup']['postcode'] =  $store_Data['it_easy_pincode'];
        $post_Data['pickup']['country'] =  'India';
        $post_Data['pickup']['phone'] =  $store_Data['it_easy_store_mobile'];
        // echo "<pre>"; print_r($post_Data);
        
        $url2 = 'https://api.instashipin.com/api/v2/courier-vendor/book';
        
        $ch2 = curl_init();
        
        curl_setopt($ch2, CURLOPT_URL, $url2);
        curl_setopt($ch2, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch2, CURLOPT_HEADER, FALSE);
        
        curl_setopt($ch2, CURLOPT_POST, TRUE);
        
        curl_setopt($ch2, CURLOPT_POSTFIELDS, json_encode($post_Data));
        
        curl_setopt($ch2, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "Authorization: Bearer ".$shiping_data->it_easy_passWord
        ));
        
        $response2 = curl_exec($ch2);
        $returnarray2 = json_decode($response2, true);
        // echo "<pre>"; print_r($returnarray2); die;
        if(!empty($returnarray2['data']['success']) && $returnarray2['data']['success'] == '1'){  
          $awb_number = $returnarray2['data']['response']['airwaybilno'];
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'], $order_data['it_easy_customer_id'] ,$shipid, $awb_number,'Shipdelightnumber Success',$response2,$currentDateTime);
          $ApiCall = new ApiCall();
          ApiCall::findOrderModel($order_data['it_easy_order_id']);
          $ApiCall->addOrderDispatch($order_data,$shipid,$shiping_data,$awb_number);
          
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
        }else{
          ApiCall::updateAwbResponce($order_data['it_easy_order_id'],$order_data['it_easy_customer_id'],$shipid,'awb number not found','Shipdelightnumber failed',$response2,$currentDateTime);
          $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => 'awb number not find' ,'responce'=> $response2);
        }  
        return $all_value;
      
    }
  
  	public function generateShipdelight($order_data){
  	    set_time_limit(0);
  	    ini_set('max_execution_time', 0);
  	    ini_set("memory_limit", "-1");
      	date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $awb_responce = new ItEasyAwbResponce();
        $order_dispatch = new ItEasyOrderDispatch();
        $shiping_data =  ItEasyShippingApi::find()->asArray()->where([ 'it_easy_ship_id' => $order_data['it_easy_shipping_id']])->One();
        $order = ItEasyOrder::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->asArray()->one();
        $store_Data = ItEasyStore::find()->where(['it_easy_id' => $order['it_easy_store_id']])->asArray()->one();
        $ApiCall = new ApiCall();
        $ApiCall->updateOrderDispatch($order_data);
        ApiCall::findupdateOrderModel($order_data['it_easy_order_id']);
        $all_value = array('order_id' => $order_data['it_easy_order_id'], 'awb_number' => $awb_number = $order_data['it_easy_awb_number'] ,'responce'=> 'success');
      	return $all_value;
    }
	
  
  	public function updateOrderDispatch($order_data){
      	$dispatch_model = ItEasyOrderDispatch::find()->where(['it_easy_order_id' => $order_data['it_easy_order_id']])->one();
      	$dispatch_model->it_easy_order_status          = 'Order Manifested';
      	$dispatch_model->it_easy_placed_time = date('Y-m-d H:i:s');
      	$dispatch_model->it_easy_status_updated_at  = date('Y-m-d H:i:s');
      	$dispatch_model->save();
    }

    public function addOrderDispatch($order_data,$shipid,$shiping_data,$returnarray=''){
    	
      	$zone_name = ItEasyZonePincode::find()->where(['it_easy_pincode' => $order_data['it_easy_shipping_pincode'] ])->one();

      	if($order_data['it_easy_payment_code'] == 'COD'){
          	$ordet_type = 'COD';
          	$collective_price = $order_data['it_easy_total_price'];
        }else{
          	$ordet_type = 'Prepaid';
          	$collective_price = '0.00';
        }
        $order_dispatch = ItEasyOrderDispatch::findOne(['it_easy_order_id' => $order_data['it_easy_order_id']]);
        if(empty($order_dispatch)){
                $order_dispatch = new ItEasyOrderDispatch();
        }
        $order_dispatch->it_easy_order_id              = $order_data['it_easy_order_id'];
        $order_dispatch->it_easy_order_number          = $order_data['it_easy_order_number'];
        $order_dispatch->it_easy_shipping_id           = $shipid;
        $order_dispatch->it_easy_user_id               = $order_data['it_easy_customer_id'];
        $order_dispatch->it_easy_department_id         = $order_data['it_easy_department_id'];
        $order_dispatch->it_easy_awb_number            = $returnarray;
        $order_dispatch->it_easy_order_type            = $ordet_type;
        $order_dispatch->it_easy_firstname             = $order_data['it_easy_shipping_firstname'];
        $order_dispatch->it_easy_lastname              = $order_data['it_easy_shipping_lastname'];
        $order_dispatch->it_easy_address_1             = $order_data['it_easy_shipping_address_1'];
        $order_dispatch->it_easy_address_2             = $order_data['it_easy_shipping_address_2'];
        $order_dispatch->it_easy_city                  = $order_data['it_easy_shipping_city'];
        $order_dispatch->it_easy_state                 = $order_data['it_easy_shipping_state'];
        $order_dispatch->it_easy_state_id              = $order_data['it_easy_shipping_state_id'];
        $order_dispatch->it_easy_pincode               = $order_data['it_easy_shipping_pincode'];
        $order_dispatch->it_easy_mobile                = $order_data['it_easy_shipping_mobile_number'];
        $order_dispatch->it_easy_email                 = $order_data['it_easy_shipping_email'];
        $order_dispatch->it_easy_alternate_mobile      = $order_data['it_easy_shipping_alternate_number'];
        $order_dispatch->it_easy_price                 = $order_data['it_easy_total_price'];
        $order_dispatch->it_easy_collective_price      = $collective_price;
        $order_dispatch->it_easy_order_date            = '';
        $order_dispatch->it_easy_dispatch_time         = '';
        $order_dispatch->it_easy_awb_time           =  date('Y-m-d H:i:s');
        $order_dispatch->it_easy_return_awb            = '';
        $order_dispatch->it_easy_pickup_time           = '';
        if(!empty($zone_name)){
            $order_dispatch->it_easy_zone_name             = $zone_name->it_easy_zone_name;
        }else{
            $order_dispatch->it_easy_zone_name             = 'Zone A';
        }
        $order_dispatch->it_easy_courier_name          = $shiping_data['it_easy_name'];
        $order_dispatch->it_easy_subcourier_name       = $shiping_data['it_easy_name'];
        $order_dispatch->it_easy_order_status          = 'AWB Assigned';
        $order_dispatch->it_easy_courier_comment       = '';
        $order_dispatch->it_easy_status_updated_at     = $order_data['it_easy_updated_time'];
        $order_dispatch->it_easy_first_scan_date       = '';
        $order_dispatch->it_easy_last_scan_date        = '';
        $order_dispatch->it_easy_first_attempted_date  = '';
        $order_dispatch->it_easy_last_attempted_date   = '';
        $order_dispatch->it_easy_delivery_date         = $order_data['it_easy_delivered_time'];
        $order_dispatch->it_easy_route_code            = '';
        $order_dispatch->it_easy_picked                = $order_data['it_easy_order_id'];
        $order_dispatch->it_easy_auto_rto_date         = '';
        $order_dispatch->it_easy_rto_date              = '';
        $order_dispatch->it_easy_attempt_count         = '';
        $order_dispatch->it_easy_courier_price         = '';
        $order_dispatch->it_easy_rto_updated_by        = '';
        $order_dispatch->save(false);
        

    }


    protected static function findOrderModel($it_easy_order_id)
    {
        if (($model = ItEasyOrder::findOne(['it_easy_order_id' => $it_easy_order_id])) !== null) {
            $model->it_easy_order_status_id = '2';
          	$model->it_easy_assign_time = date('Y-m-d H:i:s');
          	$model->it_easy_updated_time = date('Y-m-d H:i:s');
            $model->save(false);
          
          	$add_order_status = ItEasyOrder::addOrderStatusHistory($it_easy_order_id, '2', 'AWB Assign');
        }
        
    }
  
  	protected static function findupdateOrderModel($it_easy_order_id)
    {
        if (($model = ItEasyOrder::findOne(['it_easy_order_id' => $it_easy_order_id])) !== null) {
            $model->it_easy_order_status_id = '4';
          	$model->it_easy_updated_time = date('Y-m-d H:i:s');
            $model->save(false);
          
          	$add_order_status = ItEasyOrder::addOrderStatusHistory($it_easy_order_id, '4', 'Order Manifest');
        }
        
    }
 
   
    public function updateAwbResponce($it_easy_order_id="",$user_id="",$shipid="",$awb_number="",$api_type="",$responce="",$currentDateTime=""){
        $awb_responce = new ItEasyAwbResponce();
        $awb_responce->it_easy_order_id = $it_easy_order_id;
        $awb_responce->it_easy_user_id = $user_id;
        $awb_responce->it_easy_shipping_id = $shipid;
        $awb_responce->it_easy_awb_number  = $awb_number;
        $awb_responce->it_easy_api_type = $api_type;
        $awb_responce->it_easy_api_responce = $responce;
        $awb_responce->it_easy_created_time = $currentDateTime;
        $awb_responce->save(false);
    }
}
