<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_add_warehouse_history".
 *
 * @property int $id
 * @property int $it_easy_warehouse_history_id
 * @property int $it_easy_product_id
 * @property int $it_easy_variation_id
 * @property string $it_easy_product_quantity
 * @property string|null $it_easy_warehouse_name
 * @property string|null $it_easy_product_name
 * @property string|null $it_easy_variation_name
 * @property int|null $it_easy_received_by
 * @property string|null $it_easy_received_date
 * @property int|null $created_by
 * @property string|null $created_time
 */
class ItEasyAddWarehouseHistory extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_add_warehouse_history';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_warehouse_history_id', 'it_easy_product_id', 'it_easy_variation_id', 'it_easy_product_quantity'], 'required'],
            [['it_easy_warehouse_history_id', 'it_easy_product_id', 'it_easy_variation_id', 'it_easy_received_by', 'created_by'], 'integer'],
            [['it_easy_received_date', 'created_time'], 'safe'],
            [['it_easy_product_quantity'], 'string', 'max' => 30],
            [['it_easy_warehouse_name', 'it_easy_product_name', 'it_easy_variation_name'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'it_easy_warehouse_history_id' => 'It Easy Warehouse History ID',
            'it_easy_product_id' => 'It Easy Product ID',
            'it_easy_variation_id' => 'It Easy Variation ID',
            'it_easy_product_quantity' => 'It Easy Product Quantity',
            'it_easy_warehouse_name' => 'It Easy Warehouse Name',
            'it_easy_product_name' => 'It Easy Product Name',
            'it_easy_variation_name' => 'It Easy Variation Name',
            'it_easy_received_by' => 'It Easy Received By',
            'it_easy_received_date' => 'It Easy Received Date',
            'created_by' => 'Created By',
            'created_time' => 'Created Time',
        ];
    }
}
