<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;

/**
 * This is the model class for table "it_easy_add_warehouse_history".
 *
 * @property int $id
 * @property int $it_easy_warehouse_history_id
 * @property int $it_easy_product_id
 * @property int $it_easy_variation_id
 * @property string $it_easy_product_quantity
 * @property string|null $it_easy_warehouse_name
 * @property string|null $it_easy_product_name
 * @property string|null $it_easy_variation_name
 * @property int|null $it_easy_received_by
 * @property string|null $it_easy_received_date
 * @property int|null $created_by
 * @property string|null $created_time
 */
class ItEasyAddWarehouseHistorySearch extends ItEasyAddWarehouseHistory
{
    /**
     * {@inheritdoc}
     */
    

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
          

            [['it_easy_warehouse_history_id', 'it_easy_product_id', 'it_easy_variation_id', 'it_easy_product_quantity','it_easy_received_date', 'created_time','it_easy_received_by','created_by','it_easy_warehouse_name', 'it_easy_product_name', 'it_easy_variation_name'], 'safe'],
          
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'it_easy_warehouse_history_id' => 'Warehouse History ID',
            'it_easy_product_id' => 'Product ID',
            'it_easy_variation_id' => 'Variation ID',
            'it_easy_product_quantity' => 'Product Quantity',
            'it_easy_warehouse_name' => 'Warehouse Name',
            'it_easy_product_name' => 'Product Name',
            'it_easy_variation_name' => 'Variation Name',
            'it_easy_received_by' => 'Received By',
            'it_easy_received_date' => 'Received Date',
            'created_by' => 'Created By',
            'created_time' => 'Created Time',
        ];
    }



      public function search($params)
    {
        $query = ItEasyAddWarehouseHistory::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_warehouse_history_id' => $this->it_easy_warehouse_history_id,
            'it_easy_product_id' => $this->it_easy_product_id,
            'it_easy_variation_id' => $this->it_easy_variation_id,
           
        ]);

         $date = $this->created_time;

        $explode = explode('-', $date);
        if (!empty($this->created_time)) {
            $start_date = date('Y-m-d', strtotime($explode[0]));
        } else {
            $start_date = '';
        }
        if (!empty($this->created_time)) {
            $end_date = date('Y-m-d', strtotime($explode[1])).' 23:59:59';
        } else {
            $end_date = '';
        }
        $query->andFilterWhere(['<=', 'created_time', $end_date])
                     ->andWhere(['>=', 'created_time', $start_date]);
       
        return $dataProvider;
    }
}
