<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_api".
 *
 * @property int $it_easy_id
 * @property string $api_type
 * @property string $it_easy_api_name
 * @property string $it_easy_api_url
 * @property string $it_easy_api_username
 * @property string $it_easy_api_password
 * @property string|null $it_easy_api_key
 * @property string|null $it_easy_api_port
 * @property string $it_easy_status
 * @property string|null $it_easy_created_time
 * @property string|null $it_easy_updated_time
 * @property int|null $it_easy_created_by
 * @property int|null $it_easy_updated_by
 */
class ItEasyApi extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_api';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['api_type', 'it_easy_api_name', 'it_easy_api_url', 'it_easy_api_username', 'it_easy_api_password', 'it_easy_status'], 'required'],
            [['api_type', 'it_easy_status'], 'string'],
            [['it_easy_created_time', 'it_easy_updated_time'], 'safe'],
            [['it_easy_created_by', 'it_easy_updated_by'], 'integer'],
            [['it_easy_api_name'], 'string', 'max' => 100],
            [['it_easy_api_url'], 'string', 'max' => 255],
            [['it_easy_api_username', 'it_easy_api_password'], 'string', 'max' => 80],
            [['it_easy_api_key'], 'string', 'max' => 150],
            [['it_easy_api_port'], 'string', 'max' => 20],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'ID',
            'api_type' => 'Api Type',
            'it_easy_api_name' => 'Api Name',
            'it_easy_api_url' => 'Api Url',
            'it_easy_api_username' => 'Api Username',
            'it_easy_api_password' => 'Api Password',
            'it_easy_api_key' => 'Api Key',
            'it_easy_api_port' => 'Api Port',
            'it_easy_status' => 'Status',
            'it_easy_created_time' => 'Created Time',
            'it_easy_updated_time' => 'Updated Time',
            'it_easy_created_by' => 'Created By',
            'it_easy_updated_by' => 'Updated By',
        ];
    }
}
