<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyApi;

/**
 * ItEasyApiSearch represents the model behind the search form of `backend\models\ItEasyApi`.
 */
class ItEasyApiSearch extends ItEasyApi
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_id', 'it_easy_created_by', 'it_easy_updated_by'], 'integer'],
            [['api_type', 'it_easy_api_name', 'it_easy_api_url', 'it_easy_api_username', 'it_easy_api_password', 'it_easy_api_key', 'it_easy_api_port', 'it_easy_status', 'it_easy_created_time', 'it_easy_updated_time'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyApi::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_id' => $this->it_easy_id,
            'it_easy_created_time' => $this->it_easy_created_time,
            'it_easy_updated_time' => $this->it_easy_updated_time,
            'it_easy_created_by' => $this->it_easy_created_by,
            'it_easy_updated_by' => $this->it_easy_updated_by,
        ]);

        $query->andFilterWhere(['like', 'api_type', $this->api_type])
            ->andFilterWhere(['like', 'it_easy_api_name', $this->it_easy_api_name])
            ->andFilterWhere(['like', 'it_easy_api_url', $this->it_easy_api_url])
            ->andFilterWhere(['like', 'it_easy_api_username', $this->it_easy_api_username])
            ->andFilterWhere(['like', 'it_easy_api_password', $this->it_easy_api_password])
            ->andFilterWhere(['like', 'it_easy_api_key', $this->it_easy_api_key])
            ->andFilterWhere(['like', 'it_easy_api_port', $this->it_easy_api_port])
            ->andFilterWhere(['like', 'it_easy_status', $this->it_easy_status]);

        return $dataProvider;
    }
}
