<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_api_template".
 *
 * @property int $it_easy_id
 * @property string $it_easy_template_type
 * @property string $it_easy_uses_type
 * @property int $it_easy_template_name
 * @property string|null $it_easy_template_subject
 * @property string $it_easy_template_text
 * @property string $it_easy_status
 * @property string|null $it_easy_created_time
 * @property string|null $it_easy_updated_time
 * @property int|null $it_easy_created_by
 * @property int|null $it_easy_updated_by
 */
class ItEasyApiTemplate extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public $it_easy_template_text_sms;
    public static function tableName()
    {
        return 'it_easy_api_template';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_id', 'it_easy_template_type', 'it_easy_uses_type', 'it_easy_template_name', 'it_easy_status'], 'required'],
            [['it_easy_id', 'it_easy_created_by', 'it_easy_updated_by'], 'integer'],
            [['it_easy_template_type', 'it_easy_uses_type', 'it_easy_template_subject', 'it_easy_template_text', 'it_easy_status'], 'string'],
            [['it_easy_created_time', 'it_easy_updated_time','it_easy_template_text','it_easy_template_text_sms'], 'safe'],
            [['it_easy_id'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'ID',
            'it_easy_template_type' => 'Template Type',
            'it_easy_uses_type' => 'Uses Type',
            'it_easy_template_name' => 'Template Name',
            'it_easy_template_subject' => 'Template Subject',
            'it_easy_template_text' => 'Template Text',
            'it_easy_status' => 'Status',
            'it_easy_created_time' => 'It Easy Created Time',
            'it_easy_updated_time' => 'It Easy Updated Time',
            'it_easy_created_by' => 'It Easy Created By',
            'it_easy_updated_by' => 'It Easy Updated By',
        ];
    }
}
