<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_awb_responce".
 *
 * @property int $it_easy_id
 * @property string $it_easy_order_id
 * @property int $it_easy_user_id
 * @property int $it_easy_shipping_id
 * @property string|null $it_easy_awb_number
 * @property string|null $it_easy_api_type
 * @property string|null $it_easy_api_responce
 * @property string $it_easy_created_time
 * @property string $read_msg 1=unread, 0=read
 */
class ItEasyAwbResponce extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_awb_responce';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_order_id', 'it_easy_user_id', 'it_easy_shipping_id', 'it_easy_created_time'], 'required'],
            [['it_easy_user_id', 'it_easy_shipping_id'], 'integer'],
            [['it_easy_api_responce', 'read_msg'], 'string'],
            [['it_easy_created_time'], 'safe'],
            [['it_easy_order_id'], 'string', 'max' => 60],
            [['it_easy_awb_number', 'it_easy_api_type'], 'string', 'max' => 50],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'It Easy ID',
            'it_easy_order_id' => 'It Easy Order ID',
            'it_easy_user_id' => 'It Easy User ID',
            'it_easy_shipping_id' => 'It Easy Shipping ID',
            'it_easy_awb_number' => 'It Easy Awb Number',
            'it_easy_api_type' => 'It Easy Api Type',
            'it_easy_api_responce' => 'It Easy Api Responce',
            'it_easy_created_time' => 'It Easy Created Time',
            'read_msg' => 'Read Msg',
        ];
    }
}
