<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_build_history".
 *
 * @property int $it_easy_id
 * @property int $it_easy_product_id
 * @property int $it_easy_variation_id
 * @property string $it_easy_product_quantity
 * @property int $it_easy_added_by
 * @property string $it_easy_build_date
 * @property int $it_easy_product_batch_id
 * @property string $it_easy_unique_start
 * @property string $it_easy_unique_end
 * @property int|null $created_by
 * @property string|null $created_time
 * @property int|null $updated_by
 * @property string|null $updated_time
 */
class ItEasyBuildHistory extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_build_history';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_product_id', 'it_easy_variation_id', 'it_easy_product_quantity', 'it_easy_added_by', 'it_easy_build_date', 'it_easy_product_batch_id'], 'required'],
            [['it_easy_product_id', 'it_easy_variation_id', 'it_easy_added_by', 'it_easy_product_batch_id', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_build_date', 'created_time', 'updated_time','it_easy_product_stock_id'], 'safe'],
            [['it_easy_product_quantity'], 'string', 'max' => 20],
            [['it_easy_unique_start', 'it_easy_unique_end'], 'string', 'max' => 60],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'ID',
            'it_easy_product_id' => 'Product Name',
            'it_easy_variation_id' => 'Variation Name',
            'it_easy_product_quantity' => 'Product Quantity',
            'it_easy_added_by' => 'Added By',
            'it_easy_build_date' => 'Build Date',
            'it_easy_product_batch_id' => 'Product Batch',
            'it_easy_unique_start' => 'Unique Start',
            'it_easy_unique_end' => 'Unique End',
            'created_by' => 'Created By',
            'created_time' => 'Created Time',
            'updated_by' => 'Updated By',
            'updated_time' => 'Updated Time',
        ];
    }

     public function getVaritionData($productid){
        $connection = \Yii::$app->db;
        $sql = "select it_easy_product_variation_attribute.it_easy_id,it_easy_product_variation_attribute.it_easy_variation_name from it_easy_product_variation LEFT JOIN it_easy_product_variation_attribute ON it_easy_product_variation.it_easy_variation_id = it_easy_product_variation_attribute.it_easy_id where it_easy_product_variation.it_easy_product_id = ".$productid." GROUP BY it_easy_product_variation.it_easy_variation_id";
        $command = $connection->createCommand($sql);
        $data = $command->queryAll();
        $redata = '';
        $redata .= "<option value=''>Select</option>";
        foreach ($data as $key => $value) {
           $redata .= "<option value=".$value['it_easy_id'].">".$value['it_easy_variation_name']."</option>";
        }
        echo $redata;
        
    }
 
}
