<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyBuildHistory;

/**
 * ItEasyBuildHistorySearch represents the model behind the search form of `backend\models\ItEasyBuildHistory`.
 */
class ItEasyBuildHistorySearch extends ItEasyBuildHistory
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_id', 'it_easy_product_id', 'it_easy_variation_id', 'it_easy_added_by', 'it_easy_product_batch_id', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_product_quantity', 'it_easy_build_date', 'it_easy_unique_start', 'it_easy_unique_end', 'created_time', 'updated_time'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyBuildHistory::find();
    

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_id' => $this->it_easy_id,
            'it_easy_product_id' => $this->it_easy_product_id,
            'it_easy_variation_id' => $this->it_easy_variation_id,
            'it_easy_added_by' => $this->it_easy_added_by,
            'it_easy_build_date' => $this->it_easy_build_date,
            'it_easy_product_batch_id' => $this->it_easy_product_batch_id,
            // 'created_by' => $this->created_by,
            // 'created_time' => $this->created_time,
            // 'updated_by' => $this->updated_by,
            // 'updated_time' => $this->updated_time,
        ]);

        $query->andFilterWhere(['like', 'it_easy_product_quantity', $this->it_easy_product_quantity])
            ->andFilterWhere(['like', 'it_easy_unique_start', $this->it_easy_unique_start])
            ->andFilterWhere(['like', 'it_easy_unique_end', $this->it_easy_unique_end]);
     
        $date = $this->created_time;
        $explode = explode('-', $date);
        if (!empty($this->created_time)) {
            $start_date = date('Y-m-d', strtotime($explode[0]));
        } else {
            $start_date = '';
        }
        if (!empty($this->created_time)) {
            $end_date = date('Y-m-d', strtotime($explode[1]));
        } else {
            $end_date = '';
        }
        $query->andFilterWhere(['between', 'created_time', $start_date, $end_date]);
        
        return $dataProvider;

     
    }
}
