<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_build_ingredient".
 *
 * @property int $it_easy_id
 * @property int $it_easy_build_id
 * @property int $it_easy_material_id
 * @property string|null $it_easy_material_name
 * @property string $it_easy_add_quantity
 * @property string $it_easy_weight_type
 * @property string|null $created_time
 * @property string|null $updated_time
 */
class ItEasyBuildIngredient extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_build_ingredient';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_build_id', 'it_easy_product_batch_id', 'it_easy_product_id', 'it_easy_variation_id','it_easy_product_quantity'], 'required'],
            [['it_easy_build_id', 'it_easy_material_id'], 'integer'],
            [['created_time', 'updated_time','it_easy_build_date'], 'safe'],
            [['it_easy_material_name'], 'string', 'max' => 150],
            [['it_easy_add_quantity'], 'string', 'max' => 50],
            [['it_easy_weight_type'], 'string', 'max' => 30],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'It Easy ID',
            'it_easy_build_id' => 'Build ID',
            'it_easy_material_id' => 'Material ID',
            'it_easy_product_quantity'=>'Product Quantity',
            'it_easy_build_date'=>'Build Date',
            'it_easy_material_name' => 'Material Name',
            'it_easy_add_quantity' => 'Add Quantity',
            'it_easy_weight_type' => 'Weight Type',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
        ];
    }


       public function getProductBatch(){
        $connection = \Yii::$app->db;
        $sql = "select * from it_easy_product_batch";
        $command = $connection->createCommand($sql);
        $data = $command->queryAll();
        return $data;
    }

    public function getProductName(){
        $connection = \Yii::$app->db;
        $sql = "select * from it_easy_product where it_easy_product_status = 'Active'";
        $command = $connection->createCommand($sql);
        $data = $command->queryAll();
        return $data;
    }


    public function getVariation(){
        $connection = \Yii::$app->db;
        $sql = "select * from it_easy_product_variation_attribute where it_easy_status = 'Active'";
        $command = $connection->createCommand($sql);
        $data = $command->queryAll();
        return $data;
    }
    
    public function getMaterialData(){
        $connection = \Yii::$app->db;
        $sql = "select * from it_easy_product_material where it_easy_status = 'Active'";
        $command = $connection->createCommand($sql);
        $data = $command->queryAll();
        return $data;
    }
}
