<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_buy_material_product_history".
 *
 * @property int $id
 * @property int $material_history_id
 * @property int $material_id
 * @property string $material_quantity
 * @property float $material_price
 * @property float $material_unit_price
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property string|null $created_time
 * @property string|null $updated_time
 */
class ItEasyBuyMaterialProductHistory extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_buy_material_product_history';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['material_history_id', 'material_id', 'material_quantity', 'material_price', 'material_unit_price'], 'required'],
            [['material_history_id', 'material_id', 'created_by', 'updated_by'], 'integer'],
            [['material_price', 'material_unit_price'], 'number'],
            [['created_time', 'updated_time','it_easy_weight_type'], 'safe'],
            [['material_quantity'], 'string', 'max' => 30],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'material_history_id' => 'Material History ID',
            'material_id' => 'Material ID',
            'material_quantity' => 'Material Quantity',
            'material_price' => 'Material Price',
            'material_unit_price' => 'Material Unit Price',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
        ];
    }

        public function getMaterialData(){
        $connection = \Yii::$app->db;
        $sql = "select * from it_easy_product_material where it_easy_status = 'Active'";
        $command = $connection->createCommand($sql);
        $data = $command->queryAll();
        return $data;
    }
}
