<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_buy_product".
 *
 * @property int $it_easy_id
 * @property int $it_easy_vendor_id
 * @property string $it_easy_vendor_name
 * @property int $it_easy_product_id
 * @property string $it_easy_product_name
 * @property int $it_easy_variation_id
 * @property string $it_easy_product_quantity
 * @property string $it_easy_invoice_number
 * @property float $it_easy_per_bottle_price
 * @property float $it_easy_total_price
 * @property float $it_easy_gst_amount
 * @property int $it_easy_gst_type
 * @property string $it_easy_received_date
 * @property int|null $it_easy_received_by
 * @property string|null $it_easy_approved_status
 * @property string|null $it_easy_buy_month
 * @property string|null $it_easy_buy_year
 * @property string|null $created_time
 * @property string|null $updated_time
 * @property int|null $created_by
 * @property int|null $updated_by
 */
class ItEasyBuyProduct extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_buy_product';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_vendor_id', 'it_easy_vendor_name', 'it_easy_product_id', 'it_easy_product_name', 'it_easy_variation_id', 'it_easy_product_quantity', 'it_easy_invoice_number', 'it_easy_per_bottle_price', 'it_easy_total_price', 'it_easy_gst_amount', 'it_easy_gst_type', 'it_easy_received_date'], 'required'],
            [['it_easy_vendor_id', 'it_easy_product_id', 'it_easy_variation_id', 'it_easy_gst_type', 'it_easy_received_by', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_per_bottle_price', 'it_easy_total_price', 'it_easy_gst_amount'], 'number'],
            [['it_easy_received_date', 'created_time', 'updated_time'], 'safe'],
            [['it_easy_vendor_name'], 'string', 'max' => 100],
            [['it_easy_product_name'], 'string', 'max' => 200],
            [['it_easy_product_quantity'], 'string', 'max' => 12],
            [['it_easy_invoice_number'], 'string', 'max' => 80],
            [['it_easy_approved_status'], 'string', 'max' => 50],
            [['it_easy_buy_month', 'it_easy_buy_year'], 'string', 'max' => 8],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'ID',
            'it_easy_vendor_id' => 'Vendor ID',
            'it_easy_vendor_name' => 'Vendor Name',
            'it_easy_product_id' => 'Product ID',
            'it_easy_product_name' => 'Product Name',
            'it_easy_variation_id' => 'Variation ID',
            'it_easy_product_quantity' => 'Product Quantity',
            'it_easy_invoice_number' => 'Invoice Number',
            'it_easy_per_bottle_price' => 'Per Bottle Price',
            'it_easy_total_price' => 'Total Price',
            'it_easy_gst_amount' => 'Gst Amount',
            'it_easy_gst_type' => 'Gst Type',
            'it_easy_received_date' => 'Received Date',
            'it_easy_received_by' => 'Received By',
            'it_easy_approved_status' => 'Approved Status',
            'it_easy_buy_month' => 'Buy Month',
            'it_easy_buy_year' => 'Buy Year',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
        ];
    }


     public function getVaritionData($productid){
        $connection = \Yii::$app->db;
        $sql = "select it_easy_product_variation_attribute.it_easy_id,it_easy_product_variation_attribute.it_easy_variation_name from it_easy_product_variation LEFT JOIN it_easy_product_variation_attribute ON it_easy_product_variation.it_easy_variation_id = it_easy_product_variation_attribute.it_easy_id where it_easy_product_variation.it_easy_product_id = ".$productid." GROUP BY it_easy_product_variation.it_easy_variation_id";
        $command = $connection->createCommand($sql);
        $data = $command->queryAll();
        $redata = '';
        $redata .= "<option value=''>Select</option>";
        foreach ($data as $key => $value) {
           $redata .= "<option value=".$value['it_easy_id'].">".$value['it_easy_variation_name']."</option>";
        }
        echo $redata;
        
    }
}
