<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyBuyProduct;

/**
 * ItEasyBuyProductSearch represents the model behind the search form of `backend\models\ItEasyBuyProduct`.
 */
class ItEasyBuyProductSearch extends ItEasyBuyProduct
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_id', 'it_easy_vendor_id', 'it_easy_product_id', 'it_easy_variation_id', 'it_easy_gst_type', 'it_easy_received_by', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_vendor_name', 'it_easy_product_name', 'it_easy_product_quantity', 'it_easy_invoice_number', 'it_easy_received_date', 'it_easy_approved_status', 'it_easy_buy_month', 'it_easy_buy_year', 'created_time', 'updated_time'], 'safe'],
            [['it_easy_per_bottle_price', 'it_easy_total_price', 'it_easy_gst_amount'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyBuyProduct::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            // 'it_easy_id' => $this->it_easy_id,
            // 'it_easy_vendor_id' => $this->it_easy_vendor_id,
            // 'it_easy_product_id' => $this->it_easy_product_id,
            'it_easy_variation_id' => $this->it_easy_variation_id,
            // 'it_easy_per_bottle_price' => $this->it_easy_per_bottle_price,
            // 'it_easy_total_price' => $this->it_easy_total_price,
            // 'it_easy_gst_amount' => $this->it_easy_gst_amount,
            // 'it_easy_gst_type' => $this->it_easy_gst_type,
            // 'it_easy_received_date' => $this->it_easy_received_date,
            // 'it_easy_received_by' => $this->it_easy_received_by,
            // 'created_time' => $this->created_time,
            // 'updated_time' => $this->updated_time,
            // 'created_by' => $this->created_by,
            // 'updated_by' => $this->updated_by,
        ]);

        $query->andFilterWhere(['like', 'it_easy_vendor_name', $this->it_easy_vendor_name])
            ->andFilterWhere(['like', 'it_easy_product_name', $this->it_easy_product_name])
           ->andFilterWhere(['=', 'it_easy_approved_status', $this->it_easy_approved_status]);
           $date = $this->it_easy_received_date;
            $explode = explode('-', $date);
            if(!empty($this->it_easy_received_date)){
            $start_date = date('Y-m-d',strtotime($explode[0]));
            }else{
                $start_date = '';
            }
            if(!empty($this->it_easy_received_date)){
            $end_date = date('Y-m-d',strtotime($explode[1]));
             }else{
                $end_date = '';
             }
            $query->andFilterWhere(['between', 'it_easy_received_date', $start_date, $end_date]);
        return $dataProvider;
    }
}
