<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_chanel".
 *
 * @property int $id
 * @property string $fetch_Type
 * @property string $channel_name
 * @property string|null $shop_url
 * @property string $api_key
 * @property string|null $api_secret
 * @property string $api_password
 * @property string $status
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property string|null $created_time
 * @property string|null $updated_time
 */
class ItEasyChanel extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_chanel';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['fetch_Type', 'status'], 'string'],
            [['channel_name', 'api_key', 'api_password', 'status'], 'required'],
            [['created_by', 'updated_by'], 'integer'],
            [['created_time', 'updated_time'], 'safe'],
            [['channel_name', 'api_secret', 'api_password'], 'string', 'max' => 100],
            [['shop_url'], 'string', 'max' => 255],
            [['api_key'], 'string', 'max' => 80],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'fetch_Type' => 'Fetch Type',
            'channel_name' => 'Channel Name',
            'shop_url' => 'Shop Url',
            'api_key' => 'Api Key',
            'api_secret' => 'Api Secret',
            'api_password' => 'Api Password',
            'status' => 'Status',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
        ];
    }
}
