<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyChanel;

/**
 * ItEasyChanelSearch represents the model behind the search form of `backend\models\ItEasyChanel`.
 */
class ItEasyChanelSearch extends ItEasyChanel
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'created_by', 'updated_by'], 'integer'],
            [['fetch_Type', 'channel_name', 'shop_url', 'api_key', 'api_secret', 'api_password', 'status', 'created_time', 'updated_time'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyChanel::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
            'created_time' => $this->created_time,
            'updated_time' => $this->updated_time,
        ]);

        $query->andFilterWhere(['like', 'fetch_Type', $this->fetch_Type])
            ->andFilterWhere(['like', 'channel_name', $this->channel_name])
            ->andFilterWhere(['like', 'shop_url', $this->shop_url])
            ->andFilterWhere(['like', 'api_key', $this->api_key])
            ->andFilterWhere(['like', 'api_secret', $this->api_secret])
            ->andFilterWhere(['like', 'api_password', $this->api_password])
            ->andFilterWhere(['=', 'status', $this->status]);

        return $dataProvider;
    }
}
