<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_clickpost_courier".
 *
 * @property int $id
 * @property string $cp_id
 * @property string $account_name
 * @property string $created_time
 * @property string $updated_time
 * @property string $created_by
 * @property string|null $updated_by
 */
class ItEasyClickpostCourier extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_clickpost_courier';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cp_id', 'account_name', 'courier_name'], 'required'],
            [['account_name'], 'string'],
            [['created_time', 'updated_time'], 'safe'],
            [['created_by', 'updated_by'], 'integer'],
            [['account_name'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'account_name' => 'Account Name',
            'cp_id' => 'Courier ID',
            'courier_name' => 'Courier Name',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
        ];
    }
}
