<?php

namespace backend\models;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyClickpostCourier;

/**
 * ItEasyApiSearch represents the model behind the search form of `backend\models\ItEasyClickpostCourier`.
 */
class ItEasyClickpostCourierSearch extends ItEasyClickpostCourier
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'cp_id'], 'integer'],
            [['account_name', 'created_time', 'courier_name'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyClickpostCourier::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'created_time' => $this->created_time
        ]);

        $query->andFilterWhere(['like', 'account_name', $this->account_name])
               ->andFilterWhere(['like', 'courier_name', $this->courier_name]);

        return $dataProvider;
    }
}
