<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_coupon_history".
 *
 * @property int $it_easy_id
 * @property int $it_easy_order_id
 * @property int $it_easy_coupon_id
 * @property string $it_easy_table_name
 * @property string $it_easy_coupon_code
 * @property float $it_easy_coupon_discount
 * @property string|null $it_easy_created_time
 * @property string|null $it_easy_updated_time
 */
class ItEasyCouponHistory extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {   
        $today_date = date('Y-m-d');
        $ge_financial = ItEasyFinancialYear::find()->select(['it_easy_financial_year'])->where(['or',['<=', 'it_easy_date_from', $today_date], ['>=', 'it_easy_date_to', $today_date] ])->asArray()->one();
        return 'it_easy_coupon_history_'.$ge_financial['it_easy_financial_year'];
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_order_id', 'it_easy_coupon_id', 'it_easy_coupon_code'], 'required'],
            [['it_easy_order_id', 'it_easy_coupon_id'], 'integer'],
            [['it_easy_coupon_discount'], 'number'],
            [['it_easy_created_time', 'it_easy_updated_time'], 'safe'],
            [['it_easy_table_name'], 'string', 'max' => 60],
            [['it_easy_coupon_code'], 'string', 'max' => 20],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'It Easy ID',
            'it_easy_order_id' => 'It Easy Order ID',
            'it_easy_coupon_id' => 'It Easy Coupon ID',
            'it_easy_table_name' => 'It Easy Table Name',
            'it_easy_coupon_code' => 'It Easy Coupon Code',
            'it_easy_coupon_discount' => 'It Easy Coupon Discount',
            'it_easy_created_time' => 'It Easy Created Time',
            'it_easy_updated_time' => 'It Easy Updated Time',
        ];
    }
}
