<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_coupon".
 *
 * @property int $it_easy_id
 * @property string $it_easy_coupon_name
 * @property string $it_easy_coupon_code
 * @property string $it_easy_coupon_type
 * @property int $it_easy_discount
 * @property string $it_easy_discount_type
 * @property int|null $it_easy_number
 * @property string|null $it_easy_start_date
 * @property string|null $it_easy_end_date
 * @property string $it_easy_status
 * @property string|null $created_time
 * @property string|null $updated_time
 * @property int|null $created_by
 * @property int|null $updated_by
 */
class ItEasyCoupon extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_coupon';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_coupon_name', 'it_easy_coupon_code', 'it_easy_coupon_type', 'it_easy_discount', 'it_easy_discount_type', 'it_easy_status'], 'required'],
            [['it_easy_coupon_type', 'it_easy_discount_type', 'it_easy_status'], 'string'],
            [['it_easy_discount', 'it_easy_number', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_start_date', 'it_easy_end_date', 'created_time', 'updated_time'], 'safe'],
            [['it_easy_coupon_name'], 'string', 'max' => 100],
            [['it_easy_coupon_code'], 'string', 'max' => 10],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'ID',
            'it_easy_coupon_name' => 'Coupon Name',
            'it_easy_coupon_code' => 'Coupon Code',
            'it_easy_coupon_type' => 'Coupon Type',
            'it_easy_discount' => 'Coupon Discount',
            'it_easy_discount_type' => 'Discount Type',
            'it_easy_number' => 'Coupon Number',
            'it_easy_start_date' => 'Start Date',
            'it_easy_end_date' => 'End Date',
            'it_easy_status' => 'Status',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
        ];
    }
}
