<?php

namespace backend\models;

use Yii;
use backend\models\ItEasyDiseasesName;
/**
 * This is the model class for table "it_easy_customer".
 *
 * @property int $it_easy_customer_id
 * @property string $it_easy_order_ids
 * @property string $it_easy_order_table
 * @property string $it_easy_customer_financialyear
 * @property int $it_easy_store_id
 * @property string $it_easy_firstname
 * @property string|null $it_easy_lastname
 * @property string $it_easy_mobile_number
 * @property string|null $it_easy_alternative_mobile
 * @property string|null $it_easy_email
 * @property string $it_easy_disease_name
 * @property string|null $it_easy_password
 * @property int $it_easy_newsletter
 * @property int $it_easy_sms_send
 * @property int $it_easy_email_send
 * @property string $it_easy_address_1
 * @property string|null $it_easy_address_2
 * @property string $it_easy_city
 * @property string $it_easy_state
 * @property int $it_easy_state_id
 * @property string $it_easy_pincode
 * @property string $it_easy_status
 * @property string|null $it_easy_status_reason
 * @property string|null $created_time
 * @property string|null $updated_time
 * @property int|null $created_by
 * @property int|null $updated_by
 */
class ItEasyCustomer extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_customer';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_order_ids', 'it_easy_order_table', 'it_easy_customer_financialyear', 'it_easy_store_id', 'it_easy_firstname', 'it_easy_mobile_number', 'it_easy_disease_name', 'it_easy_address_1', 'it_easy_city', 'it_easy_state', 'it_easy_state_id', 'it_easy_pincode'], 'required'],
            [['it_easy_order_ids', 'it_easy_order_table', 'it_easy_disease_name'], 'string'],
            [['it_easy_store_id', 'it_easy_newsletter', 'it_easy_sms_send', 'it_easy_email_send', 'it_easy_state_id', 'created_by', 'updated_by'], 'integer'],
            [['created_time', 'updated_time'], 'safe'],
            [['it_easy_customer_financialyear', 'it_easy_email'], 'string', 'max' => 100],
            [['it_easy_firstname', 'it_easy_lastname', 'it_easy_password'], 'string', 'max' => 80],
            [['it_easy_mobile_number', 'it_easy_alternative_mobile', 'it_easy_status'], 'string', 'max' => 20],
            [['it_easy_address_1', 'it_easy_address_2', 'it_easy_status_reason'], 'string', 'max' => 200],
            [['it_easy_city'], 'string', 'max' => 50],
            [['it_easy_state'], 'string', 'max' => 60],
            [['it_easy_pincode'], 'string', 'max' => 10],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_customer_id' => 'Customer ID',
            'it_easy_order_ids' => 'Order Ids',
            'it_easy_order_table' => 'Order Table',
            'it_easy_customer_financialyear' => 'Customer Financialyear',
            'it_easy_store_id' => 'Store ID',
            'it_easy_firstname' => 'Firstname',
            'it_easy_lastname' => 'Lastname',
            'it_easy_mobile_number' => 'Mobile Number',
            'it_easy_alternative_mobile' => 'Alternative Mobile',
            'it_easy_email' => 'Email',
            'it_easy_disease_name' => 'Disease Name',
            'it_easy_password' => 'Password',
            'it_easy_newsletter' => 'Newsletter',
            'it_easy_sms_send' => 'Sms Send',
            'it_easy_email_send' => 'Email Send',
            'it_easy_address_1' => 'Address 1',
            'it_easy_address_2' => 'Address 2',
            'it_easy_city' => 'City',
            'it_easy_state' => 'State',
            'it_easy_state_id' => 'State ID',
            'it_easy_pincode' => 'Pincode',
            'it_easy_status' => 'Status',
            'it_easy_status_reason' => 'Status Reason',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
        ];
    }
  
  	public static function FindCustomerbyMobile($mobile){
        $get_data = ItEasyCustomer::find()->where(['like', 'it_easy_mobile_number', '%'.$mobile.'%', false])->one();
        return $get_data;
    }

    public static function SavecustomerModelFromMobile($data, $order_id){
        // echo "<pre>"; print_r($data); die;
        $get_financial_year = ItEasyFinancialYear::getFinancialyear();   
        $customer_model = new ItEasyCustomer();
        $customer_model->it_easy_customer_financialyear = $get_financial_year;
        $customer_model->it_easy_order_ids = $order_id;
        $customer_model->it_easy_order_table = 'it_easy_order_'.$get_financial_year;
        $customer_model->it_easy_store_id = ItEasyStore::getStorename()->it_easy_id;
        $customer_model->it_easy_firstname = $data['it_easy_firstname'];
        $customer_model->it_easy_lastname = $data['it_easy_lastname'];
        $customer_model->it_easy_mobile_number = $data['it_easy_mobile_number'];
        $customer_model->it_easy_alternative_mobile = $data['it_easy_alternate_number'];
        $customer_model->it_easy_email = $data['it_easy_email'];
        $customer_model->it_easy_address_1 = $data['it_easy_address_1'];
        $customer_model->it_easy_address_2 = $data['it_easy_address_2'];
        $customer_model->it_easy_city = $data['it_easy_city'];
        $customer_model->it_easy_state = $data['it_easy_state'];
        $customer_model->it_easy_pincode = $data['it_easy_pincode'];
        $customer_model->save(false);
        return $customer_model;
    }
  
  
  	public static function SavecustomerModelFromMobileArray($data, $order_id){
  	    
        $get_financial_year = ItEasyFinancialYear::getFinancialyear();   
        $customer_model = new ItEasyCustomer();
        $customer_model->it_easy_customer_financialyear = $get_financial_year;
        $customer_model->it_easy_order_ids = $order_id;
        $customer_model->it_easy_order_table = 'it_easy_order_'.$get_financial_year;
        $customer_model->it_easy_store_id = ItEasyStore::getStorename()->it_easy_id;
        $customer_model->it_easy_firstname = $data->it_easy_firstname;
        $customer_model->it_easy_lastname = $data->it_easy_lastname;
        $customer_model->it_easy_mobile_number = $data->it_easy_mobile_number;
        $customer_model->it_easy_alternative_mobile = $data->it_easy_alternate_number;
        $customer_model->it_easy_email = $data->it_easy_email;
        $customer_model->it_easy_address_1 = $data->it_easy_address_1;
        $customer_model->it_easy_address_2 = $data->it_easy_address_2;
        $customer_model->it_easy_city = $data->it_easy_city;
        $customer_model->it_easy_state = $data->it_easy_state;
        $customer_model->it_easy_pincode = $data->it_easy_pincode;
        $customer_model->save(false);
        return $customer_model;
    }
}
