<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyCustomer;

/**
 * ItEasyCustomerSearch represents the model behind the search form of `backend\models\ItEasyCustomer`.
 */
class ItEasyCustomerSearch extends ItEasyCustomer
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_customer_id', 'it_easy_store_id', 'it_easy_newsletter', 'it_easy_sms_send', 'it_easy_email_send', 'it_easy_state_id', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_order_ids', 'it_easy_order_table', 'it_easy_customer_financialyear', 'it_easy_firstname', 'it_easy_lastname', 'it_easy_mobile_number', 'it_easy_alternative_mobile', 'it_easy_email', 'it_easy_disease_name', 'it_easy_password', 'it_easy_address_1', 'it_easy_address_2', 'it_easy_city', 'it_easy_state', 'it_easy_pincode', 'it_easy_status', 'it_easy_status_reason', 'created_time', 'updated_time'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {	
      	// echo "<pre>"; print_r($params); die;
        $query = ItEasyCustomer::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
            'pageSize' => 100,
        ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_customer_id' => $this->it_easy_customer_id,
            'it_easy_store_id' => $this->it_easy_store_id,
            'it_easy_newsletter' => $this->it_easy_newsletter,
            'it_easy_sms_send' => $this->it_easy_sms_send,
            'it_easy_email_send' => $this->it_easy_email_send,
            'it_easy_state_id' => $this->it_easy_state_id,
          
            'updated_time' => $this->updated_time,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
        ]);
        if(!empty($params['ItEasyCustomerSearch']['it_easy_disease_name']) && isset($params['ItEasyCustomerSearch']['it_easy_disease_name'])){
            // $query->where(['FIND_IN_SET', 'it_easy_disease_name', $this->it_easy_disease_name]);

            $query->where(new \yii\db\Expression('FIND_IN_SET('.$this->it_easy_disease_name.', it_easy_disease_name)'));
        }
        $query->andFilterWhere(['like', 'it_easy_order_ids', $this->it_easy_order_ids])
            ->andFilterWhere(['like', 'it_easy_order_table', $this->it_easy_order_table])
            ->andFilterWhere(['like', 'it_easy_customer_financialyear', $this->it_easy_customer_financialyear])
            ->andFilterWhere(['like', 'it_easy_firstname', $this->it_easy_firstname])
            ->andFilterWhere(['like', 'it_easy_lastname', $this->it_easy_lastname])
            ->andFilterWhere(['like', 'it_easy_mobile_number', $this->it_easy_mobile_number])
            ->andFilterWhere(['like', 'it_easy_alternative_mobile', $this->it_easy_alternative_mobile])
            ->andFilterWhere(['like', 'it_easy_email', $this->it_easy_email])
            ->andFilterWhere(['like', 'it_easy_password', $this->it_easy_password])
            ->andFilterWhere(['like', 'it_easy_address_1', $this->it_easy_address_1])
            ->andFilterWhere(['like', 'it_easy_address_2', $this->it_easy_address_2])
            ->andFilterWhere(['like', 'it_easy_city', $this->it_easy_city])
            ->andFilterWhere(['like', 'it_easy_state', $this->it_easy_state])
            ->andFilterWhere(['like', 'it_easy_pincode', $this->it_easy_pincode])
            ->andFilterWhere(['=', 'it_easy_status', $this->it_easy_status])
            ->andFilterWhere(['like', 'created_time', $this->created_time])
            ->andFilterWhere(['like', 'it_easy_status_reason', $this->it_easy_status_reason]);

        // echo $query->createCommand()->rawSql; die;

        return $dataProvider;
    }
}
