<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_delhivery_pincodes".
 *
 * @property int $it_easy_id
 * @property string $it_easy_pincode
 * @property string|null $it_easy_city
 * @property string|null $it_easy_state
 * @property int|null $it_easy_cod
 * @property int|null $it_easy_prepaid
 * @property string|null $it_easy_metro_city
 * @property string|null $it_easy_delivery_estimate
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property string|null $updated_time
 * @property string $created_time
 */
class ItEasyDelhiveryPincodes extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_delhivery_pincodes';
    }

    /**
     * {@inheritdoc}
     */
    public $file;
    public function rules()
    {
        return [
            [['it_easy_pincode', 'file','created_time'], 'required'],
            [['it_easy_cod', 'it_easy_prepaid', 'created_by', 'updated_by'], 'integer'],
            [['file','updated_time', 'created_time'], 'safe'],
            [['it_easy_pincode', 'it_easy_city', 'it_easy_state'], 'string', 'max' => 255],
            [['it_easy_metro_city'], 'string', 'max' => 40],
            [['file'], 'file', 'extensions' => 'csv', 'checkExtensionByMimeType'=>false, 'skipOnEmpty' => false],
            [['it_easy_delivery_estimate'], 'string', 'max' => 50],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'ID',
            'it_easy_pincode' => 'Pincode',
            'it_easy_city' => 'City',
            'it_easy_state' => 'State',
            'it_easy_cod' => 'Cod',
            'it_easy_prepaid' => 'Prepaid',
            'it_easy_metro_city' => 'Metro City',
            'it_easy_delivery_estimate' => 'Delivery Estimate',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'updated_time' => 'Updated Time',
            'created_time' => 'Created Time',
        ];
    }


    
}
