<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_department".
 *
 * @property int $it_easy_id
 * @property string $it_easy_depart_name
 * @property string $it_easy_status
 * @property string $created_time
 * @property string $updated_time
 * @property int $created_by
 * @property int $updated_by
 */
class ItEasyDepartment extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_department';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_depart_name', 'it_easy_status'], 'required'],
            [['created_time', 'updated_time'], 'safe'],
            [['created_by', 'updated_by'], 'integer'],
            [['it_easy_depart_name'], 'string', 'max' => 100],
            [['it_easy_status'], 'string', 'max' => 15],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'ID',
            'it_easy_depart_name' => 'Department Name',
            'it_easy_status' => 'Status',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
        ];
    }
}
