<?php

namespace backend\models;

use Yii;
use yii\helpers\ArrayHelper;

/**
 * This is the model class for table "it_easy_diseases_name".
 *
 * @property int $it_easy_id
 * @property string $it_easy_name
 * @property string $it_easy_status
 * @property string|null $it_easy_created_time
 * @property string|null $it_easy_updated_time
 * @property int|null $it_easy_created_by
 * @property int|null $it_easy_updated_by
 */
class ItEasyDiseasesName extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_diseases_name';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_name'], 'required'],
            [['it_easy_status'], 'string'],
            [['it_easy_created_time', 'it_easy_updated_time'], 'safe'],
            [['it_easy_created_by', 'it_easy_updated_by'], 'integer'],
            [['it_easy_name'], 'string', 'max' => 80],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'It Easy ID',
            'it_easy_name' => 'Disease Name',
            'it_easy_status' => 'Status',
            'it_easy_created_time' => 'Created Time',
            'it_easy_updated_time' => 'Updated Time',
            'it_easy_created_by' => 'It Easy Created By',
            'it_easy_updated_by' => 'It Easy Updated By',
        ];
    }

    public static function ArrayHelperDiseaseName(){
        
        $return = ItEasyDiseasesName::find()->select(['it_easy_id', 'it_easy_name'])->where(['it_easy_status' => 'Active'])->all();
        $return_data = ArrayHelper::map($return, 'it_easy_id', 'it_easy_name' );
    
        return $return_data;
    }
}
