<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyDiseasesName;

/**
 * ItEasyDiseasesNameSearch represents the model behind the search form of `backend\models\ItEasyDiseasesName`.
 */
class ItEasyDiseasesNameSearch extends ItEasyDiseasesName
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_id', 'it_easy_created_by', 'it_easy_updated_by'], 'integer'],
            [['it_easy_name', 'it_easy_status', 'it_easy_created_time', 'it_easy_updated_time'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyDiseasesName::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_id' => $this->it_easy_id,
            'it_easy_created_time' => $this->it_easy_created_time,
            'it_easy_updated_time' => $this->it_easy_updated_time,
            'it_easy_created_by' => $this->it_easy_created_by,
            'it_easy_updated_by' => $this->it_easy_updated_by,
        ]);

        $query->andFilterWhere(['like', 'it_easy_name', $this->it_easy_name])
            ->andFilterWhere(['like', 'it_easy_status', $this->it_easy_status]);

        return $dataProvider;
    }
}
