<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_ecom_pincodes".
 *
 * @property int $it_easy_id
 * @property string|null $it_easy_area
 * @property string|null $it_easy_state
 * @property string|null $it_easy_route
 * @property string|null $it_easy_state_code
 * @property string $it_easy_pincode
 * @property int|null $it_easy_cod
 * @property int|null $it_easy_prepaid
 * @property string|null $it_easy_metro_city
 * @property string|null $it_easy_delivery_estimate
 * @property string|null $it_easy_city_code
 * @property string|null $it_easy_city_type
 * @property string|null $it_easy_dccode
 * @property int|null $it_easy_status
 * @property int|null $active
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property string|null $created_time
 * @property string|null $updated_time
 */
class ItEasyEcomPincodes extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_ecom_pincodes';
    }

    /**
     * {@inheritdoc}
     */
    public $file;
    public function rules()
    {
        return [
            [['it_easy_pincode'], 'required'],
            [['it_easy_cod', 'it_easy_prepaid', 'it_easy_status', 'active', 'created_by', 'updated_by'], 'integer'],
            [['created_time', 'updated_time','file'], 'safe'],
            [['it_easy_area', 'it_easy_delivery_estimate'], 'string', 'max' => 50],
            [['it_easy_state', 'it_easy_route', 'it_easy_state_code', 'it_easy_pincode', 'it_easy_city_code', 'it_easy_city_type', 'it_easy_dccode'], 'string', 'max' => 255],
            [['it_easy_metro_city'], 'string', 'max' => 40],
           [['file'], 'file', 'extensions' => 'csv', 'checkExtensionByMimeType'=>false, 'skipOnEmpty' => false]
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'Ecom ID',
            'it_easy_area' => 'Ecom Area',
            'it_easy_state' => 'Ecom State',
            'it_easy_route' => 'Ecom Route',
            'it_easy_state_code' => 'Ecom State Code',
            'it_easy_pincode' => 'Ecom Pincode',
            'it_easy_cod' => 'Ecom Cod',
            'it_easy_prepaid' => 'Ecom Prepaid',
            'it_easy_metro_city' => 'Ecom Metro City',
            'it_easy_delivery_estimate' => 'Ecom Delivery Estimate',
            'it_easy_city_code' => 'Ecom City Code',
            'it_easy_city_type' => 'Ecom City Type',
            'it_easy_dccode' => 'Ecom Dccode',
            'it_easy_status' => 'Ecom Status',
            'active' => 'Active',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
        ];
    }
}
