<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyEcomPincodes;

/**
 * ItEasyEcomPincodesSearch represents the model behind the search form of `backend\models\ItEasyEcomPincodes`.
 */
class ItEasyEcomPincodesSearch extends ItEasyEcomPincodes
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_id', 'it_easy_cod', 'it_easy_prepaid', 'it_easy_status', 'active', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_area', 'it_easy_state', 'it_easy_route', 'it_easy_state_code', 'it_easy_pincode', 'it_easy_metro_city', 'it_easy_delivery_estimate', 'it_easy_city_code', 'it_easy_city_type', 'it_easy_dccode', 'created_time', 'updated_time'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyEcomPincodes::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
            'pageSize' => 100,
        ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_id' => $this->it_easy_id,
            'it_easy_cod' => $this->it_easy_cod,
            'it_easy_prepaid' => $this->it_easy_prepaid,
            'it_easy_status' => $this->it_easy_status,
            'active' => $this->active,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
            'created_time' => $this->created_time,
            'updated_time' => $this->updated_time,
        ]);

        $query->andFilterWhere(['like', 'it_easy_area', $this->it_easy_area])
            ->andFilterWhere(['like', 'it_easy_state', $this->it_easy_state])
            ->andFilterWhere(['like', 'it_easy_route', $this->it_easy_route])
            ->andFilterWhere(['like', 'it_easy_state_code', $this->it_easy_state_code])
            ->andFilterWhere(['like', 'it_easy_pincode', $this->it_easy_pincode])
            ->andFilterWhere(['like', 'it_easy_metro_city', $this->it_easy_metro_city])
            ->andFilterWhere(['like', 'it_easy_delivery_estimate', $this->it_easy_delivery_estimate])
            ->andFilterWhere(['like', 'it_easy_city_code', $this->it_easy_city_code])
            ->andFilterWhere(['like', 'it_easy_city_type', $this->it_easy_city_type])
            ->andFilterWhere(['like', 'it_easy_dccode', $this->it_easy_dccode]);

        return $dataProvider;
    }
}
