<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_financial_year".
 *
 * @property int $it_easy_id
 * @property string $it_easy_date_from
 * @property string $it_easy_date_to
 * @property string $it_easy_financial_year
 */
class ItEasyFinancialYear extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_financial_year';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_date_from', 'it_easy_date_to', 'it_easy_financial_year'], 'required'],
            [['it_easy_date_from', 'it_easy_date_to'], 'safe'],
            [['it_easy_financial_year'], 'string', 'max' => 10],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'It Easy ID',
            'it_easy_date_from' => 'It Easy Date From',
            'it_easy_date_to' => 'It Easy Date To',
            'it_easy_financial_year' => 'It Easy Financial Year',
        ];
    }

    public static function getFinancialyear(){
        $today_date = date('Y-m-d');
        $ge_financial = ItEasyFinancialYear::find()->select(['it_easy_financial_year'])->where(['or',['<=', 'it_easy_date_from', $today_date], ['>=', 'it_easy_date_to', $today_date] ])->asArray()->one();
        return $ge_financial['it_easy_financial_year'];
    }
    
    public static function getFinancialrealyear(){
        $today_date = date('Y-m-d');
        $ge_financial = ItEasyFinancialYear::find()->select(['it_easy_real_financial_year'])->where(['or',['<=', 'it_easy_date_from', $today_date], ['>=', 'it_easy_date_to', $today_date] ])->asArray()->one();
        return $ge_financial['it_easy_real_financial_year'];
    }
}
