<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_marketer".
 *
 * @property int $it_easy_id
 * @property string $it_easy_marketer_name
 * @property string $it_easy_marketer_type
 * @property string $it_easy_marketer_api_url
 * @property string $it_easy_marketer_username
 * @property string $it_easy_marketer_password
 * @property string $it_easy_marketer_api_method
 * @property string $it_easy_marketer_api_type
 * @property string $it_easy_marketer_status
 * @property string|null $created_time
 * @property int|null $created_by
 * @property string|null $updated_time
 * @property int|null $updated_by
 */
class ItEasyMarketer extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_marketer';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_marketer_name', 'it_easy_marketer_type', 'it_easy_marketer_api_url', 'it_easy_marketer_username', 'it_easy_marketer_password', 'it_easy_marketer_api_method', 'it_easy_marketer_api_type', 'it_easy_marketer_status'], 'required'],
            [['it_easy_marketer_status'], 'string'],
            [['created_time', 'updated_time'], 'safe'],
            [['created_by', 'updated_by'], 'integer'],
            [['it_easy_marketer_api_url'], 'url'],
            [['it_easy_marketer_name', 'it_easy_marketer_username'], 'string', 'max' => 60],
            [['it_easy_marketer_type', 'it_easy_marketer_password', 'it_easy_marketer_api_type'], 'string', 'max' => 50],
            [['it_easy_marketer_api_url'], 'string', 'max' => 255],
            [['it_easy_marketer_api_method'], 'string', 'max' => 30],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'ID',
            'it_easy_marketer_name' => 'Name',
            'it_easy_marketer_type' => 'Marketer Type',
            'it_easy_marketer_api_url' => 'Api Url',
            'it_easy_marketer_username' => 'Username',
            'it_easy_marketer_password' => 'Password',
            'it_easy_marketer_api_method' => 'Api Method',
            'it_easy_marketer_api_type' => 'Api Type',
            'it_easy_marketer_status' => 'Status',
            'created_time' => 'Created Time',
            'created_by' => 'Created By',
            'updated_time' => 'Updated Time',
            'updated_by' => 'Updated By',
        ];
    }
}
