<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_marketer_publisher".
 *
 * @property int $it_easy_id
 * @property int $it_easy_marketer_id
 * @property string $it_easy_publisher_name
 * @property string $it_easy_status
 * @property string|null $created_time
 * @property string|null $updated_time
 * @property int|null $created_by
 * @property int|null $updated_by
 */
class ItEasyMarketerPublisher extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_marketer_publisher';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_marketer_id', 'it_easy_publisher_name', 'it_easy_status'], 'required'],
            [['it_easy_marketer_id', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_status'], 'string'],
            [['created_time', 'updated_time'], 'safe'],
            [['it_easy_publisher_name'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'ID',
            'it_easy_marketer_id' => 'Marketer Name',
            'it_easy_publisher_name' => 'Publisher Name',
            'it_easy_status' => 'Status',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
        ];
    }
}
