<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyMarketer;

/**
 * ItEasyMarketerSearch represents the model behind the search form of `backend\models\ItEasyMarketer`.
 */
class ItEasyMarketerSearch extends ItEasyMarketer
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_id', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_marketer_name', 'it_easy_marketer_type', 'it_easy_marketer_api_url', 'it_easy_marketer_username', 'it_easy_marketer_password', 'it_easy_marketer_api_method', 'it_easy_marketer_api_type', 'it_easy_marketer_status', 'created_time', 'updated_time'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyMarketer::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_id' => $this->it_easy_id,
            'created_time' => $this->created_time,
            'created_by' => $this->created_by,
            'updated_time' => $this->updated_time,
            'updated_by' => $this->updated_by,
        ]);

        $query->andFilterWhere(['like', 'it_easy_marketer_name', $this->it_easy_marketer_name])
            ->andFilterWhere(['like', 'it_easy_marketer_type', $this->it_easy_marketer_type])
            ->andFilterWhere(['like', 'it_easy_marketer_api_url', $this->it_easy_marketer_api_url])
            ->andFilterWhere(['like', 'it_easy_marketer_username', $this->it_easy_marketer_username])
            ->andFilterWhere(['like', 'it_easy_marketer_password', $this->it_easy_marketer_password])
            ->andFilterWhere(['like', 'it_easy_marketer_api_method', $this->it_easy_marketer_api_method])
            ->andFilterWhere(['like', 'it_easy_marketer_api_type', $this->it_easy_marketer_api_type])
            ->andFilterWhere(['=', 'it_easy_marketer_status', $this->it_easy_marketer_status]);

        return $dataProvider;
    }
}
