<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyMaterialHistory;

/**
 * ItEasyMaterialHistorySearch represents the model behind the search form of `backend\models\ItEasyMaterialHistory`.
 */
class ItEasyMaterialHistorySearch extends ItEasyMaterialHistory
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_id', 'it_easy_vendor_id', 'it_easy_material_id', 'it_easy_received_by', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_material_quantity', 'it_easy_weight_type', 'it_easy_gst_type', 'it_easy_received_date', 'it_easy_approved_status', 'it_easy_buy_month', 'it_easy_buy_year', 'created_time', 'updated_time'], 'safe'],
            [['it_easy_per_kg', 'it_easy_total_price', 'it_easy_gst_amount'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyMaterialHistory::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_id' => $this->it_easy_id,
            'it_easy_vendor_id' => $this->it_easy_vendor_id,
            'it_easy_material_id' => $this->it_easy_material_id,
            'it_easy_per_kg' => $this->it_easy_per_kg,
            'it_easy_total_price' => $this->it_easy_total_price,
            'it_easy_gst_amount' => $this->it_easy_gst_amount,
            'it_easy_received_date' => $this->it_easy_received_date,
            'it_easy_received_by' => $this->it_easy_received_by,
            'created_time' => $this->created_time,
            'updated_time' => $this->updated_time,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
        ]);

        $query->andFilterWhere(['like', 'it_easy_material_quantity', $this->it_easy_material_quantity])
            ->andFilterWhere(['like', 'it_easy_weight_type', $this->it_easy_weight_type])
            ->andFilterWhere(['like', 'it_easy_gst_type', $this->it_easy_gst_type])
            ->andFilterWhere(['like', 'it_easy_approved_status', $this->it_easy_approved_status])
            ->andFilterWhere(['like', 'it_easy_buy_month', $this->it_easy_buy_month])
            ->andFilterWhere(['like', 'it_easy_buy_year', $this->it_easy_buy_year]);

        return $dataProvider;
    }
}
