<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_material_history".
 *
 * @property int $it_easy_id
 * @property int $it_easy_vendor_id
 * @property int $it_easy_material_id
 * @property string $it_easy_material_quantity
 * @property string $it_easy_weight_type
 * @property float $it_easy_per_kg
 * @property float $it_easy_total_price
 * @property float $it_easy_gst_amount
 * @property string $it_easy_gst_type
 * @property string $it_easy_received_date
 * @property int $it_easy_received_by
 * @property string|null $it_easy_approved_status
 * @property string|null $it_easy_buy_month
 * @property string|null $it_easy_buy_year
 * @property string|null $created_time
 * @property string|null $updated_time
 * @property int|null $created_by
 * @property int|null $updated_by
 */
class ItEasyMaterialHistory extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_material_history';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_vendor_id', 'it_easy_material_id', 'it_easy_material_quantity', 'it_easy_weight_type', 'it_easy_per_kg', 'it_easy_total_price', 'it_easy_gst_amount', 'it_easy_gst_type', 'it_easy_received_date', 'it_easy_received_by'], 'required'],
            [['it_easy_vendor_id', 'it_easy_material_id', 'it_easy_received_by', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_per_kg', 'it_easy_total_price', 'it_easy_gst_amount'], 'number'],
            [['it_easy_received_date', 'created_time', 'updated_time'], 'safe'],
            [['it_easy_material_quantity'], 'string', 'max' => 30],
            [['it_easy_weight_type', 'it_easy_gst_type'], 'string', 'max' => 20],
            [['it_easy_approved_status'], 'string', 'max' => 50],
            [['it_easy_buy_month'], 'string', 'max' => 10],
            [['it_easy_buy_year'], 'string', 'max' => 6],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'ID',
            'it_easy_vendor_id' => 'Vendor Name',
            'it_easy_material_id' => 'Material Name',
            'it_easy_material_quantity' => 'Material Quantity',
            'it_easy_weight_type' => 'Weight Type',
            'it_easy_per_kg' => 'Per Kg',
            'it_easy_total_price' => 'Total Price',
            'it_easy_gst_amount' => 'Gst Amount',
            'it_easy_gst_type' => 'Gst Type',
            'it_easy_received_date' => 'Received Date',
            'it_easy_received_by' => 'Received By',
            'it_easy_approved_status' => 'Approved Status',
            'it_easy_buy_month' => 'Buy Month',
            'it_easy_buy_year' => 'IBuy Year',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
        ];
    }
}
