<?php

namespace backend\models;

use Yii;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyShippingApi;
use backend\models\ItEasyAwbResponce;
use backend\models\ItEasyOrderDispatch;
use backend\models\ItEasyOrder;
use backend\models\ItEasyOrderStatus;



class ItEasyNdr extends ItEasyOrder
{
    public $it_easy_awb_number;
    public $it_easy_courier_name;
    public $assign_type;
    public $it_easy_attempt_count;

    public function rules()
    {
        return [
            [['it_easy_order_id', 'it_easy_store_id', 'it_easy_customer_id', 'it_easy_shipping_state_id', 'it_easy_billing_gst_status', 'it_easy_billing_state_id', 'it_easy_department_id',  'it_easy_ndr_tl', 'it_easy_ndr_agent', 'it_easy_read_status', 'it_easy_address_verify_by', 'it_easy_marketer_id'], 'integer'],
            [['it_easy_financial_year', 'it_easy_order_number', 'it_easy_invoice_number', 'it_easy_store_name', 'it_easy_other_order_id', 'it_easy_firstname', 'it_easy_lastname', 'it_easy_mobile_number', 'it_easy_alternate_number', 'it_easy_email', 'it_easy_address_1', 'it_easy_address_2', 'it_easy_city', 'it_easy_state', 'it_easy_pincode', 'it_easy_fax', 'it_easy_country', 'it_easy_shipping_firstname', 'it_easy_shipping_lastname', 'it_easy_shipping_mobile_number', 'it_easy_shipping_alternate_number', 'it_easy_shipping_email', 'it_easy_shipping_address_1', 'it_easy_shipping_address_2', 'it_easy_shipping_city', 'it_easy_shipping_state', 'it_easy_shipping_pincode', 'it_easy_shipping_country', 'it_easy_billing_company_name', 'it_easy_billing_gst', 'it_easy_billing_firstname', 'it_easy_billing_lastname', 'it_easy_billing_mobile', 'it_easy_billing_alternate_number', 'it_easy_billing_email', 'it_easy_billing_address_1', 'it_easy_billing_address_2', 'it_easy_billing_city', 'it_easy_billing_state', 'it_easy_billing_pincode', 'it_easy_billing_country', 'it_easy_payment_method', 'it_easy_payment_code', 'it_easy_shipping_method', 'it_easy_shipping_code', 'it_easy_order_serviceable', 'it_easy_comment', 'it_easy_first_status', 'it_easy_marketer_publisher', 'it_easy_marketer_click_id', 'it_easy_client_ip', 'it_easy_server_ip', 'it_easy_device', 'it_easy_browser', 'it_easy_previous_url', 'it_easy_page_url', 'it_easy_created_time', 'it_easy_updated_time', 'it_easy_assign_time', 'it_easy_placed_time', 'it_easy_delivered_time', 'date_type_filter', 'date_from_date', 'date_to_date', 'assign_type', 'it_easy_state_id', 'it_easy_assigned_by', 'it_easy_assigned_to', 'it_easy_awb_number', 'it_easy_courier_name','it_easy_order_status_id','it_easy_order_disposition_id','it_easy_ndr_status_id','it_easy_arrange_time','it_easy_ndr_disposition_id', 'it_easy_attempt_count'], 'safe'],
            [['it_easy_total_price', 'it_easy_gst_price'], 'number'],
        ];
    }

    public function ndrdata($params)
    {
        
        $query = ItEasyOrder::find()->joinWith(['orderstatus', 'orderdisposition', 'assignagent', 'assigntl', 'orderdispatch', 'ndrstatus', 'ndrdisposition'])->from(['o' => ItEasyOrder::tablename()])->where(['in','o.it_easy_order_status_id',[3, 4, 5, 6, 9,13,14,15,16, 22,23,26,27,28,29,30,31,45,47]]);
      
      	if(isset($params['export']) && !empty($params['export'])){
            $query->joinWith(['orderstatus', 'orderdisposition', 'assignagent', 'assigntl', 'orderdispatch', 'ndrstatus', 'ndrdisposition'])->select(['o.it_easy_order_id as order_id', 'o.it_easy_order_number as order_number', 'it_easy_awb_number as awb_number', 'od.it_easy_order_type as order_type', 'it_easy_courier_name as courier_name', 'o.it_easy_other_order_id as other_order_id', 'o.it_easy_invoice_number as invoice_number', 'it_easy_total_price as total_price', 'it_easy_gst_price as GST_Price', 'it_easy_first_status as First_Status', 'orsta.it_easy_order_status_name as Status_Name', 'ordis.it_easy_order_disposition_name as Disposition_Name', 'ndsta.it_easy_order_status_name as ndr_Status_Name', 'nddis.it_easy_order_disposition_name as ndr_Disposition_Name', 'it_easy_arrange_time',  'CONCAT(o.it_easy_firstname," ",o.it_easy_firstname) as customer', 'o.it_easy_mobile_number as mobile_number', 'o.it_easy_address_1 as Address_1', 'o.it_easy_address_2 as Address_2', 'o.it_easy_city as City', 'o.it_easy_state as State', 'o.it_easy_pincode as Pincode', 'u2.it_easy_username as TL_username', 'u.it_easy_username as Agent_Username', 'it_easy_marketer_publisher as Marketer_Publisher', 'it_easy_marketer_click_id as Click_ID', 'o.it_easy_created_time as Created_Time', 'o.it_easy_updated_time as Updated_Time', 'o.it_easy_assign_time as Assigned_Time', 'o.it_easy_placed_time as Placed_Time', 'o.it_easy_converted_time as Confirmation_Time', 'o.it_easy_delivered_time as Delivered_Time']);
        }
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['it_easy_updated_time' => SORT_DESC]],
        ]);

        $this->load($params);
        if (!$this->validate()) {
            return $dataProvider;
        }

      $query->andFilterWhere([
            'it_easy_order_id' => $this->it_easy_order_id,
            'it_easy_store_id' => $this->it_easy_store_id,
            'it_easy_customer_id' => $this->it_easy_customer_id,
            'it_easy_state_id' => $this->it_easy_state_id,
            'it_easy_shipping_state_id' => $this->it_easy_shipping_state_id,
            'it_easy_billing_gst_status' => $this->it_easy_billing_gst_status,
            'it_easy_billing_state_id' => $this->it_easy_billing_state_id,
            'it_easy_total_price' => $this->it_easy_total_price,
            'it_easy_gst_price' => $this->it_easy_gst_price,
            'o.it_easy_order_status_id' => $this->it_easy_order_status_id,
            'o.it_easy_order_disposition_id' => $this->it_easy_order_disposition_id,
            'it_easy_ndr_status_id' => $this->it_easy_ndr_status_id,
            'it_easy_department_id' => $this->it_easy_department_id,
            'it_easy_assigned_by' => $this->it_easy_assigned_by,
            'it_easy_assigned_to' => $this->it_easy_assigned_to,
            'it_easy_ndr_tl' => $this->it_easy_ndr_tl,
            'it_easy_read_status' => $this->it_easy_read_status,
            'it_easy_address_verify_by' => $this->it_easy_address_verify_by,
            'it_easy_marketer_id' => $this->it_easy_marketer_id,
            'it_easy_created_time' => $this->it_easy_created_time,
            'it_easy_updated_time' => $this->it_easy_updated_time,
            'it_easy_assign_time' => $this->it_easy_assign_time,
            'o.it_easy_placed_time' => $this->it_easy_placed_time,
            'it_easy_delivered_time' => $this->it_easy_delivered_time,
        ]);
        if(isset($params['ItEasyNdr']['it_easy_ndr_disposition_id']) && !empty($params['ItEasyNdr']['it_easy_ndr_disposition_id']) && $params['ItEasyNdr']['it_easy_ndr_disposition_id'][0] != 'no_disposition'){
          $query->andFilterWhere(['IN','it_easy_ndr_disposition_id' , $this->it_easy_ndr_disposition_id]);
        }else if(isset($params['ItEasyNdr']['it_easy_ndr_disposition_id']) && !empty($params['ItEasyNdr']['it_easy_ndr_disposition_id']) && $params['ItEasyNdr']['it_easy_ndr_disposition_id'][0] == 'no_disposition'){
            $query->andFilterWhere(['IS', 'it_easy_ndr_disposition_id', new \yii\db\Expression('NULL')]);
        }
        
        if(isset($params['ItEasyNdr']['it_easy_courier_name']) && !empty($params['ItEasyNdr']['it_easy_courier_name'])){
          $query->andFilterWhere(['it_easy_shipping_id' => $this->it_easy_courier_name]);
        }
        
        if(isset($params['ItEasyNdr']['it_easy_attempt_count']) && !empty($params['ItEasyNdr']['it_easy_attempt_count'])){
          $query->andFilterWhere(['it_easy_attempt_count' => $this->it_easy_attempt_count]);
        }
        
        if(isset($params['ItEasyNdr']['assign_type']) && !empty($params['ItEasyNdr']['assign_type'])){
                if($params['ItEasyNdr']['assign_type'] == 'Assign'){
                        $query->andWhere(['<>', 'it_easy_ndr_agent', '']);
                }else if($params['ItEasyNdr']['assign_type'] == 'Unassign'){
                    $query->andWhere(['or', ['it_easy_ndr_agent'=>'0'], ['it_easy_ndr_agent' => NULL] ]);
                }
        }
        if(isset($params['ItEasyNdr']['it_easy_order_number']) && !empty($params['ItEasyNdr']['it_easy_order_number'])){
          $query->andFilterWhere(['o.it_easy_order_number' => $this->it_easy_order_number]);
        }else if(isset($params['ItEasyNdr']['it_easy_mobile_number']) && !empty($params['ItEasyNdr']['it_easy_mobile_number'])){
          $query->andFilterWhere(['it_easy_mobile_number' => $this->it_easy_mobile_number]);
        }else if(isset($params['ItEasyNdr']['it_easy_awb_number']) && !empty($params['ItEasyNdr']['it_easy_awb_number'])){
          $query->andFilterWhere(['it_easy_awb_number' => $this->it_easy_awb_number]);
        }else if(isset($params['ItEasyNdr']['date_from_date']) && !empty($params['ItEasyNdr']['date_from_date'])){
            
                $params['ItEasyNdr']['date_to_date'] = $params['ItEasyNdr']['date_to_date'].' 23:59:59';

                if(empty($params['ItEasyNdr']['date_to_date'])){
                    $params['ItEasyNdr']['date_to_date'] = date('Y-m-d');
                }
            
                if($params['ItEasyNdr']['date_type_filter'] == 'Date Added'){
                        $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyNdr']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyNdr']['date_from_date']]);
                }else if($params['ItEasyNdr']['date_type_filter'] == 'Date Modified'){
                        $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyNdr']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyNdr']['date_from_date']]);
                }else if($params['ItEasyNdr']['date_type_filter'] == 'Date Assigned'){
                        $query->andWhere(['<=', 'it_easy_assign_time', $params['ItEasyNdr']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_assign_time', $params['ItEasyNdr']['date_from_date']]);
                }else if($params['ItEasyNdr']['date_type_filter'] == 'Date Converted'){
                        $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyNdr']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyNdr']['date_from_date']]);
                }else if($params['ItEasyNdr']['date_type_filter'] == 'Date Dispatched'){
                        $query->andWhere(['<=', 'od.it_easy_placed_time', $params['ItEasyNdr']['date_to_date']])
                             ->andWhere(['>=', 'od.it_easy_placed_time', $params['ItEasyNdr']['date_from_date']]);
                }else if($params['ItEasyNdr']['date_type_filter'] == 'Date Delivered'){
                        $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyNdr']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyNdr']['date_from_date']]);
                }else{
                     $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyNdr']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyNdr']['date_from_date']]);
                }
        }

        if(empty($params)){
            
                $f_dddate = date('Y-m-d', strtotime('-1 day')).' 00:00:00';
              $query->andWhere(['>=', 'it_easy_updated_time', $f_dddate])
                             ->andWhere(['<=', 'it_easy_updated_time', date('Y-m-d').' 23:59:59']);
        }

        $query->andFilterWhere(['like', 'it_easy_financial_year', $this->it_easy_financial_year])
            ->andFilterWhere(['like', 'o.it_easy_order_number', $this->it_easy_order_number])
            ->andFilterWhere(['like', 'it_easy_invoice_number', $this->it_easy_invoice_number])
            ->andFilterWhere(['like', 'it_easy_store_name', $this->it_easy_store_name])
            ->andFilterWhere(['like', 'it_easy_other_order_id', $this->it_easy_other_order_id])
            ->andFilterWhere(['like', 'it_easy_firstname', $this->it_easy_firstname])
            ->andFilterWhere(['like', 'it_easy_lastname', $this->it_easy_lastname])
            ->andFilterWhere(['like', 'it_easy_mobile_number', $this->it_easy_mobile_number])
            ->andFilterWhere(['like', 'it_easy_alternate_number', $this->it_easy_alternate_number])
            ->andFilterWhere(['like', 'it_easy_email', $this->it_easy_email])
            ->andFilterWhere(['like', 'it_easy_address_1', $this->it_easy_address_1])
            ->andFilterWhere(['like', 'it_easy_address_2', $this->it_easy_address_2])
            ->andFilterWhere(['like', 'it_easy_city', $this->it_easy_city])
            ->andFilterWhere(['like', 'it_easy_state', $this->it_easy_state])
            ->andFilterWhere(['like', 'it_easy_pincode', $this->it_easy_pincode])
            ->andFilterWhere(['like', 'it_easy_fax', $this->it_easy_fax])
            ->andFilterWhere(['like', 'it_easy_country', $this->it_easy_country])
            ->andFilterWhere(['like', 'it_easy_shipping_firstname', $this->it_easy_shipping_firstname])
            ->andFilterWhere(['like', 'it_easy_shipping_lastname', $this->it_easy_shipping_lastname])
            ->andFilterWhere(['like', 'it_easy_shipping_mobile_number', $this->it_easy_shipping_mobile_number])
            ->andFilterWhere(['like', 'it_easy_shipping_alternate_number', $this->it_easy_shipping_alternate_number])
            ->andFilterWhere(['like', 'it_easy_shipping_email', $this->it_easy_shipping_email])
            ->andFilterWhere(['like', 'it_easy_shipping_address_1', $this->it_easy_shipping_address_1])
            ->andFilterWhere(['like', 'it_easy_shipping_address_2', $this->it_easy_shipping_address_2])
            ->andFilterWhere(['like', 'it_easy_shipping_city', $this->it_easy_shipping_city])
            ->andFilterWhere(['like', 'it_easy_shipping_state', $this->it_easy_shipping_state])
            ->andFilterWhere(['like', 'it_easy_shipping_pincode', $this->it_easy_shipping_pincode])
            ->andFilterWhere(['like', 'it_easy_shipping_country', $this->it_easy_shipping_country])
            ->andFilterWhere(['like', 'it_easy_billing_company_name', $this->it_easy_billing_company_name])
            ->andFilterWhere(['like', 'it_easy_billing_gst', $this->it_easy_billing_gst])
            ->andFilterWhere(['like', 'it_easy_billing_firstname', $this->it_easy_billing_firstname])
            ->andFilterWhere(['like', 'it_easy_billing_lastname', $this->it_easy_billing_lastname])
            ->andFilterWhere(['like', 'it_easy_billing_mobile', $this->it_easy_billing_mobile])
            ->andFilterWhere(['like', 'it_easy_billing_alternate_number', $this->it_easy_billing_alternate_number])
            ->andFilterWhere(['like', 'it_easy_billing_email', $this->it_easy_billing_email])
            ->andFilterWhere(['like', 'it_easy_billing_address_1', $this->it_easy_billing_address_1])
            ->andFilterWhere(['like', 'it_easy_billing_address_2', $this->it_easy_billing_address_2])
            ->andFilterWhere(['like', 'it_easy_billing_city', $this->it_easy_billing_city])
            ->andFilterWhere(['like', 'it_easy_billing_state', $this->it_easy_billing_state])
            ->andFilterWhere(['like', 'it_easy_billing_pincode', $this->it_easy_billing_pincode])
            ->andFilterWhere(['like', 'it_easy_billing_country', $this->it_easy_billing_country])
            ->andFilterWhere(['like', 'it_easy_payment_method', $this->it_easy_payment_method])
            ->andFilterWhere(['like', 'it_easy_payment_code', $this->it_easy_payment_code])
            ->andFilterWhere(['like', 'it_easy_shipping_method', $this->it_easy_shipping_method])
            ->andFilterWhere(['like', 'it_easy_shipping_code', $this->it_easy_shipping_code])
            ->andFilterWhere(['like', 'it_easy_order_serviceable', $this->it_easy_order_serviceable])
            ->andFilterWhere(['like', 'it_easy_comment', $this->it_easy_comment])
            ->andFilterWhere(['like', 'it_easy_first_status', $this->it_easy_first_status]);
            
            if(Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5'){
                $query->andWhere([ 'it_easy_ndr_agent' => Yii::$app->user->identity->id]);
            }
            
            if(Yii::$app->user->identity->id == '1'){
                //  echo "<pre>"; print_r($params);
                // echo $query->createCommand()->getRawSql(); die;
                
                // 
                //  die;
            }
            // echo "<pre>"; print_r($params);
            // echo $query->createCommand()->getRawSql(); die;
        
      	if(isset($params['export']) && !empty($params['export'])){
            return $query;
        }else{    
            return $dataProvider;
        }
    }
    
    public function ndrdataunidelivered($params)
    {
        
        $query = ItEasyOrder::find()->select(['o.*', 'od.it_easy_attempt_count'])->joinWith(['orderstatus', 'orderdisposition', 'assignagent', 'assigntl', 'orderdispatch', 'ndrstatus', 'ndrdisposition'])->from(['o' => ItEasyOrder::tablename()])->where(['in','o.it_easy_order_status_id',[9]]);
      
      	if(isset($params['export']) && !empty($params['export'])){
            $query->joinWith(['orderstatus', 'orderdisposition', 'assignagent', 'assigntl', 'orderdispatch', 'ndrstatus', 'ndrdisposition'])->select(['o.it_easy_platform as platform_name','o.it_easy_order_id as order_id', 'o.it_easy_order_number as order_number', 'it_easy_awb_number as awb_number', 'od.it_easy_order_type as order_type', 'it_easy_courier_name as courier_name', 'it_easy_courier_name as courier_name',  'it_easy_subcourier_name as sub_courier_name', 'o.it_easy_other_order_id as other_order_id', 'it_easy_payment_method as payment_method', 'od.it_easy_awb_time as awb_time', 'od.it_easy_pickup_time as pickup_time', 'od.it_easy_placed_time as assign_time', 'o.it_easy_invoice_number as invoice_number', 'it_easy_total_price as total_price','it_easy_collective_price as collective_price',  'it_easy_gst_price as GST_Price', 'it_easy_first_status as First_Status', 'orsta.it_easy_order_status_name as Status_Name', 'ordis.it_easy_order_disposition_name as Disposition_Name', 'ndsta.it_easy_order_status_name as ndr_Status_Name', 'nddis.it_easy_order_disposition_name as ndr_Disposition_Name', 'it_easy_arrange_time',  'CONCAT(o.it_easy_firstname," ",o.it_easy_firstname) as customer', 'o.it_easy_mobile_number as mobile_number', 'o.it_easy_address_1 as Address_1', 'o.it_easy_address_2 as Address_2', 'o.it_easy_city as City', 'o.it_easy_state as State', 'o.it_easy_pincode as Pincode', 'u2.it_easy_username as TL_username', 'u.it_easy_username as Agent_Username', 'it_easy_marketer_publisher as Marketer_Publisher', 'it_easy_marketer_click_id as Click_ID', 'o.it_easy_created_time as Created_Time', 'o.it_easy_updated_time as Updated_Time', 'o.it_easy_assign_time as Assigned_Time', 'o.it_easy_placed_time as Placed_Time', 'o.it_easy_converted_time as Confirmation_Time', 'o.it_easy_delivered_time as Delivered_Time', 'od.it_easy_first_scan_date as first_attempt_date', 'od.first_ndr_reason as first_ndr_reason', 'od.second_attempt_date as second_attempt_date', 'od.second_ndr_reason as second_ndr_reason', 'od.third_attempt_date as third_attempt_date', 'od.third_ndr_reason as third_ndr_reason', 'od.it_easy_last_scan_date as last_scan_date', 'od.last_ndr_reason as last_ndr_reason', 'od.it_easy_courier_comment as SCAN_REASON', 'od.it_easy_attempt_count as attempt_count' , 'od.rto_initiate_date as rto_initiate_date', 'od.it_easy_auto_rto_date as rto_date' ]);
        }
        
        if(isset(Yii::$app->user->identity->it_easy_platform)){
            $platform = explode(',', Yii::$app->user->identity->it_easy_platform);
            $query->andWhere(['IN', 'o.it_easy_platform', $platform]);
        }
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['it_easy_updated_time' => SORT_DESC]],
        ]);

        $this->load($params);
        if (!$this->validate()) {
            return $dataProvider;
        }

      $query->andFilterWhere([
            'it_easy_order_id' => $this->it_easy_order_id,
            'it_easy_store_id' => $this->it_easy_store_id,
            'it_easy_customer_id' => $this->it_easy_customer_id,
            'it_easy_state_id' => $this->it_easy_state_id,
            'it_easy_shipping_state_id' => $this->it_easy_shipping_state_id,
            'it_easy_billing_gst_status' => $this->it_easy_billing_gst_status,
            'it_easy_billing_state_id' => $this->it_easy_billing_state_id,
            'it_easy_total_price' => $this->it_easy_total_price,
            'it_easy_gst_price' => $this->it_easy_gst_price,
            'o.it_easy_order_disposition_id' => $this->it_easy_order_disposition_id,
            'it_easy_ndr_status_id' => $this->it_easy_ndr_status_id,
            'it_easy_department_id' => $this->it_easy_department_id,
            'it_easy_assigned_by' => $this->it_easy_assigned_by,
            'it_easy_assigned_to' => $this->it_easy_assigned_to,
            'it_easy_ndr_tl' => $this->it_easy_ndr_tl,
            'it_easy_read_status' => $this->it_easy_read_status,
            'it_easy_address_verify_by' => $this->it_easy_address_verify_by,
            'it_easy_marketer_id' => $this->it_easy_marketer_id,
            'it_easy_created_time' => $this->it_easy_created_time,
            'it_easy_updated_time' => $this->it_easy_updated_time,
            'it_easy_assign_time' => $this->it_easy_assign_time,
            'o.it_easy_placed_time' => $this->it_easy_placed_time,
            'it_easy_delivered_time' => $this->it_easy_delivered_time,
        ]);
        if(isset($params['ItEasyNdr']['it_easy_ndr_disposition_id']) && !empty($params['ItEasyNdr']['it_easy_ndr_disposition_id']) && $params['ItEasyNdr']['it_easy_ndr_disposition_id'][0] != 'no_disposition'){
          $query->andFilterWhere(['IN','it_easy_ndr_disposition_id' , $this->it_easy_ndr_disposition_id]);
        }else if(isset($params['ItEasyNdr']['it_easy_ndr_disposition_id']) && !empty($params['ItEasyNdr']['it_easy_ndr_disposition_id']) && $params['ItEasyNdr']['it_easy_ndr_disposition_id'][0] == 'no_disposition'){
            $query->andFilterWhere(['IS', 'it_easy_ndr_disposition_id', new \yii\db\Expression('NULL')]);
        }
        
        if(isset($params['ItEasyNdr']['it_easy_courier_name']) && !empty($params['ItEasyNdr']['it_easy_courier_name'])){
          $query->andFilterWhere(['it_easy_shipping_id' => $this->it_easy_courier_name]);
        }
        
        if(isset($params['ItEasyNdr']['it_easy_attempt_count']) && !empty($params['ItEasyNdr']['it_easy_attempt_count'])){
          $query->andFilterWhere(['it_easy_attempt_count' => $this->it_easy_attempt_count]);
        }
        
        if(isset($params['ItEasyNdr']['assign_type']) && !empty($params['ItEasyNdr']['assign_type'])){
                if($params['ItEasyNdr']['assign_type'] == 'Assign'){
                        $query->andWhere(['<>', 'it_easy_ndr_agent', '']);
                }else if($params['ItEasyNdr']['assign_type'] == 'Unassign'){
                    $query->andWhere(['or', ['it_easy_ndr_agent'=>'0'], ['it_easy_ndr_agent' => NULL] ]);
                }
        }
        if(isset($params['ItEasyNdr']['it_easy_order_number']) && !empty($params['ItEasyNdr']['it_easy_order_number'])){
          $query->andFilterWhere(['o.it_easy_order_number' => $this->it_easy_order_number]);
        }else if(isset($params['ItEasyNdr']['it_easy_mobile_number']) && !empty($params['ItEasyNdr']['it_easy_mobile_number'])){
          $query->andFilterWhere(['it_easy_mobile_number' => $this->it_easy_mobile_number]);
        }else if(isset($params['ItEasyNdr']['it_easy_awb_number']) && !empty($params['ItEasyNdr']['it_easy_awb_number'])){
          $query->andFilterWhere(['it_easy_awb_number' => $this->it_easy_awb_number]);
        }else if(isset($params['ItEasyNdr']['date_from_date']) && !empty($params['ItEasyNdr']['date_from_date'])){
            
                $params['ItEasyNdr']['date_to_date'] = $params['ItEasyNdr']['date_to_date'].' 23:59:59';

                if(empty($params['ItEasyNdr']['date_to_date'])){
                    $params['ItEasyNdr']['date_to_date'] = date('Y-m-d');
                }
            
                if($params['ItEasyNdr']['date_type_filter'] == 'Date Added'){
                        $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyNdr']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyNdr']['date_from_date']]);
                }else if($params['ItEasyNdr']['date_type_filter'] == 'Date Modified'){
                        $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyNdr']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyNdr']['date_from_date']]);
                }else if($params['ItEasyNdr']['date_type_filter'] == 'Date Assigned'){
                        $query->andWhere(['<=', 'it_easy_assign_time', $params['ItEasyNdr']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_assign_time', $params['ItEasyNdr']['date_from_date']]);
                }else if($params['ItEasyNdr']['date_type_filter'] == 'Date Converted'){
                        $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyNdr']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyNdr']['date_from_date']]);
                }else if($params['ItEasyNdr']['date_type_filter'] == 'Date Dispatched'){
                        $query->andWhere(['<=', 'od.it_easy_placed_time', $params['ItEasyNdr']['date_to_date']])
                             ->andWhere(['>=', 'od.it_easy_placed_time', $params['ItEasyNdr']['date_from_date']]);
                }else if($params['ItEasyNdr']['date_type_filter'] == 'Date Delivered'){
                        $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyNdr']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyNdr']['date_from_date']]);
                }else{
                     $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyNdr']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyNdr']['date_from_date']]);
                }
        }

        if(empty($params)){
            
                $f_dddate = date('Y-m-d', strtotime('-1 day')).' 00:00:00';
              $query->andWhere(['>=', 'it_easy_updated_time', $f_dddate])
                             ->andWhere(['<=', 'it_easy_updated_time', date('Y-m-d').' 23:59:59']);
        }

        $query->andFilterWhere(['like', 'it_easy_financial_year', $this->it_easy_financial_year])
            ->andFilterWhere(['like', 'o.it_easy_order_number', $this->it_easy_order_number])
            ->andFilterWhere(['like', 'it_easy_invoice_number', $this->it_easy_invoice_number])
            ->andFilterWhere(['like', 'it_easy_store_name', $this->it_easy_store_name])
            ->andFilterWhere(['like', 'it_easy_other_order_id', $this->it_easy_other_order_id])
            ->andFilterWhere(['like', 'it_easy_firstname', $this->it_easy_firstname])
            ->andFilterWhere(['like', 'it_easy_lastname', $this->it_easy_lastname])
            ->andFilterWhere(['like', 'it_easy_mobile_number', $this->it_easy_mobile_number])
            ->andFilterWhere(['like', 'it_easy_alternate_number', $this->it_easy_alternate_number])
            ->andFilterWhere(['like', 'it_easy_email', $this->it_easy_email])
            ->andFilterWhere(['like', 'it_easy_address_1', $this->it_easy_address_1])
            ->andFilterWhere(['like', 'it_easy_address_2', $this->it_easy_address_2])
            ->andFilterWhere(['like', 'it_easy_city', $this->it_easy_city])
            ->andFilterWhere(['like', 'it_easy_state', $this->it_easy_state])
            ->andFilterWhere(['like', 'it_easy_pincode', $this->it_easy_pincode])
            ->andFilterWhere(['like', 'it_easy_fax', $this->it_easy_fax])
            ->andFilterWhere(['like', 'it_easy_country', $this->it_easy_country])
            ->andFilterWhere(['like', 'it_easy_shipping_firstname', $this->it_easy_shipping_firstname])
            ->andFilterWhere(['like', 'it_easy_shipping_lastname', $this->it_easy_shipping_lastname])
            ->andFilterWhere(['like', 'it_easy_shipping_mobile_number', $this->it_easy_shipping_mobile_number])
            ->andFilterWhere(['like', 'it_easy_shipping_alternate_number', $this->it_easy_shipping_alternate_number])
            ->andFilterWhere(['like', 'it_easy_shipping_email', $this->it_easy_shipping_email])
            ->andFilterWhere(['like', 'it_easy_shipping_address_1', $this->it_easy_shipping_address_1])
            ->andFilterWhere(['like', 'it_easy_shipping_address_2', $this->it_easy_shipping_address_2])
            ->andFilterWhere(['like', 'it_easy_shipping_city', $this->it_easy_shipping_city])
            ->andFilterWhere(['like', 'it_easy_shipping_state', $this->it_easy_shipping_state])
            ->andFilterWhere(['like', 'it_easy_shipping_pincode', $this->it_easy_shipping_pincode])
            ->andFilterWhere(['like', 'it_easy_shipping_country', $this->it_easy_shipping_country])
            ->andFilterWhere(['like', 'it_easy_billing_company_name', $this->it_easy_billing_company_name])
            ->andFilterWhere(['like', 'it_easy_billing_gst', $this->it_easy_billing_gst])
            ->andFilterWhere(['like', 'it_easy_billing_firstname', $this->it_easy_billing_firstname])
            ->andFilterWhere(['like', 'it_easy_billing_lastname', $this->it_easy_billing_lastname])
            ->andFilterWhere(['like', 'it_easy_billing_mobile', $this->it_easy_billing_mobile])
            ->andFilterWhere(['like', 'it_easy_billing_alternate_number', $this->it_easy_billing_alternate_number])
            ->andFilterWhere(['like', 'it_easy_billing_email', $this->it_easy_billing_email])
            ->andFilterWhere(['like', 'it_easy_billing_address_1', $this->it_easy_billing_address_1])
            ->andFilterWhere(['like', 'it_easy_billing_address_2', $this->it_easy_billing_address_2])
            ->andFilterWhere(['like', 'it_easy_billing_city', $this->it_easy_billing_city])
            ->andFilterWhere(['like', 'it_easy_billing_state', $this->it_easy_billing_state])
            ->andFilterWhere(['like', 'it_easy_billing_pincode', $this->it_easy_billing_pincode])
            ->andFilterWhere(['like', 'it_easy_billing_country', $this->it_easy_billing_country])
            ->andFilterWhere(['like', 'it_easy_payment_method', $this->it_easy_payment_method])
            ->andFilterWhere(['like', 'it_easy_payment_code', $this->it_easy_payment_code])
            ->andFilterWhere(['like', 'it_easy_shipping_method', $this->it_easy_shipping_method])
            ->andFilterWhere(['like', 'it_easy_shipping_code', $this->it_easy_shipping_code])
            ->andFilterWhere(['like', 'it_easy_order_serviceable', $this->it_easy_order_serviceable])
            ->andFilterWhere(['like', 'it_easy_comment', $this->it_easy_comment])
            ->andFilterWhere(['like', 'it_easy_first_status', $this->it_easy_first_status]);
            
            if(Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5'){
                $query->andWhere([ 'it_easy_ndr_agent' => Yii::$app->user->identity->id]);
            }
            
            if(Yii::$app->user->identity->id == '1'){
                //  echo "<pre>"; print_r($params);
                // echo $query->createCommand()->getRawSql(); die;
                
                // 
                //  die;
            }
            // echo "<pre>"; print_r($params);
            //echo $query->createCommand()->getRawSql(); die;
        
      	if(isset($params['export']) && !empty($params['export'])){
            return $query;
        }else{    
            return $dataProvider;
        }
    }

}
