<?php

namespace backend\models;

use Yii;
use backend\models\ItEasyFinancialYear;
use backend\models\ItEasyEcomPincodes;
use backend\models\ItEasyDelhiveryPincodes;
use backend\models\ItEasyShipdelightPincodes;
use backend\models\ItEasyProductVariation;
use backend\models\ItEasyXpressbeesPincodes;
use backend\models\ItEasySmartshipPincodes;
use backend\models\ItEasyProduct;
use backend\models\ItEasyCouponHistory;
use backend\models\ItEasyOrderHistory;
use backend\models\ItEasyOrderDisposition;
use backend\models\ItEasyOrderStatus;
use backend\models\ItEasyShippingApi;
use backend\models\ItEasyOrderNdrStatusHistory;
use backend\models\ItEasyOrderNdrdispositionHistory;
use backend\models\ItEasyOrderDispatch;
use common\models\User;
use yii\helpers\ArrayHelper;
use yii\data\ArrayDataProvider;
use backend\models\ItEasyOrderProduct;
use backend\models\ItEasyShippingPaymentMethod;
use backend\models\ItEasyUserConnectedStatus;
use backend\models\ItEasyIthinkPincodes;
use backend\models\ItEasySmartrPincodes;
use backend\models\ItEasyBluedartPincodes;
use backend\models\ItEasyClickpostCourier;
use backend\models\ItEasyDepartment;
use backend\models\ItEasyRapidsypPincodes;
use backend\models\ItEasyProfessionalPincodes;
use backend\models\ItEasyPickndelPincodes;
use backend\models\ItEasyBlitzPincodes;
use backend\models\ItEasyDtdcPincodes;
use backend\models\ItEasyEkartPincodes;
use backend\models\ItEasyQuickshiftPincodes;
use backend\models\ItEasyProzoPincodes;
use backend\models\ItEasyUrbanboltPincodes;
use backend\models\ItEasyZippyPincodes;
use backend\models\ItEasyZippyAtsPincodes;
use backend\models\ItEasyZippyDtdcPincodes;
use backend\models\ItEasyZippyEkartPincodes;
use backend\models\ItEasyZippyXbreesPincodes;
use backend\models\OrderInvoices;

class ItEasyOrder extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {   
        $today_date = date('Y-m-d');
        // $ge_financial = ItEasyFinancialYear::find()->select(['it_easy_financial_year'])->where(['or',['<=', 'it_easy_date_from', $today_date], ['>=', 'it_easy_date_to', $today_date] ])->asArray()->one();
        $actionId = Yii::$app->controller->action->id;
        if($actionId == 'unidelivered-orders'){
            // echo ItEasyFinancialYear::find()->select(['it_easy_financial_year'])->where(['or',['<=', 'it_easy_date_from', $today_date], ['>=', 'it_easy_date_to', $today_date] ])->createCommand()->getRawSql(); die;
            // echo "<pre>"; print_r($ge_financial); die;
        }
        
        return 'it_easy_order_2023_2024';
    }

    /**
     * {@inheritdoc}
     */
    public $file;
	public $it_easy_ship_id;
    public $it_easy_order_status_comment;
    public $it_easy_order_disposition_comment;
    public $date_type_filter;
    public $date_from_date;
    public $date_to_date;
    public $assign_type;
    public $it_easy_attempt_count;
    public $it_easy_new_invoice_number;
    //

    public function rules()
    {
        return [
            [[ 'it_easy_store_id', 'it_easy_firstname', 'it_easy_mobile_number', 'it_easy_address_1', 'it_easy_city', 'it_easy_state', 'it_easy_state_id', 'it_easy_pincode', 'it_easy_shipping_firstname', 'it_easy_shipping_mobile_number', 'it_easy_shipping_address_1', 'it_easy_shipping_city', 'it_easy_shipping_state', 'it_easy_shipping_state_id', 'it_easy_shipping_pincode', 'it_easy_billing_firstname', 'it_easy_billing_lastname', 'it_easy_billing_mobile', 'it_easy_billing_address_1', 'it_easy_billing_city', 'it_easy_billing_state', 'it_easy_billing_state_id', 'it_easy_billing_pincode', 'it_easy_payment_method', 'it_easy_payment_code', 'it_easy_shipping_method', 'it_easy_shipping_code', 'it_easy_order_status_id', 'it_easy_first_status', 'it_easy_order_disposition_id', 'it_easy_department_id','it_easy_disease_name','it_easy_course_duration'], 'required'],
            [['it_easy_store_id', 'it_easy_state_id', 'it_easy_shipping_state_id', 'it_easy_billing_gst_status', 'it_easy_billing_state_id', 'it_easy_order_status_id', 'it_easy_order_disposition_id', 'it_easy_ndr_disposition_id', 'it_easy_ndr_status_id', 'it_easy_department_id', 'it_easy_assigned_by', 'it_easy_assigned_to', 'it_easy_ndr_tl', 'it_easy_ndr_agent', 'it_easy_read_status', 'it_easy_address_verify_by', 'it_easy_marketer_id'], 'integer'],
            [['it_easy_total_price', 'it_easy_gst_price','it_easy_age'], 'number'],
            [['it_easy_first_status', 'it_easy_abondoned_type', 'it_easy_order_place_time'], 'string'],
            [['it_easy_created_time', 'it_easy_updated_time', 'it_easy_assign_time', 'it_easy_placed_time', 'it_easy_delivered_time', 'it_easy_coupon_id', 'it_easy_order_status_comment', 'it_easy_order_disposition_comment','it_easy_disease_name','it_easy_course_duration','it_easy_age', 'it_easy_total_understanding', 'it_easy_partially_paid', 'it_easy_payment_id', 'it_easy_flag', 'address_validator_response'], 'safe'],
            [['it_easy_financial_year'], 'string', 'max' => 40],
            [['it_easy_order_number', 'it_easy_invoice_number', 'it_easy_city', 'it_easy_state', 'it_easy_country', 'it_easy_shipping_city', 'it_easy_shipping_state', 'it_easy_billing_city', 'it_easy_billing_state', 'it_easy_billing_country'], 'string', 'max' => 60],
            [['it_easy_store_name', 'it_easy_email', 'it_easy_shipping_email', 'it_easy_billing_email', 'it_easy_marketer_publisher', 'it_easy_marketer_click_id', 'it_easy_client_ip', 'it_easy_server_ip', 'it_easy_device', 'it_easy_browser'], 'string', 'max' => 100],
            [['it_easy_other_order_id', 'it_easy_fax', 'it_easy_shipping_country', 'it_easy_payment_method', 'it_easy_shipping_method'], 'string', 'max' => 3000],
            [['it_easy_firstname', 'it_easy_lastname', 'it_easy_shipping_firstname', 'it_easy_shipping_lastname', 'it_easy_billing_firstname', 'it_easy_billing_lastname'], 'string', 'max' => 80],
            [['it_easy_mobile_number', 'it_easy_alternate_number', 'it_easy_shipping_mobile_number', 'it_easy_shipping_alternate_number', 'it_easy_billing_mobile', 'it_easy_billing_alternate_number'], 'number', 'max' => 9999999999, 'min' => '5999999999'],
            [['it_easy_address_1', 'it_easy_address_2', 'it_easy_shipping_address_1', 'it_easy_shipping_address_2', 'it_easy_billing_company_name', 'it_easy_billing_address_1', 'it_easy_billing_address_2'], 'string', 'max' => 150],
            [['file'], 'file'],
            [['it_easy_pincode', 'it_easy_shipping_pincode', 'it_easy_billing_pincode'], 'string', 'max' => 6, 'min' => '6'],
            [['it_easy_billing_gst', 'it_easy_payment_code', 'it_easy_shipping_code'], 'string', 'max' => 30],
            [['it_easy_order_serviceable', 'it_easy_comment'], 'string', 'max' => 255],
            [['it_easy_previous_url', 'it_easy_page_url'], 'string', 'max' => 200],
            [['it_easy_platform'], 'safe'],
            [['it_easy_new_invoice_number'], 'safe']
            //
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'date_from_date' => 'From Date',
            'date_to_date' => 'To Date',
            'it_easy_order_id' => 'Order ID',
            'it_easy_financial_year' => 'Financial Year',
            'it_easy_order_number' => 'Order Number',
            'it_easy_store_id' => 'Store Name',
            'it_easy_invoice_number' => 'Invoice Number',
            'it_easy_store_name' => 'Store Name',
            'it_easy_other_order_id' => 'Other Order ID',
            'it_easy_customer_id' => 'Customer Name',
            'it_easy_firstname' => 'Customer Firstname',
            'it_easy_lastname' => 'Customer Lastname',
            'it_easy_mobile_number' => 'Mobile Number',
            'it_easy_alternate_number' => 'Alternate Number',
            'it_easy_email' => 'Customer Email',
            'it_easy_address_1' => 'Address 1',
            'it_easy_address_2' => 'Address 2',
            'it_easy_city' => 'City',
            'it_easy_state' => 'State',
            'it_easy_state_id' => 'State Name',
            'it_easy_pincode' => 'Pincode',
            'it_easy_fax' => 'Fax',
            'it_easy_flag' => 'Flag',
            'it_easy_country' => 'Country',
          	'it_easy_disease_name'=> 'Disease Name',
          	'it_easy_course_duration' => 'Course Duration',
            'it_easy_age'=>'Age',
            'it_easy_shipping_firstname' => 'Shipping Firstname',
            'it_easy_shipping_lastname' => 'Shipping Lastname',
            'it_easy_shipping_mobile_number' => 'Shipping Mobile Number',
            'it_easy_shipping_alternate_number' => 'Shipping Alternate Number',
            'it_easy_shipping_email' => 'Shipping Email',
            'it_easy_shipping_address_1' => 'Shipping Address 1',
            'it_easy_shipping_address_2' => 'Shipping Address 2',
            'it_easy_shipping_city' => 'Shipping City',
            'it_easy_shipping_state' => 'Shipping State',
            'it_easy_shipping_state_id' => 'Shipping State ID',
            'it_easy_shipping_pincode' => 'Shipping Pincode',
            'it_easy_shipping_country' => 'Shipping Country',
            'it_easy_billing_company_name' => 'Billing  Company Name',
            'it_easy_billing_gst_status' => 'Billing  Gst Status',
            'it_easy_billing_gst' => 'Billing  Gst',
            'it_easy_billing_firstname' => 'Billing  Firstname',
            'it_easy_billing_lastname' => 'Billing  Lastname',
            'it_easy_billing_mobile' => 'Billing  Mobile',
            'it_easy_billing_alternate_number' => 'Billing  Alternate Number',
            'it_easy_billing_email' => 'Billing  Email',
            'it_easy_billing_address_1' => 'Billing  Address 1',
            'it_easy_billing_address_2' => 'Billing  Address 2',
            'it_easy_billing_city' => 'Billing  City',
            'it_easy_billing_state' => 'Billing  State',
            'it_easy_billing_state_id' => 'Billing  State ID',
            'it_easy_billing_pincode' => 'Billing  Pincode',
            'it_easy_billing_country' => 'Billing  Country',
            'it_easy_payment_method' => 'Payment Method',
            'it_easy_payment_code' => 'Payment Code',
            'it_easy_shipping_method' => 'Shipping Method',
            'it_easy_shipping_code' => 'Shipping Code',
            'it_easy_order_serviceable' => 'Serviceable',
            'it_easy_comment' => 'Order Comment',
            'it_easy_total_price' => 'Total Price',
            'it_easy_gst_price' => 'GST Price',
            'it_easy_order_status_id' => 'Order Status Name',
            'it_easy_first_status' => 'First Status',
            'it_easy_order_disposition_id' => 'Order Disposition Name',
            'it_easy_ndr_disposition_id' => 'NDR Disposition Name',
            'it_easy_ndr_status_id' => 'NDR Status ID',
            'it_easy_department_id' => 'Department Name',
            'it_easy_assigned_by' => 'Assigned By',
            'it_easy_assigned_to' => 'Agent Name',
            'it_easy_ndr_tl' => 'NDL TL',
            'it_easy_ndr_agent' => 'Ndr Agent',
            'it_easy_read_status' => 'Read Status',
            'it_easy_address_verify_by' => 'Address Verify By',
            'it_easy_marketer_id' => 'Marketer ID',
            'it_easy_marketer_publisher' => 'Marketer Publisher',
            'it_easy_marketer_click_id' => 'Marketer Click ID',
            'it_easy_client_ip' => 'Client Ip',
            'it_easy_server_ip' => 'Server Ip',
            'it_easy_device' => 'Device',
            'it_easy_browser' => 'Browser',
            'it_easy_previous_url' => 'Previous Url',
            'it_easy_page_url' => 'Page Url',
            'it_easy_created_time' => 'Created Time',
            'it_easy_updated_time' => 'Updated Time',
            'it_easy_assign_time' => 'Assign Time',
            'it_easy_placed_time' => 'Placed Time',
            'it_easy_converted_time' => 'Confirm Time',
            'it_easy_delivered_time' => 'Delivered Time',
            'it_easy_order_status_comment' => 'Order Status Comment',
            'it_easy_order_disposition_comment' => 'Order Disposition Comment',
            'it_easy_coupon_id' => 'Coupon Name',
            
        ];
    }
    
    
    

    public function getOrderstatus()
    {
        return $this->hasOne(ItEasyOrderStatus::className(), ['it_easy_order_status_id' => 'it_easy_order_status_id'])->from(['orsta' => ItEasyOrderStatus::tableName()]);
    }

    public function getOrderdisposition()
    {
        return $this->hasOne(ItEasyOrderDisposition::className(), ['it_easy_order_disposition_id' => 'it_easy_order_disposition_id'])->from(['ordis' => ItEasyOrderDisposition::tableName()]);
    }
  
  	public function getNdrstatus()
    {
        return $this->hasOne(ItEasyOrderStatus::className(), ['it_easy_order_status_id' => 'it_easy_ndr_status_id'])->from(['ndsta' => ItEasyOrderStatus::tableName()]);
    }

    public function getNdrdisposition()
    {
        return $this->hasOne(ItEasyOrderDisposition::className(), ['it_easy_order_disposition_id' => 'it_easy_ndr_disposition_id'])->from(['nddis' => ItEasyOrderDisposition::tableName()]);
    }

    public function getAssigntl()
    {
        return $this->hasOne(User::className(), ['id' => 'it_easy_assigned_by'])->from(['u2' => User::tableName()]);
    }

    public function getAssignagent()
    {
        return $this->hasOne(User::className(), ['id' => 'it_easy_assigned_to'])->from(['u' => User::tableName()]);
    }
    
    public function getRetentionassigntl()
    {
        return $this->hasOne(User::className(), ['id' => 'it_easy_retention_TLid'])->from(['ru' => User::tableName()]);
    }

    public function getRetentionassignagent()
    {
        return $this->hasOne(User::className(), ['id' => 'it_easy_retention_AGENTid'])->from(['ru2' => User::tableName()]);
    }
    
    public function getDepartment()
    {
        return $this->hasOne(ItEasyDepartment::className(), ['it_easy_id' => 'it_easy_department_id'])->from(['de' => ItEasyDepartment::tableName()]);
    }

    public function getOrderproduct()
    {
        return $this->hasOne(ItEasyOrderProduct::className(), ['it_easy_order_id' => 'it_easy_order_id'])->from(['op' => ItEasyOrderProduct::tableName()]);
    }
  
  	public function getOrderdispatch()
    {
        return $this->hasOne(ItEasyOrderDispatch::className(), ['it_easy_order_id' => 'it_easy_order_id'])->from(['od' => ItEasyOrderDispatch::tableName()]);
    }
    
    
    public function getAddressValidator($name, $email, $address, $state, $pincode, $order_id){
        $url = "https://cp-staging2.clickpost.in/api/v1/rto-suite?type=address-validator&username=nutriherbs&key=28ab0068-a66d-4ecf-8b20-ad8b28f1f83f";

        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        
        $headers = array(
           "Content-Type: application/json",
        );
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        
        $data_array = [];
        $data['name'] = $name;
        $data['email'] = !empty($email) ? $email : 'rakesh12@gmail.com';
        $data['address'] = $address;
        $data['state'] = $state;
        $data['pincode'] = $pincode;
        $data['country'] = "IN";
        $data['address_type'] = "RESIDENTIAL";
        $data['order_id'] = $order_id;
        
    
        
        
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
        
        //for debug only!
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        
        $resp = curl_exec($curl);
        curl_close($curl);
        return json_decode($resp);
    }
    
    

    public static function getServicealAPIbyPincode($pincode){
        // echo $pincode; die;
        $pincode = trim($pincode);
        $api_id = [];
        
        $check_pincode_ecom = ItEasyEcomPincodes::findOne(['it_easy_pincode' => $pincode]);
        if(!empty($check_pincode_ecom)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '2'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '2';
                $api_id[] = '6';
            }
        }
        
        $check_pincode_delhivery = ItEasyDelhiveryPincodes::findOne(['it_easy_pincode' => $pincode]);
        if(!empty($check_pincode_delhivery)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '1'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '1';
            }
        }
        
         $check_pincode_delhivery_one = ItEasyDelhiveryOnePincodes::findOne(['it_easy_pincode' => $pincode]);
        if(!empty($check_pincode_delhivery_one)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '22'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '22';
            }
        }
        
        $check_pincode_shipdelight = ItEasyShipdelightPincodes::findOne(['it_easy_pincode' => $pincode]);
        if(!empty($check_pincode_shipdelight)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '4'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '4';
            }
        }
        
        $check_pincode_xpressbees = ItEasyXpressbeesPincodes::findOne(['it_easy_Pincode' => $pincode]);
        if(!empty($check_pincode_xpressbees)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '3'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '3';
            }
        }
        
        $check_pincode_smartship = ItEasySmartshipPincodes::findOne(['it_easy_pincode' => $pincode]);
        if(!empty($check_pincode_smartship)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '7'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '7';
            }
        }
        $check_pincode_smartship = ItEasyBluedartPincodes::findOne(['it_easy_pincode' => $pincode]);
        if(!empty($check_pincode_smartship)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '8'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '8';
            }
        }
        $check_pincode_smartship = ItEasySmartrPincodes::findOne(['it_easy_pincode' => $pincode]);
        if(!empty($check_pincode_smartship)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '9'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '9';
            }
        }
        
        $check_pincode_smartship = ItEasyIthinkPincodes::findOne(['it_easy_pincode' => $pincode]);
        if(!empty($check_pincode_smartship)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '10'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '10';
            }
        }
                  
        $check_pincode_smartship = ItEasyRapidsypPincodes::findOne(['it_easy_pincode' => $pincode]);
        if(!empty($check_pincode_smartship)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '11'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '11';
            }
        }
        
        $check_pincode_smartship = ItEasyShiprocketPincodes::findOne(['it_easy_pincode' => $pincode]);
        if(!empty($check_pincode_smartship)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '12'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '12';
            }
        }
        
        $check_pincode_smartship = ItEasyPickndelPincodes::findOne(['it_easy_pincode' => $pincode]);
        if(!empty($check_pincode_smartship)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '13'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '13';
            }
        }
        
        $check_pincode_smartship = ItEasyProfessionalPincodes::findOne(['it_easy_pincode' => $pincode]);
        if(!empty($check_pincode_smartship)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '14'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '14';
            }
        }
        
        $check_pincode_smartship = ItEasyBlitzPincodes::findOne(['it_easy_pincode' => $pincode]);
        if(!empty($check_pincode_smartship)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '15'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '15';
            }
        }
        
        $check_pincode_smartship = ItEasyBlitzPincodes::findOne(['it_easy_pincode' => $pincode]);
        if(!empty($check_pincode_smartship)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '15'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '15';
            }
        }
        
        $check_pincode_smartship = ItEasyDtdcPincodes::findOne(['it_easy_pincode' => $pincode]);
        if(!empty($check_pincode_smartship)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '16'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '16';
            }
        }
        
        $check_pincode_smartship = ItEasyProzoPincodes::findOne(['it_easy_pincode' => $pincode]);
        if(!empty($check_pincode_smartship)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '17'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '17';
            }
        }
        
        $check_pincode_smartship = ItEasyQuickshiftPincodes::findOne(['it_easy_pincode' => $pincode]);
        if(!empty($check_pincode_smartship)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '19'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '19';
            }
        }
        
        $check_pincode_smartship = ItEasyEkartPincodes::findOne(['it_easy_pincode' => $pincode]);
        if(!empty($check_pincode_smartship)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '20'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '20';
            }
        }
        
        $check_pincode_smartship = 	ItEasyUrbanboltPincodes::findOne(['it_easy_pincode' => $pincode]);
        if(!empty($check_pincode_smartship)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '21'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '21';
            }
        }
        
         $check_pincode_smartship = 	ItEasyZippyPincodes::findOne(['it_easy_pincode' => $pincode]); //Zippy Delhivery
        if(!empty($check_pincode_smartship)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '23'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '23';
            }
        }
        
          $check_pincode_smartship = 	ItEasyZippyAtsPincodes::findOne(['it_easy_pincode' => $pincode]); //Zippy Ats
        if(!empty($check_pincode_smartship)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '25'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '25';
            }
        }
        
         $check_pincode_smartship = 	ItEasyZippyDtdcPincodes::findOne(['it_easy_pincode' => $pincode]); //Zippy Dtdc
        if(!empty($check_pincode_smartship)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '26'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '26';
            }
        }
        
         $check_pincode_smartship = 	ItEasyZippyEkartPincodes::findOne(['it_easy_pincode' => $pincode]); //Zippy Ekart
        if(!empty($check_pincode_smartship)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '27'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '27';
            }
        }
        
         $check_pincode_smartship = 	ItEasyZippyXbreesPincodes::findOne(['it_easy_pincode' => $pincode]); //Zippy Ekart
        if(!empty($check_pincode_smartship)){
            $check_shipping = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '28'])->andWhere(['status' => 'Active'])->one();
            if(!empty($check_shipping)){
                $api_id[] = '28';
            }
        }
        
        // echo "<pre>"; print_r($api_id); die;

        return implode(',', $api_id);
    }

    public static function getIpaddress(){
        if (isset($_SERVER['HTTP_CLIENT_IP']))
            $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
        else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
        else if(isset($_SERVER['HTTP_X_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
        else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
        else if(isset($_SERVER['HTTP_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_FORWARDED'];
        else if(isset($_SERVER['REMOTE_ADDR']))
            $ipaddress = $_SERVER['REMOTE_ADDR'];
        else
            $ipaddress = 'UNKNOWN';

        return $ipaddress;
    }

    public static function getDevicename(){
        
        if(isset($_SERVER['HTTP_USER_AGENT']) && array_key_exists("HTTP_USER_AGENT",$_SERVER)){
            $device_name = $_SERVER['HTTP_USER_AGENT'];
            preg_match('#\((.*?)\)#', $device_name, $match);
            $get_device = $match[1];
        }else{
            $get_device = '';
        }

        return $get_device;
    }

    public static function getBrowsername(){
        if(isset($_SERVER['HTTP_USER_AGENT']) && array_key_exists("HTTP_USER_AGENT",$_SERVER)){
        if(strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false){
           $browser = 'Internet explorer';
         }
         elseif(strpos($_SERVER['HTTP_USER_AGENT'], 'Trident') !== false){
            $browser = 'Internet explorer';
         }
         elseif(strpos($_SERVER['HTTP_USER_AGENT'], 'Firefox') !== false){
           $browser = 'Mozilla Firefox';
         }
         elseif(strpos($_SERVER['HTTP_USER_AGENT'], 'Chrome') !== false){
           $browser = 'Google Chrome';
         }
         elseif(strpos($_SERVER['HTTP_USER_AGENT'], 'Opera Mini') !== false){
           $browser = "Opera Mini";
         }
         elseif(strpos($_SERVER['HTTP_USER_AGENT'], 'Opera') !== false){
           $browser = "Opera";
         }
         elseif(strpos($_SERVER['HTTP_USER_AGENT'], 'Safari') !== false){
           $browser = "Safari";
         }
         else{
           $browser = 'Other';
         }
        }else{
            $browser = '';
        }

        return $browser;
    }

    public static function addOrderStatusHistory($order_id, $order_status_id, $comment){
            $model_status = new ItEasyOrderStatusHistory();
            $model_status->it_easy_order_id = $order_id;
            $model_status->it_easy_order_status_id = $order_status_id;
            $model_status->it_easy_comment = $comment.' (by '.Yii::$app->user->identity->it_easy_username.')';
            $model_status->it_easy_created_time = date('Y-m-d H:i:s');
            $model_status->save(false);
            return true;
    }
  
  	public static function addndrOrderStatusHistory($order_id, $order_status_id, $comment){
            $model_status = new ItEasyOrderNdrStatusHistory();
            $model_status->it_easy_order_id = $order_id;
            $model_status->it_easy_order_status_id = $order_status_id;
            $model_status->it_easy_comment = $comment.' (by '.Yii::$app->user->identity->it_easy_username.')';
            $model_status->it_easy_created_time = date('Y-m-d H:i:s');
            $model_status->save();
            return true;
    }

    public static function addDispositionStatusHistory($order_id, $disposition_status_id, $comment){
            $model_status = new ItEasyOrderDispositionHistory();
            $model_status->it_easy_order_id = $order_id;
            $model_status->it_easy_order_disposition_id = $disposition_status_id;
            $model_status->it_easy_comment = $comment.' (by '.Yii::$app->user->identity->it_easy_username.')';
            $model_status->it_easy_created_time = date('Y-m-d H:i:s');
            $model_status->save();
            return true;
    }
  
  
  	public static function addndrDispositionStatusHistory($order_id, $disposition_status_id, $comment){
            $model_status = new ItEasyOrderNdrdispositionHistory();
            $model_status->it_easy_order_id = $order_id;
            $model_status->it_easy_order_disposition_id = $disposition_status_id;
            $model_status->it_easy_comment = $comment.' (by '.Yii::$app->user->identity->it_easy_username.')';
            $model_status->it_easy_created_time = date('Y-m-d H:i:s');
            $model_status->save();
            return true;
    }

    public static function addOrderSHistory($order_id, $comment){
            $model_status = new ItEasyOrderHistory();
            $model_status->it_easy_order_id = $order_id;
            $model_status->it_easy_comment = $comment.' (by '.Yii::$app->user->identity->it_easy_username.')';
            $model_status->it_easy_created_time = date('Y-m-d H:i:s');
            $model_status->save(false);
            return true;
    }
    

    public static function getProductVariationData($product_id, $variation_id){
            $model_product = ItEasyProductVariation::find()->where(['it_easy_product_id' => $product_id])->andWhere(['it_easy_variation_id' => $variation_id])->asArray()->one();
      	
            return $model_product;
        
    }

    public static function getOrderProductbyOrderId($order_id, $product_id, $variation_id){
            $model_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_id])->andWhere(['it_easy_variation_id' => $variation_id])->andWhere(['it_easy_product_id' => $product_id])->one();
            return $model_product;
    }

    public static function getCoouponbyid($coupon_id){
        $coupon_data = ItEasyCoupon::findOne(['it_easy_id' => $coupon_id]);
        return $coupon_data;
    }


    public static function getCoouponbyidArrayHelper($coupon_id){
        $coupon_data = ItEasyCoupon::find()->select(['it_easy_id', 'it_easy_coupon_code'])->andWhere(['it_easy_id' => $coupon_id])->asArray()->all();
        return $coupon_data;
    }

    public static function FindProductbyid($product_id){
        $product_data = ItEasyProduct::find()->select(['it_easy_product_id', 'it_easy_product_image', 'it_easy_product_name', 'it_easy_product_included_exclude_tax', 'it_easy_product_tax'])->where(['it_easy_product_id' => $product_id])->one();
        return $product_data;
      
    }
    
    public static function FindRecommandClickpost($order_id, $pincode, $payment_mode){
        if($payment_mode != 'COD'){
            $payment_mode = 'PREPAID';
        }
        $url = "https://www.clickpost.in/api/v1/recommendation_api/?key=28ab0068-a66d-4ecf-8b20-ad8b28f1f83f";

        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        
        $headers = array(
           "accept: application/json",
           "content-type: application/json",
        );
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        
        $post_array = [];
        $post_array[0]['reference_number'] = 'REF#'.$order_id;
        $post_array[0]['item'] = 'GFF';
        $post_array[0]['pickup_pincode'] = '110020';
        $post_array[0]['drop_pincode'] = $pincode;
        $post_array[0]['invoice_value'] = '1999';
        $post_array[0]['weight'] = '5';
        $post_array[0]['length'] = '5';
        $post_array[0]['breadth'] = '5';
        $post_array[0]['height'] = '5';
        $post_array[0]['delivery_type'] = 'FORWARD';
        $post_array[0]['order_type'] = $payment_mode;
        
        // echo "<pre>"; print_r($post_array); 
        
        // echo json_encode($post_array);
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($post_array));
        
        //for debug only!
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        
        $resp = curl_exec($curl);
        // echo $resp; die;
        $result = json_decode($resp);
        // echo "<pre>"; print_r($result); die;
        if(isset($result->meta->reason)){
            $result = '';
        }else{
                $val_carier = [];
            foreach($result->result[0]->preference_array as $key => $val){
                $val_carier[] = $val->cp_id;
            }
            $result = implode(",",$val_carier);
        }
        return $result;
    }

    public static function getCoouponHistorybyOrderid($order_id){
        $coupon_data = ItEasyCouponHistory::find()->where(['it_easy_order_id' => $order_id])->one();
        return $coupon_data;
    }

    public static function getOrderStatusHistorybyOrderId($order_id){
        $return_result = ItEasyOrderStatusHistory::find()->where(['it_easy_order_id' => $order_id])->orderBy(['it_easy_created_time' => SORT_DESC])->all();
        return $return_result;
    }
  
  	public static function getOrderndrStatusHistorybyOrderId($order_id){
        $return_result = ItEasyOrderNdrStatusHistory::find()->where(['it_easy_order_id' => $order_id])->orderBy(['it_easy_created_time' => SORT_DESC])->all();
        return $return_result;
    }

    public static function getOrderDispositionHistorybyOrderId($order_id){
        $return_result = ItEasyOrderDispositionHistory::find()->where(['it_easy_order_id' => $order_id])->orderBy(['it_easy_created_time' => SORT_DESC])->all();
        return $return_result;
    }
  
  	public static function getOrderndrDispositionHistorybyOrderId($order_id){
        $return_result = ItEasyOrderNdrdispositionHistory::find()->where(['it_easy_order_id' => $order_id])->orderBy(['it_easy_created_time' => SORT_DESC])->all();
        return $return_result;
    }

    public static function getOrderHistorybyOrderId($order_id){
        $return_result = ItEasyOrderHistory::find()->where(['it_easy_order_id' => $order_id])->orderBy(['it_easy_created_time' => SORT_DESC])->all();
        return $return_result;
    }

    public static function GetOrderStatusNamebystatusId($status_id){
        $return_result = ItEasyOrderStatus::findOne(['it_easy_order_status_id' => $status_id]);
        if(empty($return_result)){
            return '';
        }else{
            return $return_result['it_easy_order_status_name'];
        }
    }

    public static function GetOrderDispositionNamebystatusId($status_id){
      	
        $return_result = ItEasyOrderDisposition::findOne(['it_easy_order_disposition_id' => $status_id]);
        if(empty($return_result)){
            return '';
        }else{
            return $return_result['it_easy_order_disposition_name'];
        }
    }

    public static function getTLandAgentName($tl_id, $agent_id){
        $return_result = User::findOne(['id' => $tl_id]);
        if(empty($return_result['it_easy_username'])){
            $return_result['it_easy_username'] = '';
        }
        
        $return_result2 = User::findOne(['id' => $agent_id]);
        if(empty($return_result2['it_easy_username'])){
            $return_result2['it_easy_username'] = '';
        }
        return $return_result['it_easy_username'].'<br><span style="font-size:16px;font:weight:600;">'.$return_result2['it_easy_username'].'</span>';
    }

    public static function getAHelperOrderStatusForAgent(){
        $return_data = ItEasyOrderStatus::find()->select(['it_easy_order_status_id', 'it_easy_order_status_name'])->andWhere(['it_easy_status' => 'Active'])->andWhere(['it_easy_order_type' => 'Order'])->all();
        return $return_data;
    }
    
    public static function getAHelperOrderStatusForAgentsw(){
        
        $check_user_connected = ItEasyUserConnectedStatus::find()->andWhere(['it_easy_department_id' => Yii::$app->user->identity->it_easy_dept_id ])->andWhere(['it_easy_user_type_id' => Yii::$app->user->identity->it_easy_type_id ])->one();
            // echo $check_user_connected; die;
            // ->one();
            
            // echo "<pre>"; print_r($check_user_connected); die;
            if(!empty($check_user_connected->it_easy_status_id)){
                $check_Array = explode(',', $check_user_connected->it_easy_status_id);
                $return_data = ItEasyOrderStatus::find()->select(['it_easy_order_status_id', 'it_easy_order_status_name'])->andWhere(['it_easy_status' => 'Active'])->andWhere(['it_easy_order_type' => 'Order'])->andWhere(['in', 'it_easy_order_status_id', $check_Array ])->all();
            }else{
                $return_data = ItEasyOrderStatus::find()->select(['it_easy_order_status_id', 'it_easy_order_status_name'])->andWhere(['it_easy_status' => 'Active'])->andWhere(['it_easy_order_type' => 'Order'])->all();
            }
            // echo "<pre>"; print_r($check_Array); die;
            
        
        return $return_data;
    }
    
    
    public static function getAHelperOrderStatusForAgentLogistic(){
        
        
            
            $check_user_connected = ItEasyUserConnectedStatus::find()->andWhere(['it_easy_department_id' => Yii::$app->user->identity->it_easy_dept_id ])->andWhere(['it_easy_user_type_id' => Yii::$app->user->identity->it_easy_type_id ])->one();
            // echo $check_user_connected; die;
            // ->one();
            
            // echo "<pre>"; print_r($check_user_connected); die;
            if(!empty($check_user_connected->it_easy_status_id)){
                $check_Array = explode(',', $check_user_connected->it_easy_status_id);
                $return_data = ItEasyOrderStatus::find()->select(['it_easy_order_status_id', 'it_easy_order_status_name'])->andWhere(['it_easy_status' => 'Active'])->andWhere(['it_easy_order_type' => 'Order'])->andWhere(['in', 'it_easy_order_status_id', $check_Array ])->all();
            }else{
                $return_data = ItEasyOrderStatus::find()->select(['it_easy_order_status_id', 'it_easy_order_status_name'])->andWhere(['it_easy_status' => 'Active'])->andWhere(['it_easy_order_type' => 'Order'])->all();
            }
            // echo "<pre>"; print_r($check_Array); die;
            
        
        return $return_data;
    }
    
    

    public static function getAHelperDispositionStatusForAgent(){
        $return_data = ItEasyOrderDisposition::find()->select(['it_easy_order_disposition_id', 'it_easy_order_disposition_name'])->andWhere(['it_easy_status' => 'Active'])->andWhere(['it_easy_disposition_type' => 'Order'])->all();
        return $return_data;
    }
  
  	public static function getAHelperndrOrderStatusForAgent(){
        $return_data = ItEasyOrderStatus::find()->select(['it_easy_order_status_id', 'it_easy_order_status_name'])->andWhere(['it_easy_status' => 'Active'])->andWhere(['it_easy_order_type' => 'NDR'])->all();
        return $return_data;
    }

    public static function getAHelperndrDispositionStatusForAgent(){
        $return_data = ItEasyOrderDisposition::find()->select(['it_easy_order_disposition_id', 'it_easy_order_disposition_name'])->andWhere(['it_easy_status' => 'Active'])->andWhere(['it_easy_disposition_type' => 'NDR'])->all();
        return $return_data;
    }

    public static function getAHelperShippingMethod(){
        $return_data = ItEasyShippingPaymentMethod::find()->select(['it_easy_method_code', 'it_easy_method_name'])->andWhere(['it_easy_method_type' => 'Shipping'])->andWhere(['it_easy_status' => 'Active'])->all();
        return $return_data;
    }

    public static function getAHelperPaymentMethod(){
        $return_data = ItEasyShippingPaymentMethod::find()->select(['it_easy_method_code', 'it_easy_method_name'])->andWhere(['it_easy_method_type' => 'Payment'])->andWhere(['it_easy_status' => 'Active'])->all();
        return $return_data;
    }

    public static function getAHelperTLdata(){
        
       
        if(Yii::$app->user->identity->it_easy_dept_id == '4'){
             $return = User::find()
                ->select(['id', 'it_easy_username'])->andWhere(['it_easy_dept_id' => '4'])->andWhere(['it_easy_type_id' => '3'])->andWhere(['status' => 'ACTIVE']);
            $return->andWhere(['id' => Yii::$app->user->identity->id]);
        }else if(Yii::$app->user->identity->it_easy_dept_id == '9'){
            $return = User::find()
                ->select(['id', 'it_easy_username'])->andWhere(['it_easy_dept_id' => '9'])->andWhere(['it_easy_type_id' => '3'])->andWhere(['status' => 'ACTIVE']);
            $return->andWhere(['id' => Yii::$app->user->identity->id]);
        }else{
            $return = User::find()
                ->select(['id', 'it_easy_username'])->andWhere(['or', ['it_easy_dept_id' => '9'], ['it_easy_dept_id' => '4'] ])->andWhere(['it_easy_type_id' => '3'])->andWhere(['status' => 'ACTIVE']);
        }
        $return = $return->all();
        $return_data = ArrayHelper::map($return, 'id', 'it_easy_username' );
    
        return $return_data;
    }

    public static function getAHelperAgentdata(){
        if(Yii::$app->user->identity->it_easy_dept_id == '4' && (Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5')){
            $return = User::find()->select(['id', 'it_easy_username'])
                
                ->andWhere(['or', ['it_easy_dept_id' => '4'], ['it_easy_dept_id' => '9'] ])->andWhere(['or', ['it_easy_type_id' => '4'], ['it_easy_type_id' => '5']])->andWhere(['status' => 'ACTIVE']);
            $return->andWhere(['id' => Yii::$app->user->identity->id]);
        }else if(Yii::$app->user->identity->it_easy_dept_id == '9' && (Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5')){
            $return = User::find()->select(['id', 'it_easy_username'])
                
                ->andWhere(['or', ['it_easy_dept_id' => '4'], ['it_easy_dept_id' => '9'] ])->andWhere(['or', ['it_easy_type_id' => '4'], ['it_easy_type_id' => '5']])->andWhere(['status' => 'ACTIVE']);
            $return->andWhere(['id' => Yii::$app->user->identity->id]);
        }else if(Yii::$app->user->identity->it_easy_dept_id == '4' && (Yii::$app->user->identity->it_easy_type_id == '3')){
            
            $return = User::find()->select(['id', 'it_easy_username'])
                
                ->andWhere(['it_easy_dept_id' => '4'])->andWhere(['or', ['it_easy_type_id' => '4'], ['it_easy_type_id' => '5']])->andWhere(['status' => 'ACTIVE']);    
        }else if(Yii::$app->user->identity->it_easy_dept_id == '9' && (Yii::$app->user->identity->it_easy_type_id == '3')){
            $return = User::find()->select(['id', 'it_easy_username'])
                
                ->andWhere(['it_easy_dept_id' => '9'])->andWhere(['or', ['it_easy_type_id' => '4'], ['it_easy_type_id' => '5']])->andWhere(['status' => 'ACTIVE']);
                
        }else{
            $return = User::find()
                ->andWhere(['or', ['it_easy_dept_id' => '4'], ['it_easy_dept_id' => '9'] ])->andWhere(['or', ['it_easy_type_id' => '4'], ['it_easy_type_id' => '5']])->andWhere(['status' => 'ACTIVE']);
        }
        $return = $return->all();
        $return_data = ArrayHelper::map($return, 'id', 'it_easy_username' );
        return $return_data;
    }

    public static function GetServiceableCourierName($couriers_id){
        $explode = explode(',', $couriers_id);
        $couriers = ItEasyShippingApi::find()->where(['in', 'it_easy_ship_id', $explode])->all();
        return $couriers;
    }
    
    public static function GetServiceableClickCourierName($couriers_id){
        $explode = explode(',', $couriers_id);
        $couriers = ItEasyClickpostCourier::find()->where(['in', 'cp_id', $explode])->all();
        return $couriers;
    }
    

    public static function MainDashboardnumbers($params){
        // echo "<pre>"; print_r($params); die;
        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'].' 00:00:00';
        }else{
            
                 $from_date = date('Y-m-d').' 00:00:00';
             
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
                
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
                $to_date = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
            
                $to_date = date('Y-m-d H:i:s');
            
        }
        
        $query = ItEasyOrder::find()->select(['COUNT(*) as total_leads', 'SUM(it_easy_total_price) as sum_total_leads', 'COUNT(CASE WHEN  (`it_easy_assigned_to` <> "" OR `it_easy_retention_AGENTid` <> "" )  then 1 ELSE NULL END) AS assign_leads', 'SUM(CASE WHEN (`it_easy_assigned_to` <> "" OR `it_easy_retention_AGENTid` <> "" ) then it_easy_total_price ELSE NULL END) AS assign_leads_amount', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6", "12", "14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END) AS confirm_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6", "12", "14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then it_easy_total_price ELSE 0 END) AS confirm_sum', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then it_easy_ordered_amount ELSE 0 END) AS shopify_confirm_sum',  'ROUND( SUM(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then it_easy_total_price ELSE 0 END) / COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END), 2) as average_ticket'  , 'COUNT(CASE WHEN `it_easy_payment_code` != "COD" then 1 ELSE NULL END) AS prepaid_order', 'SUM(CASE WHEN `it_easy_payment_code` != "COD" then it_easy_total_price ELSE 0 END) AS prepaid_order_amount', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then 1 ELSE NULL END) AS dispatched_order_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then it_easy_total_price ELSE 0 END) AS dispatched_order_sum' ]);
        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['or', [ '<=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date'] ], [ '<=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_to_date'] ], ])
                         ->andWhere([ 'or', ['>=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']], ['>=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_from_date']], ]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Order Place via Agent'){
                        $query->andWhere(['<=', 'it_easy_order_place_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_order_place_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }
        }else{
            $query->andWhere(['<=', 'it_easy_created_time', $to_date])
                         ->andWhere(['>=', 'it_easy_created_time', $from_date]);
        }

        if((Yii::$app->user->identity->it_easy_dept_id == '4' || Yii::$app->user->identity->it_easy_dept_id == '9') && (Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5')){
            $query->andWhere(['or', ['it_easy_assigned_to' => Yii::$app->user->identity->id], ['it_easy_retention_AGENTid' => Yii::$app->user->identity->id] ]);
        }

        if(isset($params['ItEasyOrderSearch']['it_easy_department_id']) && !empty($params['ItEasyOrderSearch']['it_easy_department_id'])){
            $query->andWhere(['it_easy_department_id' => $params['ItEasyOrderSearch']['it_easy_department_id']]);
        }
        
        if(isset($params['ItEasyOrderSearch']['it_easy_platform']) && !empty($params['ItEasyOrderSearch']['it_easy_platform'])){
            
            $query->andFilterWhere(['like', 'it_easy_platform', $params['ItEasyOrderSearch']['it_easy_platform']]);
        }
        // if(Yii::$app->user->identity->id == '53'){
        //     echo $query->createCommand()->getRawSql(); die;
        //  }
            // echo $data = $query->createCommand()->rawSql; die;
        return $data = $query->asArray()->one();
    }
    
    
    public static function MainDashboardnumbersPrapaidThisMonth($params){
        // echo "<pre>"; print_r($params); die;
        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'].' 00:00:00';
        }else{
            
                 $from_date = date('Y-m-')."01 00:00:00";
             
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
                
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
                $to_date = date('Y-m-d').' 23:59:59';
        }
        
        $query = ItEasyOrder::find()->select(['COUNT(*) as total_leads', 'SUM(it_easy_total_price) as sum_total_leads', 'COUNT(CASE WHEN  (`it_easy_assigned_to` <> "" OR `it_easy_retention_AGENTid` <> "" )  then 1 ELSE NULL END) AS assign_leads', 'SUM(CASE WHEN (`it_easy_assigned_to` <> "" OR `it_easy_retention_AGENTid` <> "" ) then it_easy_total_price ELSE NULL END) AS assign_leads_amount', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6", "12", "14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END) AS confirm_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then it_easy_total_price ELSE 0 END) AS confirm_sum', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then it_easy_ordered_amount ELSE 0 END) AS shopify_confirm_sum', 'ROUND( SUM(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then it_easy_total_price ELSE 0 END) / COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END), 2) as average_ticket'  , 'COUNT(CASE WHEN `it_easy_payment_code` != "COD" then 1 ELSE NULL END) AS prepaid_order', 'SUM(CASE WHEN `it_easy_payment_code` != "COD" then it_easy_total_price ELSE 0 END) AS prepaid_order_amount', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then 1 ELSE NULL END) AS dispatched_order_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then it_easy_total_price ELSE 0 END) AS dispatched_order_sum', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("3","6") then 1 ELSE NULL END) AS delivered_order_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("3","6") then it_easy_total_price ELSE 0 END) AS delivered_order_sum' ]);
        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['or', [ '<=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date'] ], [ '<=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_to_date'] ], ])
                         ->andWhere([ 'or', ['>=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']], ['>=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_from_date']], ]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Order Place via Agent'){
                        $query->andWhere(['<=', 'it_easy_order_place_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_order_place_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }
        }else{
            $query->andWhere(['<=', 'it_easy_created_time', $to_date])
                         ->andWhere(['>=', 'it_easy_created_time', $from_date]);
        }

        if((Yii::$app->user->identity->it_easy_dept_id == '4' || Yii::$app->user->identity->it_easy_dept_id == '9') && (Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5')){
            $query->andWhere(['or', ['it_easy_assigned_to' => Yii::$app->user->identity->id], ['it_easy_retention_AGENTid' => Yii::$app->user->identity->id] ]);
        }
        
        if(isset($params['ItEasyOrderSearch']['it_easy_department_id']) && !empty($params['ItEasyOrderSearch']['it_easy_department_id'])){
            $query->andWhere(['it_easy_department_id' => $params['ItEasyOrderSearch']['it_easy_department_id']]);
        }
        
        // if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && !empty($params['ItEasyOrderSearch']['it_easy_first_status'])){
        //     $query->andWhere(['it_easy_first_status' => $params['ItEasyOrderSearch']['it_easy_first_status']]);
        // }
        
        if(isset($params['ItEasyOrderSearch']['it_easy_platform']) && !empty($params['ItEasyOrderSearch']['it_easy_platform'])){
            
            $query->andFilterWhere(['like', 'it_easy_platform', $params['ItEasyOrderSearch']['it_easy_platform']]);
        }
        
            // echo $data = $query->createCommand()->rawSql; die;
        return $data = $query->asArray()->one();
    }


    public static function AgentwisegettotalReport($params){
        // echo "<pre>"; print_r($params); die;
        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'];
        }else{
            
                 $from_date = date('Y-m').'-01'; 
             
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
                
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
                $to_date = date('Y-m-d').' 23:59:59';
        }
        
        $query = ItEasyOrder::find()->select(['COUNT(*) as total_assign', 'SUM(it_easy_total_price) as sum_assign_total', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31" , "9", "22", "47") then 1 ELSE NULL END) AS confirm_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then it_easy_total_price ELSE 0 END) AS confirm_sum',  'ROUND( SUM(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then it_easy_total_price ELSE 0 END) / COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END), 2) as average_ticket'  , 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("21") then 1 ELSE NULL END) AS approval_pending_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("21") then it_easy_total_price ELSE 0 END) AS approval_pending_sum',  'COUNT(CASE WHEN `it_easy_order_status_id` IN ("7") then 1 ELSE NULL END) AS hold_order_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("7") then it_easy_total_price ELSE 0 END) AS hold_order_sum', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then 1 ELSE NULL END) AS dispatched_order_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then it_easy_total_price ELSE 0 END) AS dispatched_order_sum', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("3","6") then 1 ELSE NULL END) AS delivered_order_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("3","6") then it_easy_total_price ELSE 0 END) AS delivered_order_sum', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("15") then 1 ELSE NULL END) AS rto_order_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("15") then it_easy_total_price ELSE 0 END) AS rto_order_sum', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("14") then 1 ELSE NULL END) AS lost_order_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("14") then it_easy_total_price ELSE 0 END) AS lost_order_sum', ]);
        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['or', ['<=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']], ['<=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_to_date']] ])
                         ->andWhere(['or', [ '>=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']], [ '>=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_from_date']] ]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }
        }else{
            $query->andWhere(['<=', 'it_easy_created_time', $to_date])
                         ->andWhere(['>=', 'it_easy_created_time', $from_date]);
        }

        if((Yii::$app->user->identity->it_easy_dept_id == '4' || Yii::$app->user->identity->it_easy_dept_id == '9')  && (Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5')){
            $query->andWhere(['or',[ 'it_easy_assigned_to' => Yii::$app->user->identity->id], [ 'it_easy_retention_AGENTid' => Yii::$app->user->identity->id] ]);
        }else if(Yii::$app->user->identity->it_easy_dept_id == '4' && (Yii::$app->user->identity->it_easy_type_id == '3')){
            
            $query->andWhere(['or',[ 'it_easy_assigned_by' => Yii::$app->user->identity->id], [ 'it_easy_retention_TLid' => Yii::$app->user->identity->id] ]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_by']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_by'])){
            $query->andWhere(['or',[ 'it_easy_assigned_by' => $params['ItEasyOrderSearch']['it_easy_assigned_by']], [ 'it_easy_retention_TLid' => $params['ItEasyOrderSearch']['it_easy_assigned_by']] ]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_to']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_to'])){
            $query->andWhere(['or', ['it_easy_assigned_to' => $params['ItEasyOrderSearch']['it_easy_assigned_to']], ['it_easy_retention_AGENTid' => $params['ItEasyOrderSearch']['it_easy_assigned_to']] ]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && !empty($params['ItEasyOrderSearch']['it_easy_first_status'])){
            $query->andWhere(['it_easy_first_status' => $params['ItEasyOrderSearch']['it_easy_first_status']]);
        }
        
            // echo $data = $query->createCommand()->rawSql; die;
            return $data = $query->asArray()->one();
    }


    public static function AgentwisegettotaldispositionReport($params){
        
        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'];
        }else{
            
                 $from_date = date('Y-m').'-01'; 
             
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
                
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
                $to_date = date('Y-m-d').' 23:59:59';
        }
        
        $query = ItEasyOrder::find()->select(['COUNT(*) as total_assign', 'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("1", "13") then 1 ELSE NULL END) AS callback_req_count', 'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("4", "12") then 1 ELSE NULL END) AS not_connected_count', 'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("2","5","6") then 1 ELSE NULL END) AS not_intrested_count',  'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("7") then 1 ELSE NULL END) AS duplicate_count', 'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("9", "10", "22") then 1 ELSE NULL END) AS fake_order_count', 'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("11") then 1 ELSE NULL END) AS area_not_ser_count', 'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("14") then 1 ELSE NULL END) AS call_disconnected_count', 'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("15","8") then 1 ELSE NULL END) AS promise_To_order_count', 'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("16","17","3", "20") then 1 ELSE NULL END) AS order_placed_count', 'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("18", "19") then 1 ELSE NULL END) AS medical_condition_count', 'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("21") then 1 ELSE NULL END) AS language_arrier']);
        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['or', ['<=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']], ['<=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_to_date']] ])
                         ->andWhere(['or', [ '>=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']], [ '>=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_from_date']] ]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }
        }else{
            $query->andWhere(['<=', 'it_easy_created_time', $to_date])
                         ->andWhere(['>=', 'it_easy_created_time', $from_date]);
        }

        if(Yii::$app->user->identity->it_easy_dept_id == '4' && (Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5')){
            $query->andWhere(['or',[ 'it_easy_assigned_to' => Yii::$app->user->identity->id], [ 'it_easy_retention_AGENTid' => Yii::$app->user->identity->id] ]);
        }else if(Yii::$app->user->identity->it_easy_dept_id == '4' && (Yii::$app->user->identity->it_easy_type_id == '3')){
            $query->andWhere(['or',[ 'it_easy_assigned_by' => Yii::$app->user->identity->id], [ 'it_easy_retention_TLid' => Yii::$app->user->identity->id] ]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_by']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_by'])){
             $query->andWhere(['or',[ 'it_easy_assigned_by' => $params['ItEasyOrderSearch']['it_easy_assigned_by']], [ 'it_easy_retention_TLid' => $params['ItEasyOrderSearch']['it_easy_assigned_by']] ]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_to']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_to'])){
            $query->andWhere(['or', ['it_easy_assigned_to' => $params['ItEasyOrderSearch']['it_easy_assigned_to']], ['it_easy_retention_AGENTid' => $params['ItEasyOrderSearch']['it_easy_assigned_to']] ]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && !empty($params['ItEasyOrderSearch']['it_easy_first_status'])){
            $query->andWhere(['it_easy_first_status' => $params['ItEasyOrderSearch']['it_easy_first_status']]);
        }
            // echo $data = $query->createCommand()->rawSql; die;
            return $data = $query->asArray()->all();
    }

    public static function ReportFromOrderGroupByagentname($params){
        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'];
        }else{
                 $from_date = date('Y-m').'-01 00:00:00'; 
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
                
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
                $to_date = date('Y-m-d').' 23:59:59';
        }
        
        $query = ItEasyOrder::find()->select(['it_easy_assigned_to','COUNT(*) as total_assign_number', 'SUM(it_easy_total_price) as sum_assign_total', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END) AS confirm_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then it_easy_total_price ELSE 0 END) AS confirm_sum',  'SUM(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then it_easy_ordered_amount ELSE 0 END) AS ordered_confirm_sum',  'COUNT(CASE WHEN `it_easy_order_status_id` IN ("7") then 1 ELSE NULL END) AS hold_order_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("7") then it_easy_total_price ELSE 0 END) AS hold_order_sum', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then 1 ELSE NULL END) AS dispatched_order_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then it_easy_total_price ELSE 0 END) AS dispatched_order_sum', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("3","6") then 1 ELSE NULL END) AS delivered_order_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("3","6") then it_easy_total_price ELSE 0 END) AS delivered_order_sum', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("15") then 1 ELSE NULL END) AS rto_order_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("15") then it_easy_total_price ELSE 0 END) AS rto_order_sum', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("8") then 1 ELSE NULL END) AS cancelled_order_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("8") then it_easy_total_price ELSE 0 END) AS cancelled_order_sum', 'COUNT(CASE WHEN `it_easy_payment_code` IN ("Prepaid", "Bank Transfer", "UPI") then 1 ELSE NULL END) AS prepaid_order_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("Prepaid", "Bank Transfer", "UPI") then it_easy_total_price ELSE 0 END) AS preapaid_order_sum', ]);

        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['or', ['<=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']], ['<=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_to_date']] ] )
                        ->andWhere(['or', ['>=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']], ['>=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_from_date']] ] );
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }
        }else{
            $query->andWhere(['<=', 'it_easy_created_time', $to_date])
                         ->andWhere(['>=', 'it_easy_created_time', $from_date]);
        }

        // if(Yii::$app->user->identity->it_easy_dept_id == '4' && (Yii::$app->user->identity->it_easy_type_id == '3')){
            // $query->andWhere(['it_easy_assigned_by' => Yii::$app->user->identity->id]);
        // }

        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_by']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_by'])){
            $query->andWhere(['or', [ 'it_easy_assigned_by' => $params['ItEasyOrderSearch']['it_easy_assigned_by']], [ 'it_easy_retention_TLid' => $params['ItEasyOrderSearch']['it_easy_assigned_by']] ] );
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_to']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_to'])){
            $query->andWhere(['or', ['it_easy_assigned_to' => $params['ItEasyOrderSearch']['it_easy_assigned_to']], ['it_easy_retention_AGENTid' => $params['ItEasyOrderSearch']['it_easy_assigned_to']] ]);
        }
        // if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && !empty($params['ItEasyOrderSearch']['it_easy_first_status'])){
        //     $query->andWhere(['it_easy_first_status' => $params['ItEasyOrderSearch']['it_easy_first_status']]);
        // }
        
        if(isset($params['ItEasyOrderSearch']['it_easy_platform']) && !empty($params['ItEasyOrderSearch']['it_easy_platform'])){
            
            $query->andFilterWhere(['like', 'it_easy_platform', $params['ItEasyOrderSearch']['it_easy_platform']]);
        }

        $data = $query->orderBy(['COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END)' => SORT_DESC])->groupBy(['it_easy_assigned_to'])->asArray()->all();
        
        
        // echo $query->createCommand()->rawSql; die;

        
        return $data;
    }
    
    
    public static function ReportFromOrderProper($params){
        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'];
        }else{
                 $from_date = date('Y-m').'-01 00:00:00'; 
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
                
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
                $to_date = date('Y-m-d').' 23:59:59';
        }
        
        $query = ItEasyOrder::find()->select(['it_easy_marketer_publisher','COUNT(*) as total_order_number', 'SUM(it_easy_total_price) as sum_assign_total', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47", "48", "49", "50") then 1 ELSE NULL END) AS confirm_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47",  "48", "49", "50") then it_easy_total_price ELSE 0 END) AS confirm_sum', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("7","8","10","11","17","13","18","19","20","21","22","23") then 1 ELSE NULL END) AS pending_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("7","8","10","11","17","13","18","19","20","21","22","23") then it_easy_total_price ELSE 0 END) AS pending_sum',   'COUNT(CASE WHEN `it_easy_order_status_id` IN ("2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47",  "48", "49", "50") then 1 ELSE NULL END) AS awb_assign_number', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47",  "48", "49", "50") then it_easy_total_price ELSE 0 END) AS awb_assign_sum',  'COUNT(CASE WHEN `it_easy_order_status_id` IN ("3","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE null END) AS dispatch_number', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("3","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then it_easy_total_price ELSE 0 END) AS dispatch_sum', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("3","6") then 1 ELSE NULL END) AS delivered_order_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("3","6") then it_easy_total_price ELSE 0 END) AS delivered_order_sum' ]);

        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['or', ['<=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']], ['<=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_to_date']] ] )
                        ->andWhere(['or', ['>=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']], ['>=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_from_date']] ] );
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }
        }else{
            $query->andWhere(['<=', 'it_easy_created_time', $to_date])
                         ->andWhere(['>=', 'it_easy_created_time', $from_date]);
        }

        // if(Yii::$app->user->identity->it_easy_dept_id == '4' && (Yii::$app->user->identity->it_easy_type_id == '3')){
            // $query->andWhere(['it_easy_assigned_by' => Yii::$app->user->identity->id]);
        // }

    
        if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && ($params['ItEasyOrderSearch']['it_easy_first_status'] == 'Retention')){
            $query->andWhere(['OR', ['it_easy_other_order_id' => '' ], ['IS', 'it_easy_other_order_id', null ]])->andWhere(['OR', ['it_easy_abondoned_type' => '' ], ['IS', 'it_easy_abondoned_type', null ]]);
        }else if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && ($params['ItEasyOrderSearch']['it_easy_first_status'] == 'Fresh')){
            $query->andWhere(['AND', ['<>','it_easy_other_order_id' , '' ], ['IS NOT', 'it_easy_other_order_id', null ]]);
        }else if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && ($params['ItEasyOrderSearch']['it_easy_first_status'] == 'Abondoned')){
            $query->andWhere(['OR', ['it_easy_other_order_id' => '' ], ['IS', 'it_easy_other_order_id', null ]])->andWhere(['it_easy_abondoned_type' => 'Abondoned']);
        }
        
        
        $data = $query->orderBy(['COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END)' => SORT_DESC])->groupBy(['it_easy_marketer_publisher'])->asArray()->all();
        
        
        // echo $query->createCommand()->rawSql; die;

        
        return $data;
    }
    
    

    public static function ReportDispositionFromOrderGroupByagentname($params){
        
        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'];
        }else{
                 $from_date = date('Y-m').'-01'; 
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
                
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
                $to_date = date('Y-m-d').' 23:59:59';
        }
        
        $query = ItEasyOrder::find()->select(['it_easy_assigned_to', 'COUNT(*) as total_assign', 'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("1", "13") then 1 ELSE NULL END) AS callback_req_count', 'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("4", "12") then 1 ELSE NULL END) AS not_connected_count', 'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("2","5","6") then 1 ELSE NULL END) AS not_intrested_count',  'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("7") then 1 ELSE NULL END) AS duplicate_count', 'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("9", "10", "22") then 1 ELSE NULL END) AS fake_order_count', 'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("11") then 1 ELSE NULL END) AS area_not_ser_count', 'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("14") then 1 ELSE NULL END) AS call_disconnected_count', 'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("15","8") then 1 ELSE NULL END) AS promise_To_order_count', 'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("16","17","3", "20") then 1 ELSE NULL END) AS order_placed_count', 'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("18", "19") then 1 ELSE NULL END) AS medical_condition_count', 'COUNT(CASE WHEN `it_easy_order_disposition_id` IN ("21") then 1 ELSE NULL END) AS language_arrier']);
        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['or', ['<=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']], ['<=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_to_date']] ] )
                        ->andWhere(['or', ['>=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']], ['>=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_from_date']] ] );
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }
        }else{
            $query->andWhere(['<=', 'it_easy_created_time', $to_date])
                         ->andWhere(['>=', 'it_easy_created_time', $from_date]);
        }

        if((Yii::$app->user->identity->it_easy_dept_id == '4' || Yii::$app->user->identity->it_easy_dept_id == '9' ) && (Yii::$app->user->identity->it_easy_type_id == '3')){
            $query->andWhere(['or', ['it_easy_assigned_by' => Yii::$app->user->identity->id], ['it_easy_retention_TLid' => Yii::$app->user->identity->id] ]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_by']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_by'])){
            $query->andWhere(['or', [ 'it_easy_assigned_by' => $params['ItEasyOrderSearch']['it_easy_assigned_by']], [ 'it_easy_retention_TLid' => $params['ItEasyOrderSearch']['it_easy_assigned_by']] ] );
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_to']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_to'])){
            $query->andWhere(['or', ['it_easy_assigned_to' => $params['ItEasyOrderSearch']['it_easy_assigned_to']], ['it_easy_retention_AGENTid' => $params['ItEasyOrderSearch']['it_easy_assigned_to']] ]);
        }
        // if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && !empty($params['ItEasyOrderSearch']['it_easy_first_status'])){
        //     $query->andWhere(['it_easy_first_status' => $params['ItEasyOrderSearch']['it_easy_first_status']]);
        // }
        
        if(isset($params['ItEasyOrderSearch']['it_easy_platform']) && !empty($params['ItEasyOrderSearch']['it_easy_platform'])){
            
            $query->andFilterWhere(['like', 'it_easy_platform', $params['ItEasyOrderSearch']['it_easy_platform']]);
        }

        $data = $query->orderBy(['COUNT(*)' => SORT_DESC])->groupBy(['it_easy_assigned_to'])->asArray()->all();

        $dataProvider = new ArrayDataProvider([
            'allModels' => $data,
        ]);
    
        if(isset($params['export']) && !empty($params['export'])){
            return $data;
        }else{
            return $dataProvider;
        }
    } 


    public static function StateWiseAgentwisegettotalReport($params){
        // echo "<pre>"; print_r($params); die;
        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'];
        }else{
                 $from_date = date('Y-m').'-01'; 
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
                
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
                $to_date = date('Y-m-d').' 23:59:59';
        }
        
        $query = ItEasyOrder::find()->select(['COUNT(*) as total_assign', 'it_easy_state', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END) AS confirm_count', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then 1 ELSE NULL END) AS dispatched_order_count', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("3","6") then 1 ELSE NULL END) AS delivered_order_count', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("15") then 1 ELSE NULL END) AS rto_order_count']);
        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['or', ['<=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']], ['<=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_to_date']] ] )
                        ->andWhere(['or', ['>=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']], ['>=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_from_date']] ] );
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }
        }else{
            $query->andWhere(['<=', 'it_easy_created_time', $to_date])
                         ->andWhere(['>=', 'it_easy_created_time', $from_date]);
        }

        if(Yii::$app->user->identity->it_easy_dept_id == '4' && (Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5')){
            $query->andWhere(['or',['it_easy_assigned_to' => Yii::$app->user->identity->id], ['it_easy_retention_AGENTid' => Yii::$app->user->identity->id] ]);
        }else if(Yii::$app->user->identity->it_easy_dept_id == '4' && (Yii::$app->user->identity->it_easy_type_id == '3')){
        
            $query->andWhere(['or', ['it_easy_assigned_by' => Yii::$app->user->identity->id], ['it_easy_retention_TLid' => Yii::$app->user->identity->id] ]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_by']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_by'])){
            $query->andWhere(['or', [ 'it_easy_assigned_by' => $params['ItEasyOrderSearch']['it_easy_assigned_by']], [ 'it_easy_retention_TLid' => $params['ItEasyOrderSearch']['it_easy_assigned_by']] ] );
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_to']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_to'])){
            $query->andWhere(['or', ['it_easy_assigned_to' => $params['ItEasyOrderSearch']['it_easy_assigned_to']], ['it_easy_retention_AGENTid' => $params['ItEasyOrderSearch']['it_easy_assigned_to']] ]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && !empty($params['ItEasyOrderSearch']['it_easy_first_status'])){
            $query->andWhere(['it_easy_first_status' => $params['ItEasyOrderSearch']['it_easy_first_status']]);
        } 
        
        return $data = $query->groupBy(['it_easy_state_id'])->orderBy(['COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END)' => SORT_DESC ])->asArray()->all();
    }


    public static function ProductWiseAgentwisegettotalReport($params){
        // echo "<pre>"; print_r($params); die;
        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'];
        }else{
                 $from_date = date('Y-m').'-01'; 
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
                
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
                
                $to_date = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
                $to_date = date('Y-m-d').' 23:59:59';
        }
        
        $query = ItEasyOrderProduct::find()->from(['op' => ItEasyOrderProduct::tablename()])->select(['COUNT(DISTINCT(o.it_easy_order_id)) as total_assign', 'it_easy_product_name', 'it_easy_product_id', 'it_easy_variation_id', 'it_easy_variation_name', 'SUM(op.it_easy_product_quantity) as product_quantity', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END) AS confirm_count', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then 1 ELSE NULL END) AS dispatched_order_count', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("3","6") then 1 ELSE NULL END) AS delivered_order_count', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("15") then 1 ELSE NULL END) AS rto_order_count'])->leftJoin(ItEasyOrder::tablename().' as o', 'op.it_easy_order_id = o.it_easy_order_id');
        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['or', ['<=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']], ['<=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_to_date']] ] )
                        ->andWhere(['or', ['>=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']], ['>=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_from_date']] ] );
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }
        }else{
            $query->andWhere(['<=', 'it_easy_created_time', $to_date])
                         ->andWhere(['>=', 'it_easy_created_time', $from_date]);
        }

        if(Yii::$app->user->identity->it_easy_dept_id == '4' && (Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5')){
            $query->andWhere(['or',['it_easy_assigned_to' => Yii::$app->user->identity->id], ['it_easy_retention_AGENTid' => Yii::$app->user->identity->id] ]);
        }else if(Yii::$app->user->identity->it_easy_dept_id == '4' && (Yii::$app->user->identity->it_easy_type_id == '3')){
            $query->andWhere(['or', ['it_easy_assigned_by' => Yii::$app->user->identity->id], ['it_easy_retention_TLid' => Yii::$app->user->identity->id] ]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_by']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_by'])){
            $query->andWhere(['or', [ 'it_easy_assigned_by' => $params['ItEasyOrderSearch']['it_easy_assigned_by']], [ 'it_easy_retention_TLid' => $params['ItEasyOrderSearch']['it_easy_assigned_by']] ] );
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_to']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_to'])){
            $query->andWhere(['or', ['it_easy_assigned_to' => $params['ItEasyOrderSearch']['it_easy_assigned_to']], ['it_easy_retention_AGENTid' => $params['ItEasyOrderSearch']['it_easy_assigned_to']] ]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && !empty($params['ItEasyOrderSearch']['it_easy_first_status'])){
            $query->andWhere(['it_easy_first_status' => $params['ItEasyOrderSearch']['it_easy_first_status']]);
        }
        
            // echo $data = $query->createCommand()->rawSql; die;
            return $data = $query->groupBy(['it_easy_product_id', 'it_easy_variation_id'])->orderBy(['COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31") then 1 ELSE NULL END)' => SORT_DESC ])->asArray()->all();
    } 
    
    public static function OneProductWiseAgentwisegettotalReport($params, $product_id, $variation_id){
        // echo "<pre>"; print_r($params); die;
        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'];
        }else{
                 $from_date = date('Y-m').'-01'; 
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
                
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
                
                $to_date = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
                $to_date = date('Y-m-d').' 23:59:59';
        }
        
        $query = ItEasyOrderProduct::find()->from(['op' => ItEasyOrderProduct::tablename()])->select(['COUNT(DISTINCT(o.it_easy_order_id)) as total_assign', 'SUM(op.it_easy_product_total) as ordered_ammount', 'it_easy_product_name', 'it_easy_product_id', 'it_easy_variation_id', 'it_easy_variation_name', 'SUM(op.it_easy_product_quantity) as product_quantity', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END) AS confirm_count',  'SUM(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then it_easy_product_total ELSE NULL END) AS confirm_sum', 'ROUND(SUM(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then it_easy_product_total ELSE NULL END) / COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END)) as average_ticket_size ', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then 1 ELSE NULL END) AS dispatched_order_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then it_easy_product_total ELSE NULL END) AS dispatched_order_sum', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("3","6") then 1 ELSE NULL END) AS delivered_order_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("3","6") then it_easy_product_total ELSE NULL END) AS delivered_order_sum', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("15") then 1 ELSE NULL END) AS rto_order_count'])->leftJoin(ItEasyOrder::tablename().' as o', 'op.it_easy_order_id = o.it_easy_order_id');
        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['<=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }
        }else{
            $query->andWhere(['<=', 'it_easy_created_time', $to_date])
                         ->andWhere(['>=', 'it_easy_created_time', $from_date]);
        }

        if(Yii::$app->user->identity->it_easy_dept_id == '4' && (Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5')){
            $query->andWhere(['it_easy_assigned_to' => Yii::$app->user->identity->id]);
        }else if(Yii::$app->user->identity->it_easy_dept_id == '4' && (Yii::$app->user->identity->it_easy_type_id == '3')){
            $query->andWhere(['it_easy_assigned_by' => Yii::$app->user->identity->id]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_by']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_by'])){
            $query->andWhere(['it_easy_assigned_by' => $params['ItEasyOrderSearch']['it_easy_assigned_by']]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_to']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_to'])){
            $query->andWhere(['it_easy_assigned_to' => $params['ItEasyOrderSearch']['it_easy_assigned_to']]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && !empty($params['ItEasyOrderSearch']['it_easy_first_status'])){
            $query->andWhere(['it_easy_first_status' => $params['ItEasyOrderSearch']['it_easy_first_status']]);
        }
        
        $query->andWhere(['it_easy_product_id' => $product_id]);
        $query->andWhere(['it_easy_variation_id' => $variation_id]);
        // echo $data = $query->createCommand()->rawSql; die;
        return $data = $query->asArray()->one();
    } 
    
    
    


    public static function ProductWiseAgentwisegettotalReportDashboard($params){
        // echo "<pre>"; print_r($params); die;
        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'];
        }else{
                 $from_date = date('Y-m-d'); 
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
                
                $to_date = $params['ItEasyOrderSearch']['date_to_date'];
        }else{
                $to_date = date('Y-m-d');
        }
        
        $query = ItEasyOrderProduct::find()->from(['op' => ItEasyOrderProduct::tablename()])->select(['COUNT(DISTINCT(o.it_easy_order_id)) as total_assign', 'it_easy_product_name', 'it_easy_product_id', 'it_easy_variation_id', 'it_easy_variation_name', 'SUM(op.it_easy_product_quantity) as product_quantity', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31") then 1 ELSE NULL END) AS confirm_count', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30") then 1 ELSE NULL END) AS dispatched_order_count', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("3","6") then 1 ELSE NULL END) AS delivered_order_count', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("15") then 1 ELSE NULL END) AS rto_order_count'])->leftJoin(ItEasyOrder::tablename().' as o', 'o.it_easy_order_id = op.it_easy_order_id');
        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['<=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }
        }else{
            $query->andWhere(['<=', 'it_easy_created_time', $to_date])
                         ->andWhere(['>=', 'it_easy_created_time', $from_date]);
        }

        if(Yii::$app->user->identity->it_easy_dept_id == '4' && (Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5')){
            $query->andWhere(['it_easy_assigned_to' => Yii::$app->user->identity->id]);
        }else if(Yii::$app->user->identity->it_easy_dept_id == '4' && (Yii::$app->user->identity->it_easy_type_id == '3')){
            $query->andWhere(['it_easy_assigned_by' => Yii::$app->user->identity->id]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_by']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_by'])){
            $query->andWhere(['it_easy_assigned_by' => $params['ItEasyOrderSearch']['it_easy_assigned_by']]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_to']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_to'])){
            $query->andWhere(['it_easy_assigned_to' => $params['ItEasyOrderSearch']['it_easy_assigned_to']]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && !empty($params['ItEasyOrderSearch']['it_easy_first_status'])){
            $query->andWhere(['it_easy_first_status' => $params['ItEasyOrderSearch']['it_easy_first_status']]);
        }
        
            // echo $data = $query->createCommand()->rawSql; die;
            return $data = $query->groupBy(['it_easy_product_id', 'it_easy_variation_id'])->orderBy(['COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31") then 1 ELSE NULL END)' => SORT_DESC ])->asArray()->all();
    }  
    

    public static function ReportFromOrderCourierWiseReport($params){
        // echo "<pre>"; print_r($params); die;
        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'];
        }else{
                 $from_date = date('Y-m').'-01'; 
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
                
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
                $to_date = date('Y-m-d').' 23:59:59';
        }
        
        $query = ItEasyOrderDispatch::find()->from(['od' => ItEasyOrderDispatch::tablename()])->select(['sa.it_easy_name as courier_name',  'COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END) AS confirm_count', 'COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then 1 ELSE NULL END) AS dispatched_order_count', 'COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("3","6") then 1 ELSE NULL END) AS delivered_order_count', 'COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("15") then 1 ELSE NULL END) AS rto_order_count'])->leftJoin(ItEasyOrder::tablename().' as o', 'o.it_easy_order_id = od.it_easy_order_id')->leftJoin(ItEasyShippingApi::tablename().' as sa', 'sa.it_easy_ship_id = od.it_easy_shipping_id');
        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'o.it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'o.it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['<=', 'o.it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'o.it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'o.it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }
        }else{
            $query->andWhere(['<=', 'it_easy_created_time', $to_date])
                         ->andWhere(['>=', 'it_easy_created_time', $from_date]);
        }

        if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && !empty($params['ItEasyOrderSearch']['it_easy_first_status'])){
            $query->andWhere(['od.it_easy_order_type' => $params['ItEasyOrderSearch']['it_easy_first_status']]);
        }

        if(isset($params['ItEasyOrderSearch']['it_easy_marketer_id']) && !empty($params['ItEasyOrderSearch']['it_easy_marketer_id'])){
            $query->andWhere(['od.it_easy_shipping_id' => $params['ItEasyOrderSearch']['it_easy_marketer_id']]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_platform']) && !empty($params['ItEasyOrderSearch']['it_easy_platform'])){
            
            $query->andFilterWhere(['like', 'o.it_easy_platform', $params['ItEasyOrderSearch']['it_easy_platform']]);
        }
            // echo $data = $query->createCommand()->rawSql; die;
            return $data = $query->groupBy(['od.it_easy_shipping_id'])->asArray()->all();
    }


    public static function ReportFromOrderCourierZoneWiseReport($params){
        // echo "<pre>"; print_r($params); die;
    
        
        $query = ItEasyOrderDispatch::find()->from(['od' => ItEasyOrderDispatch::tablename()])->select(['od.it_easy_zone_name as zone_name',  'COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END) AS confirm_count', 'COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then 1 ELSE NULL END) AS dispatched_order_count', 'COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("3","6") then 1 ELSE NULL END) AS delivered_order_count', 'COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("15") then 1 ELSE NULL END) AS rto_order_count'])->leftJoin(ItEasyOrder::tablename().' as o', 'o.it_easy_order_id = od.it_easy_order_id')->leftJoin(ItEasyShippingApi::tablename().' as sa', 'sa.it_easy_ship_id = od.it_easy_shipping_id');
        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'];
        }else{
                 $from_date = date('Y-m').'-01'; 
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
                
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
                $to_date = date('Y-m-d').' 23:59:59';
        }
        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'o.it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'o.it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['<=', 'o.it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'o.it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'o.it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }
        }else{
            $query->andWhere(['<=', 'it_easy_created_time', $to_date])
                         ->andWhere(['>=', 'it_easy_created_time', $from_date]);
        }

        if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && !empty($params['ItEasyOrderSearch']['it_easy_first_status'])){
            $query->andWhere(['od.it_easy_order_type' => $params['ItEasyOrderSearch']['it_easy_first_status']]);
        }

        if(isset($params['ItEasyOrderSearch']['it_easy_marketer_id']) && !empty($params['ItEasyOrderSearch']['it_easy_marketer_id'])){
            $query->andWhere(['od.it_easy_shipping_id' => $params['ItEasyOrderSearch']['it_easy_marketer_id']]);
        }
        
        if(isset($params['ItEasyOrderSearch']['it_easy_platform']) && !empty($params['ItEasyOrderSearch']['it_easy_platform'])){
            
            $query->andFilterWhere(['like', 'o.it_easy_platform', $params['ItEasyOrderSearch']['it_easy_platform']]);
        }
        
            // echo $data = $query->createCommand()->rawSql; die;
            return $data = $query->groupBy(['od.it_easy_zone_name'])->asArray()->all();
    }


    public static function ReportFromOrderCourierStateWiseReport($params){
        // echo "<pre>"; print_r($params); die;
    
        
        $query = ItEasyOrderDispatch::find()->from(['od' => ItEasyOrderDispatch::tablename()])->select(['o.it_easy_state as state_name',  'COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END) AS confirm_count', 'COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then 1 ELSE NULL END) AS dispatched_order_count', 'COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("3","6") then 1 ELSE NULL END) AS delivered_order_count', 'COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("15") then 1 ELSE NULL END) AS rto_order_count'])->leftJoin(ItEasyOrder::tablename().' as o', 'o.it_easy_order_id = od.it_easy_order_id')->leftJoin(ItEasyShippingApi::tablename().' as sa', 'sa.it_easy_ship_id = od.it_easy_shipping_id');

        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'];
        }else{
                 $from_date = date('Y-m').'-01'; 
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
                
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
                $to_date = date('Y-m-d').' 23:59:59';;
        }

        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'o.it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'o.it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['<=', 'o.it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'o.it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'o.it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }
        }else{
            $query->andWhere(['<=', 'it_easy_created_time', $to_date])
                         ->andWhere(['>=', 'it_easy_created_time', $from_date]);
        }

        if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && !empty($params['ItEasyOrderSearch']['it_easy_first_status'])){
            $query->andWhere(['od.it_easy_order_type' => $params['ItEasyOrderSearch']['it_easy_first_status']]);
        }

        if(isset($params['ItEasyOrderSearch']['it_easy_marketer_id']) && !empty($params['ItEasyOrderSearch']['it_easy_marketer_id'])){
            $query->andWhere(['od.it_easy_shipping_id' => $params['ItEasyOrderSearch']['it_easy_marketer_id']]);
        }
        
        if(isset($params['ItEasyOrderSearch']['it_easy_platform']) && !empty($params['ItEasyOrderSearch']['it_easy_platform'])){
            
            $query->andFilterWhere(['like', 'o.it_easy_platform', $params['ItEasyOrderSearch']['it_easy_platform']]);
        }
        
            // echo $data = $query->createCommand()->rawSql; die;
            return $data = $query->groupBy(['o.it_easy_state_id'])->orderBy(['COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31") then 1 ELSE NULL END)' => SORT_DESC])->asArray()->all();
    }


    public static function getStateArrayDistinct($params){
        // echo "<pre>"; print_r($params); die;
    
        
        $query = ItEasyOrderDispatch::find()->from(['od' => ItEasyOrderDispatch::tablename()])->select(['o.it_easy_state as state_name', 'o.it_easy_state_id as state_id', 'COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then 1 ELSE NULL END) AS dispatched_order_count', 'COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("3","6") then 1 ELSE NULL END) AS delivered_order_count'])->leftJoin(ItEasyOrder::tablename().' as o', 'o.it_easy_order_id = od.it_easy_order_id')->leftJoin(ItEasyShippingApi::tablename().' as sa', 'sa.it_easy_ship_id = od.it_easy_shipping_id');

        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'];
        }else{
                 $from_date = date('Y-m').'-01'; 
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
                
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'];
        }else{
                $to_date = date('Y-m-d');
        }

        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'o.it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'o.it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['<=', 'o.it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'o.it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'o.it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }
        }else{
            $query->andWhere(['<=', 'it_easy_created_time', $to_date])
                         ->andWhere(['>=', 'it_easy_created_time', $from_date]);
        }

        if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && !empty($params['ItEasyOrderSearch']['it_easy_first_status'])){
            $query->andWhere(['od.it_easy_order_type' => $params['ItEasyOrderSearch']['it_easy_first_status']]);
        }

        if(isset($params['ItEasyOrderSearch']['it_easy_marketer_id']) && !empty($params['ItEasyOrderSearch']['it_easy_marketer_id'])){
            $query->andWhere(['od.it_easy_shipping_id' => $params['ItEasyOrderSearch']['it_easy_marketer_id']]);
        }
        
        if(isset($params['ItEasyOrderSearch']['it_easy_platform']) && !empty($params['ItEasyOrderSearch']['it_easy_platform'])){
            
            $query->andFilterWhere(['like', 'o.it_easy_platform', $params['ItEasyOrderSearch']['it_easy_platform']]);
        }
        
            // echo $data = $query->createCommand()->rawSql; die;
            return $data = $query->groupBy(['o.it_easy_state_id'])->orderBy(['COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30") then 1 ELSE NULL END)' => SORT_DESC])->asArray()->all();
    }

    public static function getsStateArrayDistinctReport($state_id,$params){
        // echo "<pre>"; print_r($params); die;
    
        
        $query = ItEasyOrderDispatch::find()->from(['od' => ItEasyOrderDispatch::tablename()])->select(['od.it_easy_courier_name as courier_name', 'COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then 1 ELSE NULL END) AS dispatched_order_count', 'COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("3","6") then 1 ELSE NULL END) AS delivered_order_count'])->leftJoin(ItEasyOrder::tablename().' as o', 'o.it_easy_order_id = od.it_easy_order_id')->leftJoin(ItEasyShippingApi::tablename().' as sa', 'sa.it_easy_ship_id = od.it_easy_shipping_id');

        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'];
        }else{
                 $from_date = date('Y-m').'-01'; 
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
                
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'];
        }else{
                $to_date = date('Y-m-d');
        }

        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'o.it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'o.it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['<=', 'o.it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'o.it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'o.it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }
        }else{
            $query->andWhere(['<=', 'it_easy_created_time', $to_date])
                         ->andWhere(['>=', 'it_easy_created_time', $from_date]);
        }

        if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && !empty($params['ItEasyOrderSearch']['it_easy_first_status'])){
            $query->andWhere(['od.it_easy_order_type' => $params['ItEasyOrderSearch']['it_easy_first_status']]);
        }

        if(isset($params['ItEasyOrderSearch']['it_easy_marketer_id']) && !empty($params['ItEasyOrderSearch']['it_easy_marketer_id'])){
            $query->andWhere(['od.it_easy_shipping_id' => $params['ItEasyOrderSearch']['it_easy_marketer_id']]);
        }
        
        if(isset($params['ItEasyOrderSearch']['it_easy_platform']) && !empty($params['ItEasyOrderSearch']['it_easy_platform'])){
            
            $query->andFilterWhere(['like', 'o.it_easy_platform', $params['ItEasyOrderSearch']['it_easy_platform']]);
        }
            $query->andWhere(['o.it_easy_state_id' => $state_id]);
            // echo $data = $query->createCommand()->rawSql; die;
            return $data = $query->groupBy([ 'od.it_easy_shipping_id'])->orderBy(['COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30") then 1 ELSE NULL END)' => SORT_DESC])->asArray()->all();
    }

    


    public static function ReportFromOrderCourierLiveWiseReport($params){
        // echo "<pre>"; print_r($params); die;
    
        
        $query = ItEasyOrderDispatch::find()->from(['od' => ItEasyOrderDispatch::tablename()])->select([ 'COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("5","13","27","29","30") then 1 ELSE NULL END) AS in_transit_count', 'COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then 1 ELSE NULL END) AS dispatched_order_count', 'COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("9","14", "16", "23", "26", "28", "9", "22", "47") then 1 ELSE NULL END) AS ndr_order_count', 'COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("15", "3", "6") then 1 ELSE NULL END) AS complete_order_count'])->leftJoin(ItEasyOrder::tablename().' as o', 'o.it_easy_order_id = od.it_easy_order_id');

        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'];
        }else{
                 $from_date = date('Y-m').'-01'; 
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
                
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
                $to_date = date('Y-m-d').' 23:59:59';
        }

        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'o.it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'o.it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['<=', 'o.it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'o.it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'o.it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }
        }else{
            $query->andWhere(['<=', 'it_easy_created_time', $to_date])
                         ->andWhere(['>=', 'it_easy_created_time', $from_date]);
        }

        if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && !empty($params['ItEasyOrderSearch']['it_easy_first_status'])){
            $query->andWhere(['od.it_easy_order_type' => $params['ItEasyOrderSearch']['it_easy_first_status']]);
        }

        if(isset($params['ItEasyOrderSearch']['it_easy_marketer_id']) && !empty($params['ItEasyOrderSearch']['it_easy_marketer_id'])){
            $query->andWhere(['od.it_easy_shipping_id' => $params['ItEasyOrderSearch']['it_easy_marketer_id']]);
        }
        
        if(isset($params['ItEasyOrderSearch']['it_easy_platform']) && !empty($params['ItEasyOrderSearch']['it_easy_platform'])){
            
            $query->andFilterWhere(['like', 'o.it_easy_platform', $params['ItEasyOrderSearch']['it_easy_platform']]);
        }
        
            // echo $data = $query->createCommand()->rawSql; die;
            return $data = $query->asArray()->one();
    }


    public static function GetCourierNamebyShipid($couriers_id){
        $couriers = ItEasyShippingApi::find()->where(['it_easy_ship_id' => $couriers_id])->one();
        return $couriers->it_easy_name;
    }
    
    public static function GetClickpostCourierNamebyShipid($couriers_id){
        $couriers = ItEasyClickpostCourier::find()->where(['cp_id' => $couriers_id])->one();
        return $couriers->account_name;
    }

    public static function ArrayHelperCourierData(){
        
        $return = ItEasyShippingApi::find()->select(['it_easy_ship_id', 'it_easy_name'])->where(['status' => 'Active'])->all();
        $return_data = ArrayHelper::map($return, 'it_easy_ship_id', 'it_easy_name' );
    
        return $return_data;
    }
    
    
    public static function ArrayHelperClickpostCourierData(){
        
        $return = ItEasyClickpostCourier::find()->select(['cp_id', 'courier_name'])->where(['status' => 'Active'])->all();
        $return_data = ArrayHelper::map($return, 'cp_id', 'courier_name' );
    
        return $return_data;
    }
    
    public static function Calldones($orderid){
        $model=Yii::$app->db->createcommand()->update(ItEasyOrder::tableName(),['it_easy_callback_status'=>'Done','it_easy_disposition_time'=>null],['it_easy_order_id'=>$orderid])->execute();
        return $model;
    }
  
  public static function GetlabelData($orderid){
               
           $query = ItEasyOrder::find()->from(['o' => ItEasyOrder::tablename()])->select(['s.it_easy_store_name as storename','s.it_easy_store_url as website','s.it_easy_store_email as storeemail', 's.it_easy_store_mobile as storemobile', 's.it_easy_address_1 as storeadd1','s.it_easy_address_2 as storeadd2','s.it_easy_city as storecity','s.it_easy_state as storestate','s.it_easy_pincode as storepin','s.it_easy_gst_number as storegst','od.it_easy_placed_time as dispatchtime','o.it_easy_order_id as orderid','o.it_easy_invoice_number as invoice','o.it_easy_order_number as ordernumber','o.it_easy_shipping_firstname as shipfirstname','o.it_easy_shipping_lastname as shiplastname','o.it_easy_shipping_mobile_number as shipmobilenumber','o.it_easy_shipping_city as shipcity','o.it_easy_shipping_address_1 as shipadd1','o.it_easy_shipping_address_2 as shipadd2','o.it_easy_shipping_state as shipstate','o.it_easy_shipping_pincode as shippin','od.it_easy_order_type as paymentmode','od.it_easy_collective_price as collectprice','od.it_easy_awb_number as awbnumber','ship.it_easy_name as couriername','od.it_easy_subcourier_name as subcourier', 'od.it_easy_route_code as route_code', 's.it_easy_registered_name as it_easy_registered_name', 'o.it_easy_total_price as order_total_price'])

           ->leftJoin(ItEasyStore::tablename().' as s', 's.it_easy_id = o.it_easy_store_id')
           ->leftJoin(ItEasyOrderDispatch::tablename().' as od', 'od.it_easy_order_id = o.it_easy_order_id')
           ->leftJoin(ItEasyShippingApi::tablename().' as ship', 'od.it_easy_shipping_id = ship.it_easy_ship_id')
           //->leftJoin(ItEasyClickpostCourier::tablename().' as ship', 'od.it_easy_shipping_id = ship.cp_id')

           ->where(['in','o.it_easy_order_id',$orderid])->asArray()->all();
          return $query;

     }
     
     public static function GetlabelData1($orderid){
$query = ItEasyOrder::find()
    ->from(['o' => ItEasyOrder::tablename()])
    ->select([
        // Store Details
        's.it_easy_store_name as storename',
        's.it_easy_store_url as website',
        's.it_easy_store_email as storeemail',
        's.it_easy_store_mobile as storemobile',
        's.it_easy_address_1 as storeadd1',
        's.it_easy_address_2 as storeadd2',
        's.it_easy_city as storecity',
        's.it_easy_state as storestate',
        's.it_easy_pincode as storepin',
        's.it_easy_gst_number as storegst',
        's.it_easy_registered_name as it_easy_registered_name',

        // Order Time Fields
     
        'o.it_easy_created_time as createtime',
        'o.it_easy_converted_time as convertdate',

        // Order IDs / Invoice
        'o.it_easy_order_id as orderid',
        'o.it_easy_invoice_number as invoice',
        'o.it_easy_order_number as ordernumber',
         'o.it_easy_platform as platform',

        // Shipping Address
        'o.it_easy_shipping_firstname as shipfirstname',
        'o.it_easy_shipping_lastname as shiplastname',
        'o.it_easy_shipping_mobile_number as shipmobilenumber',
        'o.it_easy_shipping_city as shipcity',
        'o.it_easy_shipping_address_1 as shipadd1',
        'o.it_easy_shipping_address_2 as shipadd2',
        'o.it_easy_shipping_state as shipstate',
        'o.it_easy_shipping_pincode as shippin',

        // Billing Address (NEW fields added)
        'o.it_easy_billing_firstname as billfirstname',
        'o.it_easy_billing_lastname as billlastname',
        'o.it_easy_billing_mobile as billmobilenumber',
        'o.it_easy_billing_city as billcity',
        'o.it_easy_billing_address_1 as billadd1',
        'o.it_easy_billing_address_2 as billadd2',
        'o.it_easy_billing_state as billstate',
        'o.it_easy_billing_pincode as billpin',
        'o.it_easy_state_id as state_id',

        // Payment / Shipping Details
        'o.it_easy_payment_code as payment_code',
        'o.it_easy_shipping_code as shipping_code',
        'o.it_easy_coupon_id as coupon_id',
        'o.it_easy_shipping_method as shipingmethod',
        'o.it_easy_payment_method as paymentmethod',

        // Order Amount Details
        'o.it_easy_total_price as order_total_price',
        'o.it_easy_gst_price as order_gst_price',

        // Dispatch Table Fields
        'od.it_easy_awb_number as awbnumber',
        'od.it_easy_order_type as paymentmode',
        'od.it_easy_collective_price as collectprice',
        'od.it_easy_subcourier_name as subcourier',
        'od.it_easy_route_code as route_code',
   

        // Courier Table Fields
        'ship.courier_name as couriername'
    ])
    ->leftJoin(ItEasyStore::tablename() . ' as s', 's.it_easy_id = o.it_easy_store_id')
    ->leftJoin(ItEasyOrderDispatch::tablename() . ' as od', 'od.it_easy_order_id = o.it_easy_order_id')
    ->leftJoin(ItEasyClickpostCourier::tablename() . ' as ship', 'od.it_easy_shipping_id = ship.cp_id')
    ->where(['in', 'o.it_easy_order_id', $orderid])
    ->asArray()
    ->all();
    
    // ---------------------------------
    // ✔ Modify registered name based on PLATFORM
    // ---------------------------------

    foreach ($query as &$q) {

        if ($q['platform'] === 'CRMLeads') {
            $q['it_easy_registered_name'] = "Skygain Nutricare Private Limited"; 
        } else {
            $q['it_easy_registered_name'] = "Nutriherbs (Skygain Nutricare Private Limited)"; // keep original
        }

    }

return $query;


     }



     public static function GrtOrderProducts($order_id) {
         $model_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_id])->asarray()->all();
        return $model_product;
    }
    
    public static function GrtOrderProducts1($order_id)
{
    return ItEasyOrderProduct::find()
        ->alias('op')
        ->select([
            'op.*',   // all fields from order product table

            // Product table fields
            'p.it_easy_product_id',
            'p.shopify_product_id',
            'p.it_easy_product_category_id',
            'p.it_easy_product_name',
             'p.it_easy_product_hsn',
            'p.it_easy_product_sku AS product_sku',
        ])
        ->leftJoin('it_easy_product p', 'p.it_easy_product_id = op.it_easy_product_id')
        ->where(['op.it_easy_order_id' => $order_id])
        ->asArray()
        ->all();
}

public static function GrtOrderProducts12($order_id)
{
    
      $order = ItEasyOrder::find()
        ->select(['it_easy_platform'])
        ->where(['it_easy_order_id' => $order_id])
        ->asArray()
        ->one();

    // Fallback if order not found
    if (!$order) {
        return [];
    }

    // 2. Check platform
    $isOnlineWebsite = ($order['it_easy_platform'] === 'Online Website');
    if ($isOnlineWebsite) {
        // Fields when platform = Online Website
        $model_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_id])->asarray()->all();
        // echo "<pre>";
        // print_r($model_product);die;
        return $model_product;
    } else {
      return ItEasyOrderProduct::find()
        ->alias('op')
        ->select([
            'op.*',   // all fields from order product table

            // Product table fields
            'p.it_easy_product_id',
            'p.shopify_product_id',
            'p.it_easy_product_category_id',
            'p.it_easy_product_name',
             'p.it_easy_product_hsn',
            'p.it_easy_product_sku AS product_sku',
        ])
        ->leftJoin('it_easy_product p', 'p.it_easy_product_id = op.it_easy_product_id')
        ->where(['op.it_easy_order_id' => $order_id])
        ->asArray()
        ->all();
    }

  
}

public static function GrtOrderProducts2($order_id)
{
    $products = ItEasyOrderProduct::find()
        ->alias('op')
        ->select([
            'op.*',
            'p.it_easy_product_id',
            'p.shopify_product_id',
            'p.it_easy_product_category_id',
            'p.it_easy_product_name',
            'p.it_easy_product_hsn',
            'p.it_easy_product_sku AS product_sku',
        ])
        ->leftJoin('it_easy_product p', 'p.it_easy_product_id = op.it_easy_product_id')
        ->where(['op.it_easy_order_id' => $order_id])
        ->asArray()
        ->all();

    // ---- Calculate totals ----
    $total_qty = 0;
    $total_amount = 0;

    foreach ($products as $p) {
        $total_qty += $p['it_easy_product_quantity'];
        $total_amount += $p['it_easy_product_total'];
    }

    return [
        'items' => $products,
        'total_qty' => $total_qty,
        'total_amount' => $total_amount
    ];
}
    //change
    
  public static function getInvoiceNumber($orderId)
{
    // Check if invoice already exists for this order
    $invoice = OrderInvoices::find()->where(['order_id' => $orderId])->one();

    if ($invoice) {
        return $invoice->invoice_number; // return existing invoice
    }

    // Otherwise create a new one
    return self::generateNewInvoiceNumber($orderId);
}


public static function generateNewInvoiceNumber($orderId)
{
    // Get last invoice number entry
    $last = OrderInvoices::find()->orderBy(['id' => SORT_DESC])->one();

    $prefix = "NH";
    $fy = date('y', strtotime('+1 year'));  // 25, 26, etc.
    $batch = "A";

    if ($last && preg_match('/A(\d+)$/', $last->invoice_number, $m)) {
        $counter = (int)$m[1] + 1;
    } else {
        $counter = 1;
    }

    // pad to 7 digits
    $newSeq = str_pad($counter, 7, '0', STR_PAD_LEFT);

    $invoiceNo = "$prefix/$fy/$batch$newSeq";

    // Save invoice
    $inv = new OrderInvoices();
    $inv->order_id = $orderId;
    $inv->invoice_number = $invoiceNo;
    $inv->created_at = date('Y-m-d H:i:s');
    $inv->save(false);



  // -----------------------------------------------------
    // ✅ Update main order table with invoice number
    // -----------------------------------------------------
    $order = ItEasyOrder::find()->where(['it_easy_order_id' => $orderId])->one();
  if ($order !== null) {
  Yii::$app->db->createCommand()
        ->update(ItEasyOrder::tableName(), 
            ['it_easy_new_invoice_number' => $invoiceNo], 
            ['it_easy_order_id' => $orderId]
        )
        ->execute();
} 


    return $invoiceNo;
  
}


//end


      
    public static function GetInvoiceData1($orderid){
                
        $query = ItEasyOrder::find()->from(['o' => ItEasyOrder::tablename()])->select(['s.it_easy_store_name as storename','s.it_easy_store_url as website','s.it_easy_store_email as storeemail','s.it_easy_store_mobile as storemobile','s.it_easy_address_1 as storeadd1','s.it_easy_address_2 as storeadd2','s.it_easy_city as storecity','s.it_easy_state as storestate','s.it_easy_pincode as storepin','s.it_easy_gst_number as storegst','o.it_easy_placed_time as dispatchtime', 'o.it_easy_created_time  as createtime', 'o.it_easy_converted_time as convertdate','o.it_easy_order_id as orderid','o.it_easy_invoice_number as invoice','o.it_easy_order_number as ordernumber','o.it_easy_shipping_firstname as shipfirstname','o.it_easy_shipping_lastname as shiplastname','o.it_easy_shipping_mobile_number as shipmobilenumber','o.it_easy_shipping_city as shipcity','o.it_easy_shipping_address_1 as shipadd1','o.it_easy_shipping_address_2 as shipadd2','o.it_easy_shipping_state as shipstate','o.it_easy_shipping_pincode as shippin', 'o.it_easy_total_price as order_total_price', 'o.it_easy_gst_price as order_gst_price', 'o.it_easy_payment_code as payment_code','o.it_easy_shipping_code as shipping_code','o.it_easy_coupon_id as coupon_id',
            'o.it_easy_shipping_method as shipingmethod','o.it_easy_payment_method as paymentmethod','o.it_easy_billing_firstname as billfirstname','o.it_easy_billing_lastname as billlastname','o.it_easy_billing_mobile as billmobilenumber', 'o.it_easy_state_id as state_id', 'o.it_easy_billing_city as billcity','o.it_easy_billing_address_1 as billadd1','o.it_easy_billing_address_2 as billadd2','o.it_easy_billing_state as billstate','o.it_easy_billing_pincode as billpin',
            'od.it_easy_awb_number as awbnumber','od.it_easy_order_type as paymentmode','od.it_easy_collective_price as collectprice','ship.courier_name as couriername','od.it_easy_subcourier_name as subcourier'])

           ->leftJoin(ItEasyStore::tablename().' as s', 's.it_easy_id = o.it_easy_store_id')
           ->leftJoin(ItEasyOrderDispatch::tablename().' as od', 'od.it_easy_order_id = o.it_easy_order_id')
        //   ->leftJoin(ItEasyShippingApi::tablename().' as ship', 'od.it_easy_shipping_id = ship.it_easy_ship_id')
        ->leftJoin(ItEasyClickpostCourier::tablename().' as ship', 'od.it_easy_shipping_id = ship.cp_id')

           ->where(['in','o.it_easy_order_id',$orderid])->asArray()->all();
          return $query;

     }
     
     public static function GetInvoiceData($orderid)
{
    $query = ItEasyOrder::find()
        ->from(['o' => ItEasyOrder::tablename()])
        ->select([
            // --------------------------
            // STORE DETAILS
            // --------------------------
            's.it_easy_store_name AS storename',
            's.it_easy_store_url AS website',
            's.it_easy_store_email AS storeemail',
            's.it_easy_store_mobile AS storemobile',
            's.it_easy_address_1 AS storeadd1',
            's.it_easy_address_2 AS storeadd2',
            's.it_easy_city AS storecity',
            's.it_easy_state AS storestate',
            's.it_easy_pincode AS storepin',
            's.it_easy_gst_number AS storegst',

            // --------------------------
            // ORDER TIME DETAILS
            // --------------------------
            'o.it_easy_placed_time AS dispatchtime',
            'o.it_easy_created_time AS createtime',
            'o.it_easy_converted_time AS convertdate',

            // --------------------------
            // ORDER DETAILS
            // --------------------------
            'o.it_easy_order_id AS orderid',
            'o.it_easy_invoice_number AS invoice',
            'o.it_easy_order_number AS ordernumber',
            'o.it_easy_total_price AS order_total_price',
            'o.it_easy_gst_price AS order_gst_price',
            'o.it_easy_payment_code AS payment_code',
            'o.it_easy_shipping_code AS shipping_code',
            'o.it_easy_coupon_id AS coupon_id',
            'o.it_easy_platform as platform',

            // --------------------------
            // SHIPPING DETAILS
            // --------------------------
            'o.it_easy_shipping_method AS shipingmethod',
            'o.it_easy_payment_method AS paymentmethod',

            'o.it_easy_shipping_firstname AS shipfirstname',
            'o.it_easy_shipping_lastname AS shiplastname',
            'o.it_easy_shipping_mobile_number AS shipmobilenumber',
            'o.it_easy_shipping_city AS shipcity',
            'o.it_easy_shipping_address_1 AS shipadd1',
            'o.it_easy_shipping_address_2 AS shipadd2',
            'o.it_easy_shipping_state AS shipstate',
            'o.it_easy_shipping_pincode AS shippin',

            // --------------------------
            // BILLING DETAILS
            // --------------------------
            'o.it_easy_billing_firstname AS billfirstname',
            'o.it_easy_billing_lastname AS billlastname',
            'o.it_easy_billing_mobile AS billmobilenumber',
            'o.it_easy_state_id AS state_id',
            'o.it_easy_billing_city AS billcity',
            'o.it_easy_billing_address_1 AS billadd1',
            'o.it_easy_billing_address_2 AS billadd2',
            'o.it_easy_billing_state AS billstate',
            'o.it_easy_billing_pincode AS billpin',

            // --------------------------
            // DISPATCH / COURIER DETAILS$dis_coupon_value
            // --------------------------
            'od.it_easy_awb_number AS awbnumber',
            'od.it_easy_order_type AS paymentmode',
            'od.it_easy_collective_price AS collectprice',
            'ship.courier_name AS couriername',
            'od.it_easy_subcourier_name AS subcourier',
        ])

        // JOIN STORE
        ->leftJoin(ItEasyStore::tablename() . ' AS s', 's.it_easy_id = o.it_easy_store_id')

        // JOIN DISPATCH TABLE
        ->leftJoin(ItEasyOrderDispatch::tablename() . ' AS od', 'od.it_easy_order_id = o.it_easy_order_id')

        // JOIN COURIER (CLICKPOST)
        ->leftJoin(ItEasyClickpostCourier::tablename() . ' AS ship', 'od.it_easy_shipping_id = ship.cp_id')

        ->where(['in', 'o.it_easy_order_id', $orderid])
        ->asArray()
        ->all();
        
        
        // ---------------------------------
    // ✔ Modify registered name based on PLATFORM
    // ---------------------------------

    foreach ($query as &$q) {

        if ($q['platform'] === 'CRMLeads') {
            $q['it_easy_registered_name'] = "Skygain Nutricare Private Limited"; 
        } else {
            $q['it_easy_registered_name'] = "Nutriherbs (Skygain Nutricare Private Limited)"; // keep original
        }

    }

    return $query;
}

  
  public static function vieworderdata($setid){ 
        $product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $setid])->asArray()->all();
        $query = ItEasyOrder::find()->from(['o' => ItEasyOrder::tablename()])->select(['o.*','s.it_easy_store_url as website'])
           ->leftJoin(ItEasyStore::tablename().' as s', 's.it_easy_id = o.it_easy_store_id')
           ->where(['o.it_easy_order_id'=>$setid])->asArray()->one();
           
        $array_5=array('2', '3', '4', '5','6', '9', '14', '15', '16', '23',  '26', '27','28', '29', '30', '31', '48', '47');
                            
        if (!in_array($query['it_easy_order_status_id'],$array_5)){
            $check_order_status = '0';
            $check_disposition_status = '0';
        }else{
            $check_order_status = '1';
            $check_disposition_status = '1';
        }
           
           
        $get_shippingmethod = ItEasyShippingPaymentMethod::find()->where(['it_easy_method_code' => $query['it_easy_shipping_code']])->asArray()->one();
        $coupon = ItEasyCoupon::find()->where(['it_easy_id' => $query['it_easy_coupon_id']])->asArray()->one();
        $cod_handling = ItEasyShippingPaymentMethod::find()->where(['it_easy_method_code' => $query['it_easy_payment_code']])->asArray()->one();
        $get_order_history_record = ItEasyOrderStatusHistory::find()->from(['ohs' => ItEasyOrderStatusHistory::tablename()])->select(['ohs.*','os.it_easy_order_status_name as statusname'])
        ->leftJoin(ItEasyOrderStatus::tablename().' as os', 'os.it_easy_order_status_id = ohs.it_easy_order_status_id')
       ->where(['it_easy_order_id' => $setid])->asArray()->all();
         $get_despo_record = ItEasyOrderDispositionHistory::find()->from(['odh' => ItEasyOrderDispositionHistory::tablename()])->select(['odh.*','od.it_easy_order_disposition_name as statusname'])
        ->leftJoin(ItEasyOrderDisposition::tablename().' as od', 'od.it_easy_order_disposition_id = odh.it_easy_order_disposition_id')
       ->where(['it_easy_order_id' => $setid])->asArray()->all();
         $array_data = array('order'=>$query,'product'=>$product,'shiping'=>$get_shippingmethod,'coupon'=>$coupon,'codhandling'=>$cod_handling,'get_despo_record'=>$get_despo_record,'get_order_history_record'=>$get_order_history_record, 'check_order_status' => $check_order_status, 'check_disposition_status' => $check_disposition_status);

          echo json_encode($array_data);
          exit();
     }
  
  public static function GetPaymentData($orderid){   
       $model_product = ItEasyOrderProduct::find()->from(['op' => ItEasyOrderProduct::tablename()])->select(['op.*','p.it_easy_product_image','pv.*', 'o.it_easy_total_price as order_total_price', 'o.it_easy_gst_price as order_gst_price', 'o.it_easy_payment_code as payment_code','o.it_easy_shipping_code as shipping_code','o.it_easy_coupon_id as coupon_id',
            'o.it_easy_shipping_method as shipingmethod','o.it_easy_payment_method as paymentmethod'])
       ->leftJoin(ItEasyProduct::tablename().' as p', 'p.it_easy_product_id = op.it_easy_product_id')
       ->leftJoin(ItEasyProductVariation::tablename().' as pv', 'pv.it_easy_id = op.it_easy_variation_id')
       ->leftJoin(ItEasyOrder::tablename().' as o', 'o.it_easy_order_id = op.it_easy_order_id')
       ->where(['op.it_easy_order_id' => $orderid])->asarray()->all();
        return $model_product;

     } 
    public static function GetOrderManifestData($orderid){
               
           $query = ItEasyOrder::find()->from(['o' => ItEasyOrder::tablename()])->select(['s.it_easy_store_name as storename','s.it_easy_store_url as website','s.it_easy_store_email as storeemail','s.it_easy_address_1 as storeadd1','s.it_easy_address_2 as storeadd2','s.it_easy_city as storecity','s.it_easy_state as storestate','s.it_easy_pincode as storepin','s.it_easy_gst_number as storegst','o.it_easy_placed_time as dispatchtime','o.it_easy_order_id as orderid','o.it_easy_invoice_number as invoice','o.it_easy_order_number as ordernumber','o.it_easy_shipping_firstname as shipfirstname','o.it_easy_shipping_lastname as shiplastname','o.it_easy_shipping_mobile_number as shipmobilenumber','o.it_easy_shipping_city as shipcity','o.it_easy_shipping_address_1 as shipadd1','o.it_easy_shipping_address_2 as shipadd2','o.it_easy_shipping_state as shipstate','o.it_easy_shipping_pincode as shippin','od.it_easy_order_type as paymentmode','od.it_easy_collective_price as collectprice','od.it_easy_awb_number as awbnumber','od.it_easy_label_time as label_time','ship.it_easy_name as couriername'])

           ->leftJoin(ItEasyStore::tablename().' as s', 's.it_easy_id = o.it_easy_store_id')
           ->leftJoin(ItEasyOrderDispatch::tablename().' as od', 'od.it_easy_order_id = o.it_easy_order_id')
           ->leftJoin(ItEasyShippingApi::tablename().' as ship', 'od.it_easy_shipping_id = ship.it_easy_ship_id')
           //->leftJoin(ItEasyClickpostCourier::tablename().' as ship', 'od.it_easy_shipping_id = ship.cp_id')

           ->where(['in','o.it_easy_order_id',$orderid])->asArray()->all();
          return $query;

     } 
     
     public static function GetOrderStatusNamebymobile($mobilenumber){
        $order_count = ItEasyOrder::find()->select(['COUNT(*) AS cnt'])->where(['like', 'it_easy_mobile_number', $mobilenumber])->asArray()->all();
        if($order_count[0]['cnt'] > 1){
        return $order_count;
        }
    }


      public static function duplicateorderdata($mobilenumber){ 
       
        $query = ItEasyOrder::find()->from(['o' => ItEasyOrder::tablename()])->select(['o.*','os.it_easy_order_status_name as statusname','c.it_easy_coupon_code as couponcode','c.it_easy_discount as coupondiscount','u.it_easy_username as tlname','uto.it_easy_username as agentname','od.it_easy_order_disposition_name as disponame','op.it_easy_product_name as proname','op.it_easy_variation_name as provariation'])
           ->leftJoin(ItEasyOrderStatus::tablename().' as os', 'os.it_easy_order_status_id = o.it_easy_order_status_id')
           ->leftJoin(ItEasyCoupon::tablename().' as c', 'c.it_easy_id = o.it_easy_coupon_id')
           ->leftJoin(User::tablename().' as u', 'u.id = o.it_easy_assigned_by')
           ->leftJoin(User::tablename().' as uto', 'uto.id = o.it_easy_assigned_to')
           ->leftJoin(ItEasyOrderDisposition::tablename().' as od', 'od.it_easy_order_disposition_id = o.it_easy_order_disposition_id')
           ->leftJoin(ItEasyOrderProduct::tablename().' as op', 'op.it_easy_order_id = o.it_easy_order_id')
           ->where(['like','o.it_easy_mobile_number',$mobilenumber])->asArray()->all();
        
         $array_data = array('order'=>$query);

          echo json_encode($array_data);
          exit();
     }
     
     public static function Ordernumbers($params){
         if(Yii::$app->user->identity->id == '53'){
                //echo $data = $query->createCommand()->rawSql; die;
            // echo "<pre>"; print_r($params); die;
         }
         
        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'].' 00:00:00';
                $params['ItEasyOrderSearch']['date_from_date'] = $params['ItEasyOrderSearch']['date_from_date'].' 00:00:00';
        }else{
                $params['ItEasyOrderSearch']['date_from_date'] = date('Y-m-d').' 00:00:00';
                 $from_date = date('Y-m-d').' 00:00:00';
             
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
                
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
                $to_date = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
                $params['ItEasyOrderSearch']['date_to_date'] = date('Y-m-d H:i:s');
                $to_date = date('Y-m-d H:i:s');
            
        }
        
        $query = ItEasyOrder::find()->select(['COUNT(*) as total_leads', 'SUM(it_easy_total_price) as sum_total_leads', 'COUNT(CASE WHEN (`it_easy_assigned_to` <> "" OR `it_easy_retention_AGENTid` <> "") then 1 ELSE NULL END) AS assign_leads', 'COUNT(CASE WHEN (`it_easy_order_disposition_id` = "0" ) then 1 ELSE NULL END) AS pending_work_order', 'COUNT(CASE WHEN (`it_easy_assigned_to` = "" OR `it_easy_retention_AGENTid` = "") then 1 ELSE NULL END) AS unassign_leads', 'SUM(CASE WHEN (`it_easy_assigned_to` <> "" OR `it_easy_retention_AGENTid` <> "") then it_easy_total_price ELSE NULL END) AS assign_leads_amount', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6", "12", "14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END) AS confirm_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6", "12", "14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then it_easy_total_price ELSE 0 END) AS confirm_sum',  'ROUND( SUM(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then it_easy_total_price ELSE 0 END) / COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END), 2) as average_ticket'  , 'COUNT(CASE WHEN `it_easy_payment_code` != "COD" then 1 ELSE NULL END) AS prepaid_order', 'SUM(CASE WHEN `it_easy_payment_code` != "COD" then it_easy_total_price ELSE 0 END) AS prepaid_order_amount', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30") then 1 ELSE NULL END) AS dispatched_order_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30") then it_easy_total_price ELSE 0 END) AS dispatched_order_sum' ]);
        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if(isset($params['ItEasyOrderSearch']['date_type_filter']) && $params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if(isset($params['ItEasyOrderSearch']['date_type_filter']) && $params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if(isset($params['ItEasyOrderSearch']['date_type_filter']) && $params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['or', [ '<=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date'] ], [ '<=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_to_date'] ], ])
                         ->andWhere([ 'or', ['>=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']], ['>=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_from_date']], ]);
            }else if(isset($params['ItEasyOrderSearch']['date_type_filter']) && $params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if(isset($params['ItEasyOrderSearch']['date_type_filter']) && $params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if(isset($params['ItEasyOrderSearch']['date_type_filter']) && $params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else{
                $query->andWhere(['<=', 'it_easy_created_time', $to_date])
                         ->andWhere(['>=', 'it_easy_created_time', $from_date]);
            }
        }else{
            $query->andWhere(['<=', 'it_easy_created_time', $to_date])
                         ->andWhere(['>=', 'it_easy_created_time', $from_date]);
        }

        if((Yii::$app->user->identity->it_easy_dept_id == '4' || Yii::$app->user->identity->it_easy_dept_id == '9') && (Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5')){
            $query->andWhere(['it_easy_assigned_to' => Yii::$app->user->identity->id]);
        }

    
            // 
            if(Yii::$app->user->identity->id == '53'){
                //echo $data = $query->createCommand()->rawSql; die;
            // echo "<pre>"; print_r($today_report); die;
         }
        return $data = $query->asArray()->one();
    }
    
    
    
    public static function Orderndrnumbers($params){
         if(Yii::$app->user->identity->id == '53'){
                //echo $data = $query->createCommand()->rawSql; die;
            
         }
            
        $query = ItEasyOrder::find()->joinWith(['orderdispatch'])->from(['o' => ItEasyOrder::tablename()])->select(['COUNT(*) as total_leads', 'SUM(it_easy_total_price) as sum_total_leads', 'COUNT(CASE WHEN (`it_easy_ndr_agent` <> "") then 1 ELSE NULL END) AS assign_leads', 'COUNT(CASE WHEN (`it_easy_ndr_disposition_id` = "0" ) then 1 ELSE NULL END) AS pending_work_order', 'COUNT(CASE WHEN (`it_easy_ndr_agent` = "" OR `it_easy_ndr_agent` IS NULL) then 1 ELSE NULL END) AS unassign_leads', 'SUM(CASE WHEN (`it_easy_ndr_agent` <> "") then it_easy_total_price ELSE NULL END) AS assign_leads_amount', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("3") then 1 ELSE NULL END) AS delivered_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("3") then it_easy_total_price ELSE 0 END) AS delivered_sum',  'COUNT(CASE WHEN `it_easy_order_status_id` IN ("30") then 1 ELSE NULL END) AS OFD_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("30") then it_easy_total_price ELSE 0 END) AS OFD_sum' ])->where(['in','it_easy_order_status_id',[3, 4, 5, 6, 9,13,14,15,16, 22,23,26,27,28,29,30,31,45,47]]);
        
        
        
        if(isset($params['ItEasyNdr']['it_easy_ndr_disposition_id']) && !empty($params['ItEasyNdr']['it_easy_ndr_disposition_id']) && $params['ItEasyNdr']['it_easy_ndr_disposition_id'][0] != 'no_disposition'){
          $query->andFilterWhere(['IN','it_easy_ndr_disposition_id' , $params['ItEasyNdr']['it_easy_ndr_disposition_id']]);
        }else if(isset($params['ItEasyNdr']['it_easy_ndr_disposition_id']) && !empty($params['ItEasyNdr']['it_easy_ndr_disposition_id']) && $params['ItEasyNdr']['it_easy_ndr_disposition_id'][0] == 'no_disposition'){
            $query->andFilterWhere(['IS', 'it_easy_ndr_disposition_id', new \yii\db\Expression('NULL')]);
        }
        
        if(isset($params['ItEasyNdr']['it_easy_courier_name']) && !empty($params['ItEasyNdr']['it_easy_courier_name'])){
          $query->andFilterWhere(['it_easy_shipping_id' => $params['ItEasyNdr']['it_easy_courier_name']]);
        }
        
        if(isset($params['ItEasyNdr']['it_easy_attempt_count']) && !empty($params['ItEasyNdr']['it_easy_attempt_count'])){
          $query->andFilterWhere(['it_easy_attempt_count' => $params['ItEasyNdr']['it_easy_attempt_count'] ]);
        }
        
        if(isset($params['ItEasyNdr']['assign_type']) && !empty($params['ItEasyNdr']['assign_type'])){
                if($params['ItEasyNdr']['assign_type'] == 'Assign'){
                        $query->andWhere(['<>', 'it_easy_ndr_agent', '']);
                }else if($params['ItEasyNdr']['assign_type'] == 'Unassign'){
                    $query->andWhere(['or', ['it_easy_ndr_agent'=>'0'], ['it_easy_ndr_agent' => NULL] ]);
                }
        }
        
        
        
        if(isset($params['ItEasyNdr']['date_from_date']) && !empty($params['ItEasyNdr']['date_from_date'])){
            if(isset($params['ItEasyNdr']['date_type_filter']) && $params['ItEasyNdr']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyNdr']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyNdr']['date_from_date']]);
            }else if(isset($params['ItEasyNdr']['date_type_filter']) && $params['ItEasyNdr']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyNdr']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyNdr']['date_from_date']]);
            }else if(isset($params['ItEasyNdr']['date_type_filter']) && $params['ItEasyNdr']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['or', [ '<=', 'it_easy_lead_assign', $params['ItEasyNdr']['date_to_date'] ], [ '<=', 'it_easy_retention_assign_time', $params['ItEasyNdr']['date_to_date'] ], ])
                         ->andWhere([ 'or', ['>=', 'it_easy_lead_assign', $params['ItEasyNdr']['date_from_date']], ['>=', 'it_easy_retention_assign_time', $params['ItEasyNdr']['date_from_date']], ]);
            }else if(isset($params['ItEasyNdr']['date_type_filter']) && $params['ItEasyNdr']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyNdr']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyNdr']['date_from_date']]);
            }else if(isset($params['ItEasyNdr']['date_type_filter']) && $params['ItEasyNdr']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'it_easy_placed_time', $params['ItEasyNdr']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_placed_time', $params['ItEasyNdr']['date_from_date']]);
            }else if(isset($params['ItEasyNdr']['date_type_filter']) && $params['ItEasyNdr']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyNdr']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyNdr']['date_from_date']]);
            }else{
                     $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyNdr']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyNdr']['date_from_date']]);
                }
        }
        
        if(empty($params)){
              $query->andWhere(['>=', 'it_easy_updated_time', date('Y-m-d').' 00:00:00'])
                             ->andWhere(['<=', 'it_easy_updated_time', date('Y-m-d').' 23:59:59']);
        }
        
        //echo "<pre>"; print_r($params); die;
        
       
        if(isset($params['ItEasyNdr'])){
        $query->andFilterWhere(['like', 'o.it_easy_order_number', $params['ItEasyNdr']['it_easy_order_number']])
            ->andFilterWhere(['like', 'o.it_easy_mobile_number', $params['ItEasyNdr']['it_easy_mobile_number']])
            ->andFilterWhere(['like', 'it_easy_order_status_id', $params['ItEasyNdr']['it_easy_order_status_id']])
            ->andFilterWhere(['like', 'it_easy_attempt_count', $params['ItEasyNdr']['it_easy_attempt_count']])
            ->andFilterWhere(['like', 'o.it_easy_order_disposition_id', $params['ItEasyNdr']['it_easy_order_disposition_id']])
            ->andFilterWhere(['like', 'it_easy_awb_number', $params['ItEasyNdr']['it_easy_awb_number']]);
        }
        
        
        
        
        if(Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5'){
                $query->andWhere([ 'it_easy_ndr_agent' => Yii::$app->user->identity->id]);
        }

    
            // 
            //if(Yii::$app->user->identity->id == '53'){
                // echo "<pre>"; print_r($params);
                //echo $data = $query->createCommand()->rawSql; die;
            
         //}
        return $data = $query->asArray()->one();
                // $data = $query->asArray()->one();
                // echo "<pre>"; print_r($data); die;
    }   
    
    
    
    public static function ReportCourierWiseReport($params){
        // echo "<pre>"; print_r($params); die;
        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'];
        }else{
                 $from_date = date('Y-m-d').' 00:00:00'; 
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
                $params['ItEasyOrderSearch']['date_to_date']    = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
                $to_date = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
                $to_date = date('Y-m-d').' 23:59:59';
        }
        
        $query = ItEasyOrderDispatch::find()->from(['od' => ItEasyOrderDispatch::tablename()])->select(['sa.it_easy_name as courier_name', 'COUNT(CASE WHEN o.`it_easy_order_status_id` IN ("4", "5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then 1 ELSE NULL END) AS dispatched_order_count', 'SUM(CASE WHEN o.`it_easy_order_status_id` IN ("4", "5","3","6","14","15","16","23","26","27","28","29","30", "9", "22","47") then it_easy_total_price ELSE NULL END) AS dispatched_order_sum'])->leftJoin(ItEasyOrder::tablename().' as o', 'o.it_easy_order_id = od.it_easy_order_id')->leftJoin(ItEasyShippingApi::tablename().' as sa', 'sa.it_easy_ship_id = od.it_easy_shipping_id');
        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'o.it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'o.it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['<=', 'o.it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'o.it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'o.it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }
        }else{
            $query->andWhere(['<=', 'od.it_easy_placed_time', $to_date])
                         ->andWhere(['>=', 'od.it_easy_placed_time', $from_date]);
        }
            // echo $data = $query->groupBy(['od.it_easy_shipping_id'])->createCommand()->rawSql; die;
            return $data = $query->groupBy(['od.it_easy_shipping_id'])->asArray()->all();
    }



    public static function ReportProductWiseReport($params){
        // echo "<pre>"; print_r($params); die;
        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'];
        }else{
                 $from_date = date('Y-m-d').' 00:00:00'; 
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
            $params['ItEasyOrderSearch']['date_to_date']    = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
            $to_date = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
                $to_date = date('Y-m-d').' 23:59:59';
        }
        
        $query = ItEasyOrderDispatch::find()->from(['od' => ItEasyOrderDispatch::tablename()])->select(['op.it_easy_product_name as product_name','op.it_easy_variation_name as variation_name' , 'SUM(CASE WHEN `it_easy_order_status_id` IN ("4", "5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then op.it_easy_product_quantity ELSE 0 END) AS dispatched_order_count'])
            ->leftJoin(ItEasyOrder::tablename().' as o', 'o.it_easy_order_id = od.it_easy_order_id')
            ->leftJoin(ItEasyOrderProduct::tablename().' as op', 'op.it_easy_order_id = od.it_easy_order_id');
           
        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'o.it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'o.it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['<=', 'o.it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'o.it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'o.it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'o.it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }
        }else{
            $query->andWhere(['<=', 'od.it_easy_placed_time', $to_date])
                         ->andWhere(['>=', 'od.it_easy_placed_time', $from_date]);
        }
            // echo $data = $query->createCommand()->rawSql; die;
            return $data = $query->groupBy(['op.it_easy_product_id', 'op.it_easy_variation_id'])->asArray()->all();
    }
    
    // marketing code

     public static function ProductMarketerWiseAgentwisegettotalReport($params){
        // echo "<pre>"; print_r($params); die;
        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'];
        }else{
                 $from_date = date('Y-m').'-01'; 
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
                
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
                
                $to_date = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
                $to_date = date('Y-m-d').' 23:59:59';
        }
        
        $query = ItEasyOrder::find()->from(['o' => ItEasyOrder::tablename()])->select(['COUNT(DISTINCT(o.it_easy_order_id)) as total_assign', 'SUM(o.it_easy_ordered_amount) as ordered_ammount', 'it_easy_marketer_publisher', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END) AS confirm_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then it_easy_total_price ELSE NULL END) AS confirm_sum', 'ROUND(SUM(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then it_easy_total_price ELSE NULL END) / COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END)) as average_ticket_size ', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then 1 ELSE NULL END) AS dispatched_order_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then it_easy_total_price ELSE NULL END) AS dispatched_order_sum', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("3","6") then 1 ELSE NULL END) AS delivered_order_count',  'SUM(CASE WHEN `it_easy_order_status_id` IN ("3","6") then it_easy_total_price ELSE NULL END) AS delivered_order_sum', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("15") then 1 ELSE NULL END) AS rto_order_count']);
        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['<=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }
        }else{
            $query->andWhere(['<=', 'it_easy_created_time', $to_date])
                         ->andWhere(['>=', 'it_easy_created_time', $from_date]);
        }

        if(Yii::$app->user->identity->it_easy_dept_id == '4' && (Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5')){
            $query->andWhere(['it_easy_assigned_to' => Yii::$app->user->identity->id]);
        }else if(Yii::$app->user->identity->it_easy_dept_id == '4' && (Yii::$app->user->identity->it_easy_type_id == '3')){
            $query->andWhere(['it_easy_assigned_by' => Yii::$app->user->identity->id]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_by']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_by'])){
            $query->andWhere(['it_easy_assigned_by' => $params['ItEasyOrderSearch']['it_easy_assigned_by']]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_to']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_to'])){
            $query->andWhere(['it_easy_assigned_to' => $params['ItEasyOrderSearch']['it_easy_assigned_to']]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && !empty($params['ItEasyOrderSearch']['it_easy_first_status'])){
            $query->andWhere(['it_easy_first_status' => $params['ItEasyOrderSearch']['it_easy_first_status']]);
        }
        
            // echo $data = $query->createCommand()->rawSql; die;
            $query->groupBy(['o.it_easy_marketer_publisher'])->orderBy(['COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31") then 1 ELSE NULL END)' => SORT_DESC ]);

            // echo $data = $query->createCommand()->rawSql; die;
            return $data = $query->asArray()->all();
    } 
    
    public static function OneMarketingProductWiseAgentwisegettotalReport($params, $product_id, $variation_id){
        // echo "<pre>"; print_r($params); die;
        if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
               
                $from_date = $params['ItEasyOrderSearch']['date_from_date'];
        }else{
                 $from_date = date('Y-m').'-01'; 
        }
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
                
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
                
                $to_date = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
                $to_date = date('Y-m-d').' 23:59:59';
        }
        
        $query = ItEasyOrderProduct::find()->from(['op' => ItEasyOrderProduct::tablename()])->select(['COUNT(DISTINCT(o.it_easy_order_id)) as total_assign', 'SUM(o.it_easy_ordered_amount) as ordered_ammount','o.it_easy_marketer_publisher' ,'it_easy_product_name', 'it_easy_product_id', 'it_easy_variation_id', 'it_easy_variation_name', 'SUM(op.it_easy_product_quantity) as product_quantity', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END) AS confirm_count',  'SUM(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then it_easy_total_price ELSE NULL END) AS confirm_sum', 'ROUND(SUM(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then it_easy_total_price ELSE NULL END) / COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END)) as average_ticket_size ', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then 1 ELSE NULL END) AS dispatched_order_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("5","3","6","14","15","16","23","26","27","28","29","30", "9", "22", "47") then it_easy_total_price ELSE NULL END) AS dispatched_order_sum', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("3","6") then 1 ELSE NULL END) AS delivered_order_count', 'SUM(CASE WHEN `it_easy_order_status_id` IN ("3","6") then it_easy_total_price ELSE NULL END) AS delivered_order_sum', 'COUNT(CASE WHEN `it_easy_order_status_id` IN ("15") then 1 ELSE NULL END) AS rto_order_count'])->leftJoin(ItEasyOrder::tablename().' as o', 'op.it_easy_order_id = o.it_easy_order_id');
        if(isset($params['ItEasyOrderSearch']['date_from_date'])){
            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['<=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }
        }else{
            $query->andWhere(['<=', 'it_easy_created_time', $to_date])
                         ->andWhere(['>=', 'it_easy_created_time', $from_date]);
        }

        if(Yii::$app->user->identity->it_easy_dept_id == '4' && (Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5')){
            $query->andWhere(['it_easy_assigned_to' => Yii::$app->user->identity->id]);
        }else if(Yii::$app->user->identity->it_easy_dept_id == '4' && (Yii::$app->user->identity->it_easy_type_id == '3')){
            $query->andWhere(['it_easy_assigned_by' => Yii::$app->user->identity->id]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_by']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_by'])){
            $query->andWhere(['it_easy_assigned_by' => $params['ItEasyOrderSearch']['it_easy_assigned_by']]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_to']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_to'])){
            $query->andWhere(['it_easy_assigned_to' => $params['ItEasyOrderSearch']['it_easy_assigned_to']]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && !empty($params['ItEasyOrderSearch']['it_easy_first_status'])){
            $query->andWhere(['it_easy_first_status' => $params['ItEasyOrderSearch']['it_easy_first_status']]);
        }
        
        $query->andWhere(['it_easy_product_id' => $product_id]);
        $query->andWhere(['it_easy_variation_id' => $variation_id]);
        // echo $data = $query->createCommand()->rawSql; die;
        return $data = $query->asArray()->one();
    } 
}
