<?php

namespace backend\models;

use Yii;
use backend\models\ItEasyFinancialYear;

/**
 * This is the model class for table "it_easy_order_dispatch_2023_2024".
 *
 * @property int $it_easy_id
 * @property int $it_easy_order_id
 * @property string|null $it_easy_order_number
 * @property int $it_easy_shipping_id
 * @property int $it_easy_user_id
 * @property int $it_easy_department_id
 * @property string $it_easy_awb_number
 * @property string $it_easy_order_type
 * @property string $it_easy_firstname
 * @property string|null $it_easy_lastname
 * @property string $it_easy_address_1
 * @property string|null $it_easy_address_2
 * @property string $it_easy_city
 * @property string $it_easy_state
 * @property int $it_easy_state_id
 * @property string $it_easy_pincode
 * @property string $it_easy_mobile
 * @property string|null $it_easy_email
 * @property string|null $it_easy_alternate_mobile
 * @property float|null $it_easy_price
 * @property float|null $it_easy_collective_price
 * @property string|null $it_easy_order_date
 * @property string|null $it_easy_dispatch_time
 * @property string|null $it_easy_placed_time
 * @property string|null $it_easy_awb_time
 * @property string|null $it_easy_return_awb
 * @property string|null $it_easy_pickup_time
 * @property string|null $it_easy_zone_name
 * @property string|null $it_easy_courier_name
 * @property string|null $it_easy_subcourier_name
 * @property string|null $it_easy_order_status
 * @property string|null $it_easy_courier_comment
 * @property string|null $it_easy_status_updated_at
 * @property string|null $it_easy_first_scan_date
 * @property string|null $it_easy_last_scan_date
 * @property string|null $it_easy_first_attempted_date
 * @property string|null $it_easy_last_attempted_date
 * @property string|null $it_easy_delivery_date
 * @property string|null $it_easy_route_code
 * @property int $it_easy_picked
 * @property string|null $it_easy_auto_rto_date
 * @property string|null $it_easy_rto_date
 * @property int|null $it_easy_attempt_count
 * @property float|null $it_easy_courier_price
 * @property int|null $it_easy_rto_updated_by
 */
class ItEasyOrderDispatch extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */

    public static function tableName()
    {
        $get_f_year =  ItEasyFinancialYear::find()->select('it_easy_financial_year')->asArray()->where('CURDATE() between it_easy_date_from and it_easy_date_to')->One()['it_easy_financial_year'];
        return 'it_easy_order_dispatch_'.$get_f_year;
    }
    
    

    /**
     * {@inheritdoc}
     */
    
    public function rules()
    {
        return [
            [['it_easy_order_id', 'it_easy_shipping_id', 'it_easy_user_id', 'it_easy_department_id', 'it_easy_awb_number', 'it_easy_order_type', 'it_easy_firstname', 'it_easy_address_1', 'it_easy_city', 'it_easy_state', 'it_easy_state_id', 'it_easy_pincode', 'it_easy_mobile'], 'required'],
            [['it_easy_order_id', 'it_easy_shipping_id', 'it_easy_user_id', 'it_easy_department_id', 'it_easy_state_id', 'it_easy_picked', 'it_easy_attempt_count', 'it_easy_rto_updated_by'], 'integer'],
            [['it_easy_order_type'], 'string'],
            [['it_easy_price', 'it_easy_collective_price', 'it_easy_courier_price'], 'number'],
            [['it_easy_order_date', 'it_easy_dispatch_time', 'it_easy_placed_time', 'it_easy_awb_time', 'it_easy_pickup_time', 'it_easy_status_updated_at', 'it_easy_first_scan_date', 'it_easy_last_scan_date', 'it_easy_first_attempted_date', 'it_easy_last_attempted_date', 'it_easy_delivery_date', 'it_easy_auto_rto_date', 'it_easy_rto_date', 'it_easy_label_time'], 'safe'],
            [['it_easy_order_number', 'it_easy_city', 'it_easy_state'], 'string', 'max' => 60],
            [['it_easy_awb_number', 'it_easy_zone_name'], 'string', 'max' => 50],
            [['it_easy_firstname', 'it_easy_lastname'], 'string', 'max' => 80],
            [['it_easy_address_1', 'it_easy_address_2', 'it_easy_order_status'], 'string', 'max' => 150],
            [['it_easy_pincode'], 'string', 'max' => 10],
            [['it_easy_mobile', 'it_easy_alternate_mobile'], 'string', 'max' => 20],
            [['it_easy_email', 'it_easy_courier_name', 'it_easy_subcourier_name', 'it_easy_route_code'], 'string', 'max' => 100],
            [['it_easy_return_awb'], 'string', 'max' => 30],
            [['it_easy_courier_comment'], 'string', 'max' => 250],
            
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'It Easy ID',
            'it_easy_order_id' => 'It Easy Order ID',
            'it_easy_order_number' => 'It Easy Order Number',
            'it_easy_shipping_id' => 'Shipping ID',
            'it_easy_user_id' => 'User ID',
            'it_easy_department_id' => 'Department ID',
            'it_easy_awb_number' => 'Awb Number',
            'it_easy_order_type' => 'It Easy Order Type',
            'it_easy_firstname' => 'It Easy Firstname',
            'it_easy_lastname' => 'It Easy Lastname',
            'it_easy_address_1' => 'It Easy Address 1',
            'it_easy_address_2' => 'It Easy Address 2',
            'it_easy_city' => 'It Easy City',
            'it_easy_state' => 'It Easy State',
            'it_easy_state_id' => 'It Easy State ID',
            'it_easy_pincode' => 'It Easy Pincode',
            'it_easy_mobile' => 'It Easy Mobile',
            'it_easy_email' => 'It Easy Email',
            'it_easy_alternate_mobile' => 'It Easy Alternate Mobile',
            'it_easy_price' => 'It Easy Price',
            'it_easy_collective_price' => 'It Easy Collective Price',
            'it_easy_order_date' => 'It Easy Order Date',
            'it_easy_dispatch_time' => 'It Easy Dispatch Time',
            'it_easy_placed_time' => 'It Easy Placed Time',
            'it_easy_awb_time' => 'It Easy Awb Time',
            'it_easy_return_awb' => 'It Easy Return Awb',
            'it_easy_pickup_time' => 'It Easy Pickup Time',
            'it_easy_zone_name' => 'It Easy Zone Name',
            'it_easy_courier_name' => 'It Easy Courier Name',
            'it_easy_subcourier_name' => 'It Easy Subcourier Name',
            'it_easy_order_status' => 'It Easy Order Status',
            'it_easy_courier_comment' => 'It Easy Courier Comment',
            'it_easy_status_updated_at' => 'It Easy Status Updated At',
            'it_easy_first_scan_date' => 'It Easy First Scan Date',
            'it_easy_last_scan_date' => 'It Easy Last Scan Date',
            'it_easy_first_attempted_date' => 'It Easy First Attempted Date',
            'it_easy_last_attempted_date' => 'It Easy Last Attempted Date',
            'it_easy_delivery_date' => 'It Easy Delivery Date',
            'it_easy_route_code' => 'It Easy Route Code',
            'it_easy_picked' => 'It Easy Picked',
            'it_easy_auto_rto_date' => 'It Easy Auto Rto Date',
            'it_easy_rto_date' => 'It Easy Rto Date',
            'it_easy_attempt_count' => 'It Easy Attempt Count',
            'it_easy_courier_price' => 'It Easy Courier Price',
            'it_easy_rto_updated_by' => 'It Easy Rto Updated By',
        ];
    }
    
    public static function getAwbnumberdata($awb_number, $shipping_id){
        $d_data = ItEasyOrderDispatch::find()->andWhere(['it_easy_shipping_id' => $shipping_id ])->andWhere([ 'it_easy_awb_number' => $awb_number]);
        echo $d_data->createCommand()->rawSql; die;
        return $d_data;
    }
}
