<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyOrderDispatch;

/**
 * ItEasyOrderDispatchSearch represents the model behind the search form of `backend\models\ItEasyOrderDispatch`.
 */
class ItEasyOrderDispatchSearch extends ItEasyOrderDispatch
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_id', 'it_easy_order_id', 'it_easy_shipping_id', 'it_easy_user_id', 'it_easy_department_id', 'it_easy_state_id', 'it_easy_picked', 'it_easy_attempt_count', 'it_easy_rto_updated_by'], 'integer'],
            [['it_easy_order_number', 'it_easy_awb_number', 'it_easy_order_type', 'it_easy_firstname', 'it_easy_lastname', 'it_easy_address_1', 'it_easy_address_2', 'it_easy_city', 'it_easy_state', 'it_easy_pincode', 'it_easy_mobile', 'it_easy_email', 'it_easy_alternate_mobile', 'it_easy_order_date', 'it_easy_dispatch_time', 'it_easy_placed_time', 'it_easy_awb_time', 'it_easy_return_awb', 'it_easy_pickup_time', 'it_easy_zone_name', 'it_easy_courier_name', 'it_easy_subcourier_name', 'it_easy_order_status', 'it_easy_courier_comment', 'it_easy_status_updated_at', 'it_easy_first_scan_date', 'it_easy_last_scan_date', 'it_easy_first_attempted_date', 'it_easy_last_attempted_date', 'it_easy_delivery_date', 'it_easy_route_code', 'it_easy_auto_rto_date', 'it_easy_rto_date'], 'safe'],
            [['it_easy_price', 'it_easy_collective_price', 'it_easy_courier_price'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyOrderDispatch::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['it_easy_updated_time' => SORT_DESC]],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_id' => $this->it_easy_id,
            'it_easy_order_id' => $this->it_easy_order_id,
            'it_easy_shipping_id' => $this->it_easy_shipping_id,
            'it_easy_user_id' => $this->it_easy_user_id,
            'it_easy_department_id' => $this->it_easy_department_id,
            'it_easy_state_id' => $this->it_easy_state_id,
            'it_easy_price' => $this->it_easy_price,
            'it_easy_collective_price' => $this->it_easy_collective_price,
            'it_easy_order_date' => $this->it_easy_order_date,
            'it_easy_dispatch_time' => $this->it_easy_dispatch_time,
            'it_easy_placed_time' => $this->it_easy_placed_time,
            'it_easy_awb_time' => $this->it_easy_awb_time,
            'it_easy_pickup_time' => $this->it_easy_pickup_time,
            'it_easy_status_updated_at' => $this->it_easy_status_updated_at,
            'it_easy_first_scan_date' => $this->it_easy_first_scan_date,
            'it_easy_last_scan_date' => $this->it_easy_last_scan_date,
            'it_easy_first_attempted_date' => $this->it_easy_first_attempted_date,
            'it_easy_last_attempted_date' => $this->it_easy_last_attempted_date,
            'it_easy_delivery_date' => $this->it_easy_delivery_date,
            'it_easy_picked' => $this->it_easy_picked,
            'it_easy_auto_rto_date' => $this->it_easy_auto_rto_date,
            'it_easy_rto_date' => $this->it_easy_rto_date,
            'it_easy_attempt_count' => $this->it_easy_attempt_count,
            'it_easy_courier_price' => $this->it_easy_courier_price,
            'it_easy_rto_updated_by' => $this->it_easy_rto_updated_by,
        ]);

        $query->andFilterWhere(['like', 'it_easy_order_number', $this->it_easy_order_number])
            ->andFilterWhere(['like', 'it_easy_awb_number', $this->it_easy_awb_number])
            ->andFilterWhere(['like', 'it_easy_order_type', $this->it_easy_order_type])
            ->andFilterWhere(['like', 'it_easy_firstname', $this->it_easy_firstname])
            ->andFilterWhere(['like', 'it_easy_lastname', $this->it_easy_lastname])
            ->andFilterWhere(['like', 'it_easy_address_1', $this->it_easy_address_1])
            ->andFilterWhere(['like', 'it_easy_address_2', $this->it_easy_address_2])
            ->andFilterWhere(['like', 'it_easy_city', $this->it_easy_city])
            ->andFilterWhere(['like', 'it_easy_state', $this->it_easy_state])
            ->andFilterWhere(['like', 'it_easy_pincode', $this->it_easy_pincode])
            ->andFilterWhere(['like', 'it_easy_mobile', $this->it_easy_mobile])
            ->andFilterWhere(['like', 'it_easy_email', $this->it_easy_email])
            ->andFilterWhere(['like', 'it_easy_alternate_mobile', $this->it_easy_alternate_mobile])
            ->andFilterWhere(['like', 'it_easy_return_awb', $this->it_easy_return_awb])
            ->andFilterWhere(['like', 'it_easy_zone_name', $this->it_easy_zone_name])
            ->andFilterWhere(['like', 'it_easy_courier_name', $this->it_easy_courier_name])
            ->andFilterWhere(['like', 'it_easy_subcourier_name', $this->it_easy_subcourier_name])
            ->andFilterWhere(['like', 'it_easy_order_status', $this->it_easy_order_status])
            ->andFilterWhere(['like', 'it_easy_courier_comment', $this->it_easy_courier_comment])
            ->andFilterWhere(['like', 'it_easy_route_code', $this->it_easy_route_code]);

        return $dataProvider;
    }
}
