<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_order_disposition".
 *
 * @property int $it_easy_order_disposition_id
 * @property string $it_easy_order_disposition_name
 * @property string $it_easy_status
 * @property string|null $created_time
 * @property string|null $updated_time
 * @property int|null $created_by
 * @property int|null $updated_by
 */
class ItEasyOrderDisposition extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_order_disposition';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_order_disposition_name', 'it_easy_status'], 'required'],
            [['it_easy_status'], 'string'],
            [['created_time', 'updated_time'], 'safe'],
            [['created_by', 'updated_by'], 'integer'],
            [['it_easy_order_disposition_name'], 'string', 'max' => 70],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_order_disposition_id' => 'Order Disposition ID',
            'it_easy_order_disposition_name' => 'Order Disposition Name',
            'it_easy_status' => 'Status',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
        ];
    }
}
