<?php

namespace backend\models;

use Yii;
use backend\models\ItEasyFinancialYear;

/**
 * This is the model class for table "it_easy_order_ndr_status_history_2023_2024".
 *
 * @property int $it_easy_id
 * @property int $it_easy_order_id
 * @property int $it_easy_order_status_id
 * @property string|null $it_easy_comment
 * @property string|null $it_easy_created_time
 */
class ItEasyOrderNdrStatusHistory extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {	
      	$get_financial_year = ItEasyFinancialYear::getFinancialyear();
        return 'it_easy_order_ndr_status_history_'.$get_financial_year;
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_order_id', 'it_easy_order_status_id'], 'required'],
            [['it_easy_order_id', 'it_easy_order_status_id'], 'integer'],
            [['it_easy_created_time'], 'safe'],
            [['it_easy_comment'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'It Easy ID',
            'it_easy_order_id' => 'It Easy Order ID',
            'it_easy_order_status_id' => 'It Easy Order Status ID',
            'it_easy_comment' => 'It Easy Comment',
            'it_easy_created_time' => 'It Easy Created Time',
        ];
    }
}
