<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_order_product_20223_2024".
 *
 * @property int $it_easy_id
 * @property int $it_easy_order_id
 * @property int $it_easy_product_id
 * @property string $it_easy_product_name
 * @property float $it_easy_product_price
 * @property int $it_easy_product_quantity
 * @property string $it_easy_product_sku
 * @property float $it_easy_product_total
 * @property float $it_easy_product_tax
 * @property string|null $created_time
 * @property string|null $updated_time
 */
class ItEasyOrderProduct extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {   
        $today_date = date('Y-m-d');

        $ge_financial = ItEasyFinancialYear::find()->select(['it_easy_financial_year'])->where(['or',['<=', 'it_easy_date_from', $today_date], ['>=', 'it_easy_date_to', $today_date] ])->asArray()->one();
        return 'it_easy_order_product_'.$ge_financial['it_easy_financial_year'];
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_order_id',  'it_easy_product_name', 'it_easy_product_price', 'it_easy_product_sku', 'it_easy_product_total', 'it_easy_product_tax'], 'required'],
            ['it_easy_product_id', 'required', 'on' => 'create'],
            [['it_easy_order_id', 'it_easy_product_id', 'it_easy_product_quantity'], 'integer'],
            [['it_easy_product_price', 'it_easy_product_total', 'it_easy_product_tax'], 'number'],
            [['created_time', 'updated_time'], 'safe'],
            [['it_easy_product_name', 'it_easy_product_sku'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'It Easy ID',
            'it_easy_order_id' => 'It Easy Order ID',
            'it_easy_product_id' => 'It Easy Product ID',
            'it_easy_product_name' => 'It Easy Product Name',
            'it_easy_product_price' => 'It Easy Product Price',
            'it_easy_product_quantity' => 'It Easy Product Quantity',
            'it_easy_product_sku' => 'It Easy Product Sku',
            'it_easy_product_total' => 'It Easy Product Total',
            'it_easy_product_tax' => 'It Easy Product Tax',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
        ];
    }
}
