<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyOrder;
use common\models\User;
use yii\helpers\ArrayHelper;
use yii\data\ArrayDataProvider;

/**
 * ItEasyOrderSearch represents the model behind the search form of `backend\models\ItEasyOrder`.
 */
class ItEasyOrderSearch extends ItEasyOrder
{
    /**
     * {@inheritdoc}
     */
    public $it_easy_courier_name;
    public $it_easy_servisable_name;
    public $it_easy_awb_number;
    public $it_easy_label_generated;
    public function rules()
    {
        return [
            [['it_easy_order_id', 'it_easy_store_id', 'it_easy_customer_id', 'it_easy_shipping_state_id', 'it_easy_billing_gst_status', 'it_easy_billing_state_id', 'it_easy_department_id',  'it_easy_ndr_tl', 'it_easy_ndr_agent', 'it_easy_read_status', 'it_easy_address_verify_by', 'it_easy_marketer_id', 'it_easy_retention_AGENTid', 'it_easy_retention_TLid'], 'integer'],
            [['it_easy_financial_year', 'it_easy_retention_assign_time', 'it_easy_order_number', 'it_easy_invoice_number', 'it_easy_store_name', 'it_easy_other_order_id', 'it_easy_firstname', 'it_easy_lastname', 'it_easy_mobile_number', 'it_easy_alternate_number', 'it_easy_email', 'it_easy_address_1', 'it_easy_address_2', 'it_easy_city', 'it_easy_state', 'it_easy_pincode', 'it_easy_fax', 'it_easy_country', 'it_easy_shipping_firstname', 'it_easy_shipping_lastname', 'it_easy_shipping_mobile_number', 'it_easy_shipping_alternate_number', 'it_easy_shipping_email', 'it_easy_shipping_address_1', 'it_easy_shipping_address_2', 'it_easy_shipping_city', 'it_easy_shipping_state', 'it_easy_shipping_pincode', 'it_easy_shipping_country', 'it_easy_billing_company_name', 'it_easy_billing_gst', 'it_easy_billing_firstname', 'it_easy_billing_lastname', 'it_easy_billing_mobile', 'it_easy_billing_alternate_number', 'it_easy_billing_email', 'it_easy_billing_address_1', 'it_easy_billing_address_2', 'it_easy_billing_city', 'it_easy_billing_state', 'it_easy_billing_pincode', 'it_easy_billing_country', 'it_easy_payment_method', 'it_easy_payment_code', 'it_easy_shipping_method', 'it_easy_shipping_code', 'it_easy_order_serviceable', 'it_easy_comment', 'it_easy_first_status', 'it_easy_marketer_publisher', 'it_easy_marketer_click_id', 'it_easy_client_ip', 'it_easy_server_ip', 'it_easy_device', 'it_easy_browser', 'it_easy_previous_url', 'it_easy_page_url', 'it_easy_created_time', 'it_easy_updated_time', 'it_easy_assign_time', 'it_easy_placed_time', 'it_easy_delivered_time', 'date_type_filter', 'date_from_date', 'date_to_date', 'assign_type', 'it_easy_order_status_id', 'it_easy_state_id', 'it_easy_assigned_by', 'it_easy_assigned_to','it_easy_disease_name','it_easy_course_duration','it_easy_age', 'it_easy_order_disposition_id', 'it_easy_courier_name','it_easy_servisable_name','it_easy_awb_number','it_easy_label_generated', 'it_easy_platform','it_easy_new_invoice_number'], 'safe'],
            [['it_easy_total_price', 'it_easy_gst_price','it_easy_age'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {       
        //   echo "<pre>"; print_r($params); die();
        // $query = ItEasyOrder::find()->from(['o' => ItEasyOrder::tablename()]);
        $query = ItEasyOrder::find()->from(['o' => ItEasyOrder::tablename()])->joinWith(['orderdispatch']);
        if(isset($params['export']) && !empty($params['export'])){
            // echo Yii::$app->user->identity->id; die;
            $query->from(['o' => ItEasyOrder::tablename()])->joinWith(['orderstatus', 'orderdisposition', 'assignagent', 'assigntl', 'orderdispatch', 'retentionassigntl', 'retentionassignagent', 'department'])->select(['de.it_easy_depart_name as Department_Name','o.it_easy_order_id as order_id', 'o.it_easy_platform as platform_name', 'o.it_easy_transaction_id as transaction_id', 'o.it_easy_order_number as order_number', 'it_easy_awb_number as awb_number', 'it_easy_courier_name as courier_name', 'o.it_easy_other_order_id as other_order_id', 'o.it_easy_invoice_number as invoice_number', 'o.it_easy_total_price as total_price', 'o.it_easy_gst_price as GST_Price', 'o.it_easy_first_status as First_Status', 'it_easy_order_status_name as Status_Name', 'it_easy_order_disposition_name as Disposition_Name',  'CONCAT(o.it_easy_firstname," ",o.it_easy_firstname) as customer', 'o.it_easy_mobile_number as mobile_number', 'o.it_easy_email as customer_email', 'o.it_easy_address_1 as Address_1', 'o.it_easy_address_2 as Address_2', 'o.it_easy_city as City', 'o.it_easy_state as State', 'o.it_easy_pincode as Pincode', 'u2.it_easy_username as TL_username', 'u.it_easy_username as Agent_Username',  'ru.it_easy_username as RetentionTL_username', 'ru2.it_easy_username as RetentionAgent_Username', 'it_easy_marketer_publisher as Marketer_Publisher', 'it_easy_marketer_click_id as Click_ID', 'o.it_easy_created_time as Created_Time', 'o.it_easy_updated_time as Updated_Time', 'o.it_easy_assign_time as AWB_Assigned_Time', 'o.it_easy_lead_assign as lead_Assigned_Time', 'od.it_easy_placed_time as Placed_Time', 'o.it_easy_converted_time as Confirmation_Time', 'o.it_easy_delivered_time as Delivered_Time','o.it_easy_state_id', 'o.it_easy_payment_code as payment_type', 'o.it_easy_payment_method as payment_method', 'o.it_easy_confirmation_id as Confirmation_username', 'o.it_easy_order_place_time as order_place_time', 'it_easy_flag']);

            // echo "<pre>"; print_r($query); die;
        }
        
        if(isset(Yii::$app->user->identity->it_easy_dept_id) && (Yii::$app->user->identity->it_easy_dept_id == '9')){
            
                $filter_date_days = date('Y-m-d', strtotime('-15 days'));
                $filter_date_month = date('Y-m-d', strtotime('-1 month'));
                $query->andWhere(['or',
                    [
                        'and',
                        ['it_easy_course_duration' => '1 month'],
                        ['<', 'date(od.it_easy_placed_time)', $filter_date_month]
                    ],
                    [
                        'and',
                        ['it_easy_course_duration' => '15 days'],
                        ['<', 'date(od.it_easy_placed_time)', $filter_date_days]
                    ],
                    
                    [
                        'or',
                        ['<>', 'it_easy_retention_TLid', ''],
                        ['<>', 'it_easy_retention_AGENTid', '']
                    ],
                ]);
        }
        
        if(isset(Yii::$app->user->identity->it_easy_platform)){
            $platform = explode(',', Yii::$app->user->identity->it_easy_platform);
            $query->andWhere(['IN', 'o.it_easy_platform', $platform]);
        }

        // add conditions that should always apply here
        if(isset(Yii::$app->user->identity->it_easy_dept_id) && (Yii::$app->user->identity->it_easy_dept_id == '9') && (Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5')){
            
            $dataProvider = new ActiveDataProvider([
                'query' => $query,
                'sort'=> ['defaultOrder' => ['it_easy_retention_assign_time' => SORT_DESC]],
            ]);
            
        }else{
            $dataProvider = new ActiveDataProvider([
                'query' => $query,
                'sort'=> ['defaultOrder' => ['it_easy_order_id' => SORT_DESC]],
            ]);
        }

        

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }
          

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_order_id' => $this->it_easy_order_id,
            'it_easy_store_id' => $this->it_easy_store_id,
            'it_easy_customer_id' => $this->it_easy_customer_id,
          	'o.it_easy_state_id' => $this->it_easy_state_id,
            'o.it_easy_order_status_id' => $this->it_easy_order_status_id,
            // 'it_easy_order_disposition_id' => $this->it_easy_order_disposition_id,
            'it_easy_ndr_disposition_id' => $this->it_easy_ndr_disposition_id,
            'it_easy_ndr_status_id' => $this->it_easy_ndr_status_id,
            'it_easy_department_id' => $this->it_easy_department_id,
            // 'it_easy_assigned_by' => $this->it_easy_assigned_by,
            // 'it_easy_assigned_to' => $this->it_easy_assigned_to,
            'it_easy_ndr_tl' => $this->it_easy_ndr_tl,
            'it_easy_ndr_agent' => $this->it_easy_ndr_agent,
            'o.it_easy_email' => $this->it_easy_email,
        ]);
        
        // --- Courier Partner Filter ---
if (isset($params['ItEasyOrderSearch']['it_easy_courier_name']) && !empty($params['ItEasyOrderSearch']['it_easy_courier_name'])) {
    // Filter by courier shipping ID or name from dispatch table
    $query->andFilterWhere(['od.it_easy_shipping_id' => $this->it_easy_courier_name]);
    // OR if your dropdown gives courier name instead of ID:
    // $query->andFilterWhere(['like', 'od.it_easy_courier_name', $this->it_easy_courier_name]);
}
        
        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_by']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_by'])){
          $query->andFilterWhere(['or',['o.it_easy_assigned_by'=>$this->it_easy_assigned_by], ['o.it_easy_retention_TLid'=>$this->it_easy_assigned_by] ]);
        }
        
        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_to']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_to'])){
          $query->andFilterWhere(['or',['o.it_easy_assigned_to'=>$this->it_easy_assigned_to], ['o.it_easy_retention_AGENTid'=>$this->it_easy_assigned_to] ]);
        }
        
        
        if(isset($params['ItEasyOrderSearch']['it_easy_order_disposition_id']) && !empty($params['ItEasyOrderSearch']['it_easy_order_disposition_id']) && $params['ItEasyOrderSearch']['it_easy_order_disposition_id'] != 'no_disposition'){
          $query->andFilterWhere(['o.it_easy_order_disposition_id'=>$this->it_easy_order_disposition_id]);
        }else if(isset($params['ItEasyOrderSearch']['it_easy_order_disposition_id']) && !empty($params['ItEasyOrderSearch']['it_easy_order_disposition_id']) && $params['ItEasyOrderSearch']['it_easy_order_disposition_id'] == 'no_disposition'){
            $query->andFilterWhere(['IS', 'o.it_easy_order_disposition_id', new \yii\db\Expression('NULL')])->orWhere(['o.it_easy_order_disposition_id'=>0]);
        }
        
            if(isset($params['ItEasyOrderSearch']['it_easy_order_number']) && !empty($params['ItEasyOrderSearch']['it_easy_order_number'])){
                $query->andFilterWhere(['o.it_easy_order_number' => $this->it_easy_order_number]);
            }else if(isset($params['ItEasyOrderSearch']['it_easy_mobile_number']) && !empty($params['ItEasyOrderSearch']['it_easy_mobile_number'])){
                $query->andFilterWhere(['like', 'o.it_easy_mobile_number', $this->it_easy_mobile_number]);
            }else if(isset($params['ItEasyOrderSearch']['it_easy_awb_number']) && !empty($params['ItEasyOrderSearch']['it_easy_awb_number'])){
                $query->andFilterWhere(['like', 'od.it_easy_awb_number', $this->it_easy_awb_number]);
            }else if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
                if(empty($params['ItEasyOrderSearch']['date_to_date'])){
                    $params['ItEasyOrderSearch']['date_to_date'] = date('Y-m-d').' 23:59:59';
                }else{
                    $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
                }
                if(empty($params['ItEasyOrderSearch']['date_to_date'])){
                    $params['ItEasyOrderSearch']['date_to_date'] = date('Y-m-d');
                }

                if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                        $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                        $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    if(isset(Yii::$app->user->identity->it_easy_dept_id) && (Yii::$app->user->identity->it_easy_dept_id == '9')){
                        $query->andWhere(['<=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_from_date']]);
                        
                    }else{
                        $query->andWhere(['or', ['<=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']], ['<=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_to_date']] ])
                             ->andWhere(['or', ['>=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']], ['>=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_from_date']]]);
                    }
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                        $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                        $query->andWhere(['<=', 'o.it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'o.it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                        $query->andWhere(['<=', 'o.it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'o.it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Order Place via Agent'){
                        $query->andWhere(['<=', 'o.it_easy_order_place_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'o.it_easy_order_place_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else{
                    
                    if(isset(Yii::$app->user->identity->it_easy_dept_id) && (Yii::$app->user->identity->it_easy_dept_id == '9')){
                        $query->andWhere(['<=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_from_date']]);
                        
                    }else{
                        $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
                    }
                }
            }else{
                
                 if((isset(Yii::$app->user->identity->it_easy_dept_id) && (Yii::$app->user->identity->it_easy_dept_id == '9')) && (Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5')){
                     $query->andWhere(['>=', 'it_easy_retention_assign_time', date('Y-m-d').' 00:00:00'])
                             ->andWhere(['<=', 'it_easy_retention_assign_time', date('Y-m-d').' 23:59:59']);
                 }else{
                    $query->andWhere(['>=', 'it_easy_created_time', date('Y-m-d').' 00:00:00'])
                             ->andWhere(['<=', 'it_easy_created_time', date('Y-m-d').' 23:59:59']);
                 }
            }

        if(isset($params['ItEasyOrderSearch']['assign_type']) && !empty($params['ItEasyOrderSearch']['assign_type'])){
                if($params['ItEasyOrderSearch']['assign_type'] == 'Assign'){
                    if(isset(Yii::$app->user->identity->it_easy_dept_id) && Yii::$app->user->identity->it_easy_dept_id == '9'){
                        $query->andWhere(['<>', 'it_easy_retention_AGENTid', '']);
                    }else{
                        $query->andWhere(['<>', 'it_easy_assigned_to', '']);
                    }
                }else if($params['ItEasyOrderSearch']['assign_type'] == 'Unassign'){
                    if(isset(Yii::$app->user->identity->it_easy_dept_id) && Yii::$app->user->identity->it_easy_dept_id == '9'){
                        $query->andWhere(['or', ['it_easy_retention_AGENTid'=>'0'], ['it_easy_retention_AGENTid' => NULL] ]);
                    }else{
                        $query->andWhere(['or', ['it_easy_assigned_to'=>'0'], ['it_easy_assigned_to' => NULL] ]);
                    }
                }
        }
      
        // if(empty($params)){
        //       $query->andWhere(['>=', 'it_easy_created_time', date('Y-m-d').' 00:00:00'])
        //                      ->andWhere(['<=', 'it_easy_created_time', date('Y-m-d').' 23:59:59']);
        // }
      
        $query->andFilterWhere(['like', 'it_easy_financial_year', $this->it_easy_financial_year])
            ->andFilterWhere(['like', 'o.it_easy_order_number', $this->it_easy_order_number])
            ->andFilterWhere(['like', 'it_easy_invoice_number', $this->it_easy_invoice_number])
            ->andFilterWhere(['like', 'o.it_easy_platform', $this->it_easy_platform])
            ->andFilterWhere(['like', 'it_easy_store_name', $this->it_easy_store_name])
            ->andFilterWhere(['like', 'it_easy_other_order_id', $this->it_easy_other_order_id])
            ->andFilterWhere(['like', 'it_easy_city', $this->it_easy_city])
            ->andFilterWhere(['like', 'it_easy_state', $this->it_easy_state])
            ->andFilterWhere(['like', 'it_easy_pincode', $this->it_easy_pincode])
            ->andFilterWhere(['like', 'o.it_easy_payment_code', $this->it_easy_payment_code])
            ->andFilterWhere(['like', 'it_easy_shipping_code', $this->it_easy_shipping_code])
            ->andFilterWhere(['like', 'o.it_easy_first_status', $this->it_easy_first_status])
            ->andFilterWhere(['like', 'it_easy_marketer_publisher', $this->it_easy_marketer_publisher])
            ->andFilterWhere(['like', 'it_easy_marketer_click_id', $this->it_easy_marketer_click_id]);
  
    //  	echo $query->createCommand()->getRawSql();die;

         // 
        if(Yii::$app->user->identity->it_easy_dept_id == '4'){
            if(Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5'){
                $query->andWhere([ 'it_easy_assigned_to' => Yii::$app->user->identity->id]);
            }
        }else if(Yii::$app->user->identity->it_easy_dept_id == '9'){
             if(Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5'){
                 $query->andWhere([ 'it_easy_retention_AGENTid' => Yii::$app->user->identity->id]);
             }
        } 
        if(Yii::$app->user->identity->id == '1'){
            //echo $query->createCommand()->getRawSql(); die;
         }
        

        if(isset($params['export']) && !empty($params['export'])){
            return $query;
        }else{    
            return $dataProvider;
        }
    }
    
    
    public function getordermanifest3($params){
        
        $query = ItEasyOrder::find()->joinWith(['orderdispatch'])->from(['o' => ItEasyOrder::tablename()])->select(['count(*) as count_order', 'od.it_easy_courier_name']);
        
        if(isset($params['ItEasyOrderSearch']['it_easy_courier_name']) && !empty($params['ItEasyOrderSearch']['it_easy_courier_name'])){
          $query->andFilterWhere(['it_easy_shipping_id' => $this->it_easy_courier_name]);
        }
        if(isset(Yii::$app->user->identity->it_easy_platform)){
            $platform = explode(',', Yii::$app->user->identity->it_easy_platform);
            $query->andWhere(['IN', 'o.it_easy_platform', $platform]);
        }
        
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
            $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
            
            $to_date = date('Y-m-d').' 23:59:59';
            $from_date = date('Y-m-d');
        }
      	if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){

                if(empty($params['ItEasyOrderSearch']['date_to_date'])){
                  $params['ItEasyOrderSearch']['date_to_date'] = date('Y-m-d').' 23:59:59';
                }
                    $query->andWhere(['<=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                    ->andWhere(['>=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
        }else{
            
            $query->andWhere(['<=', 'od.it_easy_placed_time', $to_date])
                     ->andWhere(['>=', 'od.it_easy_placed_time', $from_date]);
        }
            $query->andWhere(['NOT IN', 'od.it_easy_shipping_id', ['', NULL]]);
        return $data = $query->groupby(['od.it_easy_shipping_id'])->asArray()->all();
        
        // echo "<pre>"; print_r($data); die;
        
    }
    
    
    public function search2($params)
    {
        //   $query = ItEasyOrder::find();
          $query = ItEasyOrder::find()->joinWith(['orderdispatch'])->from(['o' => ItEasyOrder::tablename()]);
          if(Yii::$app->controller->id == 'order-dispatch' && Yii::$app->controller->action->id == 'assign'){
            $query->where(['it_easy_order_status_id' => '24']);
          }else if(Yii::$app->controller->id == 'order-dispatch' && Yii::$app->controller->action->id == 'manifest'){
            $query->where(['IN', 'it_easy_order_status_id', ['3', '4', '5', '6', '9','14', '2', '15', '16', '22', '23', '26', '27', '28','29', '30', '31' ]]);
          }else{
            $query->where(['it_easy_order_status_id' => '1']);
          }
          
          if(isset(Yii::$app->user->identity->it_easy_platform)){
            $platform = explode(',', Yii::$app->user->identity->it_easy_platform);
            $query->andWhere(['IN', 'o.it_easy_platform', $platform]);
        }
          
          if(isset(Yii::$app->user->identity->it_easy_dept_id) && (Yii::$app->user->identity->it_easy_dept_id == '9') && (Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5')){
            
            $dataProvider = new ActiveDataProvider([
                'query' => $query,
                'sort'=> ['defaultOrder' => ['it_easy_retention_assign_time' => SORT_DESC]],
            ]);
            
        }else{
            $dataProvider = new ActiveDataProvider([
                  'query' => $query,
                  'sort'=> ['defaultOrder' => ['it_easy_updated_time' => SORT_DESC]],
              ]);
        }

          

          $this->load($params);

          if (!$this->validate()) {
              // uncomment the following line if you do not want to return any records when validation fails
              // $query->where('0=1');
              return $dataProvider;
          }
          
          

          // grid filtering conditions
          $query->andFilterWhere([
            'it_easy_order_id' => $this->it_easy_order_id,
            'it_easy_store_id' => $this->it_easy_store_id,
            'o.it_easy_state_id' => $this->it_easy_state_id,
            'o.it_easy_order_status_id' => $this->it_easy_order_status_id,
            'it_easy_order_disposition_id' => $this->it_easy_order_disposition_id,
            'it_easy_ndr_disposition_id' => $this->it_easy_ndr_disposition_id,
            'it_easy_ndr_status_id' => $this->it_easy_ndr_status_id,
            'it_easy_department_id' => $this->it_easy_department_id,
            'it_easy_assigned_by' => $this->it_easy_assigned_by,
            'it_easy_assigned_to' => $this->it_easy_assigned_to,
            'it_easy_ndr_tl' => $this->it_easy_ndr_tl,
            'it_easy_ndr_agent' => $this->it_easy_ndr_agent,
        ]);
        
        if(isset($params['ItEasyOrderSearch']['it_easy_courier_name']) && !empty($params['ItEasyOrderSearch']['it_easy_courier_name'])){
          $query->andFilterWhere(['it_easy_shipping_id' => $this->it_easy_courier_name]);
        }
        
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
            $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
            
            $to_date = date('Y-m-d').' 23:59:59';
            $from_date = date('Y-m-d');
        }
      	if(isset($params['ItEasyOrderSearch']['it_easy_order_number']) && !empty($params['ItEasyOrderSearch']['it_easy_order_number'])){
          	$query->andFilterWhere(['o.it_easy_order_number' => $this->it_easy_order_number]);
        }else if(isset($params['ItEasyOrderSearch']['it_easy_mobile_number']) && !empty($params['ItEasyOrderSearch']['it_easy_mobile_number'])){
          	$query->andFilterWhere(['o.it_easy_mobile_number' => $this->it_easy_mobile_number]);
        }else if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){

                if(empty($params['ItEasyOrderSearch']['date_to_date'])){
                  $params['ItEasyOrderSearch']['date_to_date'] = date('Y-m-d').' 23:59:59';
                }

                if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                  $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                    ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                  $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                    ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                  $query->andWhere(['<=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']])
                    ->andWhere(['>=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']]);
                    
                    
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'AWB ASSIGN'){
                  $query->andWhere(['<=', 'it_easy_assign_time', $params['ItEasyOrderSearch']['date_to_date']])
                    ->andWhere(['>=', 'o.it_easy_assign_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                  $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                    ->andWhere(['>=', 'o.it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                  $query->andWhere(['<=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                    ->andWhere(['>=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                  $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                    ->andWhere(['>=', 'o.it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else{
                    $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                    ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }
                
                
          
        }else{
            if(Yii::$app->controller->id == 'order-dispatch' && Yii::$app->controller->action->id == 'manifest'){
                $query->andWhere(['<=', 'od.it_easy_awb_time', $to_date])
                     ->andWhere(['>=', 'od.it_easy_awb_time', $from_date]);
                     
            }
        }
        
        // if(empty($params)){
                    
        //     if(Yii::$app->controller->id == 'order-dispatch' && Yii::$app->controller->action->id == 'manifest'){
        //         $query->andWhere(['<=', 'od.it_easy_placed_time', $to_date])
        //              ->andWhere(['>=', 'od.it_easy_placed_time', $from_date]);
                     
        //     }
        // }
        
        if(isset($params['ItEasyOrderSearch']['assign_type']) && !empty($params['ItEasyOrderSearch']['assign_type'])){
            if($params['ItEasyOrderSearch']['assign_type'] == 'Assign'){
              $query->andWhere(['it_easy_assigned_to' => '0']);
            }else if($params['ItEasyOrderSearch']['assign_type'] == 'Unassign'){
              $query->andWhere(['<>', 'it_easy_assigned_to','0']);
            }
        }
        
        if(isset($params['ItEasyOrderSearch']['it_easy_servisable_name']) && !empty($params['ItEasyOrderSearch']['it_easy_servisable_name'])){
              $query->andWhere(new \yii\db\Expression('FIND_IN_SET(:it_easy_servisable_name,it_easy_order_serviceable)'))
                ->addParams([':it_easy_servisable_name' => $params['ItEasyOrderSearch']['it_easy_servisable_name']]);
        }

        if(Yii::$app->user->identity->it_easy_dept_id == '4'){
            if(Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5'){
                $query->andWhere([ 'it_easy_assigned_to' => Yii::$app->user->identity->id]);
            }
        }else if(Yii::$app->user->identity->it_easy_dept_id == '9'){
             if(Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5'){
                 $query->andWhere([ 'it_easy_retention_AGENTid' => Yii::$app->user->identity->id]);
             }
        } 
 
        $query->andFilterWhere(['like', 'it_easy_financial_year', $this->it_easy_financial_year])
            ->andFilterWhere(['like', 'it_easy_invoice_number', $this->it_easy_invoice_number])
            ->andFilterWhere(['like', 'it_easy_store_name', $this->it_easy_store_name])
            ->andFilterWhere(['like', 'it_easy_other_order_id', $this->it_easy_other_order_id])
            ->andFilterWhere(['like', 'it_easy_email', $this->it_easy_email])
            ->andFilterWhere(['like', 'it_easy_state', $this->it_easy_state])
            ->andFilterWhere(['like', 'it_easy_pincode', $this->it_easy_pincode])
            ->andFilterWhere(['like', 'o.it_easy_platform', $this->it_easy_platform])
            ->andFilterWhere(['like', 'o.it_easy_payment_code', $this->it_easy_payment_code])
            ->andFilterWhere(['like', 'it_easy_shipping_code', $this->it_easy_shipping_code])
            ->andFilterWhere(['like', 'it_easy_order_serviceable', $this->it_easy_order_serviceable])
            ->andFilterWhere(['like', 'it_easy_comment', $this->it_easy_comment])
            ->andFilterWhere(['like', 'o.it_easy_first_status', $this->it_easy_first_status])
            ->andFilterWhere(['like', 'it_easy_marketer_publisher', $this->it_easy_marketer_publisher])
            ->andFilterWhere(['like', 'it_easy_marketer_click_id', $this->it_easy_marketer_click_id])
            ->andFilterWhere(['like', 'it_easy_label_generated', $this->it_easy_label_generated]);

        // echo $query->createCommand()->getRawSql();die;
          return $dataProvider;
      }
      
      public function nonserviceablesearch($params)
    {
        //   $query = ItEasyOrder::find();
          $query = ItEasyOrder::find()->joinWith(['orderdispatch'])->from(['o' => ItEasyOrder::tablename()]);
          
         $query->where(['it_easy_order_status_id' => '24'])->andWhere(['or',
            ['it_easy_order_serviceable' => null],
            ['it_easy_order_serviceable' => '']
        ]);
          
          
          if(isset(Yii::$app->user->identity->it_easy_platform)){
            $platform = explode(',', Yii::$app->user->identity->it_easy_platform);
            $query->andWhere(['IN', 'o.it_easy_platform', $platform]);
          }
          
          if(isset(Yii::$app->user->identity->it_easy_dept_id) && (Yii::$app->user->identity->it_easy_dept_id == '9') && (Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5')){
            
            $dataProvider = new ActiveDataProvider([
                'query' => $query,
                'sort'=> ['defaultOrder' => ['it_easy_retention_assign_time' => SORT_DESC]],
            ]);
            
        }else{
            $dataProvider = new ActiveDataProvider([
                  'query' => $query,
                  'sort'=> ['defaultOrder' => ['it_easy_updated_time' => SORT_DESC]],
              ]);
        }

          

          $this->load($params);

          if (!$this->validate()) {
              // uncomment the following line if you do not want to return any records when validation fails
              // $query->where('0=1');
              return $dataProvider;
          }
          
          

          // grid filtering conditions
          $query->andFilterWhere([
            'it_easy_order_id' => $this->it_easy_order_id,
            'it_easy_store_id' => $this->it_easy_store_id,
            'o.it_easy_state_id' => $this->it_easy_state_id,
            'o.it_easy_order_status_id' => $this->it_easy_order_status_id,
            'it_easy_order_disposition_id' => $this->it_easy_order_disposition_id,
            'it_easy_ndr_disposition_id' => $this->it_easy_ndr_disposition_id,
            'it_easy_ndr_status_id' => $this->it_easy_ndr_status_id,
            'it_easy_department_id' => $this->it_easy_department_id,
            'it_easy_assigned_by' => $this->it_easy_assigned_by,
            'it_easy_assigned_to' => $this->it_easy_assigned_to,
            'it_easy_ndr_tl' => $this->it_easy_ndr_tl,
            'it_easy_ndr_agent' => $this->it_easy_ndr_agent,
        ]);
        
        if(isset($params['ItEasyOrderSearch']['it_easy_courier_name']) && !empty($params['ItEasyOrderSearch']['it_easy_courier_name'])){
          $query->andFilterWhere(['it_easy_shipping_id' => $this->it_easy_courier_name]);
        }
        
        if(isset($params['ItEasyOrderSearch']['date_to_date']) && !empty($params['ItEasyOrderSearch']['date_to_date'])){
            $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        }else{
            
            $to_date = date('Y-m-d').' 23:59:59';
            $from_date = date('Y-m-d');
        }
      	if(isset($params['ItEasyOrderSearch']['it_easy_order_number']) && !empty($params['ItEasyOrderSearch']['it_easy_order_number'])){
          	$query->andFilterWhere(['o.it_easy_order_number' => $this->it_easy_order_number]);
        }else if(isset($params['ItEasyOrderSearch']['it_easy_mobile_number']) && !empty($params['ItEasyOrderSearch']['it_easy_mobile_number'])){
          	$query->andFilterWhere(['o.it_easy_mobile_number' => $this->it_easy_mobile_number]);
        }else if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){

                if(empty($params['ItEasyOrderSearch']['date_to_date'])){
                  $params['ItEasyOrderSearch']['date_to_date'] = date('Y-m-d').' 23:59:59';
                }

                if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                  $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                    ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                  $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                    ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                  $query->andWhere(['<=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']])
                    ->andWhere(['>=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']]);
                    
                    
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'AWB ASSIGN'){
                  $query->andWhere(['<=', 'it_easy_assign_time', $params['ItEasyOrderSearch']['date_to_date']])
                    ->andWhere(['>=', 'o.it_easy_assign_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                  $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                    ->andWhere(['>=', 'o.it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                  $query->andWhere(['<=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                    ->andWhere(['>=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                  $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                    ->andWhere(['>=', 'o.it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else{
                    $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                    ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }
                
                
          
        }else{
            if(Yii::$app->controller->id == 'order-dispatch' && Yii::$app->controller->action->id == 'manifest'){
                $query->andWhere(['<=', 'od.it_easy_awb_time', $to_date])
                     ->andWhere(['>=', 'od.it_easy_awb_time', $from_date]);
                     
            }
        }
        
        // if(empty($params)){
                    
        //     if(Yii::$app->controller->id == 'order-dispatch' && Yii::$app->controller->action->id == 'manifest'){
        //         $query->andWhere(['<=', 'od.it_easy_placed_time', $to_date])
        //              ->andWhere(['>=', 'od.it_easy_placed_time', $from_date]);
                     
        //     }
        // }
        
        if(isset($params['ItEasyOrderSearch']['assign_type']) && !empty($params['ItEasyOrderSearch']['assign_type'])){
            if($params['ItEasyOrderSearch']['assign_type'] == 'Assign'){
              $query->andWhere(['it_easy_assigned_to' => '0']);
            }else if($params['ItEasyOrderSearch']['assign_type'] == 'Unassign'){
              $query->andWhere(['<>', 'it_easy_assigned_to','0']);
            }
        }
        
        if(isset($params['ItEasyOrderSearch']['it_easy_servisable_name']) && !empty($params['ItEasyOrderSearch']['it_easy_servisable_name'])){
              $query->andWhere(new \yii\db\Expression('FIND_IN_SET(:it_easy_servisable_name,it_easy_order_serviceable)'))
                ->addParams([':it_easy_servisable_name' => $params['ItEasyOrderSearch']['it_easy_servisable_name']]);
        }

        if(Yii::$app->user->identity->it_easy_dept_id == '4'){
            if(Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5'){
                $query->andWhere([ 'it_easy_assigned_to' => Yii::$app->user->identity->id]);
            }
        }else if(Yii::$app->user->identity->it_easy_dept_id == '9'){
             if(Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5'){
                 $query->andWhere([ 'it_easy_retention_AGENTid' => Yii::$app->user->identity->id]);
             }
        } 
 
        $query->andFilterWhere(['like', 'it_easy_financial_year', $this->it_easy_financial_year])
            ->andFilterWhere(['like', 'it_easy_invoice_number', $this->it_easy_invoice_number])
            ->andFilterWhere(['like', 'it_easy_store_name', $this->it_easy_store_name])
            ->andFilterWhere(['like', 'it_easy_other_order_id', $this->it_easy_other_order_id])
            ->andFilterWhere(['like', 'it_easy_email', $this->it_easy_email])
            ->andFilterWhere(['like', 'it_easy_state', $this->it_easy_state])
            ->andFilterWhere(['like', 'it_easy_pincode', $this->it_easy_pincode])
            ->andFilterWhere(['like', 'o.it_easy_platform', $this->it_easy_platform])
            ->andFilterWhere(['like', 'o.it_easy_payment_code', $this->it_easy_payment_code])
            ->andFilterWhere(['like', 'it_easy_shipping_code', $this->it_easy_shipping_code])
            ->andFilterWhere(['like', 'it_easy_order_serviceable', $this->it_easy_order_serviceable])
            ->andFilterWhere(['like', 'it_easy_comment', $this->it_easy_comment])
            ->andFilterWhere(['like', 'o.it_easy_first_status', $this->it_easy_first_status])
            ->andFilterWhere(['like', 'it_easy_marketer_publisher', $this->it_easy_marketer_publisher])
            ->andFilterWhere(['like', 'it_easy_marketer_click_id', $this->it_easy_marketer_click_id])
            ->andFilterWhere(['like', 'it_easy_label_generated', $this->it_easy_label_generated]);

        // echo $query->createCommand()->getRawSql();die;
          return $dataProvider;
      }
      
      
  
  	  
  	  public function search3($params){
        $query=ItEasyOrder::find()->where(['<>', 'it_easy_disposition_time', ''])->andWhere(['it_easy_callback_status'=>'Pending']);
       
        if(isset(Yii::$app->user->identity->it_easy_platform)){
            $platform = explode(',', Yii::$app->user->identity->it_easy_platform);
            $query->andWhere(['IN', 'it_easy_platform', $platform]);
        }
        
        
          $dataProvider = new ActiveDataProvider([
              'query' => $query,
              'sort'=> ['defaultOrder' => ['it_easy_disposition_time' => SORT_DESC]],
              'pagination' => [
            'pageSize' => 100,
        ],
          ]);

          $this->load($params);

          if (!$this->validate()) {
              // uncomment the following line if you do not want to return any records when validation fails
              // $query->where('0=1');
              return $dataProvider;
          }

          // grid filtering conditions
          $query->andFilterWhere([
            'it_easy_order_id' => $this->it_easy_order_id,
            'it_easy_store_id' => $this->it_easy_store_id,
            'it_easy_customer_id' => $this->it_easy_customer_id,
            'it_easy_state_id' => $this->it_easy_state_id,
            'it_easy_shipping_state_id' => $this->it_easy_shipping_state_id,
            'it_easy_billing_gst_status' => $this->it_easy_billing_gst_status,
            'it_easy_billing_state_id' => $this->it_easy_billing_state_id,
            'it_easy_total_price' => $this->it_easy_total_price,
            'it_easy_gst_price' => $this->it_easy_gst_price,
            'it_easy_order_status_id' => $this->it_easy_order_status_id,
            'it_easy_order_disposition_id' => $this->it_easy_order_disposition_id,
            'it_easy_ndr_disposition_id' => $this->it_easy_ndr_disposition_id,
            'it_easy_ndr_status_id' => $this->it_easy_ndr_status_id,
            'it_easy_department_id' => $this->it_easy_department_id,
            'it_easy_assigned_by' => $this->it_easy_assigned_by,
            'it_easy_assigned_to' => $this->it_easy_assigned_to,
            'it_easy_ndr_tl' => $this->it_easy_ndr_tl,
            'it_easy_ndr_agent' => $this->it_easy_ndr_agent,
            'it_easy_read_status' => $this->it_easy_read_status,
            'it_easy_address_verify_by' => $this->it_easy_address_verify_by,
            'it_easy_marketer_id' => $this->it_easy_marketer_id,
            'it_easy_created_time' => $this->it_easy_created_time,
            'it_easy_updated_time' => $this->it_easy_updated_time,
            'it_easy_assign_time' => $this->it_easy_assign_time,
            'it_easy_placed_time' => $this->it_easy_placed_time,
            'it_easy_delivered_time' => $this->it_easy_delivered_time,
        ]);
      
        if(isset($params['ItEasyOrderSearch']['date_type_filter']) && !empty($params['ItEasyOrderSearch']['date_type_filter'])){

          if(!empty($params['ItEasyOrderSearch']['date_from_date'])){

            if(empty($params['ItEasyOrderSearch']['date_to_date'])){
              $params['ItEasyOrderSearch']['date_to_date'] = date('Y-m-d');
            }

            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
              $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
              $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
              $query->andWhere(['<=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']])
                ->andWhere(['>=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
              $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
              $query->andWhere(['<=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                ->andWhere(['>=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
              $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }
          }
        }

        if(isset($params['ItEasyOrderSearch']['assign_type']) && !empty($params['ItEasyOrderSearch']['assign_type'])){
                if($params['ItEasyOrderSearch']['assign_type'] == 'Assign'){
                        $query->andWhere(['it_easy_assigned_to' => '0']);
                }else if($params['ItEasyOrderSearch']['assign_type'] == 'Unassign'){
                    $query->andWhere(['<>', 'it_easy_assigned_to','0']);
                }
        }

        if(Yii::$app->user->identity->it_easy_dept_id == '4'){
            if(Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5'){
                $query->andWhere([ 'it_easy_assigned_to' => Yii::$app->user->identity->id]);
            }
        }else if(Yii::$app->user->identity->it_easy_dept_id == '9'){
             if(Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5'){
                 $query->andWhere([ 'it_easy_retention_AGENTid' => Yii::$app->user->identity->id]);
             }
        } 

        $query->andFilterWhere(['like', 'it_easy_financial_year', $this->it_easy_financial_year])
            ->andFilterWhere(['like', 'it_easy_order_number', $this->it_easy_order_number])
            ->andFilterWhere(['like', 'it_easy_invoice_number', $this->it_easy_invoice_number])
            ->andFilterWhere(['like', 'it_easy_store_name', $this->it_easy_store_name])
            ->andFilterWhere(['like', 'it_easy_other_order_id', $this->it_easy_other_order_id])
            ->andFilterWhere(['like', 'it_easy_firstname', $this->it_easy_firstname])
            ->andFilterWhere(['like', 'it_easy_lastname', $this->it_easy_lastname])
            ->andFilterWhere(['like', 'it_easy_mobile_number', $this->it_easy_mobile_number])
            ->andFilterWhere(['like', 'it_easy_alternate_number', $this->it_easy_alternate_number])
            ->andFilterWhere(['like', 'it_easy_email', $this->it_easy_email])
            ->andFilterWhere(['like', 'it_easy_address_1', $this->it_easy_address_1])
            ->andFilterWhere(['like', 'it_easy_address_2', $this->it_easy_address_2])
            ->andFilterWhere(['like', 'it_easy_city', $this->it_easy_city])
            ->andFilterWhere(['like', 'it_easy_state', $this->it_easy_state])
            ->andFilterWhere(['like', 'it_easy_pincode', $this->it_easy_pincode])
            ->andFilterWhere(['like', 'it_easy_shipping_mobile_number', $this->it_easy_shipping_mobile_number])
            ->andFilterWhere(['like', 'it_easy_shipping_state', $this->it_easy_shipping_state])
            ->andFilterWhere(['like', 'it_easy_shipping_pincode', $this->it_easy_shipping_pincode])
            ->andFilterWhere(['like', 'it_easy_shipping_country', $this->it_easy_shipping_country])
            ->andFilterWhere(['like', 'it_easy_payment_method', $this->it_easy_payment_method])
            ->andFilterWhere(['like', 'it_easy_payment_code', $this->it_easy_payment_code])
            ->andFilterWhere(['like', 'it_easy_shipping_method', $this->it_easy_shipping_method])
            ->andFilterWhere(['like', 'it_easy_shipping_code', $this->it_easy_shipping_code])
            ->andFilterWhere(['like', 'it_easy_order_serviceable', $this->it_easy_order_serviceable])
            ->andFilterWhere(['like', 'it_easy_comment', $this->it_easy_comment])
            ->andFilterWhere(['like', 'it_easy_first_status', $this->it_easy_first_status])
            ->andFilterWhere(['like', 'it_easy_marketer_publisher', $this->it_easy_marketer_publisher])
            ->andFilterWhere(['like', 'it_easy_marketer_click_id', $this->it_easy_marketer_click_id]);

  
          return $dataProvider;
      }
      
    public function manifestexport($params)
    {
        
         $query = ItEasyOrder::find()->from(['o' => ItEasyOrder::tablename()]);
        $query->where(['IN', 'o.it_easy_order_status_id', ['3', '4', '5', '6', '9','14', '2', '15', '16', '22', '23', '26', '27', '28','29', '30', '31' ]]);
        if(isset($params['export']) && !empty($params['export'])){
            $query->joinWith(['orderstatus', 'orderdisposition', 'assignagent', 'assigntl', 'orderdispatch', 'ndrstatus', 'ndrdisposition'])->select(['o.it_easy_order_id as order_id', 'o.it_easy_order_number as order_number', 'od.it_easy_order_type as order_type', 'it_easy_awb_number as awb_number', 'it_easy_courier_name as courier_name', 'o.it_easy_other_order_id as other_order_id', 'o.it_easy_invoice_number as invoice_number', 'it_easy_total_price as total_price', 'it_easy_gst_price as GST_Price', 'it_easy_first_status as First_Status', 'orsta.it_easy_order_status_name as Status_Name', 'ordis.it_easy_order_disposition_name as Disposition_Name', 'ndsta.it_easy_order_status_name as ndr_Status_Name', 'nddis.it_easy_order_disposition_name as ndr_Disposition_Name', 'it_easy_arrange_time',  'CONCAT(o.it_easy_firstname," ",o.it_easy_firstname) as customer', 'o.it_easy_mobile_number as mobile_number', 'o.it_easy_address_1 as Address_1', 'o.it_easy_address_2 as Address_2', 'o.it_easy_city as City', 'o.it_easy_state as State', 'o.it_easy_pincode as Pincode', 'u2.it_easy_username as TL_username', 'u.it_easy_username as Agent_Username', 'it_easy_marketer_publisher as Marketer_Publisher', 'it_easy_marketer_click_id as Click_ID', 'o.it_easy_created_time as Created_Time', 'o.it_easy_updated_time as Updated_Time', 'o.it_easy_assign_time as Assigned_Time', 'o.it_easy_placed_time as Placed_Time', 'o.it_easy_converted_time as Confirmation_Time', 'o.it_easy_delivered_time as Delivered_Time', 'it_easy_coupon_id']);
        }
        
        
        if(isset(Yii::$app->user->identity->it_easy_platform)){
            $platform = explode(',', Yii::$app->user->identity->it_easy_platform);
            $query->andWhere(['IN', 'o.it_easy_platform', $platform]);
        }
        
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            // 'sort'=> ['defaultOrder' => ['it_easy_updated_time' => SORT_DESC]],
        ]);

        $this->load($params);
        if (!$this->validate()) {
            return $dataProvider;
        }
        //echo $data = $query->createCommand()->rawSql; die;
        // echo "<pre>"; print_r($params); die;
        
        if(isset($params['ItEasyOrderSearch']['it_easy_courier_name']) && !empty($params['ItEasyOrderSearch']['it_easy_courier_name'])){
          $query->andFilterWhere(['it_easy_shipping_id' => $this->it_easy_courier_name]);
        }
        
        if(isset($params['ItEasyOrderSearch']['assign_type']) && !empty($params['ItEasyOrderSearch']['assign_type'])){
                if($params['ItEasyOrderSearch']['assign_type'] == 'Assign'){
                        $query->andWhere(['<>', 'it_easy_ndr_agent', '']);
                }else if($params['ItEasyOrderSearch']['assign_type'] == 'Unassign'){
                    $query->andWhere(['or', ['it_easy_ndr_agent'=>'0'], ['it_easy_ndr_agent' => NULL] ]);
                }
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_order_number']) && !empty($params['ItEasyOrderSearch']['it_easy_order_number'])){
          $query->andFilterWhere(['o.it_easy_order_number' => $this->it_easy_order_number]);
        }else if(isset($params['ItEasyOrderSearch']['it_easy_mobile_number']) && !empty($params['ItEasyOrderSearch']['it_easy_mobile_number'])){
          $query->andFilterWhere(['it_easy_mobile_number' => $this->it_easy_mobile_number]);
        }else if(isset($params['ItEasyOrderSearch']['it_easy_awb_number']) && !empty($params['ItEasyOrderSearch']['it_easy_awb_number'])){
          $query->andFilterWhere(['it_easy_awb_number' => $this->it_easy_awb_number]);
        }else if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
            
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';

                if(empty($params['ItEasyOrderSearch']['date_to_date'])){
                    $params['ItEasyOrderSearch']['date_to_date'] = date('Y-m-d');
                }
            
                if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                        $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                        $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                        $query->andWhere(['<=', 'it_easy_assign_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_assign_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'AWB ASSIGN'){
                        $query->andWhere(['<=', 'it_easy_assign_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_assign_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                        $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                        $query->andWhere(['<=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                        $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else{
                     $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }
        }else{
            $query->andWhere(['>=', 'it_easy_created_time', date('Y-m-d').' 00:00:00'])
                             ->andWhere(['<=', 'it_easy_created_time', date('Y-m-d').' 23:59:59']);
        }
            
        $query->andFilterWhere([
            'it_easy_order_id' => $this->it_easy_order_id,
            'it_easy_store_id' => $this->it_easy_store_id,
            'it_easy_customer_id' => $this->it_easy_customer_id,
            'it_easy_state_id' => $this->it_easy_state_id,
            'it_easy_shipping_state_id' => $this->it_easy_shipping_state_id,
            'it_easy_billing_gst_status' => $this->it_easy_billing_gst_status,
            'it_easy_billing_state_id' => $this->it_easy_billing_state_id,
            'it_easy_total_price' => $this->it_easy_total_price,
            'it_easy_gst_price' => $this->it_easy_gst_price,
            'o.it_easy_order_status_id' => $this->it_easy_order_status_id,
            'o.it_easy_order_disposition_id' => $this->it_easy_order_disposition_id,
            'it_easy_ndr_disposition_id' => $this->it_easy_ndr_disposition_id,
            'it_easy_ndr_status_id' => $this->it_easy_ndr_status_id,
            'it_easy_department_id' => $this->it_easy_department_id,
            'it_easy_assigned_by' => $this->it_easy_assigned_by,
            'it_easy_assigned_to' => $this->it_easy_assigned_to,
            'it_easy_ndr_tl' => $this->it_easy_ndr_tl,
            'it_easy_read_status' => $this->it_easy_read_status,
            'it_easy_address_verify_by' => $this->it_easy_address_verify_by,
            'it_easy_marketer_id' => $this->it_easy_marketer_id,
            'it_easy_created_time' => $this->it_easy_created_time,
            'it_easy_updated_time' => $this->it_easy_updated_time,
            'it_easy_assign_time' => $this->it_easy_assign_time,
            'o.it_easy_placed_time' => $this->it_easy_placed_time,
            'o.it_easy_delivered_time' => $this->it_easy_delivered_time,
        ]);
        
        
        if(isset($params['ItEasyOrderSearch']['it_easy_payment_code']) && !empty($params['ItEasyOrderSearch']['it_easy_payment_code'])){
          $query->andFilterWhere(['o.it_easy_payment_code' => $this->it_easy_payment_code]);
        }
        
        if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && !empty($params['ItEasyOrderSearch']['it_easy_first_status'])){
          $query->andFilterWhere(['o.it_easy_first_status' => $this->it_easy_first_status]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_label_generated'])){
          $query->andFilterWhere([ 'it_easy_label_generated'=> $params['ItEasyOrderSearch']['it_easy_label_generated']]);
        }
        
        if(isset($params['ItEasyOrderSearch']['it_easy_platform']) && !empty($params['ItEasyOrderSearch']['it_easy_platform'])){
          $query->andFilterWhere(['like', 'it_easy_platform', $params['ItEasyOrderSearch']['it_easy_platform']]);
        }
        
        
        // echo $query->createCommand()->getRawSql(); 
        if(isset($params['export']) && !empty($params['export'])){
            //   echo $query->createCommand()->getRawSql(); 
                
            //      echo "<pre>"; print_r($params); die;
            return $query;
        }else{    
            return $dataProvider;
        }
    }
    
    
    public function nonserviceexport($params)
    {
        
         $query = ItEasyOrder::find()->from(['o' => ItEasyOrder::tablename()]);
        $query->where(['o.it_easy_order_status_id' => '24'])->andWhere(['or',
            ['it_easy_order_serviceable' => null],
            ['it_easy_order_serviceable' => '']
        ]);
        if(isset($params['export']) && !empty($params['export'])){
            $query->joinWith(['orderstatus', 'orderdisposition', 'assignagent', 'assigntl', 'orderdispatch', 'ndrstatus', 'ndrdisposition'])->select(['o.it_easy_order_id as order_id', 'o.it_easy_order_number as order_number', 'od.it_easy_order_type as order_type', 'it_easy_awb_number as awb_number', 'it_easy_courier_name as courier_name', 'o.it_easy_other_order_id as other_order_id', 'o.it_easy_invoice_number as invoice_number', 'it_easy_total_price as total_price', 'it_easy_gst_price as GST_Price', 'it_easy_first_status as First_Status', 'orsta.it_easy_order_status_name as Status_Name', 'ordis.it_easy_order_disposition_name as Disposition_Name', 'ndsta.it_easy_order_status_name as ndr_Status_Name', 'nddis.it_easy_order_disposition_name as ndr_Disposition_Name', 'it_easy_arrange_time',  'CONCAT(o.it_easy_firstname," ",o.it_easy_firstname) as customer', 'o.it_easy_mobile_number as mobile_number', 'o.it_easy_address_1 as Address_1', 'o.it_easy_address_2 as Address_2', 'o.it_easy_city as City', 'o.it_easy_state as State', 'o.it_easy_pincode as Pincode', 'u2.it_easy_username as TL_username', 'u.it_easy_username as Agent_Username', 'it_easy_marketer_publisher as Marketer_Publisher', 'it_easy_marketer_click_id as Click_ID', 'o.it_easy_created_time as Created_Time', 'o.it_easy_updated_time as Updated_Time', 'o.it_easy_assign_time as Assigned_Time', 'o.it_easy_placed_time as Placed_Time', 'o.it_easy_converted_time as Confirmation_Time', 'o.it_easy_delivered_time as Delivered_Time', 'it_easy_coupon_id']);
        }
        
        
        if(isset(Yii::$app->user->identity->it_easy_platform)){
            $platform = explode(',', Yii::$app->user->identity->it_easy_platform);
            $query->andWhere(['IN', 'o.it_easy_platform', $platform]);
        }
        
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            // 'sort'=> ['defaultOrder' => ['it_easy_updated_time' => SORT_DESC]],
        ]);

        $this->load($params);
        if (!$this->validate()) {
            return $dataProvider;
        }
        //echo $data = $query->createCommand()->rawSql; die;
        // echo "<pre>"; print_r($params); die;
        
        if(isset($params['ItEasyOrderSearch']['it_easy_courier_name']) && !empty($params['ItEasyOrderSearch']['it_easy_courier_name'])){
          $query->andFilterWhere(['it_easy_shipping_id' => $this->it_easy_courier_name]);
        }
        
        if(isset($params['ItEasyOrderSearch']['assign_type']) && !empty($params['ItEasyOrderSearch']['assign_type'])){
                if($params['ItEasyOrderSearch']['assign_type'] == 'Assign'){
                        $query->andWhere(['<>', 'it_easy_ndr_agent', '']);
                }else if($params['ItEasyOrderSearch']['assign_type'] == 'Unassign'){
                    $query->andWhere(['or', ['it_easy_ndr_agent'=>'0'], ['it_easy_ndr_agent' => NULL] ]);
                }
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_order_number']) && !empty($params['ItEasyOrderSearch']['it_easy_order_number'])){
          $query->andFilterWhere(['o.it_easy_order_number' => $this->it_easy_order_number]);
        }else if(isset($params['ItEasyOrderSearch']['it_easy_mobile_number']) && !empty($params['ItEasyOrderSearch']['it_easy_mobile_number'])){
          $query->andFilterWhere(['it_easy_mobile_number' => $this->it_easy_mobile_number]);
        }else if(isset($params['ItEasyOrderSearch']['it_easy_awb_number']) && !empty($params['ItEasyOrderSearch']['it_easy_awb_number'])){
          $query->andFilterWhere(['it_easy_awb_number' => $this->it_easy_awb_number]);
        }else if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
            
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';

                if(empty($params['ItEasyOrderSearch']['date_to_date'])){
                    $params['ItEasyOrderSearch']['date_to_date'] = date('Y-m-d');
                }
            
                if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                        $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                        $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                        $query->andWhere(['<=', 'it_easy_assign_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_assign_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'AWB ASSIGN'){
                        $query->andWhere(['<=', 'it_easy_assign_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_assign_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                        $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                        $query->andWhere(['<=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                        $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else{
                     $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }
        }else{
            $query->andWhere(['>=', 'it_easy_created_time', date('Y-m-d').' 00:00:00'])
                             ->andWhere(['<=', 'it_easy_created_time', date('Y-m-d').' 23:59:59']);
        }
            
        $query->andFilterWhere([
            'it_easy_order_id' => $this->it_easy_order_id,
            'it_easy_store_id' => $this->it_easy_store_id,
            'it_easy_customer_id' => $this->it_easy_customer_id,
            'it_easy_state_id' => $this->it_easy_state_id,
            'it_easy_shipping_state_id' => $this->it_easy_shipping_state_id,
            'it_easy_billing_gst_status' => $this->it_easy_billing_gst_status,
            'it_easy_billing_state_id' => $this->it_easy_billing_state_id,
            'it_easy_total_price' => $this->it_easy_total_price,
            'it_easy_gst_price' => $this->it_easy_gst_price,
            'o.it_easy_order_status_id' => $this->it_easy_order_status_id,
            'o.it_easy_order_disposition_id' => $this->it_easy_order_disposition_id,
            'it_easy_ndr_disposition_id' => $this->it_easy_ndr_disposition_id,
            'it_easy_ndr_status_id' => $this->it_easy_ndr_status_id,
            'it_easy_department_id' => $this->it_easy_department_id,
            'it_easy_assigned_by' => $this->it_easy_assigned_by,
            'it_easy_assigned_to' => $this->it_easy_assigned_to,
            'it_easy_ndr_tl' => $this->it_easy_ndr_tl,
            'it_easy_read_status' => $this->it_easy_read_status,
            'it_easy_address_verify_by' => $this->it_easy_address_verify_by,
            'it_easy_marketer_id' => $this->it_easy_marketer_id,
            'it_easy_created_time' => $this->it_easy_created_time,
            'it_easy_updated_time' => $this->it_easy_updated_time,
            'it_easy_assign_time' => $this->it_easy_assign_time,
            'o.it_easy_placed_time' => $this->it_easy_placed_time,
            'o.it_easy_delivered_time' => $this->it_easy_delivered_time,
        ]);
        
        
        if(isset($params['ItEasyOrderSearch']['it_easy_payment_code']) && !empty($params['ItEasyOrderSearch']['it_easy_payment_code'])){
          $query->andFilterWhere(['o.it_easy_payment_code' => $this->it_easy_payment_code]);
        }
        
        if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && !empty($params['ItEasyOrderSearch']['it_easy_first_status'])){
          $query->andFilterWhere(['o.it_easy_first_status' => $this->it_easy_first_status]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_label_generated'])){
          $query->andFilterWhere([ 'it_easy_label_generated'=> $params['ItEasyOrderSearch']['it_easy_label_generated']]);
        }
        
        if(isset($params['ItEasyOrderSearch']['it_easy_platform']) && !empty($params['ItEasyOrderSearch']['it_easy_platform'])){
          $query->andFilterWhere(['like', 'it_easy_platform', $params['ItEasyOrderSearch']['it_easy_platform']]);
        }
        
        
        // echo $query->createCommand()->getRawSql(); 
        if(isset($params['export']) && !empty($params['export'])){
            //   echo $query->createCommand()->getRawSql(); 
                
            //      echo "<pre>"; print_r($params); die;
            return $query;
        }else{    
            return $dataProvider;
        }
    }
    
    
    public function salesforceexport($params)
    {
        
         $query = ItEasyOrder::find()->from(['o' => ItEasyOrder::tablename()]);
        $query->where(['IN', 'o.it_easy_order_status_id', ['3', '4', '5', '6', '9','14', '2', '15', '16', '22', '23', '26', '27', '28','29', '30', '31' ]]);
        if(isset($params['export']) && !empty($params['export'])){
            $query->joinWith(['orderstatus', 'orderdisposition', 'assignagent', 'assigntl', 'orderdispatch', 'ndrstatus', 'ndrdisposition'])->select(['o.it_easy_order_id as order_id', 'o.it_easy_page_url as order_number', 'o.it_easy_other_order_id as shopify_order_number', 'od.it_easy_order_type as payment_method', 'it_easy_awb_number as awb_number', 'it_easy_courier_name as courier_name',  'it_easy_total_price as total_price', 'it_easy_total_price as total_price', 'orsta.it_easy_order_status_name as Status_Name', 'ordis.it_easy_order_disposition_name as Disposition_reason',  'CONCAT(o.it_easy_firstname," ",o.it_easy_firstname) as account_name', 'o.it_easy_mobile_number as customer_phone_number', 'o.it_easy_address_1 as shipping_Address_1', 'o.it_easy_address_2 as shipping_Address_2', 'o.it_easy_city as shipping_City', 'o.it_easy_state as shipping_State', 'o.it_easy_pincode as shipping_Pincode', 'u.it_easy_username as Aaccount_owner_name', 'o.it_easy_converted_time as Order_Confirmed_date']);
        }
        
        
        if(isset(Yii::$app->user->identity->it_easy_platform)){
            $platform = explode(',', Yii::$app->user->identity->it_easy_platform);
            $query->andWhere(['IN', 'o.it_easy_platform', $platform]);
        }
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            // 'sort'=> ['defaultOrder' => ['it_easy_updated_time' => SORT_DESC]],
        ]);

        $this->load($params);
        if (!$this->validate()) {
            return $dataProvider;
        }

      $query->andFilterWhere([
            'it_easy_order_id' => $this->it_easy_order_id,
            'it_easy_store_id' => $this->it_easy_store_id,
            'it_easy_customer_id' => $this->it_easy_customer_id,
            'it_easy_state_id' => $this->it_easy_state_id,
            'it_easy_shipping_state_id' => $this->it_easy_shipping_state_id,
            'it_easy_billing_gst_status' => $this->it_easy_billing_gst_status,
            'it_easy_billing_state_id' => $this->it_easy_billing_state_id,
            'it_easy_total_price' => $this->it_easy_total_price,
            'it_easy_gst_price' => $this->it_easy_gst_price,
            'o.it_easy_order_status_id' => $this->it_easy_order_status_id,
            'o.it_easy_order_disposition_id' => $this->it_easy_order_disposition_id,
            'it_easy_ndr_disposition_id' => $this->it_easy_ndr_disposition_id,
            'it_easy_ndr_status_id' => $this->it_easy_ndr_status_id,
            'it_easy_department_id' => $this->it_easy_department_id,
            'it_easy_assigned_by' => $this->it_easy_assigned_by,
            'it_easy_assigned_to' => $this->it_easy_assigned_to,
            'it_easy_ndr_tl' => $this->it_easy_ndr_tl,
            'it_easy_read_status' => $this->it_easy_read_status,
            'it_easy_address_verify_by' => $this->it_easy_address_verify_by,
            'it_easy_marketer_id' => $this->it_easy_marketer_id,
            'it_easy_created_time' => $this->it_easy_created_time,
            'it_easy_updated_time' => $this->it_easy_updated_time,
            'it_easy_assign_time' => $this->it_easy_assign_time,
            'o.it_easy_placed_time' => $this->it_easy_placed_time,
            'it_easy_delivered_time' => $this->it_easy_delivered_time,
            'o.it_easy_payment_code', $this->it_easy_payment_code,
            'it_easy_first_status' , $this->it_easy_first_status,
        ]);
        
        if(isset($params['ItEasyOrderSearch']['it_easy_courier_name']) && !empty($params['ItEasyOrderSearch']['it_easy_courier_name'])){
          $query->andFilterWhere(['it_easy_shipping_id' => $this->it_easy_courier_name]);
        }
        
        if(isset($params['ItEasyOrderSearch']['assign_type']) && !empty($params['ItEasyOrderSearch']['assign_type'])){
                if($params['ItEasyOrderSearch']['assign_type'] == 'Assign'){
                        $query->andWhere(['<>', 'it_easy_ndr_agent', '']);
                }else if($params['ItEasyOrderSearch']['assign_type'] == 'Unassign'){
                    $query->andWhere(['or', ['it_easy_ndr_agent'=>'0'], ['it_easy_ndr_agent' => NULL] ]);
                }
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_order_number']) && !empty($params['ItEasyOrderSearch']['it_easy_order_number'])){
          $query->andFilterWhere(['o.it_easy_order_number' => $this->it_easy_order_number]);
        }else if(isset($params['ItEasyOrderSearch']['it_easy_mobile_number']) && !empty($params['ItEasyOrderSearch']['it_easy_mobile_number'])){
          $query->andFilterWhere(['it_easy_mobile_number' => $this->it_easy_mobile_number]);
        }else if(isset($params['ItEasyOrderSearch']['it_easy_awb_number']) && !empty($params['ItEasyOrderSearch']['it_easy_awb_number'])){
          $query->andFilterWhere(['it_easy_awb_number' => $this->it_easy_awb_number]);
        }else if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
            
                $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';

                if(empty($params['ItEasyOrderSearch']['date_to_date'])){
                    $params['ItEasyOrderSearch']['date_to_date'] = date('Y-m-d');
                }
            
                if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                        $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                        $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                        $query->andWhere(['<=', 'it_easy_assign_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_assign_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                        $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                        $query->andWhere(['<=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'od.it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                        $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }else{
                     $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                             ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
                }
        }else{
            $query->andWhere(['>=', 'it_easy_created_time', date('Y-m-d').' 00:00:00'])
                             ->andWhere(['<=', 'it_easy_created_time', date('Y-m-d').' 23:59:59']);
        }
            
            if(Yii::$app->user->identity->id == '1'){
               
            }
        
        if(isset($params['export']) && !empty($params['export'])){
             // echo $query->createCommand()->getRawSql(); 
                
             //    echo "<pre>"; print_r($params); die;
            return $query;
        }else{    
            return $dataProvider;
        }
    }
    
    
    
    public function searchorder($params)
    {       
    
           if(!empty($params)){
        $query = ItEasyOrder::find()->from(['o' => ItEasyOrder::tablename()])->joinWith(['orderdispatch']);
        }else{
        $query = ItEasyOrder::find()->from(['o' => ItEasyOrder::tablename()])->where(['it_easy_order_id' => '']);
        }
        
        if(isset(Yii::$app->user->identity->it_easy_platform)){
            $platform = explode(',', Yii::$app->user->identity->it_easy_platform);
            $query->andWhere(['IN', 'o.it_easy_platform', $platform]);
        }
    
        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['it_easy_order_id' => SORT_DESC]],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }
          

        // grid filtering conditions
        $query->andFilterWhere([
     
            'o.it_easy_email' => $this->it_easy_email,
        ]);
        
            if(isset($params['ItEasyOrderSearch']['it_easy_mobile_number']) && !empty($params['ItEasyOrderSearch']['it_easy_mobile_number'])){
                $query->andFilterWhere(['like', 'o.it_easy_mobile_number', $this->it_easy_mobile_number]);
            }else if(isset($params['ItEasyOrderSearch']['it_easy_awb_number']) && !empty($params['ItEasyOrderSearch']['it_easy_awb_number'])){
                $query->andFilterWhere(['like', 'od.it_easy_awb_number', $this->it_easy_awb_number]);
            }else if(isset($params['ItEasyOrderSearch']['it_easy_awb_number']) && empty($params['ItEasyOrderSearch']['it_easy_awb_number']) && isset($params['ItEasyOrderSearch']['it_easy_mobile_number']) && empty($params['ItEasyOrderSearch']['it_easy_mobile_number']) && isset($params['ItEasyOrderSearch']['it_easy_email']) && empty($params['ItEasyOrderSearch']['it_easy_email'])){
                $query->andFilterWhere([
     
                    'o.it_easy_order_id' => '0',
                ]);
            }
   
            return $dataProvider;
       
    }
    
    // agent wise report export

    public static function getAgentdata(){

        $return = User::find()->select(['id', 'it_easy_username'])
                ->leftJoin(ItEasyOrder::tablename().' as tb3', 'it_easy_user.id = tb3.it_easy_assigned_to')
                ->andWhere(['or', ['it_easy_dept_id' => '9'], ['it_easy_dept_id' => '4'] ])->andWhere(['or', ['it_easy_type_id' => '5']])->andWhere(['status' => 'ACTIVE']);
      
       
        return $return;
    }

    public static  function agentWiseexport($params, $agent_id){
       
        $query = ItEasyOrder::find()->from(['o' => ItEasyOrder::tablename()])->select(['COUNT(o.it_easy_order_id) as order_number', 'SUM(o.it_easy_total_price) as order_sum',


            'COUNT(CASE WHEN o.it_easy_order_disposition_id IN ("1", "13") then 1 ELSE NULL END) AS callback_req_count', 'COUNT(CASE WHEN o.it_easy_order_disposition_id IN ("4", "12") then 1 ELSE NULL END) AS not_connected_count', 'COUNT(CASE WHEN o.it_easy_order_disposition_id IN ("2","5","6") then 1 ELSE NULL END) AS not_intrested_count',  'COUNT(CASE WHEN o.it_easy_order_disposition_id IN ("7") then 1 ELSE NULL END) AS duplicate_count', 'COUNT(CASE WHEN o.it_easy_order_disposition_id IN ("9", "10", "22") then 1 ELSE NULL END) AS fake_order_count', 'COUNT(CASE WHEN o.it_easy_order_disposition_id IN ("11") then 1 ELSE NULL END) AS area_not_ser_count', 'COUNT(CASE WHEN o.it_easy_order_disposition_id IN ("14") then 1 ELSE NULL END) AS call_disconnected_count', 'COUNT(CASE WHEN o.it_easy_order_disposition_id IN ("15","8") then 1 ELSE NULL END) AS promise_To_order_count', 'COUNT(CASE WHEN o.it_easy_order_disposition_id IN ("16","17","3", "20") then 1 ELSE NULL END) AS order_placed_count', 'COUNT(CASE WHEN o.it_easy_order_disposition_id IN ("18", "19") then 1 ELSE NULL END) AS medical_condition_count', 'COUNT(CASE WHEN o.it_easy_order_disposition_id IN ("21") then 1 ELSE NULL END) AS language_barrier',


            'SUM(CASE WHEN o.it_easy_order_disposition_id IN ("1", "13") then it_easy_total_price ELSE 0 END) AS callback_req_sum', 'SUM(CASE WHEN o.it_easy_order_disposition_id IN ("4", "12") then it_easy_total_price ELSE 0 END) AS not_connected_sum', 'SUM(CASE WHEN o.it_easy_order_disposition_id IN ("2","5","6") then it_easy_total_price ELSE 0 END) AS not_intrested_sum',  'SUM(CASE WHEN o.it_easy_order_disposition_id IN ("7") then it_easy_total_price ELSE 0 END) AS duplicate_sum', 'SUM(CASE WHEN o.it_easy_order_disposition_id IN ("9", "10", "22") then it_easy_total_price ELSE 0 END) AS fake_order_sum', 'SUM(CASE WHEN o.it_easy_order_disposition_id IN ("11") then it_easy_total_price ELSE 0 END) AS area_not_ser_sum', 'SUM(CASE WHEN o.it_easy_order_disposition_id IN ("14") then it_easy_total_price ELSE 0 END) AS call_disconnected_sum', 'SUM(CASE WHEN o.it_easy_order_disposition_id IN ("15","8") then it_easy_total_price ELSE 0 END) AS promise_To_order_sum', 'SUM(CASE WHEN o.it_easy_order_disposition_id IN ("16","17","3", "20") then it_easy_total_price ELSE 0 END) AS order_placed_sum', 'SUM(CASE WHEN o.it_easy_order_disposition_id IN ("18", "19") then it_easy_total_price ELSE 0 END) AS medical_condition_sum', 'SUM(CASE WHEN o.it_easy_order_disposition_id IN ("21") then it_easy_total_price ELSE 0 END) AS language_barrier_sum',

            'concat(round(( COUNT(CASE WHEN o.it_easy_order_disposition_id IN ("16","17","3", "20") then 1 ELSE NULL END) * 100 ) / COUNT(o.it_easy_order_id),2),"%") AS percentage',

            'ROUND(SUM(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then it_easy_total_price ELSE NULL END) / COUNT(CASE WHEN `it_easy_order_status_id` IN ("1","2","3","4","5","6","14","15","16","24","23","25","26","27","28","29","30","31", "9", "22", "47") then 1 ELSE NULL END)) as average_ticket_size '])
   
   ->leftJoin(ItEasyOrderDisposition::tablename().' as od', 'od.it_easy_order_disposition_id = o.it_easy_order_disposition_id');
   
        if(isset(Yii::$app->user->identity->it_easy_platform)){
            $platform = explode(',', Yii::$app->user->identity->it_easy_platform);
            $query->andWhere(['IN', 'o.it_easy_platform', $platform]);
        }
            
        if(isset($params['ItEasyOrderSearch']['it_easy_other_order_id']) && !empty($params['ItEasyOrderSearch']['it_easy_other_order_id'])){
            $query->andFilterWhere(['o.it_easy_other_order_id' => $params['ItEasyOrderSearch']['it_easy_other_order_id']]);
        }    
        
        if(isset($params['ItEasyOrderSearch']['it_easy_state_id']) && !empty($params['ItEasyOrderSearch']['it_easy_state_id'])){
            $query->andFilterWhere(['o.it_easy_state_id' => $params['ItEasyOrderSearch']['it_easy_state_id']]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_order_status_id']) && !empty($params['ItEasyOrderSearch']['it_easy_order_status_id'])){
            $query->andFilterWhere(['o.it_easy_order_status_id' => $params['ItEasyOrderSearch']['it_easy_order_status_id']]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_email']) && !empty($params['ItEasyOrderSearch']['it_easy_email'])){
            $query->andFilterWhere(['o.it_easy_email' => $params['ItEasyOrderSearch']['it_easy_email']]);
        }
        
        if(isset($params['ItEasyOrderSearch']['it_easy_payment_code']) && !empty($params['ItEasyOrderSearch']['it_easy_payment_code'])){
            $query->andFilterWhere(['o.it_easy_payment_code' => $params['ItEasyOrderSearch']['it_easy_payment_code']]);
        }
        if(isset($params['ItEasyOrderSearch']['it_easy_first_status']) && !empty($params['ItEasyOrderSearch']['it_easy_first_status'])){
            $query->andFilterWhere(['o.it_easy_first_status' => $params['ItEasyOrderSearch']['it_easy_first_status']]);
        }

        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_by']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_by'])){
            $query->andFilterWhere(['o.it_easy_assigned_by' => $params['ItEasyOrderSearch']['it_easy_assigned_by']]);
        }

        if(isset($params['ItEasyOrderSearch']['it_easy_assigned_to']) && !empty($params['ItEasyOrderSearch']['it_easy_assigned_to'])){
            $query->andFilterWhere(['o.it_easy_assigned_to' => $params['ItEasyOrderSearch']['it_easy_assigned_to']]);
        }

        if(isset($params['ItEasyOrderSearch']['it_easy_order_disposition_id']) && !empty($params['ItEasyOrderSearch']['it_easy_order_disposition_id']) && $params['ItEasyOrderSearch']['it_easy_order_disposition_id'] != 'no_disposition'){
          $query->andFilterWhere(['o.it_easy_order_disposition_id'=>$params['ItEasyOrderSearch']['it_easy_order_disposition_id']]);
        }else if(isset($params['ItEasyOrderSearch']['it_easy_order_disposition_id']) && !empty($params['ItEasyOrderSearch']['it_easy_order_disposition_id']) && $params['ItEasyOrderSearch']['it_easy_order_disposition_id'] == 'no_disposition'){
            $query->andFilterWhere(['IS', 'o.it_easy_order_disposition_id', new \yii\db\Expression('NULL')])->orWhere(['o.it_easy_order_disposition_id'=>0]);
        }
        
        if(isset($params['ItEasyOrderSearch']['it_easy_order_number']) && !empty($params['ItEasyOrderSearch']['it_easy_order_number'])){
            $query->andFilterWhere(['o.it_easy_order_number' => $params['ItEasyOrderSearch']['it_easy_order_number']]);
        }else if(isset($params['ItEasyOrderSearch']['it_easy_mobile_number']) && !empty($params['ItEasyOrderSearch']['it_easy_mobile_number'])){
            $query->andFilterWhere(['like', 'o.it_easy_mobile_number', $params['ItEasyOrderSearch']['it_easy_mobile_number']]);
        }else if(isset($params['ItEasyOrderSearch']['it_easy_awb_number']) && !empty($params['ItEasyOrderSearch']['it_easy_awb_number'])){
            $query->andFilterWhere(['like', 'od.it_easy_awb_number', $params['ItEasyOrderSearch']['it_easy_awb_number']]);
        }else if(isset($params['ItEasyOrderSearch']['date_from_date']) && !empty($params['ItEasyOrderSearch']['date_from_date'])){
            $params['ItEasyOrderSearch']['date_to_date'] = $params['ItEasyOrderSearch']['date_to_date'].' 23:59:59';
        if(empty($params['ItEasyOrderSearch']['date_to_date'])){
                $params['ItEasyOrderSearch']['date_to_date'] = date('Y-m-d');
        }

            if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Added'){
                    $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Modified'){
                    $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Assigned'){
                    $query->andWhere(['or', ['<=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_to_date']], ['<=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_to_date']] ])
                         ->andWhere(['or', ['>=', 'it_easy_lead_assign', $params['ItEasyOrderSearch']['date_from_date']], ['>=', 'it_easy_retention_assign_time', $params['ItEasyOrderSearch']['date_from_date']] ]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Converted'){
                    $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Dispatched'){
                    $query->andWhere(['<=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_placed_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else if($params['ItEasyOrderSearch']['date_type_filter'] == 'Date Delivered'){
                    $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }else{
                $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_to_date']])
                         ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderSearch']['date_from_date']]);
            }
        }
        else{
             $query->andWhere(['>=', 'it_easy_created_time', date('Y-m-d').' 00:00:00'])
                         ->andWhere(['<=', 'it_easy_created_time', date('Y-m-d').' 23:59:59']);
        }

        if(isset($params['ItEasyOrderSearch']['assign_type']) && !empty($params['ItEasyOrderSearch']['assign_type'])){
                if($params['ItEasyOrderSearch']['assign_type'] == 'Assign'){
                        $query->andWhere(['or', ['<>', 'o.it_easy_assigned_to', ''], ['<>', 'o.it_easy_retention_AGENTid', ''] ]);
                }else if($params['ItEasyOrderSearch']['assign_type'] == 'Unassign'){
                    $query->andWhere(['or', ['o.it_easy_assigned_to'=>'0'], ['it_easy_assigned_to' => NULL], ['o.it_easy_retention_AGENTid'=>'0'], ['it_easy_retention_AGENTid' => NULL] ]);
                }
        }
      
  
        if(Yii::$app->user->identity->it_easy_dept_id == '4'){
            if(Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5'){
                $query->andWhere([ 'o.it_easy_assigned_to' => Yii::$app->user->identity->id]);
            }
        }else if(Yii::$app->user->identity->it_easy_dept_id == '9'){
             if(Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5'){
                 $query->andWhere([ 'o.it_easy_retention_AGENTid' => Yii::$app->user->identity->id]);
             }
        }  
        
        $query->andWhere(['or', ['it_easy_assigned_to' => $agent_id], ['it_easy_retention_AGENTid' => $agent_id] ]);
      
        // echo $data = $query->createCommand()->rawSql; die;
        $data = $query->asArray()->all();

       

        return $data;
    }
}
