<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_order_status".
 *
 * @property int $it_easy_order_status_id
 * @property string $it_easy_order_status_name
 * @property string $it_easy_status
 * @property string|null $created_time
 * @property string|null $updated_time
 * @property int|null $created_by
 * @property int|null $updated_by
 */
class ItEasyOrderStatus extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_order_status';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_order_status_name', 'it_easy_status'], 'required'],
            [['it_easy_status'], 'string'],
            [['created_time', 'updated_time'], 'safe'],
            [['created_by', 'updated_by'], 'integer'],
            [['it_easy_order_status_name'], 'string', 'max' => 70],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_order_status_id' => 'Order Status ID',
            'it_easy_order_status_name' => 'Order Status Name',
            'it_easy_status' => 'Status',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
        ];
    }
}
