<?php

namespace backend\models;

use Yii;
use backend\models\ItEasyFinancialYear;
use backend\models\ItEasyShippingApi;
use backend\models\ItEasyOrderDispatch;

/**
 * This is the model class for table "it_easy_order_track_2023_2024".
 *
 * @property int $id
 * @property int $vendor_id
 * @property int $order_id
 * @property string $order_awb
 * @property int $shipping_id
 * @property string $awb_number
 * @property string $order_status
 * @property string|null $courier_comment
 * @property string|null $courier_time
 * @property string|null $created_time
 */
class ItEasyOrderTrack extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {	
      	$today_date = date('Y-m-d');
        $ge_financial = ItEasyFinancialYear::find()->select(['it_easy_financial_year'])->where(['or',['<=', 'it_easy_date_from', $today_date], ['>=', 'it_easy_date_to', $today_date] ])->asArray()->one();
        return 'it_easy_order_track_'.$ge_financial['it_easy_financial_year'];
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['vendor_id', 'order_id', 'order_awb', 'shipping_id', 'awb_number', 'order_status'], 'required'],
            [['vendor_id', 'order_id', 'shipping_id'], 'integer'],
            [['courier_time', 'created_time', 'location', 'status_code'], 'safe'],
            [['order_awb', 'awb_number'], 'string', 'max' => 40],
            [['order_status'], 'string', 'max' => 100],
            [['courier_comment'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'vendor_id' => 'Vendor ID',
            'order_id' => 'Order ID',
            'order_awb' => 'Order Awb',
            'shipping_id' => 'Shipping ID',
            'awb_number' => 'Awb Number',
            'order_status' => 'Order Status',
            'courier_comment' => 'Courier Comment',
            'courier_time' => 'Courier Time',
            'created_time' => 'Created Time',
        ];
    }

    public function getTrackshipdelight($da){
        ini_set('memory_limit', '-1');
        ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL);
        if(!empty($da)){
            // echo "<pre>"; print_r($da);die; 
            foreach($da as $key => $val){ 
                // if($i == 1){
                ItEasyOrderTrack::deleteAll(['in','it_easy_awb_number',$val]);
                // }
				//print_r($da);die;
                $awb = implode(',', $val);
        
                date_default_timezone_set("Asia/Kolkata");
                $create_date=date("Y-m-d H:i:s");
                $url_ship='https://crm.shipdelight.com/index.php/api/detailed_status/trackAwb?awb='.$awb;   
                $ch_ship = curl_init($url_ship);
                curl_setopt($ch_ship, CURLOPT_CUSTOMREQUEST, "GET");
                curl_setopt($ch_ship, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch_ship, CURLOPT_FOLLOWLOCATION, 1);
                $response = curl_exec($ch_ship);
                $returnarray = json_decode($response, true);
                // echo "<pre>"; print_r($returnarray); 
                if(isset($returnarray[0]['scan_detail']) && !empty($returnarray[0]['scan_detail'])){
                    foreach($returnarray as $key => $value){
                        $count = count($value['scan_detail']);
                            $i = 1;
                        if(!empty($value['scan_detail'])){  
                            foreach ($value['scan_detail'] as $key => $track) {
                            
                                
                              
                              	
                              	$data = ItEasyOrderDispatch::findOne(['it_easy_awb_number' =>$track['awbno'] ]);
                          
                          		$order_data = ItEasyOrder::findOne(['it_easy_order_id' =>$data->it_easy_order_id ]);
                              	
                                $trackModel = new ItEasyOrderTrack();
                                $trackModel->it_easy_vendor_id = $data->it_easy_user_id;
                                $trackModel->it_easy_order_id = $data->it_easy_order_id;
                                $trackModel->it_easy_order_awb = $data->it_easy_order_number;
                                $trackModel->it_easy_shipping_id = '4';
                                $trackModel->it_easy_order_status =  $track['status'];
                                $trackModel->it_easy_awb_number = $data->it_easy_awb_number;
                                $trackModel->it_easy_courier_comment =  $track['remarks'];
                                $trackModel->it_easy_location =  $track['location'];
                                $trackModel->it_easy_status_code = $track['status_code'];
                                $trackModel->it_easy_courier_time = $track['updated_date'];
                                $trackModel->created_time = $create_date;
                                $trackModel->save(false);
                                if($i == 1){
                                    $data->it_easy_awb_time = $track['updated_date'];
                                    $data->save(false);
                                }
                                if($track['reason_code'] == 'PICKUP DONE'){
                                    $data->it_easy_pickup_time = $track['updated_date'];
                                  	$order_data->it_easy_order_status_id = '29';
                              		$order_data->save(false);
                                    $data->save(false);
                                }
                                if($track['status'] == 'Delivered' || $track['status'] == 'DELIVERED'){
                                    $data->it_easy_delivery_date = $track['updated_date'];
                                  	$order_data->it_easy_order_status_id = '3';
                                    $order_data->it_easy_delivered_time = $track['updated_date'];
                                    $order_data->save(false);
                                    $data->save(false);
                                }
                                if($track['status'] == 'Order Allocated'){
                                    $trackModel->it_easy_order_status =  'IN-TRANSIT';
                                  	$order_data->it_easy_order_status_id = '27';
                              		$order_data->save(false);
                                    $trackModel->save(false);
                                }
                                if($track['status'] == 'Out for Pickup'){
                                    $trackModel->it_easy_order_status =  'Booked';
                                  	$order_data->it_easy_order_status_id = '31';
                              		$order_data->save(false);
                                    $trackModel->save(false);
                                }
                                if($track['status'] == 'Unattempted'){
                                    $trackModel->it_easy_order_status =  'Undelivered';
                                	$order_data->it_easy_order_status_id = '9';
                              		$order_data->save(false);
                                    $trackModel->save(false);
                                }
                                if($track['status'] == 'OUT FOR DELIVERY'){
                                    if(empty($data->it_easy_last_scan_date)){
                                        $data->it_easy_last_scan_date = $track['updated_date'];
                                        $data->it_easy_attempt_count = '1';
                                        $data->save(false);
                                    }else{
                                        if(date('Y-m-d') != date('Y-m-d', strtotime($data->it_easy_last_scan_date))){
                                            $data->it_easy_last_scan_date = $track['updated_date'];
                                            $data->it_easy_attempt_count = $data->it_easy_attempt_count +1;
                                            $data->save(false);
                                        }
                                    }
                                  
                                  	$order_data->it_easy_order_status_id = '30';
                              		$order_data->save(false);
                                }
                                if($track['status'] == 'RTO Delivered'){
                                    $data->it_easy_auto_rto_date = $track['updated_date'];
                                    $data->save(false);
                                    $order_data->it_easy_order_status_id = '47';
                              		$order_data->save(false);
                                }
                                if($track['remarks'] == 'Shipment in-scan'){
                                    $data->it_easy_first_scan_date = $track['updated_date'];
                                    $data->save(false);
                                }
                                if($track['status'] == 'UNDELIVERED'){
                                    $trackModel->it_easy_order_status =  'Undelivered';
                                	$order_data->it_easy_order_status_id = '9';
                              		$order_data->save(false);
                                    $trackModel->save(false);
                                }
                                
                                if($track['status'] == 'RTO INITIATED'){
                                    $trackModel->it_easy_order_status =  'RTO Intransit';
                                	$order_data->it_easy_order_status_id = '26';
                              		$order_data->save(false);
                                    $trackModel->save(false);
                                }
                                
                                if($track['status'] == 'RTO IN-TRANSIT'){
                                    $trackModel->it_easy_order_status =  'RTO Intransit';
                                	$order_data->it_easy_order_status_id = '26';
                              		$order_data->save(false);
                                    $trackModel->save(false);
                                }
                                
                                
                                
                                
                                
                                
                                if($i == $count){
                                    $data->it_easy_order_status = $trackModel->it_easy_order_status;
                                    $data->it_easy_courier_comment = $track['remarks'];
                                    $data->it_easy_status_updated_at = $track['updated_date'];
                                    // echo "<pre>"; print_r($track); die;
                                  	$order_data->it_easy_comment = $track['status'];
                              		$order_data->save(false);
                                    $data->save(false);
                                }
                                $i++;
                            }
                        }
                        
                    }
                }
            }
            
        }
    }
    
    
    public function getTrackxpressbees($da){
        // echo "<pre>"; print_r($da);die;
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        if(!empty($da)){
            
            foreach($da as $key => $val){ 
                // if($i == 1){
                // echo "<pre>"; print_r($val); die;
                ItEasyOrderTrack::deleteAll(['in','it_easy_awb_number',$val]);
                // }
              	$couriers = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '3'])->one();
                $awb = implode(',', $val);
                $search['XBkey'] = 'sWEzpvwQvEqc1026Sb4HamqPQ';
                $search['AWBNo'] = $awb;
                
                date_default_timezone_set("Asia/Kolkata");
                $create_date=date("Y-m-d H:i:s");
                //$xsprs_url="http://49.248.221.43:803/StandardForwardStagingService.svc/GetBulkShipmentStatus";       
                $xsprs_url="https://xbclientapi.xbees.in/TrackingService.svc/GetShipmentSummaryDetails";
            
                $ch_xsprs = curl_init();
                $headers= array('Accept: application/json','Content-Type: application/json');
                curl_setopt($ch_xsprs, CURLOPT_URL, $xsprs_url);
                curl_setopt($ch_xsprs, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch_xsprs, CURLOPT_POST, 1);
                curl_setopt($ch_xsprs, CURLOPT_POSTFIELDS,json_encode($search));
                curl_setopt($ch_xsprs, CURLOPT_RETURNTRANSFER, true);
                $response  = curl_exec($ch_xsprs);
                $returnarray = json_decode($response, true);
                // echo "<pre>"; print_r($returnarray); die;
                if(isset($returnarray[0]['ShipmentSummary']) && !empty($returnarray[0]['ShipmentSummary'])){
                    foreach($returnarray as $key => $value){
                        
                        if (is_array($value['ShipmentSummary'])){
                            $count = count($value['ShipmentSummary']);
                        
                        
                        // echo $count; die;
                            $i = 1;
                          
                        foreach ($value['ShipmentSummary'] as $key => $track) {
                
                            
                            $data = ItEasyOrderDispatch::findOne(['it_easy_awb_number' =>$value['AWBNo'] ]);
                          
                          	$order_data = ItEasyOrder::findOne(['it_easy_order_id' =>$data->it_easy_order_id ]);
                            $trackModel = new ItEasyOrderTrack();
                            $trackModel->it_easy_vendor_id = $data->it_easy_user_id;
                            $trackModel->it_easy_order_id = $data->it_easy_order_id;
                            $trackModel->it_easy_order_awb = $data->it_easy_order_number;
                            $trackModel->it_easy_shipping_id = '3';
                            $trackModel->it_easy_order_status =  $track['Status'];
                            $trackModel->it_easy_awb_number = $data->it_easy_awb_number;
                            $trackModel->it_easy_courier_comment =  $track['Status'];
                            $trackModel->it_easy_location =  $track['Location'];
                            $trackModel->it_easy_status_code = $track['StatusCode'];
                            $trackModel->it_easy_courier_time = date('Y-m-d', strtotime($track['StatusDate'])).' '.date('H:i:s', strtotime($track['StatusTime']));
                            $trackModel->created_time = $create_date;
                            $trackModel->save(false);
                            if($i == $count){
                                $data->it_easy_awb_time = date('Y-m-d', strtotime($track['StatusDate'])).' '.date('H:i:s', strtotime($track['StatusTime']));
                                $data->save(false);
                            }
                            if($track['StatusCode'] == 'PKD'){
                                $data->it_easy_pickup_time = date('Y-m-d', strtotime($track['StatusDate'])).' '.date('H:i:s', strtotime($track['StatusTime']));
                              	
                                $data->save(false);
                            }
                            if($track['StatusCode'] == 'PUD'){
                                $data->it_easy_first_scan_date = date('Y-m-d', strtotime($track['StatusDate'])).' '.date('H:i:s', strtotime($track['StatusTime']));
                                $data->save(false);
                            }
                            
                            if($track['Status'] == 'Add Incomplete/ Incorrect  & Mobile not reachable'){
                                $trackModel->it_easy_order_status =  'Undelivered';
                                $trackModel->save(false);
                            }
                            if($track['Status'] == 'COD Amount Not Ready'){
                                $trackModel->it_easy_order_status =  'Undelivered';
                                $trackModel->save(false);
                            }
                            if($track['Status'] == 'Customer Not Available & Mobile not reachable'){
                                $trackModel->it_easy_order_status =  'Undelivered';
                                $trackModel->save(false);
                            }
                            if($track['Status'] == 'Customer Out of Station'){
                                $trackModel->it_easy_order_status =  'Undelivered';
                                $trackModel->save(false);
                            }
                            if($track['Status'] == 'Customer Refused To Accept'){
                                $trackModel->it_easy_order_status =  'Undelivered';
                                $trackModel->save(false);
                            }
                            
                            if($track['Status'] == 'Self Collect'){
                                $trackModel->it_easy_order_status =  'Undelivered';
                                $trackModel->save(false);
                            }
                            
                            if($track['Status'] == 'Long Pincode'){
                                $trackModel->it_easy_order_status =  'Undelivered';
                                $trackModel->save(false);
                            }
                            
                            if($track['Status'] == 'Address incomplete'){
                                $trackModel->it_easy_order_status =  'Undelivered';
                                $trackModel->save(false);
                            }
                            
                            
                            if($track['Status'] == 'Customer not available x Customer not available at given address and not reachable over phone'){
                                $trackModel->it_easy_order_status =  'Undelivered';
                                $trackModel->save(false);
                            }
                            
                            if($track['Status'] == 'Customer wants future delivery'){
                                $trackModel->it_easy_order_status =  'Undelivered';
                                $trackModel->save(false);
                            }
                            if($track['Status'] == 'Customer Wants Open Delivery'){
                                $trackModel->it_easy_order_status =  'Undelivered';
                                $trackModel->save(false);
                            }
                            if($track['Status'] == 'Delivery not attempted (time constraint)'){
                                $trackModel->it_easy_order_status =  'Undelivered';
                                $trackModel->save(false);
                            }
                            if($track['Status'] == 'Entry not permitted'){
                                $trackModel->it_easy_order_status =  'Undelivered';
                                $trackModel->save(false);
                            }
                            if($track['Status'] == 'Future Delivery : Requested by Customer'){
                                $trackModel->it_easy_order_status =  'In-Transit';
                                $trackModel->save(false);
                            }
                            if($track['Status'] == 'InTransit'){
                                $trackModel->it_easy_order_status =  'In-Transit';
                                $trackModel->save(false);
                            }
                            if($track['Status'] == 'NonDeliveredDispute'){
                                $trackModel->it_easy_order_status =  'Undelivered';
                                $trackModel->save(false);
                            }
                            if($track['Status'] == 'ODA (Out Of Delivery Area)'){
                                $trackModel->it_easy_order_status =  'Undelivered';
                                $trackModel->save(false);
                            }
                            if($track['Status'] == 'Reached at Destination'){
                                $trackModel->it_easy_order_status =  'In-Transit';
                                $trackModel->save(false);
                            }
                            if($track['Status'] == 'Reached at Origin'){
                                $trackModel->it_easy_order_status =  'In-Transit';
                                $trackModel->save(false);
                            }
                            if($track['Status'] == "Residence/Office Closed : Can't Deliver"){
                                $trackModel->it_easy_order_status =  'Undelivered';
                                $trackModel->save(false);
                            }
                            if($track['Status'] == 'Return Delivered'){
                                $trackModel->it_easy_order_status =  'RTO Delivered';
                                $trackModel->save(false);
                                $data->it_easy_order_status = $trackModel->it_easy_order_status;
                                $data->it_easy_courier_comment = $track['Status'];
                                $data->it_easy_status_updated_at = date('Y-m-d', strtotime($track['StatusDate'])).' '.date('H:i:s', strtotime($track['StatusTime']));
                                $data->save(false);
                            }
                            if($track['Status'] == 'Return to Origin' || $track['Status'] == 'Return to Origin Intransit' || $track['Status'] == 'Return to Origin Out for Delivery'){
                                $trackModel->it_easy_order_status =  'RTO In-Transit';
                                $trackModel->save(false);
                            }
                            if($track['Status'] == 'Return Undelivered'){
                                $trackModel->it_easy_order_status =  'RTO Undelivered';
                                $trackModel->save(false);
                                
                            }
                            if($track['Status'] == 'UnAssign Shipment from SR to ReAssign for delivery'){
                                $trackModel->it_easy_order_status =  'In-Transit';
                                $trackModel->save(false);
                            }
                            if($track['Status'] == 'Out for Delivery'){
                                if(empty($data->it_easy_last_scan_date)){
                                    $data->it_easy_last_scan_date = date('Y-m-d', strtotime($track['StatusDate'])).' '.date('H:i:s', strtotime($track['StatusTime']));
                                    $data->it_easy_attempt_count = '1';
                                    $data->save(false);
                                }else{
                                    if(date('Y-m-d') != date('Y-m-d', strtotime($data->it_easy_last_scan_date))){
                                        $data->it_easy_last_scan_date = date('Y-m-d', strtotime($track['StatusDate'])).' '.date('H:i:s', strtotime($track['StatusTime']));
                                        $data->it_easy_attempt_count = $data->it_easy_attempt_count +1;
                                        $data->save(false);
                                    }
                                }
                            }
                            if($track['Status'] == 'Return Delivered'){
                                $data->it_easy_auto_rto_date = date('Y-m-d', strtotime($track['StatusDate'])).' '.date('H:i:s', strtotime($track['StatusTime']));
                                $data->save(false);
                            }
                            if($track['Status'] == 'Delivered'){
                                $data->it_easy_delivery_date = date('Y-m-d', strtotime($track['StatusDate'])).' '.date('H:i:s', strtotime($track['StatusTime']));
                                $data->save(false);
                            }
                            if($i == 1){
                                if($track['Status'] == 'Delivered'){
                                    $order_data->it_easy_order_status_id = '3';
                                  	$order_data->it_easy_delivered_time = date('Y-m-d', strtotime($track['StatusDate'])).' '.date('H:i:s', strtotime($track['StatusTime']));
                                  	$order_data->save(false);
                                }
                                
                                
                                
                                if($track['StatusCode'] == 'PUD'){
                                  	$order_data->it_easy_order_status_id = '27';
                                  	$order_data->save(false);
                                }
                                
                                if($track['Status'] == 'Add Incomplete/ Incorrect  & Mobile not reachable'){
                                  	$order_data->it_easy_order_status_id = '9';
                                  	$order_data->save(false);
                                }
                                if($track['Status'] == 'COD Amount Not Ready'){
                                  	$order_data->it_easy_order_status_id = '9';
                                  	$order_data->save(false);
                                }
                                if($track['Status'] == 'Customer Not Available & Mobile not reachable'){
                                  	$order_data->it_easy_order_status_id = '9';
                                  	$order_data->save(false);
                                }
                                if($track['Status'] == 'Customer Out of Station'){
                                  	$order_data->it_easy_order_status_id = '9';
                                  	$order_data->save(false);
                                }
                                if($track['Status'] == 'Customer Refused To Accept'){
                                  	$order_data->it_easy_order_status_id = '9';
                                  	$order_data->save(false);
                                }
                                if($track['Status'] == 'Customer Wants Open Delivery'){
                                  	$order_data->it_easy_order_status_id = '9';
                                  	$order_data->save(false);
                                }
                                if($track['Status'] == 'Delivery not attempted (time constraint)'){
                                  	$order_data->it_easy_order_status_id = '9';
                                  	$order_data->save(false);
                                }
                                if($track['Status'] == 'Entry not permitted'){
                                
                                  	$order_data->it_easy_order_status_id = '9';
                                  	$order_data->save(false);
                                }
                                if($track['Status'] == 'Future Delivery : Requested by Customer'){
                                  	$order_data->it_easy_order_status_id = '27';
                                  	$order_data->save(false);
                                }
                                if($track['Status'] == 'InTransit'){
                                  	$order_data->it_easy_order_status_id = '27';
                                  	$order_data->save(false);
                                }
                                if($track['Status'] == 'NonDeliveredDispute'){
                                  	$order_data->it_easy_order_status_id = '9';
                                  	$order_data->save(false);
                                }
                                if($track['Status'] == 'ODA (Out Of Delivery Area)'){
                                  	$order_data->it_easy_order_status_id = '9';
                                  	$order_data->save(false);
                                }
                                if($track['Status'] == 'Reached at Destination'){
                                  	$order_data->it_easy_order_status_id = '27';
                                  	$order_data->save(false);
                                }
                                if($track['Status'] == 'Reached at Origin'){
                                    
                                  	$order_data->it_easy_order_status_id = '27';
                                  	$order_data->save(false);
                                }
                                if($track['Status'] == "Residence/Office Closed : Can't Deliver"){
                                  	$order_data->it_easy_order_status_id = '9';
                                  	$order_data->save(false);
                                }
                                
                                
                                
                                if($track['Status'] == "Long Pincode"){
                                  	$order_data->it_easy_order_status_id = '9';
                                  	$order_data->save(false);
                                }
                                
                                if($track['Status'] == "Self Collect"){
                                  	$order_data->it_easy_order_status_id = '27';
                                  	$order_data->save(false);
                                }
                                
                                if($track['Status'] == "Address incomplete"){
                                  	$order_data->it_easy_order_status_id = '9';
                                  	$order_data->save(false);
                                }
                                
                                if($track['Status'] == "Customer wants future delivery"){
                                  	$order_data->it_easy_order_status_id = '27';
                                  	$order_data->save(false);
                                }
                                
                                
                                if($track['Status'] == 'Return to Origin' || $track['Status'] == 'Return to Origin Intransit' || $track['Status'] == 'Return to Origin Out for Delivery'){
                                    
                                  	$order_data->it_easy_order_status_id = '26';
                                  	$order_data->save(false);
                                }
                                if($track['Status'] == 'Return Undelivered'){
                                  	$order_data->it_easy_order_status_id = '47';
                                  	$order_data->save(false);
                                    
                                }
                                if($track['Status'] == 'UnAssign Shipment from SR to ReAssign for delivery'){
                                  	$order_data->it_easy_order_status_id = '27';
                                  	$order_data->save(false);
                                }
                                if($track['Status'] == 'Out for Delivery'){
                                
                                  	$order_data->it_easy_order_status_id = '30';
                              		$order_data->save(false);
                                    
                                }
                                
                                
                                if($track['Status'] == "Customer not available x Customer not available at given address and not reachable over phone"){
                                  	$order_data->it_easy_order_status_id = '9';
                                  	$order_data->save(false);
                                }
                                
                                if($track['Status'] == "Customer not available x Customer out of station"){
                                  	$order_data->it_easy_order_status_id = '9';
                                  	$order_data->save(false);
                                }
                                
                                
                                if($track['Status'] == 'Delivered'){
                    
                                  	$order_data->it_easy_order_status_id = '3';
                                  	$order_data->it_easy_delivered_time = date('Y-m-d', strtotime($track['StatusDate'])).' '.date('H:i:s', strtotime($track['StatusTime']));
                                  	$order_data->save(false);
                                }
                                
                                
                                
                                
                                
                                $data->it_easy_order_status = $trackModel->it_easy_order_status;
                                $data->it_easy_courier_comment = $track['Status'];
                              	$order_data->it_easy_comment = $track['Status'];
                              	$order_data->save(false);
                                $data->it_easy_status_updated_at = date('Y-m-d', strtotime($track['StatusDate'])).' '.date('H:i:s', strtotime($track['StatusTime']));
                                $data->save(false);
                            }
                            $i++;
                            // echo "<pre>"; print_r($order_data); die;
                        }
                        }
                        
                    }
                }
            }
            
        }
    }
    
    
    public function getTrackEkart($dat){
        ini_set('memory_limit', '512M');
        if(!empty($dat)){
        foreach($dat as $key => $da){     
            // if($i == 1){
            SolLogisTrackAwb::deleteAll(['in','awb_number',$da]);
            // }
            $search = [];
            $search['tracking_ids'] = $da;
            
            date_default_timezone_set("Asia/Kolkata");
            $create_date=date("Y-m-d H:i:s");
            $chdlv = curl_init();
            curl_setopt($chdlv, CURLOPT_URL, "https://api.ekartlogistics.com/v2/shipments/track");
            curl_setopt($chdlv, CURLOPT_POST, true);
            curl_setopt($chdlv, CURLOPT_POSTFIELDS, json_encode($search));
            curl_setopt($chdlv, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($chdlv, CURLOPT_HTTPHEADER, array(
                "Content-Type: application/json",
                "HTTP_X_MERCHANT_CODE: ESR",
                "Authorization: Basic anNxdWFyZWVudGVycHJzaXNlczpdbXJdVE1VeXsqNX1HcTVx",
            ));
            $result = curl_exec($chdlv);
            $returnarray = json_decode($result, true);
            // echo "<pre>"; print_r($returnarray); die;
            if(isset($returnarray) && !empty($returnarray)){
                foreach($returnarray as $key => $value){
                    if(!empty($value['history'])){
                    $count = count($value['history']);
                        $i = 1;
                      
                    foreach ($value['history'] as $key => $track) {
                        
                        // if(!isset($track['description'])){
                        //     echo "<pre>"; print_r($track); die;
                        // }
                        $data = SolLogisOrders::findOne(['awb_number' =>$value['shipment_id'] ]);
                        // echo "<pre>"; print_r($data); die;
                        $trackModel = new SolLogisTrackAwb();
                        $trackModel->vendor_id = $data->vendor_id;
                        $trackModel->order_id = $data->id;
                        $trackModel->order_awb = $data->order_number;
                        $trackModel->shipping_id = '7';
                        $trackModel->order_status =  $track['status'];
                        $trackModel->awb_number = $data->awb_number;
                        $trackModel->courier_comment =  isset($track['description']) ? $track['description']: '';
                        $trackModel->location =  $track['city'];
                        $trackModel->status_code = '100';
                        $trackModel->courier_time = date('Y-m-d H:i:s', strtotime($track['event_date']));
                        $trackModel->created_time = $create_date;
                        $trackModel->save(false);
                        if($i == $count){
                            
                            $data->awb_time = date('Y-m-d H:i:s', strtotime($track['event_date']));
                            $data->save(false);
                        }
                        if($track['status'] == 'pickup_complete'){
                            $trackModel->order_status =  'PICKUP DONE';
                            $trackModel->save(false);
                            $data->pickup_date = date('Y-m-d H:i:s', strtotime($track['event_date']));
                            $data->save(false);
                        }
                        if($track['status'] == 'shipment_expected'){
                            $trackModel->order_status =  'IN-TRANSIT';
                            $trackModel->save(false);
                        }
                        if($track['status'] == 'undelivered_due_to_cash_unavailability' || $track['status'] == 'undelivered_due_to_customer_unavailability' || $track['status'] == 'undelivered_due_to_rejection_by_customer' ||  $track['status'] == 'unsuccessful_delivery_attempt_due_to_address_issues' ||  $track['status'] == 'unsuccessful_delivery_attempt_due_to_serviceability_issues'){
                            $trackModel->order_status =  'Undelivered';
                            $trackModel->courier_comment =  $track['status'];
                            $trackModel->save(false);
                        }
                        if($track['status'] == 'in_transit'){
                            $trackModel->order_status =  'IN-TRANSIT';
                            $trackModel->save(false);
                            $data->first_scan_date = date('Y-m-d H:i:s', strtotime($track['event_date']));
                            $data->save(false);
                        }
                        if($track['status'] == 'delivered'){
                            $data->end_delivery_date = date('Y-m-d H:i:s', strtotime($track['event_date']));
                            $data->save(false);
                        }
                        if($track['status'] == 'out_for_delivery'){
                            if(empty($data->it_easy_last_scan_date)){
                                $data->it_easy_last_scan_date = date('Y-m-d H:i:s', strtotime($track['event_date']));
                                $data->it_easy_attempt_count = '1';
                                $data->save(false);
                            }else{
                                if(date('Y-m-d') != date('Y-m-d', strtotime($data->it_easy_last_scan_date))){
                                    $data->it_easy_last_scan_date = date('Y-m-d H:i:s', strtotime($track['event_date']));
                                    $data->it_easy_attempt_count = $data->it_easy_attempt_count +1;
                                    $data->save(false);
                                }
                            }
                            $trackModel->order_status =  'OUT FOR DELIVERY';
                            $trackModel->save(false);
                        }
                        if($track['status'] == 'RETURN TO SHIPPER ' || $track['status'] == 'rto_completed' || $track['status'] == 'rto_received' || $track['status'] == 'RTO DELIVERED'){
                            $trackModel->order_status = 'RTO DELIVERED';
                            $trackModel->save(false);
                            $data->rto_Delivery_date = date('Y-m-d H:i:s', strtotime($track['created']));
                            $data->save(false);
                        }
                        if($i == 1){
                            $data->order_status = $trackModel->order_status;
                            $data->courier_comment = $trackModel->courier_comment;
                            $data->status_updated_at = date('Y-m-d H:i:s', strtotime($track['event_date']));
                            $data->save(false);
                        }
                        $i++;
                    }
                    }
                    
                }
            }
        }
        }
    }
    
    public function getTrackShadow($da){
        ini_set('memory_limit', '512M');
        if(!empty($da)){
            
            // if($i == 1){
            SolLogisTrackAwb::deleteAll(['in','awb_number',$da]);
            // }
            $search = [];
            $search['awb_numbers'] = $da;
            // echo json_encode($search); die;
            date_default_timezone_set("Asia/Kolkata");
            $create_date=date("Y-m-d H:i:s");
            
            $ch = curl_init();

            curl_setopt($ch, CURLOPT_URL, "https://dale.shadowfax.in/api/v2/clients/bulk_track/?format=json");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_HEADER, FALSE);
            
            curl_setopt($ch, CURLOPT_POST, TRUE);
            
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($search));
            
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                "Content-Type:application/json",
              "Authorization: Token 69e04e90095c3eb352c7ce4b3c5611c34d253a19"
            ));
            
            $response = curl_exec($ch);
            
            $returnarray = json_decode($response, true);
            curl_close($ch);
            
            if(isset($returnarray['data']) && !empty($returnarray['data'])){
                
                foreach($returnarray['data'] as $key => $value){
                    
                    $count = count($value['tracking_details']);
                        $i = 1;
                      
                    foreach ($value['tracking_details'] as $key => $track) {
                        // echo "<pre>"; print_r($track); die;
                        
                        $data = SolLogisOrders::findOne(['awb_number' =>$value['awb_number'] ]);
                        // echo "<pre>"; print_r($data); die;
                        $trackModel = new SolLogisTrackAwb();
                        $trackModel->vendor_id = $data->vendor_id;
                        $trackModel->order_id = $data->id;
                        $trackModel->order_awb = $data->order_number;
                        $trackModel->shipping_id = '8';
                        $trackModel->order_status =  $track['status'];
                        $trackModel->awb_number = $data->awb_number;
                        $trackModel->courier_comment =  $track['remarks'];
                        $trackModel->location =  $track['location'];
                        $trackModel->status_code = '100';
                        $trackModel->courier_time = date('Y-m-d H:i:s', strtotime($track['created']));
                        $trackModel->created_time = $create_date;
                        $trackModel->save(false);
                        if($i == 1){
                            $data->awb_time = date('Y-m-d H:i:s', strtotime($track['created']));
                            $data->save(false);
                        }
                        if($track['status_id'] == 'recd_at_rev_hub'){
                            $data->pickup_date = date('Y-m-d H:i:s', strtotime($track['created']));
                            $data->save(false);
                        }
                        if($track['status_id'] == 'assigned_for_seller_pickup'){
                            $data->first_scan_date = date('Y-m-d H:i:s', strtotime($track['created']));
                            $data->save(false);
                        }
                        if($track['status'] == 'Delivered'){
                            $data->end_delivery_date = date('Y-m-d H:i:s', strtotime($track['created']));
                            $data->save(false);
                        }
                        if($track['status'] == 'Assigned For Delivery' || $track['status'] == 'Assigned For Pickup' || $track['status'] == 'Not Attempted'  || $track['status'] == 'Received at Forward Hub'  || $track['status'] == 'Received at Reverse Hub'  || $track['status'] == 'Sent to Forward' || $track['status'] == 'rto_in_transit'){
                            $trackModel->order_status = 'IN-TRANSIT';
                            $trackModel->save(false);
                        }
                        if($track['status'] == 'Not Attempted' || $track['status'] == 'Not Contactable' || $track['status'] == 'On Hold'){
                            $trackModel->order_status = 'Undelivered';
                            $trackModel->save(false);
                        }
                        if($track['status'] == 'Returned To Client' || $track['status'] == 'rto_completed' || $track['status'] == 'rto_received' || $track['status'] == 'RTO DELIVERED'){
                            $trackModel->order_status = 'RTO DELIVERED';
                            $trackModel->save(false);
                            $data->rto_Delivery_date = date('Y-m-d H:i:s', strtotime($track['created']));
                            $data->save(false);
                        }
                        if($track['status'] == 'Picked'){
                            $trackModel->order_status = 'PICKUP DONE';
                            $trackModel->save(false);
                        }
                        if($track['status'] == 'Return to Seller initiated'){
                            $trackModel->order_status = 'RTO IN-TRANSIT';
                            $trackModel->save(false);
                        }
                        if($track['status'] == 'Out For Delivery'){
                            if(empty($data->it_easy_last_scan_date)){
                                $data->it_easy_last_scan_date = date('Y-m-d H:i:s', strtotime($track['created']));
                                $data->it_easy_attempt_count = '1';
                                $data->save(false);
                            }else{
                                if(date('Y-m-d') != date('Y-m-d', strtotime($data->it_easy_last_scan_date))){
                                    $data->it_easy_last_scan_date = date('Y-m-d H:i:s', strtotime($track['created']));
                                    $data->it_easy_attempt_count = $data->it_easy_attempt_count +1;
                                    $data->save(false);
                                }
                            }
                        }
                        if($i == $count){
                            $data->order_status = $trackModel->order_status;
                            $data->courier_comment = $track['remarks'];
                            $data->status_updated_at = date('Y-m-d H:i:s', strtotime($track['created']));
                            $data->save(false);
                        }
                        $i++;
                    }
                    
                }
            }
        }
    }
    
  
  	public function getTrackEcom($dat){
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        if(!empty($dat)){
        foreach($dat as $key => $da){ 
            ItEasyOrderTrack::deleteAll(['in','it_easy_awb_number',$da]);
          	$couriers = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '2'])->one();
            $awb_numbers = implode(',',$da);
            date_default_timezone_set("Asia/Kolkata");
            $create_date=date("Y-m-d H:i:s");
          	$url= "https://plapi.ecomexpress.in/track_me/api/mawbd/?awb=".$awb_numbers."&order=&username=".$couriers->it_easy_userName."&password=".$couriers->it_easy_passWord;
          
            $headers= array('Accept: application/json','Content-Type: application/json');
      
            $ch4 = curl_init($url);
            curl_setopt($ch4, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch4, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch4, CURLOPT_HTTPHEADER,  $headers);
            $marketer_json = curl_exec($ch4);
            
            $xml = simplexml_load_string($marketer_json);
          
            // echo "<pre>"; print_r($xml); die;
            if(isset($xml) && !empty($xml)){
            	foreach($xml as $key => $value){
            	    
                  if(isset($value->field[36]) && !empty($value->field[36])){
                      $awb_number_s = strval($value->field[0]);
                    $data = ItEasyOrderDispatch::findOne(['it_easy_awb_number' =>$awb_number_s, 'it_easy_shipping_id' => '2' ]);
                    $data->it_easy_attempt_count = '0';
                    $data->it_easy_return_awb = $value->field[22];
                  	$order_data = ItEasyOrder::findOne(['it_easy_order_id' =>$data->it_easy_order_id ]);
                     $count = count($value->field[36]);
                        $i = 1;
                    foreach($value->field[36] as $track){
                        $date_array = explode(',', $track->field[0]);
                        $date_courier = date('Y', strtotime($date_array[1])).'-'.date('m-d', strtotime($date_array[0])).' '.date('H:i', strtotime($date_array[2])).':00';
                        
                        
                        $trackModel = new ItEasyOrderTrack();
                        $trackModel->it_easy_vendor_id = $data->it_easy_user_id;
                        $trackModel->it_easy_order_id = $data->it_easy_order_id;
                        $trackModel->it_easy_order_awb = $data->it_easy_order_number;
                        $trackModel->it_easy_shipping_id = '2';
                        $trackModel->it_easy_order_status =  strval($track->field[4]);
                        $trackModel->it_easy_awb_number = $data->it_easy_awb_number;
                        $trackModel->it_easy_courier_comment =  strval($track->field[2]);
                        $trackModel->it_easy_location =  strval($track->field[6]);
                        $trackModel->it_easy_status_code = strval($track->field[3]);
                        $trackModel->it_easy_courier_time = $date_courier;
                        $trackModel->save(false);
                        // echo "<pre>"; print_R($trackModel); die;
                        if($i == $count){
                            $data->it_easy_awb_time = $date_courier;
                            $data->save(false);
                        }
                        if($track->field[1] == 'Shipment Picked Up'){
                            $data->it_easy_pickup_time = $date_courier;
                          	$order_data->it_easy_order_status_id = '29';
                            $order_data->save(false);
                            $data->save(false);
                        }
                        if($track->field[1] == 'Shipment in-scan at DC'){
                            $data->it_easy_first_scan_date = $date_courier;
                          	$order_data->it_easy_order_status_id = '27';
                            $order_data->save(false);
                            $data->save(false);
                        }
                        if($track->field[4] == 'OUT'){
                            if(empty($data->it_easy_last_scan_date)){
                                $data->it_easy_last_scan_date = $date_courier;
                                $data->it_easy_attempt_count = '1';
                                $data->save(false);
                            }else{
                                if(date('Y-m-d') != date('Y-m-d', strtotime($data->it_easy_last_scan_date))){
                                    $data->it_easy_last_scan_date = $date_courier;
                                    $data->it_easy_attempt_count = $data->it_easy_attempt_count +1;
                                    $data->save(false);
                                }
                            }
                          
                          	$order_data->it_easy_order_status_id = '30';
                            $order_data->save(false);
                          	$trackModel->it_easy_order_status = 'OUT FOR Delivery';
                          	$trackModel->save(false);
                        }
                        
                        
                        if($track->field[1] == 'In-Transit' || $track->field[4] == 'IN'){
                            
                                $trackModel->it_easy_order_status = 'In-Transit';
                              	$order_data->it_easy_order_status_id = '27';
                            	$order_data->save(false);
                                $trackModel->save(false);
                            
                        }
                        if($track->field[1] == 'Shipment delivered'){
                            $data->it_easy_delivery_date = $date_courier;
                          	$order_data->it_easy_order_status_id = '3';
                          	$order_data->it_easy_delivered_time = $date_courier;
                            $order_data->save(false);
                            $data->save(false);
                          	$trackModel->it_easy_order_status = 'DELIVERED';
                          	$trackModel->save(false);
                        }
                        if($i == 1){
                            
                            $data->it_easy_order_status = $trackModel->it_easy_order_status;
                            $data->it_easy_courier_comment = $track->field[2];
                            if($data->it_easy_courier_comment == '777 - RTS - Return To Shipper'){
                                $data->it_easy_order_status = 'RTO IN-TRANSIT';
                                // $order_data->it_easy_order_status_id = '15';
                            }
                          	$order_data->it_easy_comment = $track->field[2];
                            $order_data->save(false);
                            $data->it_easy_status_updated_at = $date_courier;
                            $data->save(false);
                        }
                        $i++;
                    }
                    
                    		if($value->field[11] == 'In-Transit'){
                                $status_id = '27';
                              
                              
                              	$order_data->it_easy_order_status_id = '27';
                            	$order_data->save(false);
                            }else if($value->field[11] =='Undelivered'){
                                
                              
                              	$order_data->it_easy_order_status_id = '9';
                            	$order_data->save(false);
                            }else if($value->field[11] =='Delivered'){
                                
                                // echo "<pre>"; print_r($date_array2); die;
                                $data->it_easy_order_status = 'Delivered';
                                $data->save(false);
                              	$order_data->it_easy_delivered_time = date('Y-m-d H:i:s', strtotime($value->field[20]));
                              	$order_data->it_easy_order_status_id = '3';
                            	$order_data->save(false);
                            }else if($value->field[11] == 'Out For Delivery'){
                                $order_data->it_easy_order_status_id = '30';
                            	$order_data->save(false);
                            }else if($value->field[11] == 'Connected'){
                                $order_data->it_easy_order_status_id = '27';
                            	$order_data->save(false);
                            }else if($value->field[11] == 'Shipment Redirected'){
                                $order_data->it_easy_order_status_id = '26';
                            	$order_data->save(false);
                            }
                    
                    
                    
                    }
                }
            }
        }
        }
    }
    
    
    
    public function getTrackEcom3($dat){
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        if(!empty($dat)){
        foreach($dat as $key => $da){ 
            ItEasyOrderTrack::deleteAll(['in','it_easy_awb_number',$da]);
          	$couriers = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '2'])->one();
            $awb_numbers = implode(',',$da);
            date_default_timezone_set("Asia/Kolkata");
            $create_date=date("Y-m-d H:i:s");
          	$url= "https://plapi.ecomexpress.in/track_me/api/mawbd/?awb=".$awb_numbers."&order=&username=".$couriers->it_easy_userName."&password=".$couriers->it_easy_passWord;
          
            $headers= array('Accept: application/json','Content-Type: application/json');
      
            $ch4 = curl_init($url);
            curl_setopt($ch4, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch4, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch4, CURLOPT_HTTPHEADER,  $headers);
            $marketer_json = curl_exec($ch4);
            
            $xml = simplexml_load_string($marketer_json);
          
            // echo "<pre>"; print_r($xml); die;
            if(isset($xml) && !empty($xml)){
            	foreach($xml as $key => $value){
            	    
                  if(isset($value->field[36]) && !empty($value->field[36])){
                      $awb_number_s = strval($value->field[0]);
                    $data = ItEasyOrderDispatch::findOne(['it_easy_return_awb' =>$awb_number_s, 'it_easy_shipping_id' => '2' ]);
                    // $data->it_easy_attempt_count = '0';
                    $data->it_easy_return_awb = $value->field[22];
                  	$order_data = ItEasyOrder::findOne(['it_easy_order_id' =>$data->it_easy_order_id ]);
                     $count = count($value->field[36]);
                        $i = 1;
                    foreach($value->field[36] as $track){
                        $date_array = explode(',', $track->field[0]);
                        $date_courier = date('Y', strtotime($date_array[1])).'-'.date('m-d', strtotime($date_array[0])).' '.date('H:i', strtotime($date_array[2])).':00';
                        
                        
                        $trackModel = new ItEasyOrderTrack();
                        $trackModel->it_easy_vendor_id = $data->it_easy_user_id;
                        $trackModel->it_easy_order_id = $data->it_easy_order_id;
                        $trackModel->it_easy_order_awb = $data->it_easy_order_number;
                        $trackModel->it_easy_shipping_id = '2';
                        $trackModel->it_easy_order_status =  strval($track->field[4]);
                        $trackModel->it_easy_awb_number = $data->it_easy_awb_number;
                        $trackModel->it_easy_courier_comment =  strval($track->field[2]);
                        $trackModel->it_easy_location =  strval($track->field[6]);
                        $trackModel->it_easy_status_code = strval($track->field[3]);
                        $trackModel->it_easy_courier_time = $date_courier;
                        $trackModel->save(false);
                        // echo "<pre>"; print_R($trackModel); die;
                        
                        if($track->field[4] == 'OUT'){
                            
                          	$trackModel->it_easy_order_status = 'RTO OUT FOR Delivery';
                          	$trackModel->save(false);
                        }
                        
                        
                        if($track->field[1] == 'In-Transit' || $track->field[4] == 'IN'){
                            
                                $trackModel->it_easy_order_status = 'RTO In-Transit';
                              	$order_data->it_easy_order_status_id = '26';
                            	$order_data->save(false);
                                $trackModel->save(false);
                            
                        }
                        if($track->field[1] == 'Shipment delivered'){
                            $data->it_easy_rto_date = $date_courier;
                          	$order_data->it_easy_order_status_id = '47';
                          	$order_data->it_easy_updated_time = $date_courier;
                            $order_data->save(false);
                            $data->save(false);
                          	$trackModel->it_easy_order_status = 'RTO DELIVERED';
                          	$trackModel->save(false);
                        }
                        if($i == 1){
                            
                            $data->it_easy_order_status = $trackModel->it_easy_order_status;
                            $data->it_easy_courier_comment = $track->field[2];
                          	$order_data->it_easy_comment = $track->field[2];
                            $order_data->save(false);
                            $data->it_easy_status_updated_at = $date_courier;
                            $data->save(false);
                        }
                        $i++;
                    }
                    
                    		if($value->field[11] == 'In-Transit'){
                                $status_id = '27';
                              
                              
                              	$order_data->it_easy_order_status_id = '26';
                            	$order_data->save(false);
                            }else if($value->field[11] =='Undelivered'){
                                
                              
                              	$order_data->it_easy_order_status_id = '9';
                            	$order_data->save(false);
                            }else if($value->field[11] =='Delivered'){
                                
                                // echo "<pre>"; print_r($date_array2); die;
                                $data->it_easy_order_status = 'RTO DELIVERED';
                                $data->save(false);
                              	$order_data->it_easy_order_status_id = '47';
                            	$order_data->save(false);
                            }else if($value->field[11] == 'Out For Delivery'){
                                $order_data->it_easy_order_status_id = '26';
                            	$order_data->save(false);
                            }else if($value->field[11] == 'Connected'){
                                $order_data->it_easy_order_status_id = '26';
                            	$order_data->save(false);
                            }else if($value->field[11] == 'Shipment Redirected'){
                                $order_data->it_easy_order_status_id = '26';
                            	$order_data->save(false);
                            }
                    
                    
                    
                    }
                }
            }
        }
        }
    }
    
    
    
    public function getTrackEcom2($dat){
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        if(!empty($dat)){
        foreach($dat as $key => $da){ 
            ItEasyOrderTrack::deleteAll(['in','it_easy_awb_number',$da]);
          	$couriers = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '6'])->one();
            $awb_numbers = implode(',',$da);
            date_default_timezone_set("Asia/Kolkata");
            $create_date=date("Y-m-d H:i:s");
          	$url= "https://plapi.ecomexpress.in/track_me/api/mawbd/?awb=".$awb_numbers."&order=&username=".$couriers->it_easy_userName."&password=".$couriers->it_easy_passWord;
          
            $headers= array('Accept: application/json','Content-Type: application/json');
      
            $ch4 = curl_init($url);
            curl_setopt($ch4, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch4, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch4, CURLOPT_HTTPHEADER,  $headers);
            $marketer_json = curl_exec($ch4);
            
            $xml = simplexml_load_string($marketer_json);
          
            
            if(isset($xml) && !empty($xml)){
            	foreach($xml as $key => $value){
            	    
                  if(isset($value->field[36]) && !empty($value->field[36])){
                      $awb_number_s = strval($value->field[0]);
                    $data = ItEasyOrderDispatch::findOne(['it_easy_awb_number' =>$awb_number_s, 'it_easy_shipping_id' => '6' ]);
                    $data->it_easy_attempt_count = '0';
                  	$order_data = ItEasyOrder::findOne(['it_easy_order_id' =>$data->it_easy_order_id ]);
                     $count = count($value->field[36]);
                        $i = 1;
                    foreach($value->field[36] as $track){
                        $date_array = explode(',', $track->field[0]);
                        $date_courier = date('Y', strtotime($date_array[1])).'-'.date('m-d', strtotime($date_array[0])).' '.date('H:i', strtotime($date_array[2])).':00';
                        
                        
                        $trackModel = new ItEasyOrderTrack();
                        $trackModel->it_easy_vendor_id = $data->it_easy_user_id;
                        $trackModel->it_easy_order_id = $data->it_easy_order_id;
                        $trackModel->it_easy_order_awb = $data->it_easy_order_number;
                        $trackModel->it_easy_shipping_id = '6';
                        $trackModel->it_easy_order_status =  strval($track->field[4]);
                        $trackModel->it_easy_awb_number = $data->it_easy_awb_number;
                        $trackModel->it_easy_courier_comment =  strval($track->field[2]);
                        $trackModel->it_easy_location =  strval($track->field[6]);
                        $trackModel->it_easy_status_code = strval($track->field[3]);
                        $trackModel->it_easy_courier_time = $date_courier;
                        $trackModel->save(false);
                        // echo "<pre>"; print_R($trackModel); die;
                        if($i == $count){
                            $data->it_easy_awb_time = $date_courier;
                            $data->save(false);
                        }
                        if(strval($track->field[2]) == '777 - RTS - Return To Shipper'){
                          
                            $trackModel->it_easy_order_status = 'RTO IN-TRANSIT';
                          	$trackModel->save(false);
                          	
                         
                        }
                        
                        
                        if($track->field[1] == 'Shipment Picked Up'){
                            $data->it_easy_pickup_time = $date_courier;
                          	$order_data->it_easy_order_status_id = '29';
                            $order_data->save(false);
                            $data->save(false);
                        }
                        if($track->field[1] == 'Shipment in-scan at DC'){
                            $data->it_easy_first_scan_date = $date_courier;
                          	$order_data->it_easy_order_status_id = '27';
                            $order_data->save(false);
                            $data->save(false);
                        }
                        if($track->field[4] == 'OUT'){
                            if(empty($data->it_easy_last_scan_date)){
                                $data->it_easy_last_scan_date = $date_courier;
                                $data->it_easy_attempt_count = '1';
                                $data->save(false);
                            }else{
                                if(date('Y-m-d') != date('Y-m-d', strtotime($data->it_easy_last_scan_date))){
                                    $data->it_easy_last_scan_date = $date_courier;
                                    $data->it_easy_attempt_count = $data->it_easy_attempt_count +1;
                                    $data->save(false);
                                }
                            }
                          
                          	$order_data->it_easy_order_status_id = '30';
                            $order_data->save(false);
                          	$trackModel->it_easy_order_status = 'OUT FOR Delivery';
                          	$trackModel->save(false);
                        }
                        
                        if($track->field[1] == 'Shipment delivered'){
                            $data->it_easy_delivery_date = $date_courier;
                          	$order_data->it_easy_order_status_id = '3';
                          	$order_data->it_easy_delivered_time = $date_courier;
                            $order_data->save(false);
                            $data->save(false);
                          	$trackModel->it_easy_order_status = 'DELIVERED';
                          	$trackModel->save(false);
                        }
                        if($track->field[1] == 'In-Transit' || $track->field[4] == 'IN'){
                            
                                $trackModel->it_easy_order_status = 'In-Transit';
                              	$order_data->it_easy_order_status_id = '27';
                            	$order_data->save(false);
                                $trackModel->save(false);
                            
                        }
                        if($i == 1){
                            $data->it_easy_order_status = $trackModel->it_easy_order_status;
                            $data->it_easy_courier_comment = $track->field[2];
                            
                            if($data->it_easy_courier_comment == '777 - RTS - Return To Shipper'){
                                $data->it_easy_order_status = 'RTO IN-TRANSIT';
                            
                                // $order_data->it_easy_order_status_id = '15';
                            }
                          	$order_data->it_easy_comment = $track->field[2];
                            $order_data->save(false);
                            $data->it_easy_status_updated_at = $date_courier;
                            $data->save(false);
                        }
                        $i++;
                    }
                    
                    		if($value->field[11] == 'In-Transit'){
                                $status_id = '45';
                              
                              
                              	$order_data->it_easy_order_status_id = '27';
                            	$order_data->save(false);
                            }else if($value->field[11] =='Undelivered'){
                                
                              
                              	$order_data->it_easy_order_status_id = '9';
                            	$order_data->save(false);
                            }else if($value->field[11] =='Delivered'){
                                
                                // echo "<pre>"; print_r($date_array2); die;
                                
                              	$order_data->it_easy_delivered_time = date('Y-m-d H:i:s', strtotime($value->field[20]));
                              	$order_data->it_easy_order_status_id = '3';
                            	$order_data->save(false);
                            	
                            }else if($value->field[11] == 'Out For Delivery'){
                                $order_data->it_easy_order_status_id = '30';
                            	$order_data->save(false);
                            }else if($value->field[11] == 'Connected'){
                                $order_data->it_easy_order_status_id = '27';
                            	$order_data->save(false);
                            }else if($value->field[11] == 'Shipment Redirected'){
                                $order_data->it_easy_order_status_id = '26';
                            	$order_data->save(false);
                            }
                    
                    
                    
                    }
                }
            }
        }
        }
    }
  
  
    public function getTrackDelhivery($dat){
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        if(!empty($dat)){
        foreach($dat as $key => $da){ 
            ItEasyOrderTrack::deleteAll(['in','it_easy_awb_number',$da]);
          	$couriers = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '1'])->one();
            $awb_numbers = implode(',',$da);
            date_default_timezone_set("Asia/Kolkata");
            $create_date=date("Y-m-d H:i:s");
            
            $url_ship='https://track.delhivery.com/api/v1/packages/json/?waybill='.$awb_numbers.'&token='.$couriers->it_easy_auth_key;   
            $ch_ship = curl_init($url_ship);
            curl_setopt($ch_ship, CURLOPT_CUSTOMREQUEST, "GET");
            curl_setopt($ch_ship, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch_ship, CURLOPT_FOLLOWLOCATION, 1);
            $response = curl_exec($ch_ship);
            $returnarray = json_decode($response, true);
            // echo "<pre>"; print_r($returnarray); die;
            if(isset($returnarray['ShipmentData']) && !empty($returnarray['ShipmentData'])){
                foreach($returnarray['ShipmentData'] as $key => $value){
                    if(!empty($value['Shipment']['Scans'])){
                      
                    $count = count($value['Shipment']['Scans']);
                        $i = 1;
                      
                    foreach ($value['Shipment']['Scans'] as $key => $track) {
                        // echo "<pre>"; print_r($track); die;
                        
                        $data = ItEasyOrderDispatch::findOne(['it_easy_awb_number' =>$value['Shipment']['AWB'], 'it_easy_shipping_id' => '1' ]);
                  		$order_data = ItEasyOrder::findOne(['it_easy_order_id' =>$data->it_easy_order_id ]);
                        $trackModel = new ItEasyOrderTrack();
                        $trackModel->it_easy_vendor_id = $data->it_easy_user_id;
                        $trackModel->it_easy_order_id = $data->it_easy_order_id;
                        $trackModel->it_easy_order_awb = $data->it_easy_order_number;
                        $trackModel->it_easy_shipping_id = '1';
                        $trackModel->it_easy_order_status =  $track['ScanDetail']['Scan'];
                        $trackModel->it_easy_awb_number = $data->it_easy_awb_number;
                        $trackModel->it_easy_courier_comment =  $track['ScanDetail']['Instructions'];
                        $trackModel->it_easy_location =  $track['ScanDetail']['ScannedLocation'];
                        $trackModel->it_easy_status_code = $track['ScanDetail']['StatusCode'];
                        $trackModel->it_easy_courier_time = date('Y-m-d H:i:s', strtotime($track['ScanDetail']['ScanDateTime']));
                        $trackModel->created_time = $create_date;
                        $trackModel->save(false);
                      
                        if($i == 1){
                            $data->it_easy_awb_time = date('Y-m-d H:i:s', strtotime($track['ScanDetail']['ScanDateTime']));
                            $data->save(false);
                        }
                        if($track['ScanDetail']['Instructions'] == 'Shipment Picked Up from Client Location'){
                            $data->it_easy_pickup_time = date('Y-m-d H:i:s', strtotime($track['ScanDetail']['ScanDateTime']));
                          	$order_data->it_easy_order_status_id = '29';
                            $order_data->save(false);
                            $data->save(false);
                        }
                        if($track['ScanDetail']['Instructions'] == 'Shipment Picked Up from Client Location'){
                            $data->it_easy_first_scan_date = date('Y-m-d H:i:s', strtotime($track['ScanDetail']['ScanDateTime']));
                          	$order_data->it_easy_order_status_id = '27';
                            $order_data->save(false);
                            $data->save(false);
                        }
                        
                        
                        
                        if($track['ScanDetail']['Instructions'] == 'Out for delivery'){
                            if(empty($data->it_easy_last_scan_date)){
                                $data->it_easy_last_scan_date = date('Y-m-d H:i:s', strtotime($track['ScanDetail']['ScanDateTime']));
                                $data->it_easy_attempt_count = '1';
                                $data->save(false);
                            }else{
                                if(date('Y-m-d') != date('Y-m-d', strtotime($data->it_easy_last_scan_date))){
                                    $data->it_easy_last_scan_date = date('Y-m-d H:i:s', strtotime($track['ScanDetail']['ScanDateTime']));
                                    $data->it_easy_attempt_count = $data->it_easy_attempt_count +1;
                                    $data->save(false);
                                }
                            }
                          
                          	$order_data->it_easy_order_status_id = '30';
                            $order_data->save(false);
                        }
                        if($track['ScanDetail']['Scan'] == 'Pending' && $track['ScanDetail']['ScanType']  == 'UD'){
                            
                            $data->it_easy_first_scan_date = date('Y-m-d H:i:s', strtotime($track['ScanDetail']['ScanDateTime']));
                            
                            $trackModel->it_easy_order_status = 'Undelivered';
                            $trackModel->save(false);
                          	$order_data->it_easy_order_status_id = '9';
                            $order_data->save(false);
                            $data->save(false);
                        }
                        if($track['ScanDetail']['Scan'] == 'RTO'){
                            $trackModel->it_easy_order_status = 'RTO Delivered';
                            $trackModel->save(false);
                            $data->it_easy_auto_rto_date = date('Y-m-d H:i:s', strtotime($track['ScanDetail']['ScanDateTime']));
                            $order_data->it_easy_order_status_id = '47';
                            $order_data->save(false);
                            $data->save(false);
                        }
                        if($track['ScanDetail']['Scan'] == 'Delivered'){
                            $data->it_easy_delivery_date = date('Y-m-d H:i:s', strtotime($track['ScanDetail']['ScanDateTime']));
                          	$order_data->it_easy_order_status_id = '3';
                          	$order_data->it_easy_delivered_time = date('Y-m-d H:i:s', strtotime($track['ScanDetail']['ScanDateTime']));
                            $order_data->save(false);
                            $data->save(false);
                        }
                        if($track['ScanDetail']['Scan'] == 'In Transit'){
                            if($track['ScanDetail']['ScanType'] == 'RT'){
                                $trackModel->it_easy_order_status = 'RTO In-Transit';
                              	$order_data->it_easy_order_status_id = '26';
                            	$order_data->save(false);
                                $trackModel->save(false);
                            }else{
                                $trackModel->it_easy_order_status = 'In-Transit';
                              	$order_data->it_easy_order_status_id = '27';
                            	$order_data->save(false);
                                $trackModel->save(false);
                            }
                        }
                        if($i == $count){
                            $data->it_easy_order_status = $trackModel->it_easy_order_status;
                            $data->it_easy_courier_comment = $track['ScanDetail']['Instructions'];
                          	$order_data->it_easy_comment = $track['ScanDetail']['Instructions'];
                            $order_data->save(false);
                            $data->it_easy_status_updated_at = date('Y-m-d H:i:s', strtotime($track['ScanDetail']['ScanDateTime']));
                            $data->save(false);
                        }
                        $i++;
                    }
                    }
                }
            }
        }
        }
    }
    
    public function getTrackDelhivery2($dat){
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        if(!empty($dat)){
        foreach($dat as $key => $da){ 
            ItEasyOrderTrack::deleteAll(['in','awb_number',$da]);
          	$couriers = ItEasyShippingApi::find()->where(['it_easy_ship_id' => '1'])->one();
            $awb_numbers = implode(',',$da);
            date_default_timezone_set("Asia/Kolkata");
            $create_date=date("Y-m-d H:i:s");
            
            $url_ship='https://track.delhivery.com/api/v1/packages/json/?waybill='.$awb_numbers.'&token='.$couriers->it_easy_auth_key;   
            $ch_ship = curl_init($url_ship);
            curl_setopt($ch_ship, CURLOPT_CUSTOMREQUEST, "GET");
            curl_setopt($ch_ship, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch_ship, CURLOPT_FOLLOWLOCATION, 1);
            $response = curl_exec($ch_ship);
            $returnarray = json_decode($response, true);
            
            if(isset($returnarray['ShipmentData']) && !empty($returnarray['ShipmentData'])){
                foreach($returnarray['ShipmentData'] as $key => $value){
                    if(!empty($value['Shipment']['Scans'])){
                      
                    $count = count($value['Shipment']['Scans']);
                        $i = 1;
                      
                    foreach ($value['Shipment']['Scans'] as $key => $track) {
                        // echo "<pre>"; print_r($track); die;
                        
                        $data = ItEasyOrderDispatch::findOne(['it_easy_awb_number' =>$value['Shipment']['AWB'], 'it_easy_shipping_id' => '1' ]);
                  		$order_data = ItEasyOrder::findOne(['it_easy_order_id' =>$data->it_easy_order_id ]);
                        $trackModel = new SolLogisTrackAwb();
                        $trackModel->it_easy_vendor_id = $data->it_easy_user_id;
                        $trackModel->it_easy_order_id = $data->it_easy_order_id;
                        $trackModel->it_easy_order_awb = $data->it_easy_order_number;
                        $trackModel->it_easy_shipping_id = '1';
                        $trackModel->it_easy_order_status =  $track['ScanDetail']['Scan'];
                        $trackModel->it_easy_awb_number = $data->it_easy_awb_number;
                        $trackModel->it_easy_courier_comment =  $track['ScanDetail']['Instructions'];
                        $trackModel->it_easy_location =  $track['ScanDetail']['ScannedLocation'];
                        $trackModel->it_easy_status_code = $track['ScanDetail']['StatusCode'];
                        $trackModel->it_easy_courier_time = date('Y-m-d H:i:s', strtotime($track['ScanDetail']['ScanDateTime']));
                        $trackModel->created_time = $create_date;
                        $trackModel->save(false);
                      
                        if($i == 1){
                            $data->it_easy_awb_time = date('Y-m-d H:i:s', strtotime($track['ScanDetail']['ScanDateTime']));
                            $data->save(false);
                        }
                        if($track['ScanDetail']['Instructions'] == 'Shipment Picked Up from Client Location'){
                            $data->it_easy_pickup_time = date('Y-m-d H:i:s', strtotime($track['ScanDetail']['ScanDateTime']));
                          	$order_data->it_easy_order_status_id = '29';
                            $order_data->save(false);
                            $data->save(false);
                        }
                        if($track['ScanDetail']['Instructions'] == 'Shipment Picked Up from Client Location'){
                            $data->it_easy_first_scan_date = date('Y-m-d H:i:s', strtotime($track['ScanDetail']['ScanDateTime']));
                          	$order_data->it_easy_order_status_id = '27';
                            $order_data->save(false);
                            $data->save(false);
                        }
                        if($track['ScanDetail']['Instructions'] == 'Out for delivery'){
                            if(empty($data->it_easy_last_scan_date)){
                                $data->it_easy_last_scan_date = date('Y-m-d H:i:s', strtotime($track['ScanDetail']['ScanDateTime']));
                                $data->it_easy_attempt_count = '1';
                                $data->save(false);
                            }else{
                                if(date('Y-m-d') != date('Y-m-d', strtotime($data->it_easy_last_scan_date))){
                                    $data->it_easy_last_scan_date = date('Y-m-d H:i:s', strtotime($track['ScanDetail']['ScanDateTime']));
                                    $data->it_easy_attempt_count = $data->it_easy_attempt_count +1;
                                    $data->save(false);
                                }
                            }
                          
                          	$order_data->it_easy_order_status_id = '30';
                            $order_data->save(false);
                        }
                        if($track['ScanDetail']['Scan'] == 'RTO'){
                            $trackModel->it_easy_order_status = 'RTO Delivered';
                            $trackModel->save(false);
                            $data->it_easy_auto_rto_date = date('Y-m-d H:i:s', strtotime($track['ScanDetail']['ScanDateTime']));
                            $order_data->it_easy_order_status_id = '47';
                            $order_data->save(false);
                            $data->save(false);
                        }
                        if($track['ScanDetail']['Scan'] == 'Delivered'){
                            $data->it_easy_delivery_date = date('Y-m-d H:i:s', strtotime($track['ScanDetail']['ScanDateTime']));
                          	$order_data->it_easy_order_status_id = '3';
                          	$order_data->it_easy_delivered_time = date('Y-m-d H:i:s', strtotime($track['ScanDetail']['ScanDateTime']));
                            $order_data->save(false);
                            $data->save(false);
                        }
                        if($track['ScanDetail']['Scan'] == 'In Transit'){
                            if($track['ScanDetail']['ScanType'] == 'RT'){
                                $trackModel->it_easy_order_status = 'RTO In-Transit';
                              	$order_data->it_easy_order_status_id = '26';
                            	$order_data->save(false);
                                $trackModel->save(false);
                            }else{
                                $trackModel->it_easy_order_status = 'In-Transit';
                              	$order_data->it_easy_order_status_id = '27';
                            	$order_data->save(false);
                                $trackModel->save(false);
                            }
                        }
                        if($i == $count){
                            $data->it_easy_order_status = $trackModel->it_easy_order_status;
                            $data->it_easy_courier_comment = $track['ScanDetail']['Instructions'];
                          	$order_data->it_easy_comment = $track['ScanDetail']['Instructions'];
                            $order_data->save(false);
                            $data->it_easy_status_updated_at = date('Y-m-d H:i:s', strtotime($track['ScanDetail']['ScanDateTime']));
                            $data->save(false);
                        }
                        $i++;
                    }
                    }
                }
            }
        }
        }
    }
    
}
