<?php

namespace backend\models;

use Yii;
use backend\models\ItEasyFinancialYear;

/**
 * This is the model class for table "it_easy_order_2023_2024".
 *
 * @property int $it_easy_order_id
 * @property string $it_easy_financial_year
 * @property string $it_easy_order_number
 * @property int $it_easy_store_id
 * @property string $it_easy_invoice_number
 * @property string|null $it_easy_store_name
 * @property string $it_easy_other_order_id
 * @property int $it_easy_customer_id
 * @property string $it_easy_firstname
 * @property string|null $it_easy_lastname
 * @property string $it_easy_mobile_number
 * @property string|null $it_easy_alternate_number
 * @property string|null $it_easy_email
 * @property string $it_easy_address_1
 * @property string $it_easy_address_2
 * @property string $it_easy_city
 * @property string $it_easy_state
 * @property int $it_easy_state_id
 * @property string $it_easy_pincode
 * @property string|null $it_easy_fax
 * @property string|null $it_easy_country
 * @property string $it_easy_shipping_firstname
 * @property string|null $it_easy_shipping_lastname
 * @property string $it_easy_shipping_mobile_number
 * @property string|null $it_easy_shipping_alternate_number
 * @property string|null $it_easy_shipping_email
 * @property string $it_easy_shipping_address_1
 * @property string $it_easy_shipping_address_2
 * @property string $it_easy_shipping_city
 * @property string $it_easy_shipping_state
 * @property int $it_easy_shipping_state_id
 * @property string $it_easy_shipping_pincode
 * @property string|null $it_easy_shipping_country
 * @property string|null $it_easy_billing_company_name
 * @property int|null $it_easy_billing_gst_status
 * @property string|null $it_easy_billing_gst
 * @property string $it_easy_billing_firstname
 * @property string $it_easy_billing_lastname
 * @property string $it_easy_billing_mobile
 * @property string|null $it_easy_billing_alternate_number
 * @property string|null $it_easy_billing_email
 * @property string $it_easy_billing_address_1
 * @property string|null $it_easy_billing_address_2
 * @property string $it_easy_billing_city
 * @property string $it_easy_billing_state
 * @property int $it_easy_billing_state_id
 * @property string $it_easy_billing_pincode
 * @property string|null $it_easy_billing_country
 * @property string $it_easy_payment_method
 * @property string $it_easy_payment_code
 * @property string $it_easy_shipping_method
 * @property string $it_easy_shipping_code
 * @property string|null $it_easy_order_serviceable
 * @property string $it_easy_comment
 * @property float|null $it_easy_total_price
 * @property float|null $it_easy_gst_price
 * @property int $it_easy_order_status_id
 * @property string $it_easy_first_status
 * @property int $it_easy_order_disposition_id
 * @property int $it_easy_ndr_disposition_id
 * @property int $it_easy_ndr_status_id
 * @property int $it_easy_department_id
 * @property int $it_easy_assigned_by
 * @property int $it_easy_assigned_to
 * @property int $it_easy_ndr_tl
 * @property int $it_easy_ndr_agent
 * @property int $it_easy_read_status
 * @property int $it_easy_address_verify_by
 * @property int $it_easy_marketer_id
 * @property string $it_easy_marketer_publisher
 * @property string $it_easy_marketer_click_id
 * @property string|null $it_easy_client_ip
 * @property string|null $it_easy_server_ip
 * @property string|null $it_easy_device
 * @property string|null $it_easy_browser
 * @property string|null $it_easy_previous_url
 * @property string|null $it_easy_page_url
 * @property string|null $it_easy_created_time
 * @property string|null $it_easy_updated_time
 * @property string|null $it_easy_assign_time
 * @property string|null $it_easy_placed_time
 * @property string|null $it_easy_delivered_time
 */
class ItEasyOrderVerify extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {   
        $today_date = date('Y-m-d');
        $ge_financial = ItEasyFinancialYear::find()->select(['it_easy_financial_year'])->where(['or',['<=', 'it_easy_date_from', $today_date], ['>=', 'it_easy_date_to', $today_date] ])->asArray()->one();
        
        return 'it_easy_order_'.$ge_financial['it_easy_financial_year'];
    }

    /**
     * {@inheritdoc}
     */
     public $it_easy_ship_id;
    public function rules()
    {
        return [
            [['it_easy_order_number', 'it_easy_store_id', 'it_easy_invoice_number', 'it_easy_other_order_id', 'it_easy_firstname', 'it_easy_mobile_number', 'it_easy_address_1', 'it_easy_city', 'it_easy_state', 'it_easy_state_id', 'it_easy_pincode', 'it_easy_shipping_firstname', 'it_easy_shipping_mobile_number', 'it_easy_shipping_address_1', 'it_easy_shipping_address_2', 'it_easy_shipping_city', 'it_easy_shipping_state', 'it_easy_shipping_state_id', 'it_easy_shipping_pincode', 'it_easy_billing_firstname', 'it_easy_billing_lastname', 'it_easy_billing_mobile', 'it_easy_billing_address_1', 'it_easy_billing_city', 'it_easy_billing_state', 'it_easy_billing_state_id', 'it_easy_billing_pincode', 'it_easy_payment_method', 'it_easy_payment_code', 'it_easy_shipping_method', 'it_easy_shipping_code', 'it_easy_comment', 'it_easy_order_status_id', 'it_easy_first_status', 'it_easy_order_disposition_id', 'it_easy_ndr_disposition_id', 'it_easy_ndr_status_id', 'it_easy_department_id', 'it_easy_assigned_by', 'it_easy_assigned_to', 'it_easy_ndr_tl', 'it_easy_ndr_agent', 'it_easy_read_status', 'it_easy_marketer_id', 'it_easy_marketer_publisher', 'it_easy_marketer_click_id'], 'required'],
            [['it_easy_store_id', 'it_easy_state_id', 'it_easy_shipping_state_id', 'it_easy_billing_gst_status', 'it_easy_billing_state_id', 'it_easy_order_status_id', 'it_easy_order_disposition_id', 'it_easy_ndr_disposition_id', 'it_easy_ndr_status_id', 'it_easy_department_id', 'it_easy_assigned_by', 'it_easy_assigned_to', 'it_easy_ndr_tl', 'it_easy_ndr_agent', 'it_easy_read_status', 'it_easy_address_verify_by', 'it_easy_marketer_id'], 'integer'],
            [['it_easy_total_price', 'it_easy_gst_price'], 'number'],
            [['it_easy_first_status'], 'string'],
            [['it_easy_created_time', 'it_easy_updated_time', 'it_easy_assign_time', 'it_easy_placed_time', 'it_easy_delivered_time','it_easy_ship_id', 'it_easy_platform'], 'safe'],
            [['it_easy_financial_year'], 'string', 'max' => 40],
            [['it_easy_order_number', 'it_easy_invoice_number', 'it_easy_city', 'it_easy_state', 'it_easy_country', 'it_easy_shipping_city', 'it_easy_shipping_state', 'it_easy_billing_city', 'it_easy_billing_state', 'it_easy_billing_country'], 'string', 'max' => 60],
            [['it_easy_store_name', 'it_easy_email', 'it_easy_shipping_email', 'it_easy_billing_email', 'it_easy_marketer_publisher', 'it_easy_marketer_click_id', 'it_easy_client_ip', 'it_easy_server_ip', 'it_easy_device', 'it_easy_browser', 'address_validator_response'], 'string', 'max' => 100],
            [['it_easy_other_order_id', 'it_easy_fax', 'it_easy_shipping_country', 'it_easy_payment_method', 'it_easy_shipping_method'], 'string', 'max' => 50],
            [['it_easy_firstname', 'it_easy_lastname', 'it_easy_shipping_firstname', 'it_easy_shipping_lastname', 'it_easy_billing_firstname', 'it_easy_billing_lastname'], 'string', 'max' => 80],
            [['it_easy_mobile_number', 'it_easy_alternate_number', 'it_easy_shipping_mobile_number', 'it_easy_shipping_alternate_number', 'it_easy_billing_mobile', 'it_easy_billing_alternate_number'], 'string', 'max' => 20],
            [['it_easy_address_1', 'it_easy_address_2', 'it_easy_shipping_address_1', 'it_easy_shipping_address_2', 'it_easy_billing_company_name', 'it_easy_billing_address_1', 'it_easy_billing_address_2'], 'string', 'max' => 150],
            [['it_easy_pincode', 'it_easy_shipping_pincode', 'it_easy_billing_pincode'], 'string', 'max' => 10],
            [['it_easy_billing_gst', 'it_easy_payment_code', 'it_easy_shipping_code'], 'string', 'max' => 30],
            [['it_easy_order_serviceable', 'it_easy_comment'], 'string', 'max' => 255],
            [['it_easy_previous_url', 'it_easy_page_url'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_order_id' => 'Order ID',
            'it_easy_financial_year' => 'Financial Year',
            'it_easy_order_number' => 'Order Number',
            'it_easy_store_id' => 'Store Name',
            'it_easy_invoice_number' => 'Invoice Number',
            'it_easy_store_name' => 'Store Name',
            'it_easy_other_order_id' => 'Other Order ID',
            'it_easy_customer_id' => 'Customer Name',
            'it_easy_firstname' => 'Customer Firstname',
            'it_easy_lastname' => 'Customer Lastname',
            'it_easy_mobile_number' => 'Mobile Number',
            'it_easy_alternate_number' => 'Alternate Number',
            'it_easy_email' => 'Customer Email',
            'it_easy_address_1' => 'Address 1',
            'it_easy_address_2' => 'Address 2',
            'it_easy_city' => 'City',
            'it_easy_state' => 'State',
            'it_easy_state_id' => 'State Name',
            'it_easy_pincode' => 'Pincode',
            'it_easy_fax' => 'Fax',
            'it_easy_country' => 'Country',
            'it_easy_shipping_firstname' => 'Shipping Firstname',
            'it_easy_shipping_lastname' => 'Shipping Lastname',
            'it_easy_shipping_mobile_number' => 'Shipping Mobile Number',
            'it_easy_shipping_alternate_number' => 'Shipping Alternate Number',
            'it_easy_shipping_email' => 'Shipping Email',
            'it_easy_shipping_address_1' => 'Shipping Address 1',
            'it_easy_shipping_address_2' => 'Shipping Address 2',
            'it_easy_shipping_city' => 'Shipping City',
            'it_easy_shipping_state' => 'Shipping State',
            'it_easy_shipping_state_id' => 'Shipping State ID',
            'it_easy_shipping_pincode' => 'Shipping Pincode',
            'it_easy_shipping_country' => 'Shipping Country',
            'it_easy_billing_company_name' => 'Billing  Company Name',
            'it_easy_billing_gst_status' => 'Billing  Gst Status',
            'it_easy_billing_gst' => 'Billing  Gst',
            'it_easy_billing_firstname' => 'Billing  Firstname',
            'it_easy_billing_lastname' => 'Billing  Lastname',
            'it_easy_billing_mobile' => 'Billing  Mobile',
            'it_easy_billing_alternate_number' => 'Billing  Alternate Number',
            'it_easy_billing_email' => 'Billing  Email',
            'it_easy_billing_address_1' => 'Billing  Address 1',
            'it_easy_billing_address_2' => 'Billing  Address 2',
            'it_easy_billing_city' => 'Billing  City',
            'it_easy_billing_state' => 'Billing  State',
            'it_easy_billing_state_id' => 'Billing  State ID',
            'it_easy_billing_pincode' => 'Billing  Pincode',
            'it_easy_billing_country' => 'Billing  Country',
            'it_easy_payment_method' => 'Payment Method',
            'it_easy_payment_code' => 'Payment Code',
            'it_easy_shipping_method' => 'Shipping Method',
            'it_easy_shipping_code' => 'Shipping Code',
            'it_easy_order_serviceable' => 'Order Serviceable',
            'it_easy_comment' => 'Order Comment',
            'it_easy_total_price' => 'Total Price',
            'it_easy_gst_price' => 'GST Price',
            'it_easy_order_status_id' => 'Order Status Name',
            'it_easy_first_status' => 'First Status',
            'it_easy_order_disposition_id' => 'Order Disposition Name',
            'it_easy_ndr_disposition_id' => 'NDR Disposition Name',
            'it_easy_ndr_status_id' => 'NDR Status ID',
            'it_easy_department_id' => 'Department Name',
            'it_easy_assigned_by' => 'Assigned By',
            'it_easy_assigned_to' => 'Agent Name',
            'it_easy_ndr_tl' => 'NDL TL',
            'it_easy_ndr_agent' => 'Ndr Agent',
            'it_easy_read_status' => 'Read Status',
            'it_easy_address_verify_by' => 'Address Verify By',
            'it_easy_marketer_id' => 'Marketer ID',
            'it_easy_marketer_publisher' => 'Marketer Publisher',
            'it_easy_marketer_click_id' => 'Marketer Click ID',
            'it_easy_client_ip' => 'Client Ip',
            'it_easy_server_ip' => 'Server Ip',
            'it_easy_device' => 'Device',
            'it_easy_browser' => 'Browser',
            'it_easy_previous_url' => 'Previous Url',
            'it_easy_page_url' => 'Page Url',
            'it_easy_created_time' => 'Created Time',
            'it_easy_updated_time' => 'Updated Time',
            'it_easy_assign_time' => 'Assign Time',
            'it_easy_placed_time' => 'Placed Time',
            'it_easy_delivered_time' => 'Delivered Time',
        ];
    }


     public function getOrderData($orderid){
        $model = ItEasyOrderVerify::find()->where(['it_easy_order_id' => $orderid])->asArray()->one();
        echo json_encode($model);
        exit();
    }
}
