<?php

namespace backend\models;
use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyOrderVerify;

/**
 * ItEasyOrderSearch represents the model behind the search form of `backend\models\ItEasyOrder`.
 */
class ItEasyOrderVerifySearch extends ItEasyOrder
{
    /**
     * {@inheritdoc}
     */
   public $it_easy_servisable_name;
    public function rules()
    {
        return [
            [['it_easy_order_id', 'it_easy_store_id', 'it_easy_customer_id', 'it_easy_state_id', 'it_easy_shipping_state_id', 'it_easy_billing_gst_status', 'it_easy_billing_state_id', 'it_easy_order_status_id', 'it_easy_order_disposition_id', 'it_easy_ndr_disposition_id', 'it_easy_ndr_status_id', 'it_easy_department_id', 'it_easy_assigned_by', 'it_easy_assigned_to', 'it_easy_ndr_tl', 'it_easy_ndr_agent', 'it_easy_read_status', 'it_easy_address_verify_by', 'it_easy_marketer_id'], 'integer'],
            [['it_easy_servisable_name','it_easy_financial_year', 'it_easy_order_number', 'it_easy_invoice_number', 'it_easy_store_name', 'it_easy_other_order_id', 'it_easy_firstname', 'it_easy_lastname', 'it_easy_mobile_number', 'it_easy_alternate_number', 'it_easy_email', 'it_easy_address_1', 'it_easy_address_2', 'it_easy_city', 'it_easy_state', 'it_easy_pincode', 'it_easy_fax', 'it_easy_country', 'it_easy_shipping_firstname', 'it_easy_shipping_lastname', 'it_easy_shipping_mobile_number', 'it_easy_shipping_alternate_number', 'it_easy_shipping_email', 'it_easy_shipping_address_1', 'it_easy_shipping_address_2', 'it_easy_shipping_city', 'it_easy_shipping_state', 'it_easy_shipping_pincode', 'it_easy_shipping_country', 'it_easy_billing_company_name', 'it_easy_billing_gst', 'it_easy_billing_firstname', 'it_easy_billing_lastname', 'it_easy_billing_mobile', 'it_easy_billing_alternate_number', 'it_easy_billing_email', 'it_easy_billing_address_1', 'it_easy_billing_address_2', 'it_easy_billing_city', 'it_easy_billing_state', 'it_easy_billing_pincode', 'it_easy_billing_country', 'it_easy_payment_method', 'it_easy_payment_code', 'it_easy_shipping_method', 'it_easy_shipping_code', 'it_easy_order_serviceable', 'it_easy_comment', 'it_easy_first_status', 'it_easy_marketer_publisher', 'it_easy_marketer_click_id', 'it_easy_client_ip', 'it_easy_server_ip', 'it_easy_device', 'it_easy_browser', 'it_easy_previous_url', 'it_easy_page_url', 'it_easy_created_time', 'it_easy_updated_time', 'it_easy_assign_time', 'it_easy_placed_time', 'it_easy_delivered_time','date_from_date', 'date_to_date','date_type_filter', 'it_easy_platform'], 'safe'],
            [['it_easy_total_price', 'it_easy_gst_price'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */

    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        //$query = ItEasyOrderVerify::find()->where(['it_easy_order_status_id'=>'1']);
        $query = ItEasyOrderVerify::find()->where(['IN', 'it_easy_order_status_id', ['1', '12']])->andWhere(['IN', 'it_easy_order_disposition_id', ['3','41','40'] ]);

        // add conditions that should always apply here
        // echo "<pre>"; print_r($params); die;
        if(isset(Yii::$app->user->identity->it_easy_platform)){
            $platform = explode(',', Yii::$app->user->identity->it_easy_platform);
            $query->andWhere(['IN', 'it_easy_platform', $platform]);
        }

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_order_id' => $this->it_easy_order_id,
            'it_easy_store_id' => $this->it_easy_store_id,
            'it_easy_customer_id' => $this->it_easy_customer_id,
            'it_easy_state_id' => $this->it_easy_state_id,
            'it_easy_shipping_state_id' => $this->it_easy_shipping_state_id,
            'it_easy_billing_gst_status' => $this->it_easy_billing_gst_status,
            'it_easy_billing_state_id' => $this->it_easy_billing_state_id,
            'it_easy_total_price' => $this->it_easy_total_price,
            'it_easy_gst_price' => $this->it_easy_gst_price,
            'it_easy_order_status_id' => $this->it_easy_order_status_id,
            'it_easy_order_disposition_id' => $this->it_easy_order_disposition_id,
            'it_easy_ndr_disposition_id' => $this->it_easy_ndr_disposition_id,
            'it_easy_ndr_status_id' => $this->it_easy_ndr_status_id,
            'it_easy_department_id' => $this->it_easy_department_id,
            'it_easy_assigned_by' => $this->it_easy_assigned_by,
            'it_easy_assigned_to' => $this->it_easy_assigned_to,
            'it_easy_ndr_tl' => $this->it_easy_ndr_tl,
            'it_easy_ndr_agent' => $this->it_easy_ndr_agent,
            'it_easy_read_status' => $this->it_easy_read_status,
            'it_easy_address_verify_by' => $this->it_easy_address_verify_by,
            'it_easy_marketer_id' => $this->it_easy_marketer_id,
            'it_easy_created_time' => $this->it_easy_created_time,
            'it_easy_updated_time' => $this->it_easy_updated_time,
            'it_easy_assign_time' => $this->it_easy_assign_time,
            'it_easy_placed_time' => $this->it_easy_placed_time,
            'it_easy_delivered_time' => $this->it_easy_delivered_time,
        ]);

        $query->andFilterWhere(['like', 'it_easy_financial_year', $this->it_easy_financial_year])
            ->andFilterWhere(['like', 'it_easy_order_number', $this->it_easy_order_number])
            ->andFilterWhere(['like', 'it_easy_platform', $this->it_easy_platform])
            ->andFilterWhere(['like', 'it_easy_invoice_number', $this->it_easy_invoice_number])
            ->andFilterWhere(['like', 'it_easy_store_name', $this->it_easy_store_name])
            ->andFilterWhere(['like', 'it_easy_other_order_id', $this->it_easy_other_order_id])
            ->andFilterWhere(['like', 'it_easy_firstname', $this->it_easy_firstname])
            ->andFilterWhere(['like', 'it_easy_lastname', $this->it_easy_lastname])
            ->andFilterWhere(['like', 'it_easy_mobile_number', $this->it_easy_mobile_number])
            ->andFilterWhere(['like', 'it_easy_alternate_number', $this->it_easy_alternate_number])
            ->andFilterWhere(['like', 'it_easy_email', $this->it_easy_email])
            ->andFilterWhere(['like', 'it_easy_address_1', $this->it_easy_address_1])
            ->andFilterWhere(['like', 'it_easy_address_2', $this->it_easy_address_2])
            ->andFilterWhere(['like', 'it_easy_city', $this->it_easy_city])
            ->andFilterWhere(['like', 'it_easy_state', $this->it_easy_state])
            ->andFilterWhere(['like', 'it_easy_pincode', $this->it_easy_pincode])
            ->andFilterWhere(['like', 'it_easy_fax', $this->it_easy_fax])
            ->andFilterWhere(['like', 'it_easy_country', $this->it_easy_country])
            ->andFilterWhere(['like', 'it_easy_shipping_firstname', $this->it_easy_shipping_firstname])
            ->andFilterWhere(['like', 'it_easy_shipping_lastname', $this->it_easy_shipping_lastname])
            ->andFilterWhere(['like', 'it_easy_shipping_mobile_number', $this->it_easy_shipping_mobile_number])
            ->andFilterWhere(['like', 'it_easy_shipping_alternate_number', $this->it_easy_shipping_alternate_number])
            ->andFilterWhere(['like', 'it_easy_shipping_email', $this->it_easy_shipping_email])
            ->andFilterWhere(['like', 'it_easy_shipping_address_1', $this->it_easy_shipping_address_1])
            ->andFilterWhere(['like', 'it_easy_shipping_address_2', $this->it_easy_shipping_address_2])
            ->andFilterWhere(['like', 'it_easy_shipping_city', $this->it_easy_shipping_city])
            ->andFilterWhere(['like', 'it_easy_shipping_state', $this->it_easy_shipping_state])
            ->andFilterWhere(['like', 'it_easy_shipping_pincode', $this->it_easy_shipping_pincode])
            ->andFilterWhere(['like', 'it_easy_shipping_country', $this->it_easy_shipping_country])
            ->andFilterWhere(['like', 'it_easy_billing_company_name', $this->it_easy_billing_company_name])
            ->andFilterWhere(['like', 'it_easy_billing_gst', $this->it_easy_billing_gst])
            ->andFilterWhere(['like', 'it_easy_billing_firstname', $this->it_easy_billing_firstname])
            ->andFilterWhere(['like', 'it_easy_billing_lastname', $this->it_easy_billing_lastname])
            ->andFilterWhere(['like', 'it_easy_billing_mobile', $this->it_easy_billing_mobile])
            ->andFilterWhere(['like', 'it_easy_billing_alternate_number', $this->it_easy_billing_alternate_number])
            ->andFilterWhere(['like', 'it_easy_billing_email', $this->it_easy_billing_email])
            ->andFilterWhere(['like', 'it_easy_billing_address_1', $this->it_easy_billing_address_1])
            ->andFilterWhere(['like', 'it_easy_billing_address_2', $this->it_easy_billing_address_2])
            ->andFilterWhere(['like', 'it_easy_billing_city', $this->it_easy_billing_city])
            ->andFilterWhere(['like', 'it_easy_billing_state', $this->it_easy_billing_state])
            ->andFilterWhere(['like', 'it_easy_billing_pincode', $this->it_easy_billing_pincode])
            ->andFilterWhere(['like', 'it_easy_billing_country', $this->it_easy_billing_country])
            ->andFilterWhere(['like', 'it_easy_payment_method', $this->it_easy_payment_method])
            ->andFilterWhere(['like', 'it_easy_payment_code', $this->it_easy_payment_code])
            ->andFilterWhere(['like', 'it_easy_shipping_method', $this->it_easy_shipping_method])
            ->andFilterWhere(['like', 'it_easy_shipping_code', $this->it_easy_shipping_code])
            ->andFilterWhere(['like', 'it_easy_order_serviceable', $this->it_easy_order_serviceable])
            ->andFilterWhere(['like', 'it_easy_comment', $this->it_easy_comment])
            ->andFilterWhere(['like', 'it_easy_first_status', $this->it_easy_first_status])
            ->andFilterWhere(['like', 'it_easy_marketer_publisher', $this->it_easy_marketer_publisher])
            ->andFilterWhere(['like', 'it_easy_marketer_click_id', $this->it_easy_marketer_click_id])
            ->andFilterWhere(['like', 'it_easy_client_ip', $this->it_easy_client_ip])
            ->andFilterWhere(['like', 'it_easy_server_ip', $this->it_easy_server_ip])
            ->andFilterWhere(['like', 'it_easy_device', $this->it_easy_device])
            ->andFilterWhere(['like', 'it_easy_browser', $this->it_easy_browser])
            ->andFilterWhere(['like', 'it_easy_previous_url', $this->it_easy_previous_url])
            ->andFilterWhere(['like', 'it_easy_page_url', $this->it_easy_page_url]);
        // echo $query->createCommand()->getRawSql();die;
             if(isset($params['ItEasyOrderVerifySearch']['it_easy_servisable_name']) && !empty($params['ItEasyOrderVerifySearch']['it_easy_servisable_name'])){
              $query->andWhere(new \yii\db\Expression('FIND_IN_SET(:it_easy_servisable_name,it_easy_order_serviceable)'))
                ->addParams([':it_easy_servisable_name' => $params['ItEasyOrderVerifySearch']['it_easy_servisable_name']]);
        }
        if(isset($params['ItEasyOrderVerifySearch']['date_type_filter']) && !empty($params['ItEasyOrderVerifySearch']['date_type_filter'])){

            if(!empty($params['ItEasyOrderVerifySearch']['date_from_date'])){
  
              if(empty($params['ItEasyOrderVerifySearch']['date_to_date'])){
                $params['ItEasyOrderVerifySearch']['date_to_date'] = date('Y-m-d');
              }
  
              if($params['ItEasyOrderVerifySearch']['date_type_filter'] == 'Date Added'){
                $query->andWhere(['<=', 'it_easy_created_time', $params['ItEasyOrderVerifySearch']['date_to_date']])
                  ->andWhere(['>=', 'it_easy_created_time', $params['ItEasyOrderVerifySearch']['date_from_date']]);
              }else if($params['ItEasyOrderVerifySearch']['date_type_filter'] == 'Date Modified'){
                $query->andWhere(['<=', 'it_easy_updated_time', $params['ItEasyOrderVerifySearch']['date_to_date']])
                  ->andWhere(['>=', 'it_easy_updated_time', $params['ItEasyOrderVerifySearch']['date_from_date']]);
              }else if($params['ItEasyOrderVerifySearch']['date_type_filter'] == 'Date Assigned'){
                $query->andWhere(['<=', 'it_easy_assign_time', $params['ItEasyOrderVerifySearch']['date_to_date']])
                  ->andWhere(['>=', 'it_easy_assign_time', $params['ItEasyOrderVerifySearch']['date_from_date']]);
              }else if($params['ItEasyOrderVerifySearch']['date_type_filter'] == 'Date Converted'){
                $query->andWhere(['<=', 'it_easy_converted_time', $params['ItEasyOrderVerifySearch']['date_to_date']])
                  ->andWhere(['>=', 'it_easy_converted_time', $params['ItEasyOrderVerifySearch']['date_from_date']]);
              }else if($params['ItEasyOrderVerifySearch']['date_type_filter'] == 'Date Dispatched'){
                $query->andWhere(['<=', 'it_easy_placed_time', $params['ItEasyOrderVerifySearch']['date_to_date']])
                  ->andWhere(['>=', 'it_easy_placed_time', $params['ItEasyOrderVerifySearch']['date_from_date']]);
              }else if($params['ItEasyOrderVerifySearch']['date_type_filter'] == 'Date Delivered'){
                $query->andWhere(['<=', 'it_easy_delivered_time', $params['ItEasyOrderVerifySearch']['date_to_date']])
                  ->andWhere(['>=', 'it_easy_delivered_time', $params['ItEasyOrderVerifySearch']['date_from_date']]);
              }
            }
          }
          
          $query->orderBy(['it_easy_order_id' => SORT_ASC]);
        //  echo $query->createCommand()->getRawSql();die;
        return $dataProvider;
    }


}
