<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_payment_gateway".
 *
 * @property int $it_easy_id
 * @property string $it_easy_name
 * @property string $it_easy_api_key
 * @property string|null $it_easy_api_secret
 * @property string|null $it_easy_api_password
 * @property string $it_easy_status
 * @property string|null $it_easy_created_time
 * @property string|null $it_easy_updated_time
 * @property int|null $it_easy_created_by
 * @property int|null $it_easy_updated_by
 */
class ItEasyPaymentGateway extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_payment_gateway';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_name', 'it_easy_api_key', 'it_easy_status'], 'required'],
            [['it_easy_status'], 'string'],
            [['it_easy_created_time', 'it_easy_updated_time'], 'safe'],
            [['it_easy_created_by', 'it_easy_updated_by'], 'integer'],
            [['it_easy_name'], 'string', 'max' => 150],
            [['it_easy_api_key', 'it_easy_api_secret', 'it_easy_api_password'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'ID',
            'it_easy_name' => 'Name',
            'it_easy_api_key' => 'Api Key',
            'it_easy_api_secret' => 'Api Secret Key',
            'it_easy_api_password' => 'Api Password',
            'it_easy_status' => 'Status',
            'it_easy_created_time' => 'Created Time',
            'it_easy_updated_time' => 'Updated Time',
            'it_easy_created_by' => 'Created By',
            'it_easy_updated_by' => 'Updated By',
        ];
    }
}
