<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_product".
 *
 * @property int $it_easy_product_id
 * @property int $it_easy_product_category_id
 * @property string $it_easy_product_name
 * @property string $it_easy_product_sku
 * @property string|null $it_easy_product_description
 * @property string $it_easy_product_type
 * @property string $it_easy_weight_type
 * @property int $it_easy_product_one_bottle_quantity
 * @property int $it_easy_product_quantity
 * @property string $it_easy_product_stock_id
 * @property float $it_easy_product_price
 * @property float $it_easy_product_mrp
 * @property int|null $it_easy_tax_price
 * @property float|null $it_easy_product_discount
 * @property string|null $it_easy_discount_start_date
 * @property string|null $it_easy_discount_end_date
 * @property int|null $it_easy_price_without_tax
 * @property int $it_easy_product_tax
 * @property string|null $it_easy_product_image
 * @property float|null $it_easy_product_width
 * @property float|null $it_easy_product_height
 * @property float|null $it_easy_product_length
 * @property int $it_easy_product_feature_status
 * @property int $it_easy_product_brand_id
 * @property string $it_easy_product_status
 * @property int|null $it_easy_product_approved_by
 * @property string|null $created_time
 * @property string|null $updated_time
 * @property int|null $created_by
 * @property int|null $update_by
 */
class ItEasyProduct extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_product';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_product_category_id','it_easy_product_name', 'it_easy_product_sku', 'it_easy_product_one_bottle_quantity', 'it_easy_product_mrp', 'it_easy_product_tax','it_easy_product_included_exclude_tax','it_easy_product_brand_id'], 'required'],
            [['it_easy_product_category_id', 'it_easy_product_one_bottle_quantity', 'it_easy_product_quantity', 'it_easy_tax_price', 'it_easy_price_without_tax', 'it_easy_product_tax', 'it_easy_product_feature_status', 'it_easy_product_brand_id', 'it_easy_product_approved_by', 'created_by', 'update_by'], 'integer'],
            [['it_easy_product_description'], 'string'],
            [['it_easy_product_price', 'it_easy_product_mrp', 'it_easy_product_discount', 'it_easy_product_width', 'it_easy_product_height', 'it_easy_product_length'], 'number'],
            [['it_easy_product_included_exclude_tax','it_easy_discount_start_date', 'it_easy_discount_end_date', 'created_time', 'updated_time', 'it_easy_stock_alert', 'it_easy_stock_alert_number'], 'safe'],
            [['it_easy_product_name'], 'string', 'max' => 255],
            [['it_easy_product_hsn'], 'string', 'max' => 255],
            [['it_easy_product_sku', 'it_easy_product_image'], 'string', 'max' => 150],
            [['it_easy_product_type'], 'string', 'max' => 30],
            [['it_easy_weight_type'], 'string', 'max' => 40],
            [['it_easy_product_stock_id'], 'string', 'max' => 20],
            [['it_easy_product_status'], 'string', 'max' => 15],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_product_id' => 'Product ID',
            'it_easy_product_category_id' => 'Product Category ID',
            'it_easy_product_name' => 'Product Name',
             'it_easy_product_hsn' => 'Product Hsn',
            'it_easy_product_sku' => 'Product Sku',
            'it_easy_product_description' => 'Product Description',
            'it_easy_product_type' => 'Product Type',
            'it_easy_weight_type' => 'Weight Type',
            'it_easy_product_one_bottle_quantity' => 'Product One Bottle Quantity',
            'it_easy_product_quantity' => 'Product Quantity',
            'it_easy_product_stock_id' => 'Product Stock ID',
            'it_easy_product_price' => 'Product Price',
            'it_easy_product_mrp' => 'Product Mrp',
            'it_easy_tax_price' => 'Tax Price',
            'it_easy_product_discount' => 'Product Discount',
            'it_easy_discount_start_date' => 'Discount Start Date',
            'it_easy_discount_end_date' => 'Discount End Date',
            'it_easy_price_without_tax' => 'Price Without Tax',
            'it_easy_product_included_exclude_tax' => 'Price Tax Included or Exclude',
            'it_easy_product_tax' => 'Product Tax Percentage',
            'it_easy_product_image' => 'Product Image',
            'it_easy_product_width' => 'Product Width',
            'it_easy_product_height' => 'Product Height',
            'it_easy_product_length' => 'Product Length',
            'it_easy_product_feature_status' => '',
            'it_easy_product_brand_id' => 'Product Brand ID',
            'it_easy_product_status' => 'Product Status',
            'it_easy_product_approved_by' => 'Product Approved By',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
            'created_by' => 'Created By',
            'update_by' => 'Update By',
        ];
    }
}
